/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event;

import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import java.util.ArrayList;
import java.util.List;

public class EventHandlerChain {
    private final List<IEventHandler> eventHandlers = new ArrayList<IEventHandler>();
    long expirationTime;

    public EventHandlerChain(List<Class<? extends IEventHandler>> eventHandlerTypes, int lifetimeMinutes) throws InstantiationException, IllegalAccessException {
        this.expirationTime = System.currentTimeMillis() + (long)lifetimeMinutes * 60000L;
        for (Class<? extends IEventHandler> eventHandlerClass : eventHandlerTypes) {
            IEventHandler eventHandler = eventHandlerClass.newInstance();
            eventHandler.initialize();
            this.eventHandlers.add(eventHandler);
        }
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    public List<IEventHandler> getEventHandlers() {
        return this.eventHandlers;
    }
}

