/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.resource;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.locale.Locale;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.resourceString.ResourceString;
import de.proveo.wwt.logic.app.locale.LocaleFacadeLocal;
import de.proveo.wwt.logic.app.resource.ResourceControl;
import de.proveo.wwt.logic.app.resource.ResourceFacadeLocal;
import de.proveo.wwt.logic.app.resource.ResourceFacadeRemote;
import de.proveo.wwt.logic.app.resource.ResourceStringDAO;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="ResourceFacade")
@Remote(value={ResourceFacadeRemote.class})
@Local(value={ResourceFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ResourceFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ResourceFacade")
public class ResourceFacadeBean {
    private static final Log log = LogFactory.getLog(ResourceFacadeBean.class);
    private static final String BASE_NAME = "DATABASE";
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private ResourceStringDAO resourceStringDAO;
    @EJB
    private LocaleFacadeLocal localeFacade = null;

    @PostConstruct
    public void initialize() {
        this.resourceStringDAO = ResourceStringDAO.newInstance(this.entityManager);
    }

    @Business(viewType="both")
    public Locale getDefaultLocale() {
        return this.localeFacade.findLocale("en", "US");
    }

    @Business(viewType="both")
    public void createResourceString(ResourceString resourceString) {
        this.resourceStringDAO.createEntity(resourceString);
    }

    @Business(viewType="both")
    public void removeResourceString(ResourceString resourceString) {
        if (!this.entityManager.contains((Object)resourceString)) {
            resourceString = (ResourceString)this.resourceStringDAO.findByPrimaryKey(resourceString.getPrimaryKey());
        }
        this.resourceStringDAO.removeEntity(resourceString);
    }

    @Business(viewType="both")
    public ResourceString updateResourceString(ResourceString resourceString) {
        return (ResourceString)this.resourceStringDAO.updateEntity(resourceString);
    }

    @Business(viewType="both")
    public List<ResourceString> getResourceStrings(int moduleId, String language, String country) {
        return this.getResourceStrings(moduleId, language, country, true);
    }

    @Business(viewType="both")
    public List<ResourceString> getResourceStrings(int moduleId, String language, String country, boolean useDefaultLocaleOnError) {
        Locale locale = this.localeFacade.findLocale(language.toLowerCase(), country.toUpperCase());
        if (locale == null) {
            if (useDefaultLocaleOnError) {
                locale = this.getDefaultLocale();
            } else {
                return null;
            }
        }
        return this.resourceStringDAO.findByModuleIdAndLocaleId(moduleId, locale.getId());
    }

    @Business(viewType="both")
    public List<ResourceString> getResourceStrings(int moduleId, int localeId) {
        return this.resourceStringDAO.findByModuleIdAndLocaleId(moduleId, localeId);
    }

    @Business(viewType="both")
    public List<ResourceString> getResourceStrings(int moduleId, String stringId) {
        return this.resourceStringDAO.findByModuleIdAndStringId(moduleId, stringId);
    }

    @Business(viewType="both")
    public ResourceBundle getResourceBundle(int moduleId, java.util.Locale locale) {
        java.util.Locale defaultLocale = this.getDefaultLocale().getLocale();
        List<ResourceString> defaultResources = this.getResourceStrings(moduleId, this.getDefaultLocale().getId());
        if (defaultLocale.equals(locale)) {
            ResourceControl resourceControl = new ResourceControl(locale, defaultResources, null, null);
            return ResourceBundle.getBundle(BASE_NAME, resourceControl);
        }
        List<ResourceString> resources = this.getResourceStrings(moduleId, locale.getLanguage(), locale.getCountry());
        ResourceControl resourceControl = new ResourceControl(locale, resources, defaultLocale, defaultResources);
        return ResourceBundle.getBundle(BASE_NAME, resourceControl);
    }

    @Business(viewType="both")
    public ResourceBundle getResourceBundle(int[] moduleIds, java.util.Locale locale) {
        Locale defaultLocale = this.getDefaultLocale();
        List<ResourceString> defaultResources = this.resourceStringDAO.findByModuleIdsAndLocaleId(moduleIds, defaultLocale.getId());
        Locale requestedLocale = this.localeFacade.findLocale(locale.getLanguage(), locale.getCountry());
        if (requestedLocale == null || defaultLocale.getId() == requestedLocale.getId()) {
            ResourceControl resourceControl = new ResourceControl(locale, defaultResources, null, null);
            return ResourceBundle.getBundle(BASE_NAME, resourceControl);
        }
        List<ResourceString> resources = this.resourceStringDAO.findByModuleIdsAndLocaleId(moduleIds, requestedLocale.getId());
        ResourceControl resourceControl = new ResourceControl(locale, resources, defaultLocale.getLocale(), defaultResources);
        return ResourceBundle.getBundle(BASE_NAME, resourceControl);
    }

    @Business(viewType="both")
    public void test() {
        ResourceBundle rb = this.getResourceBundle(new int[]{ModuleType.WEB.getValue(), ModuleType.STATE_MODEL.getValue()}, new java.util.Locale("de", "DE"));
        rb = null;
    }
}

