/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.use.group;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.unit.permission.IUnitPermissionOwner;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="use_group")
@NamedQueries(value={@NamedQuery(name="findUseGroupAll", query="SELECT h FROM UseGroup h WHERE h.deleted = FALSE ORDER BY h.name ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseGroupByName", query="SELECT h FROM UseGroup h where h.name = ?1 AND h.deleted = FALSE", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseGroupByNameIncludeDeleted", query="SELECT h FROM UseGroup h where h.name = ?1", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUseGroupAllIncludeDeleted", query="SELECT h FROM UseGroup h ORDER BY h.name ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class UseGroup
extends AuditEntityBase
implements Serializable,
IUnitPermissionOwner {
    private static final long serialVersionUID = 9023330452640395681L;
    @AuditRelevant
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long id;
    @AuditRelevant
    @Column(name="NAME")
    @Equals
    @ToString
    private String name;
    @AuditRelevant
    @Column(name="DELETED")
    @Equals
    @ToString
    private boolean deleted;
    @AuditRelevant
    @Column(name="IS_SUPER_USER")
    @Equals
    @ToString
    private boolean isSuperUser;
    @AuditRelevant
    @Column(name="DESCRIPTION")
    @Equals
    @ToString
    private String description;
    @AuditRelevant
    @ManyToMany(targetEntity=UseUser.class, fetch=FetchType.LAZY, mappedBy="useGroups")
    @JoinTable(name="use_user_x_use_group", joinColumns={@JoinColumn(name="ID_USE_GROUP")}, inverseJoinColumns={@JoinColumn(name="ID_USE_USER")})
    private List<UseUser> useUsers = new ArrayList<UseUser>();
    @AuditRelevant
    @OneToMany(targetEntity=UnitPermission.class, mappedBy="useGroup", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<UnitPermission> unitPermissions = new ArrayList<UnitPermission>();

    public UseGroup(UseGroup useGroup) {
        this.id = useGroup.id;
        this.name = useGroup.name;
        this.deleted = useGroup.deleted;
        this.isSuperUser = useGroup.isSuperUser;
        this.description = useGroup.description;
        this.unitPermissions = useGroup.unitPermissions;
    }

    public UseGroup() {
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        if (!this.deleted && deleted) {
            this.setAuditBehaviour(AuditEntityBase.AuditBehaviour.REMOVE);
        } else if (this.deleted && !deleted) {
            this.setAuditBehaviour(AuditEntityBase.AuditBehaviour.DEFAULT);
        }
        this.deleted = deleted;
    }

    public List<UseUser> getUseUsers() {
        return this.useUsers;
    }

    public void setUseUsers(List<UseUser> useUsers) {
        this.useUsers = useUsers;
    }

    public boolean getIsSuperUser() {
        return this.isSuperUser;
    }

    public void setIsSuperUser(boolean isSuperUser) {
        this.isSuperUser = isSuperUser;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<UnitPermission> getUnitPermissions() {
        return this.unitPermissions;
    }

    @Override
    public void setUnitPermissions(List<UnitPermission> unitPermissions) {
        this.unitPermissions = unitPermissions;
    }

    @Override
    public void setPermissionOwner(UnitPermission unitPermission) {
        unitPermission.setUseGroupId(this.getId());
    }

    @Override
    public boolean isPermissionOwner(UnitPermission unitPermission) {
        Long id = unitPermission.getUseGroupId();
        return id != null && id.equals(this.getPrimaryKey());
    }

    public boolean idHasBeenSet() {
        return this.id != 0L;
    }

    public void addUseUser(UseUser useUser) {
        if (useUser != null && !this.useUsers.contains(useUser)) {
            this.useUsers.add(useUser);
            if (!useUser.getUseGroups().contains(this)) {
                useUser.getUseGroups().add(this);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UseGroup");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("name = ");
        stringBuilder.append(this.name == null ? "[null]" : this.name.toString());
        stringBuilder.append(", ");
        stringBuilder.append("deleted = ");
        stringBuilder.append(this.deleted);
        stringBuilder.append(", ");
        stringBuilder.append("isSuperUser = ");
        stringBuilder.append(this.isSuperUser);
        stringBuilder.append(", ");
        stringBuilder.append("description = ");
        stringBuilder.append(this.description == null ? "[null]" : this.description.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UseGroup useGroup = (UseGroup)object;
        if (this.id != useGroup.id) {
            return false;
        }
        if (this.name == null ? useGroup.name != null : !this.name.equals(useGroup.name)) {
            return false;
        }
        if (this.deleted != useGroup.deleted) {
            return false;
        }
        if (this.isSuperUser != useGroup.isSuperUser) {
            return false;
        }
        return !(this.description == null ? useGroup.description != null : !this.description.equals(useGroup.description));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = n * n2 + (this.deleted ? 0 : 1);
        n2 = n * n2 + (this.isSuperUser ? 0 : 1);
        n2 = n * n2 + (this.description == null ? 0 : this.description.hashCode());
        return n2;
    }
}

