/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.state;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.state.StateBase;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="state_cache")
@NamedQueries(value={@NamedQuery(name="findCurrentStateCacheAll", query="SELECT c FROM StateCache c"), @NamedQuery(name="stateCache.findAllOrderByHistoryId", query="SELECT c FROM StateCache c ORDER BY c.historyId"), @NamedQuery(name="findCurrentStateCacheByUnitId", query="SELECT c FROM StateCache c WHERE c.pk.unitId = ?1"), @NamedQuery(name="findCurrentStateCacheByUnitGroupId", query="SELECT c FROM StateCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1"), @NamedQuery(name="findCurrentStateCacheByUnitGroupIdStateModelId", query="SELECT c FROM StateCache c, IN (c.groupHistory.unitGroups) ug WHERE c.unitModel.deleted = false AND c.groupHistory.endTime <= 0 AND ug.unitId = ?1  AND c.pk.stateModelId = ?2"), @NamedQuery(name="StateCache.findByUnitGroupIdStateModelIdStateId", query="SELECT c FROM StateCache c, IN (c.groupHistory.unitGroups) ug WHERE c.unitModel.deleted = false AND c.groupHistory.endTime <= 0 AND ug.unitId = ?1  AND c.pk.stateModelId = ?2 AND c.stateId = ?3"), @NamedQuery(name="findCurrentStateCacheAllByStateModelId", query="SELECT c FROM StateCache c WHERE c.pk.stateModelId = ?1"), @NamedQuery(name="StateCache.findAllByStateModelIdAndStateId", query="SELECT c FROM StateCache c WHERE c.pk.stateModelId = ?1 AND c.stateId = ?2"), @NamedQuery(name="findCurrentStateCacheByUnitModelId", query="SELECT c FROM StateCache c WHERE c.pk.unitId = ?1 AND c.pk.stateModelId = ?2"), @NamedQuery(name="findCurrentStateCacheByUnitModelIdAndStateId", query="SELECT c FROM StateCache c WHERE c.pk.unitId = ?1 AND c.pk.stateModelId = ?2 AND c.stateId = ?3"), @NamedQuery(name="findCurrentStateCacheByRotationAssignment", query="SELECT h FROM StateCache h WHERE h.pk.stateModelId = :stateModelId AND h.stateId = :stateId AND h.remark = :rkey ORDER BY h.pk.unitId ASC")})
public class StateCache
extends StateBase
implements ICacheEntity<StateHistory> {
    private static final long serialVersionUID = -6232548713232118467L;
    @EmbeddedId
    @Equals
    @ToString
    private PK pk = new PK();
    @Column(name="history_id", nullable=false)
    @Equals
    @ToString
    private long historyId;
    @OneToOne(targetEntity=StateHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="history_id", updatable=false, insertable=false)
    private StateHistory history;
    @ManyToOne(targetEntity=State.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="state_id", insertable=false, updatable=false), @JoinColumn(name="state_model_id", insertable=false, updatable=false)})
    private State state;

    public StateCache() {
    }

    public StateCache(StateBase stateBase) {
        super(stateBase);
        this.pk = new PK(stateBase.getUnitId(), stateBase.getStateModelId());
    }

    public long getTimestamp() {
        return this.getBeginTime();
    }

    public void setTimestamp(long timestamp) {
        this.setBeginTime(timestamp);
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public PK getPk() {
        return this.pk;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    @Override
    public int getStateModelId() {
        return this.pk.getStateModelId();
    }

    @Override
    public void setStateModelId(int stateModelId) {
        this.pk.setStateModelId(stateModelId);
    }

    @Override
    public long getUnitId() {
        return this.pk.getUnitId();
    }

    @Override
    public void setUnitId(long unitId) {
        this.pk.setUnitId(unitId);
    }

    @Override
    public long getHistoryId() {
        return this.historyId;
    }

    @Override
    public void setHistoryId(long stateHistoryId) {
        this.historyId = stateHistoryId;
    }

    @Override
    public StateHistory getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StateCache");
        stringBuilder.append(" (");
        stringBuilder.append("pk = ");
        stringBuilder.append(this.pk == null ? "[null]" : this.pk.toString());
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StateCache stateCache = (StateCache)object;
        if (this.pk == null ? stateCache.pk != null : !this.pk.equals(stateCache.pk)) {
            return false;
        }
        return this.historyId == stateCache.historyId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (this.pk == null ? 0 : this.pk.hashCode());
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = -4444291585403585751L;
        @Column(name="UNIT_ID")
        private long unitId;
        @Column(name="STATE_MODEL_ID")
        private int stateModelId;

        public PK(PK pK) {
            this.unitId = pK.unitId;
            this.stateModelId = pK.stateModelId;
        }

        public PK(long unitId, int stateModelId) {
            this.unitId = unitId;
            this.stateModelId = stateModelId;
        }

        public PK() {
        }

        public long getUnitId() {
            return this.unitId;
        }

        public void setUnitId(long unitId) {
            this.unitId = unitId;
        }

        public int getStateModelId() {
            return this.stateModelId;
        }

        public void setStateModelId(int stateModelId) {
            this.stateModelId = stateModelId;
        }

        public String toString() {
            return StringUtil.appendStrings((String[])new String[]{this.getClass().getSimpleName(), " (stateModelId = ", String.valueOf(this.stateModelId), "; ", "unitId = ", String.valueOf(this.unitId), ")"});
        }

        public int hashCode() {
            return (int)(this.unitId ^ this.unitId >>> 32) ^ (this.stateModelId ^ this.stateModelId >>> 32);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PK)) {
                return false;
            }
            PK other = (PK)o;
            return this.unitId == other.unitId && this.stateModelId == other.stateModelId;
        }
    }
}

