/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.measurement;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.logic.ejb.entityListener.MeasurementListener;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="measurement_range_defn")
@EntityListeners(value={MeasurementListener.class})
public class MeasurementRange
extends EntityBase {
    private static final long serialVersionUID = -802720752595880134L;
    @Id
    @Column(name="id")
    @Equals
    @ToString
    private int id;
    @Column(name="name", length=255, nullable=false)
    @Equals
    @ToString
    private String name;
    @Column(name="measurement_defn_id", nullable=false)
    @Equals
    @ToString
    private int measurementDefinitionId;
    @ManyToOne(targetEntity=MeasurementDefinition.class, fetch=FetchType.LAZY)
    @JoinColumn(name="measurement_defn_id", updatable=false, insertable=false)
    private MeasurementDefinition measurementDefinition;
    @Column(name="range_begin", nullable=false)
    @Equals
    @ToString
    private double rangeBegin;
    @Column(name="range_end", nullable=false)
    @Equals
    @ToString
    private double rangeEnd;

    public String getName() {
        return this.name;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getMeasurementDefinitionId() {
        return this.measurementDefinitionId;
    }

    public void setMeasurementDefinitionId(int measurementDefinitionId) {
        this.measurementDefinitionId = measurementDefinitionId;
    }

    public double getRangeBegin() {
        return this.rangeBegin;
    }

    public void setRangeBegin(double rangeBegin) {
        this.rangeBegin = rangeBegin;
    }

    public double getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(double rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public MeasurementDefinition getMeasurementDefinition() {
        return this.measurementDefinition;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MeasurementRange");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("name = ");
        stringBuilder.append(this.name == null ? "[null]" : this.name.toString());
        stringBuilder.append(", ");
        stringBuilder.append("measurementDefinitionId = ");
        stringBuilder.append(this.measurementDefinitionId);
        stringBuilder.append(", ");
        stringBuilder.append("rangeBegin = ");
        stringBuilder.append(this.rangeBegin);
        stringBuilder.append(", ");
        stringBuilder.append("rangeEnd = ");
        stringBuilder.append(this.rangeEnd);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MeasurementRange measurementRange = (MeasurementRange)((Object)object);
        if (this.id != measurementRange.id) {
            return false;
        }
        if (this.name == null ? measurementRange.name != null : !this.name.equals(measurementRange.name)) {
            return false;
        }
        if (this.measurementDefinitionId != measurementRange.measurementDefinitionId) {
            return false;
        }
        if (Double.doubleToLongBits(this.rangeBegin) != Double.doubleToLongBits(measurementRange.rangeBegin)) {
            return false;
        }
        return Double.doubleToLongBits(this.rangeEnd) == Double.doubleToLongBits(measurementRange.rangeEnd);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.id;
        n2 = n * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = n * n2 + this.measurementDefinitionId;
        long l = this.rangeBegin == 0.0 ? 0L : Double.doubleToLongBits(this.rangeBegin);
        n2 = n * n2 + (int)(l ^ l >>> 32);
        l = this.rangeEnd == 0.0 ? 0L : Double.doubleToLongBits(this.rangeEnd);
        n2 = n * n2 + (int)(l ^ l >>> 32);
        return n2;
    }
}

