/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.measurement;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.measurement.MeasurementBase;
import de.proveo.wwt.datamodel.measurement.MeasurementHistory;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="measurement_cache")
@NamedQueries(value={@NamedQuery(name="measurementCache.findByUnitIdAndMeasurementDefinition", query="SELECT m FROM MeasurementCache m WHERE m.pk.unitId=?1 and m.pk.measurementDefinitionId=?2"), @NamedQuery(name="measurementCache.findAll", query="SELECT m FROM MeasurementCache m")})
public class MeasurementCache
extends MeasurementBase
implements ICacheEntity<MeasurementHistory> {
    private static final long serialVersionUID = 2071994267795772811L;
    @EmbeddedId
    @Equals
    @ToString
    private PK pk = new PK();
    @Equals
    @Column(name="history_id", nullable=false)
    @ToString
    private long historyId;
    @OneToOne(targetEntity=MeasurementHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="history_id", updatable=false, insertable=false)
    private MeasurementHistory history;

    public MeasurementCache() {
    }

    public MeasurementCache(MeasurementBase measurementBase) {
        super(measurementBase);
        this.pk.unitId = measurementBase.getUnitId();
        this.pk.measurementDefinitionId = measurementBase.getMeasurementDefinitionId();
    }

    @Override
    public long getBeginTime() {
        return this.getCreateTime();
    }

    @Override
    public void setBeginTime(long timestamp) {
        this.setCreateTime(timestamp);
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    public PK getPk() {
        return this.pk;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    @Override
    public int getMeasurementDefinitionId() {
        return this.pk.getMeasurementDefinitionId();
    }

    @Override
    public long getUnitId() {
        return this.pk.getUnitId();
    }

    @Override
    public void setMeasurementDefinitionId(int measurementTypeId) {
        this.pk.setMeasurementTypeId(measurementTypeId);
    }

    @Override
    public void setUnitId(long unitId) {
        this.pk.setUnitId(unitId);
    }

    @Override
    public long getHistoryId() {
        return this.historyId;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    @Override
    public MeasurementHistory getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MeasurementCache");
        stringBuilder.append(" (");
        stringBuilder.append("pk = ");
        stringBuilder.append(this.pk == null ? "[null]" : this.pk.toString());
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MeasurementCache measurementCache = (MeasurementCache)object;
        if (this.pk == null ? measurementCache.pk != null : !this.pk.equals(measurementCache.pk)) {
            return false;
        }
        return this.historyId == measurementCache.historyId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (this.pk == null ? 0 : this.pk.hashCode());
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = -4444291585403585751L;
        @Column(name="unit_id", nullable=false)
        private long unitId;
        @Column(name="measurement_defn_id", nullable=false)
        private int measurementDefinitionId;

        public PK(PK pk) {
            this.unitId = pk.unitId;
            this.measurementDefinitionId = pk.measurementDefinitionId;
        }

        public PK(long unitId, int measurementDefninitionId) {
            this.unitId = unitId;
            this.measurementDefinitionId = measurementDefninitionId;
        }

        public PK() {
        }

        public long getUnitId() {
            return this.unitId;
        }

        public void setUnitId(long unitId) {
            this.unitId = unitId;
        }

        public int getMeasurementDefinitionId() {
            return this.measurementDefinitionId;
        }

        public void setMeasurementTypeId(int measurementDefinitionId) {
            this.measurementDefinitionId = measurementDefinitionId;
        }

        public String toString() {
            return StringUtil.appendStrings((String[])new String[]{this.getClass().getSimpleName(), " (measurementTypeId = ", String.valueOf(this.measurementDefinitionId), "; ", "unitId = ", String.valueOf(this.unitId), ")"});
        }

        public int hashCode() {
            return (int)(this.unitId ^ this.unitId >>> 32) ^ (this.measurementDefinitionId ^ this.measurementDefinitionId >>> 32);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PK)) {
                return false;
            }
            PK other = (PK)o;
            return this.unitId == other.unitId && this.measurementDefinitionId == other.measurementDefinitionId;
        }
    }
}

