/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.measurement;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.grouphistory.Grouphistory;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IGdataHistory;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class MeasurementBase
extends EntityBase
implements IGdataHistory {
    private static final long serialVersionUID = 9047903012255951724L;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="unit_id", updatable=false, insertable=false)
    private UnitModel unitModel;
    @ManyToOne(targetEntity=MeasurementDefinition.class, fetch=FetchType.LAZY)
    @JoinColumn(name="measurement_defn_id", updatable=false, insertable=false)
    private MeasurementDefinition measurementDefinition;
    @Column(name="create_time", nullable=false)
    @Equals
    @ToString
    private long createTime;
    @Column(name="receive_time", nullable=false)
    @Equals
    @ToString
    private long receiveTime;
    @Column(name="value", nullable=false)
    @Equals
    @ToString
    private float value;
    @Column(name="group_history_id")
    @Equals
    @ToString
    private Long groupHistoryId;
    @Column(name="AREA_ID")
    @Equals
    @ToString
    private Integer areaId;
    @ManyToOne(targetEntity=Area.class, fetch=FetchType.LAZY)
    @JoinColumn(name="AREA_ID", updatable=false, insertable=false)
    private Area area;
    @Column(name="USE_USER_ID")
    @Equals
    @ToString
    private Long useUserId;
    @ManyToOne(targetEntity=UseUser.class, fetch=FetchType.LAZY)
    @JoinColumn(name="USE_USER_ID", updatable=false, insertable=false)
    private UseUser useUser;
    @Column(name="GDATA_HISTORY_ID")
    @Equals
    @ToString
    private Long gdataHistoryId;
    @ManyToOne(targetEntity=GdataHistory.class, fetch=FetchType.LAZY)
    @JoinColumn(name="GDATA_HISTORY_ID", updatable=false, insertable=false)
    private GdataHistory gdataHistory;
    @ManyToOne(targetEntity=Grouphistory.class, fetch=FetchType.LAZY)
    @JoinColumn(name="group_history_id", updatable=false, insertable=false)
    private Grouphistory groupHistory;

    public abstract long getUnitId();

    public abstract void setUnitId(long var1);

    public abstract int getMeasurementDefinitionId();

    public abstract void setMeasurementDefinitionId(int var1);

    public MeasurementBase() {
    }

    public MeasurementBase(MeasurementBase measurementBase) {
        this.createTime = measurementBase.createTime;
        this.receiveTime = measurementBase.receiveTime;
        this.value = measurementBase.value;
        this.groupHistoryId = measurementBase.groupHistoryId;
        this.groupHistory = measurementBase.groupHistory;
        this.measurementDefinition = measurementBase.measurementDefinition;
        this.unitModel = measurementBase.unitModel;
        this.useUser = measurementBase.useUser;
        this.useUserId = measurementBase.useUserId;
        this.area = measurementBase.area;
        this.areaId = measurementBase.areaId;
        this.gdataHistory = measurementBase.gdataHistory;
        this.gdataHistoryId = measurementBase.gdataHistoryId;
    }

    public String getName() {
        return this.getPrimaryKey().toString();
    }

    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    public MeasurementDefinition getMeasurementDefinition() {
        return this.measurementDefinition;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(long receiveTime) {
        this.receiveTime = receiveTime;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public Grouphistory getGroupHistory() {
        return this.groupHistory;
    }

    public void setGroupHistory(Grouphistory groupHistory) {
        this.groupHistory = groupHistory;
    }

    public Long getGroupHistoryId() {
        return this.groupHistoryId;
    }

    public void setGroupHistoryId(Long grouphistoryId) {
        this.groupHistoryId = grouphistoryId;
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public Long getUseUserId() {
        return this.useUserId;
    }

    public void setUseUserId(Long useUserId) {
        this.useUserId = useUserId;
    }

    @Override
    public Long getGdataHistoryId() {
        return this.gdataHistoryId;
    }

    @Override
    public void setGdataHistoryId(Long gdataHistoryId) {
        this.gdataHistoryId = gdataHistoryId;
    }

    public Area getArea() {
        return this.area;
    }

    @Override
    public GdataHistory getGdataHistory() {
        return this.gdataHistory;
    }

    public UseUser getUseUser() {
        return this.useUser;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MeasurementBase");
        stringBuilder.append(" (");
        stringBuilder.append("createTime = ");
        stringBuilder.append(this.createTime);
        stringBuilder.append(", ");
        stringBuilder.append("receiveTime = ");
        stringBuilder.append(this.receiveTime);
        stringBuilder.append(", ");
        stringBuilder.append("value = ");
        stringBuilder.append(this.value);
        stringBuilder.append(", ");
        stringBuilder.append("groupHistoryId = ");
        stringBuilder.append(this.groupHistoryId == null ? "[null]" : this.groupHistoryId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("areaId = ");
        stringBuilder.append(this.areaId == null ? "[null]" : this.areaId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("useUserId = ");
        stringBuilder.append(this.useUserId == null ? "[null]" : this.useUserId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("gdataHistoryId = ");
        stringBuilder.append(this.gdataHistoryId == null ? "[null]" : this.gdataHistoryId.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MeasurementBase measurementBase = (MeasurementBase)object;
        if (this.createTime != measurementBase.createTime) {
            return false;
        }
        if (this.receiveTime != measurementBase.receiveTime) {
            return false;
        }
        if (Float.floatToIntBits(this.value) != Float.floatToIntBits(measurementBase.value)) {
            return false;
        }
        if (this.groupHistoryId == null ? measurementBase.groupHistoryId != null : !this.groupHistoryId.equals(measurementBase.groupHistoryId)) {
            return false;
        }
        if (this.areaId == null ? measurementBase.areaId != null : !this.areaId.equals(measurementBase.areaId)) {
            return false;
        }
        if (this.useUserId == null ? measurementBase.useUserId != null : !this.useUserId.equals(measurementBase.useUserId)) {
            return false;
        }
        return !(this.gdataHistoryId == null ? measurementBase.gdataHistoryId != null : !this.gdataHistoryId.equals(measurementBase.gdataHistoryId));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.createTime ^ this.createTime >>> 32);
        n2 = n * n2 + (int)(this.receiveTime ^ this.receiveTime >>> 32);
        n2 = n * n2 + (this.value == 0.0f ? 0 : Float.floatToIntBits(this.value));
        n2 = n * n2 + (this.groupHistoryId == null ? 0 : this.groupHistoryId.hashCode());
        n2 = n * n2 + (this.areaId == null ? 0 : this.areaId.hashCode());
        n2 = n * n2 + (this.useUserId == null ? 0 : this.useUserId.hashCode());
        n2 = n * n2 + (this.gdataHistoryId == null ? 0 : this.gdataHistoryId.hashCode());
        return n2;
    }
}

