/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.keepalive;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.base.HistoryHelperBase;
import de.proveo.wwt.datamodel.keepalive.KeepAliveBase;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.keepalive.KeepaliveHistoryHelper;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="keepalive_history")
@NamedQueries(value={@NamedQuery(name="findKeepAliveHistoryByUnitAndPeriod", query="SELECT h FROM KeepAliveHistory h WHERE h.unitId = :unitId AND h.createTime BETWEEN :beginTime AND :endTime"), @NamedQuery(name="findKeepAliveHistoryAllByPeriod", query="SELECT h FROM KeepAliveHistory h , UnitModel u WHERE h.unitId = u.unitId AND u.airportmapVisible = true AND h.createTime BETWEEN ?1 AND ?2")})
public class KeepAliveHistory
extends KeepAliveBase
implements IHistoryEntity<KeepAliveHistory, KeepAliveCache> {
    private static final long serialVersionUID = -8239862232451872660L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long id;
    @JoinColumn(name="ID", updatable=false, insertable=false)
    @OneToMany(targetEntity=KeepaliveHistoryHelper.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<KeepaliveHistoryHelper> keepaliveHistoryHelper;
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private Long unitId;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @OneToOne(targetEntity=KeepAliveCache.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="history")
    @JoinColumn(name="id", referencedColumnName="history_id", insertable=false, updatable=false)
    private KeepAliveCache cache;

    public KeepAliveHistory() {
    }

    public KeepAliveHistory(KeepAliveCache keepAliveCache) {
        super(keepAliveCache);
    }

    @Override
    public Class<? extends HistoryHelperBase> getHelperClass() {
        return KeepaliveHistoryHelper.class;
    }

    @Override
    public long getBeginTime() {
        return this.getCreateTime();
    }

    @Override
    public void setBeginTime(long timestamp) {
        this.setCreateTime(timestamp);
    }

    @Override
    public void finishHistory(KeepAliveHistory oldHistory) {
    }

    @Override
    public KeepAliveCache generateCache() {
        return new KeepAliveCache(this);
    }

    @Override
    public long getHistoryId() {
        return this.id;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.id = historyId;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("KeepAliveHistory");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId == null ? "[null]" : this.unitId.toString());
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeepAliveHistory keepAliveHistory = (KeepAliveHistory)object;
        if (this.id != keepAliveHistory.id) {
            return false;
        }
        return !(this.unitId == null ? keepAliveHistory.unitId != null : !this.unitId.equals(keepAliveHistory.unitId));
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (this.unitId == null ? 0 : this.unitId.hashCode());
        return n2;
    }
}

