/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.keepalive;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.keepalive.KeepAliveBase;
import de.proveo.wwt.datamodel.keepalive.KeepAliveHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="keepalive_cache")
@NamedQueries(value={@NamedQuery(name="findKeepAliveCacheAll", query="SELECT k FROM KeepAliveCache k"), @NamedQuery(name="findKeepAliveCacheByUnitId", query="SELECT k FROM KeepAliveCache k WHERE k.unitId = ?1"), @NamedQuery(name="findKeepAliveCacheByUnitGroupId", query="SELECT c FROM KeepAliveCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1")})
public class KeepAliveCache
extends KeepAliveBase
implements ICacheEntity<KeepAliveHistory> {
    private static final long serialVersionUID = 96790801178558047L;
    @Id
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private long unitId;
    @OneToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @Column(name="history_id", nullable=false)
    @Equals
    @ToString
    private long historyId;
    @OneToOne(targetEntity=KeepAliveHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="history_id", updatable=false, insertable=false)
    private KeepAliveHistory history;

    public KeepAliveCache() {
    }

    public KeepAliveCache(KeepAliveBase keepAliveBase) {
        super(keepAliveBase);
        this.unitId = keepAliveBase.getUnitId();
        this.unitModel = new UnitModel(this.unitId);
    }

    @Override
    public long getBeginTime() {
        return this.getCreateTime();
    }

    @Override
    public void setBeginTime(long timestamp) {
        this.setCreateTime(timestamp);
    }

    public Object getPrimaryKey() {
        return this.unitId;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    @Override
    public long getHistoryId() {
        return this.historyId;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    @Override
    public KeepAliveHistory getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("KeepAliveCache");
        stringBuilder.append(" (");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId);
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeepAliveCache keepAliveCache = (KeepAliveCache)object;
        if (this.unitId != keepAliveCache.unitId) {
            return false;
        }
        return this.historyId == keepAliveCache.historyId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.unitId ^ this.unitId >>> 32);
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }
}

