/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.infoman.setup.update;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.infoman.software.InfomanSoftware;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.codec.binary.Base64;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="infoman_update")
@NamedQueries(value={@NamedQuery(name="findInfomanUpdatePlanedUpdates", query="SELECT u FROM InfomanUpdate u LEFT JOIN u.infomanSoftware JOIN FETCH u.account JOIN FETCH u.unitModel WHERE u.unitId=?1 AND u.done = false ORDER BY u.scheduledTime ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findInfomanUpdateActiveUpdates", query="SELECT u FROM InfomanUpdate u LEFT JOIN  u.infomanSoftware LEFT JOIN u.account JOIN FETCH u.unitModel WHERE u.unitId=?1 AND u.done = false AND u.scheduledTime<?2 ORDER BY u.scheduledTime ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findUpdateByConfigurationChecksum", query="SELECT u FROM InfomanUpdate u, UnitModel unit LEFT JOIN u.infomanSoftware LEFT JOIN u.account JOIN FETCH u.unitModel WHERE unit.unitId = ?1 AND u.configurationChecksumType = ?2 AND u.configurationChecksum = ?3", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InfomanUpdate
extends EntityBase {
    @Id
    @Column(name="UPDATE_ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long updateId;
    @Column(name="DESCRIPTION")
    @Equals
    @ToString
    private String description;
    @Lob
    @Column(name="CONFIGURATION")
    @Equals
    @ToString
    private byte[] configuration;
    @Column(name="DONE")
    @Equals
    @ToString
    private boolean done;
    @Column(name="CONFIGURATION_CHECKSUM")
    @Equals
    @ToString
    private String configurationChecksum;
    @Column(name="SUCCESSFULLY")
    @Equals
    @ToString
    private boolean successfully;
    @Column(name="CONFIGURATION_CHECKSUM_TYPE")
    @Equals
    @ToString
    private String configurationChecksumType;
    @Column(name="FINISHED_TIME")
    @Equals
    @ToString
    private long finishedTime;
    @Column(name="ERROR_MESSAGE")
    @Equals
    @ToString
    private String errorMessage;
    @Column(name="SCHEDULED_TIME")
    @Equals
    @ToString
    private long scheduledTime;
    @Column(name="CONFIGURATION_NAME")
    @Equals
    @ToString
    private String configurationName;
    @Column(name="ACCOUNT_ID")
    @Equals
    @ToString
    private Long accountId;
    @ManyToOne(targetEntity=Account.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ACCOUNT_ID", insertable=false, updatable=false)
    private Account account;
    @Column(name="START_TIME")
    @Equals
    @ToString
    private long startTime;
    @Column(name="CONFIGURATION_CONTENT_TYPE")
    @Equals
    @ToString
    private String configurationContentType;
    @Column(name="SOFTWARE_ID")
    @Equals
    @ToString
    private Long infomanSoftwareId;
    @ManyToOne(targetEntity=InfomanSoftware.class, fetch=FetchType.LAZY)
    @JoinColumn(name="SOFTWARE_ID", insertable=false, updatable=false)
    private InfomanSoftware infomanSoftware;
    @Column(name="UNIT_ID", nullable=false)
    @Equals
    @ToString
    private long unitId;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", nullable=false, insertable=false, updatable=false)
    private UnitModel unitModel;
    private static final long serialVersionUID = 1L;

    public InfomanUpdate(InfomanUpdate infomanUpdate) {
        this.updateId = infomanUpdate.updateId;
        this.description = infomanUpdate.description;
        this.configuration = infomanUpdate.configuration;
        this.done = infomanUpdate.done;
        this.configurationChecksum = infomanUpdate.configurationChecksum;
        this.successfully = infomanUpdate.successfully;
        this.configurationChecksumType = infomanUpdate.configurationChecksumType;
        this.finishedTime = infomanUpdate.finishedTime;
        this.errorMessage = infomanUpdate.errorMessage;
        this.scheduledTime = infomanUpdate.scheduledTime;
        this.configurationName = infomanUpdate.configurationName;
        this.accountId = infomanUpdate.accountId;
        this.account = infomanUpdate.account;
        this.startTime = infomanUpdate.startTime;
        this.configurationContentType = infomanUpdate.configurationContentType;
        this.infomanSoftwareId = infomanUpdate.infomanSoftwareId;
        this.infomanSoftware = infomanUpdate.infomanSoftware;
        this.unitId = infomanUpdate.unitId;
        this.unitModel = infomanUpdate.unitModel;
    }

    public InfomanUpdate() {
        try {
            new PropertyUtilsBean().getPropertyDescriptor((Object)this, "configuration").setValue("transient", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getName() {
        return this.description;
    }

    public Object getPrimaryKey() {
        return this.updateId;
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte[] getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(byte[] configuration) {
        this.configuration = configuration;
    }

    public boolean getDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public String getConfigurationChecksum() {
        return this.configurationChecksum;
    }

    public void setConfigurationChecksum(String configurationChecksum) {
        this.configurationChecksum = configurationChecksum;
    }

    public boolean getSuccessfully() {
        return this.successfully;
    }

    public void setSuccessfully(boolean successfully) {
        this.successfully = successfully;
    }

    public String getConfigurationChecksumType() {
        return this.configurationChecksumType;
    }

    public void setConfigurationChecksumType(String configurationChecksumType) {
        this.configurationChecksumType = configurationChecksumType;
    }

    public long getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(long finishedTime) {
        this.finishedTime = finishedTime;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Account getAccount() {
        return this.account;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getConfigurationContentType() {
        return this.configurationContentType;
    }

    public void setConfigurationContentType(String configurationContentType) {
        this.configurationContentType = configurationContentType;
    }

    public Long getInfomanSoftwareId() {
        return this.infomanSoftwareId;
    }

    public void setInfomanSoftwareId(Long infomanSoftwareId) {
        this.infomanSoftwareId = infomanSoftwareId;
    }

    public InfomanSoftware getInfomanSoftware() {
        return this.infomanSoftware;
    }

    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    public void setEncodedConfiguration(String encodedConfiguration) {
        try {
            this.setConfiguration(Base64.decodeBase64((byte[])encodedConfiguration.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getEncodedConfiguration() {
        if (this.getConfiguration() == null) {
            return null;
        }
        try {
            return new String(Base64.encodeBase64((byte[])this.getConfiguration()), "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InfomanUpdate");
        stringBuilder.append(" (");
        stringBuilder.append("updateId = ");
        stringBuilder.append(this.updateId);
        stringBuilder.append(", ");
        stringBuilder.append("description = ");
        stringBuilder.append(this.description == null ? "[null]" : this.description.toString());
        stringBuilder.append(", ");
        stringBuilder.append("configuration = ");
        stringBuilder.append(this.configuration == null ? "[null]" : this.configuration.toString());
        stringBuilder.append(", ");
        stringBuilder.append("done = ");
        stringBuilder.append(this.done);
        stringBuilder.append(", ");
        stringBuilder.append("configurationChecksum = ");
        stringBuilder.append(this.configurationChecksum == null ? "[null]" : this.configurationChecksum.toString());
        stringBuilder.append(", ");
        stringBuilder.append("successfully = ");
        stringBuilder.append(this.successfully);
        stringBuilder.append(", ");
        stringBuilder.append("configurationChecksumType = ");
        stringBuilder.append(this.configurationChecksumType == null ? "[null]" : this.configurationChecksumType.toString());
        stringBuilder.append(", ");
        stringBuilder.append("finishedTime = ");
        stringBuilder.append(this.finishedTime);
        stringBuilder.append(", ");
        stringBuilder.append("errorMessage = ");
        stringBuilder.append(this.errorMessage == null ? "[null]" : this.errorMessage.toString());
        stringBuilder.append(", ");
        stringBuilder.append("scheduledTime = ");
        stringBuilder.append(this.scheduledTime);
        stringBuilder.append(", ");
        stringBuilder.append("configurationName = ");
        stringBuilder.append(this.configurationName == null ? "[null]" : this.configurationName.toString());
        stringBuilder.append(", ");
        stringBuilder.append("accountId = ");
        stringBuilder.append(this.accountId == null ? "[null]" : this.accountId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("startTime = ");
        stringBuilder.append(this.startTime);
        stringBuilder.append(", ");
        stringBuilder.append("configurationContentType = ");
        stringBuilder.append(this.configurationContentType == null ? "[null]" : this.configurationContentType.toString());
        stringBuilder.append(", ");
        stringBuilder.append("infomanSoftwareId = ");
        stringBuilder.append(this.infomanSoftwareId == null ? "[null]" : this.infomanSoftwareId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        InfomanUpdate infomanUpdate = (InfomanUpdate)((Object)object);
        if (this.updateId != infomanUpdate.updateId) {
            return false;
        }
        if (this.description == null ? infomanUpdate.description != null : !this.description.equals(infomanUpdate.description)) {
            return false;
        }
        if (!Arrays.equals(this.configuration, infomanUpdate.configuration)) {
            return false;
        }
        if (this.done != infomanUpdate.done) {
            return false;
        }
        if (this.configurationChecksum == null ? infomanUpdate.configurationChecksum != null : !this.configurationChecksum.equals(infomanUpdate.configurationChecksum)) {
            return false;
        }
        if (this.successfully != infomanUpdate.successfully) {
            return false;
        }
        if (this.configurationChecksumType == null ? infomanUpdate.configurationChecksumType != null : !this.configurationChecksumType.equals(infomanUpdate.configurationChecksumType)) {
            return false;
        }
        if (this.finishedTime != infomanUpdate.finishedTime) {
            return false;
        }
        if (this.errorMessage == null ? infomanUpdate.errorMessage != null : !this.errorMessage.equals(infomanUpdate.errorMessage)) {
            return false;
        }
        if (this.scheduledTime != infomanUpdate.scheduledTime) {
            return false;
        }
        if (this.configurationName == null ? infomanUpdate.configurationName != null : !this.configurationName.equals(infomanUpdate.configurationName)) {
            return false;
        }
        if (this.accountId == null ? infomanUpdate.accountId != null : !this.accountId.equals(infomanUpdate.accountId)) {
            return false;
        }
        if (this.startTime != infomanUpdate.startTime) {
            return false;
        }
        if (this.configurationContentType == null ? infomanUpdate.configurationContentType != null : !this.configurationContentType.equals(infomanUpdate.configurationContentType)) {
            return false;
        }
        if (this.infomanSoftwareId == null ? infomanUpdate.infomanSoftwareId != null : !this.infomanSoftwareId.equals(infomanUpdate.infomanSoftwareId)) {
            return false;
        }
        return this.unitId == infomanUpdate.unitId;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.updateId ^ this.updateId >>> 32);
        n2 = n * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = n * n2 + Arrays.hashCode(this.configuration);
        n2 = n * n2 + (this.done ? 0 : 1);
        n2 = n * n2 + (this.configurationChecksum == null ? 0 : this.configurationChecksum.hashCode());
        n2 = n * n2 + (this.successfully ? 0 : 1);
        n2 = n * n2 + (this.configurationChecksumType == null ? 0 : this.configurationChecksumType.hashCode());
        n2 = n * n2 + (int)(this.finishedTime ^ this.finishedTime >>> 32);
        n2 = n * n2 + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        n2 = n * n2 + (int)(this.scheduledTime ^ this.scheduledTime >>> 32);
        n2 = n * n2 + (this.configurationName == null ? 0 : this.configurationName.hashCode());
        n2 = n * n2 + (this.accountId == null ? 0 : this.accountId.hashCode());
        n2 = n * n2 + (int)(this.startTime ^ this.startTime >>> 32);
        n2 = n * n2 + (this.configurationContentType == null ? 0 : this.configurationContentType.hashCode());
        n2 = n * n2 + (this.infomanSoftwareId == null ? 0 : this.infomanSoftwareId.hashCode());
        n2 = n * n2 + (int)(this.unitId ^ this.unitId >>> 32);
        return n2;
    }
}

