/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.groupIdent;

import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.role.IRoleOwner;
import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.datamodel.unit.permission.IUnitPermissionOwner;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="group_ident")
@NamedQuery(name="findGroupIdentAll", query="SELECT a FROM GroupIdent a ORDER BY a.groupName ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class GroupIdent
extends AuditEntityBase
implements Serializable,
IUnitPermissionOwner,
IRoleOwner {
    private static final long serialVersionUID = 1730722132492231561L;
    @AuditRelevant
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    private long id;
    @AuditRelevant
    @Column(name="GROUP_NAME")
    private String groupName;
    @AuditRelevant
    @ManyToMany(targetEntity=Role.class, fetch=FetchType.LAZY)
    @JoinTable(name="groupident_x_role", joinColumns={@JoinColumn(name="ID_GROUPIDENT")}, inverseJoinColumns={@JoinColumn(name="ID_ROLE")})
    private List<Role> roles = new ArrayList<Role>();
    @AuditRelevant
    @ManyToMany(targetEntity=Account.class, fetch=FetchType.LAZY, mappedBy="groups")
    @JoinTable(name="account_x_groupident", joinColumns={@JoinColumn(name="ID_GROUPIDENT")}, inverseJoinColumns={@JoinColumn(name="ID_ACCOUNT")})
    private List<Account> accounts = new ArrayList<Account>();
    @AuditRelevant
    @OneToMany(targetEntity=UnitPermission.class, mappedBy="groupIdent", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="GROUPIDENT")
    private List<UnitPermission> unitPermissions = new ArrayList<UnitPermission>();

    public GroupIdent(GroupIdent groupIdent) {
        this.id = groupIdent.id;
        this.groupName = groupIdent.groupName;
        this.roles = groupIdent.roles;
        this.accounts = groupIdent.accounts;
        this.unitPermissions = groupIdent.unitPermissions;
    }

    public GroupIdent() {
    }

    public String getName() {
        return this.groupName;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public Object getPrimaryKey() {
        return this.getId();
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public List<Role> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    @Override
    public List<UnitPermission> getUnitPermissions() {
        return this.unitPermissions;
    }

    @Override
    public void setUnitPermissions(List<UnitPermission> unitPermissions) {
        this.unitPermissions = unitPermissions;
    }

    @Override
    public void setPermissionOwner(UnitPermission unitPermission) {
        unitPermission.setGroupIdentId(this.id);
    }

    @Override
    public boolean isPermissionOwner(UnitPermission unitPermission) {
        Long id = unitPermission.getGroupIdentId();
        return id != null && id.equals(this.getPrimaryKey());
    }

    public boolean idHasBeenSet() {
        return this.id != 0L;
    }

    public void addAccount(Account account) {
        if (account != null && !this.accounts.contains(account)) {
            this.accounts.add(account);
            account.addGroupIdent(this);
        }
    }

    public void addUnitPermission(UnitPermission unitPermission) {
        if (unitPermission != null && !this.unitPermissions.contains(unitPermission)) {
            this.unitPermissions.add(unitPermission);
            unitPermission.setGroupIdent(this);
        }
    }

    @Override
    public void addRole(Role role) {
        if (role != null && !this.roles.contains(role)) {
            this.roles.add(role);
            role.addGroupIdent(this);
        }
    }

    @Override
    public void addRoles(List<Role> roles) {
        for (Role role : roles) {
            this.addRole(role);
        }
    }

    @Override
    public void replaceRoles(List<Role> newRoles) {
        if (this.roles == null) {
            this.roles = new ArrayList<Role>(newRoles.size());
        } else {
            this.roles.clear();
        }
        this.addRoles(newRoles);
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("GroupIdent ( ").append(super.toString()).append("    ").append("groupName = ").append(this.groupName).append("    ").append("id = ").append(this.id).append("    ").append(" )");
        return retValue.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupIdent)) {
            return false;
        }
        GroupIdent other = (GroupIdent)obj;
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        return this.id == other.id;
    }
}

