/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.geofencing;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geofencing.GeofGroup;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="geof_zone")
public class GeofZone
extends EntityBase {
    private static final long serialVersionUID = 1058789316923598099L;
    @Id
    @Column(name="ZONE_ID")
    private int zoneId;
    @ManyToOne(targetEntity=GeofGroup.class, fetch=FetchType.LAZY)
    @JoinColumn(name="GROUP_ID", updatable=false, insertable=false)
    private GeofGroup geofGroup;
    @Column(name="ZONE")
    private String zone;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="ZONE_ENTRY_NOTIFICATION_ID")
    private int zoneEntryNotificationId;
    @Column(name="ZONE_EXIT_NOTIFICATION_ID")
    private int zoneExitNotificationId;
    @Column(name="BLACKBOARD_ITEM")
    private String blackBoardItem;
    @Column(name="ZONE_ENTRY")
    private boolean zoneEntry;
    @Column(name="ZONE_EXIT")
    private boolean zoneExit;
    @ManyToMany(targetEntity=Area.class, fetch=FetchType.LAZY)
    @JoinTable(name="geof_area_x_zone", joinColumns={@JoinColumn(name="ZONE_ID")}, inverseJoinColumns={@JoinColumn(name="AREA_ID")})
    private List<Area> areas = new ArrayList<Area>();

    public String getName() {
        return this.zone;
    }

    public Object getPrimaryKey() {
        return this.zoneId;
    }

    public int getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(int zoneId) {
        this.zoneId = zoneId;
    }

    public GeofGroup getGeofGroup() {
        return this.geofGroup;
    }

    public void setGeofGroup(GeofGroup geofGroup) {
        this.geofGroup = geofGroup;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getZoneEntryNotificationId() {
        return this.zoneEntryNotificationId;
    }

    public void setZoneEntryNotificationId(int zoneEntryNotificationId) {
        this.zoneEntryNotificationId = zoneEntryNotificationId;
    }

    public int getZoneExitNotificationId() {
        return this.zoneExitNotificationId;
    }

    public void setZoneExitNotificationId(int zoneExitNotificationId) {
        this.zoneExitNotificationId = zoneExitNotificationId;
    }

    public String getBlackBoardItem() {
        return this.blackBoardItem;
    }

    public void setBlackBoardItem(String blackBoardItem) {
        this.blackBoardItem = blackBoardItem;
    }

    public boolean isZoneEntry() {
        return this.zoneEntry;
    }

    public void setZoneEntry(boolean zoneEntry) {
        this.zoneEntry = zoneEntry;
    }

    public boolean isZoneExit() {
        return this.zoneExit;
    }

    public void setZoneExit(boolean zoneExit) {
        this.zoneExit = zoneExit;
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public void setAreas(List<Area> areas) {
        this.areas = areas;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blackBoardItem == null ? 0 : this.blackBoardItem.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.geofGroup == null ? 0 : this.geofGroup.hashCode());
        result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
        result = 31 * result + (this.zoneEntry ? 1231 : 1237);
        result = 31 * result + this.zoneEntryNotificationId;
        result = 31 * result + (this.zoneExit ? 1231 : 1237);
        result = 31 * result + this.zoneExitNotificationId;
        result = 31 * result + this.zoneId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GeofZone other = (GeofZone)((Object)obj);
        if (this.blackBoardItem == null ? other.blackBoardItem != null : !this.blackBoardItem.equals(other.blackBoardItem)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.geofGroup == null ? other.geofGroup != null : !this.geofGroup.equals((Object)other.geofGroup)) {
            return false;
        }
        if (this.zone == null ? other.zone != null : !this.zone.equals(other.zone)) {
            return false;
        }
        if (this.zoneEntry != other.zoneEntry) {
            return false;
        }
        if (this.zoneEntryNotificationId != other.zoneEntryNotificationId) {
            return false;
        }
        if (this.zoneExit != other.zoneExit) {
            return false;
        }
        if (this.zoneExitNotificationId != other.zoneExitNotificationId) {
            return false;
        }
        return this.zoneId == other.zoneId;
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer retValue = new StringBuffer();
        retValue.append("GeofZone ( ").append(super.toString()).append("    ").append("zoneId = ").append(this.zoneId).append("    ").append("geofGroup = ").append((Object)this.geofGroup).append("    ").append("zone = ").append(this.zone).append("    ").append("description = ").append(this.description).append("    ").append("zoneEntryNotificationId = ").append(this.zoneEntryNotificationId).append("    ").append("zoneExitNotificationId = ").append(this.zoneExitNotificationId).append("    ").append("blackBoardItem = ").append(this.blackBoardItem).append("    ").append("zoneEntry = ").append(this.zoneEntry).append("    ").append("zoneExit = ").append(this.zoneExit).append("    ").append(" )");
        return retValue.toString();
    }
}

