/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.geo;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.grouphistory.Grouphistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class GdataBase
extends AuditEntityBase {
    private static final long serialVersionUID = -1590501673567673760L;
    @AuditRelevant
    @Column(name="BEGIN_TIME")
    @Equals
    @ToString
    private long beginTime;
    @AuditRelevant
    @Column(name="BEGIN_RECEIVE_TIME")
    @Equals
    @ToString
    private long beginReceiveTime;
    @AuditRelevant
    @Column(name="LAT_MSEC")
    @Equals
    @ToString
    private int latMsec;
    @AuditRelevant
    @Column(name="LONG_MSEC")
    @Equals
    @ToString
    private int longMsec;
    @AuditRelevant
    @Column(name="RMC_REC")
    @Equals
    @ToString
    private String rmcRec;
    @AuditRelevant
    @Column(name="GGA_REC")
    @Equals
    @ToString
    private String ggaRec;
    @Column(name="TRUSTED")
    @Equals
    @ToString
    private boolean trusted;
    @Column(name="REASON")
    @Equals
    @ToString
    private String reason;
    @Column(name="AREA_ID")
    @Equals
    @ToString
    private Integer areaId;
    @AuditRelevant
    @ManyToOne(targetEntity=Area.class, fetch=FetchType.EAGER)
    @JoinColumn(name="AREA_ID", updatable=false, insertable=false)
    private Area area;
    @Column(name="GROUP_HISTORY_ID")
    @Equals
    @ToString
    private Long groupHistoryId;
    @ManyToOne(targetEntity=Grouphistory.class, fetch=FetchType.LAZY)
    @JoinColumn(name="GROUP_HISTORY_ID", updatable=false, insertable=false)
    @Equals
    @ToString
    private Grouphistory groupHistory;

    public abstract long getUnitId();

    public abstract void setUnitId(long var1);

    public abstract UnitModel getUnitModel();

    protected abstract long getHistoryId();

    protected abstract void setUnitModel(UnitModel var1);

    public GdataBase() {
    }

    public GdataBase(GdataBase g) {
        this.beginTime = g.beginTime;
        this.beginReceiveTime = g.beginReceiveTime;
        this.latMsec = g.latMsec;
        this.longMsec = g.longMsec;
        this.rmcRec = g.rmcRec;
        this.ggaRec = g.ggaRec;
        this.trusted = g.trusted;
        this.reason = g.reason;
        this.areaId = g.areaId;
        this.area = g.area;
        this.groupHistoryId = g.groupHistoryId;
        this.groupHistory = g.getGroupHistory();
    }

    public String getName() {
        return this.getUnitModel().getName();
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getBeginReceiveTime() {
        return this.beginReceiveTime;
    }

    public void setBeginReceiveTime(long beginReceiveTime) {
        this.beginReceiveTime = beginReceiveTime;
    }

    public long getEndTime() {
        return 0L;
    }

    public void setEndTime(long endTime) {
    }

    public long getEndReceiveTime() {
        return 0L;
    }

    public void setEndReceiveTime(long endReceiveTime) {
    }

    public int getLatMsec() {
        return this.latMsec;
    }

    public void setLatMsec(int latMsec) {
        this.latMsec = latMsec;
    }

    public int getLongMsec() {
        return this.longMsec;
    }

    public void setLongMsec(int longMsec) {
        this.longMsec = longMsec;
    }

    public String getRmcRec() {
        return this.rmcRec;
    }

    public void setRmcRec(String rmcRec) {
        this.rmcRec = rmcRec;
    }

    public String getGgaRec() {
        return this.ggaRec;
    }

    public void setGgaRec(String ggaRec) {
        this.ggaRec = ggaRec;
    }

    public boolean getTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public Grouphistory getGroupHistory() {
        return this.groupHistory;
    }

    public Long getGroupHistoryId() {
        return this.groupHistoryId;
    }

    public void setGroupHistoryId(Long grouphistoryId) {
        this.groupHistoryId = grouphistoryId;
    }

    @Deprecated
    public void setStruct(GeoStruct struct) {
        this.setUnitId(struct.getUnitId());
        this.setBeginTime(struct.getBeginTime());
        this.setBeginReceiveTime(struct.getBeginReceiveTime());
        this.setEndTime(struct.getEndTime());
        this.setEndReceiveTime(struct.getEndReceiveTime());
        this.setRmcRec(struct.getRmcRec());
        this.setGgaRec(struct.getGgaRec());
        this.setAreaId(struct.getAreaId());
        this.setTrusted(struct.isTrusted());
        this.setReason(struct.getReason());
        this.setLongMsec(struct.getLongMSEC());
        this.setLatMsec(struct.getLatMSEC());
    }

    @Deprecated
    public GeoStruct getStruct() {
        String areaDesc = "";
        String areaName = "";
        Area area = this.getArea();
        if (area != null) {
            areaName = area.getArea() == null ? "" : area.getArea();
            areaDesc = area.getDescription() == null ? "" : area.getDescription();
        }
        return new GeoStruct(this.getUnitId(), this.getBeginTime(), this.getBeginReceiveTime(), this.getEndTime(), this.getEndReceiveTime(), this.getHistoryId(), this.getRmcRec(), this.getGgaRec(), areaName, areaDesc, this.getTrusted(), this.getReason(), this.getLongMsec(), this.getLatMsec(), area);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GdataBase");
        stringBuilder.append(" (");
        stringBuilder.append("beginTime = ");
        stringBuilder.append(this.beginTime);
        stringBuilder.append(", ");
        stringBuilder.append("beginReceiveTime = ");
        stringBuilder.append(this.beginReceiveTime);
        stringBuilder.append(", ");
        stringBuilder.append("latMsec = ");
        stringBuilder.append(this.latMsec);
        stringBuilder.append(", ");
        stringBuilder.append("longMsec = ");
        stringBuilder.append(this.longMsec);
        stringBuilder.append(", ");
        stringBuilder.append("rmcRec = ");
        stringBuilder.append(this.rmcRec == null ? "[null]" : this.rmcRec.toString());
        stringBuilder.append(", ");
        stringBuilder.append("ggaRec = ");
        stringBuilder.append(this.ggaRec == null ? "[null]" : this.ggaRec.toString());
        stringBuilder.append(", ");
        stringBuilder.append("trusted = ");
        stringBuilder.append(this.trusted);
        stringBuilder.append(", ");
        stringBuilder.append("reason = ");
        stringBuilder.append(this.reason == null ? "[null]" : this.reason.toString());
        stringBuilder.append(", ");
        stringBuilder.append("areaId = ");
        stringBuilder.append(this.areaId == null ? "[null]" : this.areaId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("groupHistoryId = ");
        stringBuilder.append(this.groupHistoryId == null ? "[null]" : this.groupHistoryId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("groupHistory = ");
        stringBuilder.append(this.groupHistory == null ? "[null]" : this.groupHistory.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        GdataBase gdataBase = (GdataBase)((Object)object);
        if (this.beginTime != gdataBase.beginTime) {
            return false;
        }
        if (this.beginReceiveTime != gdataBase.beginReceiveTime) {
            return false;
        }
        if (this.latMsec != gdataBase.latMsec) {
            return false;
        }
        if (this.longMsec != gdataBase.longMsec) {
            return false;
        }
        if (this.rmcRec == null ? gdataBase.rmcRec != null : !this.rmcRec.equals(gdataBase.rmcRec)) {
            return false;
        }
        if (this.ggaRec == null ? gdataBase.ggaRec != null : !this.ggaRec.equals(gdataBase.ggaRec)) {
            return false;
        }
        if (this.trusted != gdataBase.trusted) {
            return false;
        }
        if (this.reason == null ? gdataBase.reason != null : !this.reason.equals(gdataBase.reason)) {
            return false;
        }
        if (this.areaId == null ? gdataBase.areaId != null : !this.areaId.equals(gdataBase.areaId)) {
            return false;
        }
        if (this.groupHistoryId == null ? gdataBase.groupHistoryId != null : !this.groupHistoryId.equals(gdataBase.groupHistoryId)) {
            return false;
        }
        return !(this.groupHistory == null ? gdataBase.groupHistory != null : !this.groupHistory.equals(gdataBase.groupHistory));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (int)(this.beginTime ^ this.beginTime >>> 32);
        n2 = n * n2 + (int)(this.beginReceiveTime ^ this.beginReceiveTime >>> 32);
        n2 = n * n2 + this.latMsec;
        n2 = n * n2 + this.longMsec;
        n2 = n * n2 + (this.rmcRec == null ? 0 : this.rmcRec.hashCode());
        n2 = n * n2 + (this.ggaRec == null ? 0 : this.ggaRec.hashCode());
        n2 = n * n2 + (this.trusted ? 0 : 1);
        n2 = n * n2 + (this.reason == null ? 0 : this.reason.hashCode());
        n2 = n * n2 + (this.areaId == null ? 0 : this.areaId.hashCode());
        n2 = n * n2 + (this.groupHistoryId == null ? 0 : this.groupHistoryId.hashCode());
        n2 = n * n2 + (this.groupHistory == null ? 0 : this.groupHistory.hashCode());
        return n2;
    }
}

