/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.file;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.file.FileBase;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;

@Entity
@Table(name="file_storage")
@NamedQueries(value={@NamedQuery(name="FileStorage.findByModuleId", query="SELECT a FROM FileStorage a WHERE a.moduleId = ?1 ORDER BY a.parentId, a.name"), @NamedQuery(name="FileStorage.findModuleIdWithoutDataBlob", query="SELECT a.id, a.filename, a.name, a.description, a.contentType, a.size, a.createTime FROM FileStorage a WHERE a.moduleId = ?1 ORDER BY a.parentId, a.name"), @NamedQuery(name="FileStorage.findByParentId", query="SELECT a FROM FileStorage a WHERE a.parentId = ?1 ORDER BY a.name")})
public class FileStorage
extends FileBase {
    private static final long serialVersionUID = 5675859047746091728L;
    private static final Log log = LogFactory.getLog(FileStorage.class);
    @Transient
    private static final int BLOB_SIZE = Integer.MAX_VALUE;
    @Equals
    @Column(name="data", length=0x7FFFFFFF, nullable=false)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private Blob data;
    @Equals
    @Column(name="filename", length=255, nullable=false)
    @ToString
    private String filename;
    @Equals
    @Column(name="content_type", length=64, nullable=false)
    @ToString
    private String contentType;
    @Equals
    @Column(name="filesize", nullable=false)
    @ToString
    private int size;

    public byte[] getData() {
        try {
            if (this.data != null) {
                return this.data.getBytes(1L, (int)this.data.length());
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return new byte[0];
    }

    public void setData(byte[] data) {
        this.data = Hibernate.createBlob((byte[])data);
        this.size = data != null ? data.length : 0;
    }

    public InputStream getStream() {
        try {
            if (this.data != null) {
                return this.data.getBinaryStream();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return null;
    }

    public void setStream(InputStream inputStream) {
        try {
            this.data = Hibernate.createBlob((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
            this.data = null;
            this.size = 0;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FileStorage");
        stringBuilder.append(" (");
        stringBuilder.append("filename = ");
        stringBuilder.append(this.filename == null ? "[null]" : this.filename.toString());
        stringBuilder.append(", ");
        stringBuilder.append("contentType = ");
        stringBuilder.append(this.contentType == null ? "[null]" : this.contentType.toString());
        stringBuilder.append(", ");
        stringBuilder.append("size = ");
        stringBuilder.append(this.size);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        FileStorage fileStorage = (FileStorage)((Object)object);
        if (this.data == null ? fileStorage.data != null : !this.data.equals(fileStorage.data)) {
            return false;
        }
        if (this.filename == null ? fileStorage.filename != null : !this.filename.equals(fileStorage.filename)) {
            return false;
        }
        if (this.contentType == null ? fileStorage.contentType != null : !this.contentType.equals(fileStorage.contentType)) {
            return false;
        }
        return this.size == fileStorage.size;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (this.data == null ? 0 : this.data.hashCode());
        n2 = n * n2 + (this.filename == null ? 0 : this.filename.hashCode());
        n2 = n * n2 + (this.contentType == null ? 0 : this.contentType.hashCode());
        n2 = n * n2 + this.size;
        return n2;
    }
}

