/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.Action;

public interface VCSHistoryProvider {
    public HistoryEntry[] getHistory(File[] var1, Date var2);

    public Action createShowHistoryAction(File[] var1);

    public void addHistoryChangeListener(HistoryChangeListener var1);

    public void removeHistoryChangeListener(HistoryChangeListener var1);

    public static interface HistoryChangeListener {
        public void fireHistoryChanged(HistoryEvent var1);
    }

    public static final class HistoryEntry {
        private Date dateTime;
        private String message;
        private File[] files;
        private String usernameShort;
        private String username;
        private String revisionShort;
        private String revision;
        private Action[] actions;
        private RevisionProvider revisionProvider;
        private MessageEditProvider messageEditProvider;
        private ParentProvider parentProvider;

        public HistoryEntry(File[] files, Date dateTime, String message, String username, String usernameShort, String revision, String revisionShort, Action[] actions, RevisionProvider revisionProvider) {
            assert (files != null && files.length > 0) : "a history entry must have at least one file";
            assert (revision != null && revision != null) : "a history entry must have a revision";
            assert (dateTime != null) : "a history entry must have a date";
            assert (message != null) : "a history entry must have a message, at least empty";
            this.files = files;
            this.dateTime = dateTime;
            this.message = message;
            this.username = username;
            this.usernameShort = usernameShort;
            this.revision = revision;
            this.revisionShort = revisionShort;
            this.actions = actions;
            this.revisionProvider = revisionProvider;
        }

        public HistoryEntry(File[] files, Date dateTime, String message, String username, String usernameShort, String revision, String revisionShort, Action[] actions, RevisionProvider revisionProvider, MessageEditProvider messageEditProvider) {
            this(files, dateTime, message, username, usernameShort, revision, revisionShort, actions, revisionProvider);
            this.messageEditProvider = messageEditProvider;
        }

        public HistoryEntry(File[] files, Date dateTime, String message, String username, String usernameShort, String revision, String revisionShort, Action[] actions, RevisionProvider revisionProvider, MessageEditProvider messageEditProvider, ParentProvider parentProvider) {
            this(files, dateTime, message, username, usernameShort, revision, revisionShort, actions, revisionProvider, messageEditProvider);
            this.parentProvider = parentProvider;
        }

        public boolean canEdit() {
            return this.messageEditProvider != null;
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) throws IOException {
            if (!this.canEdit()) {
                throw new IllegalStateException("This entry is read-only");
            }
            this.messageEditProvider.setMessage(message);
            this.message = message;
        }

        public File[] getFiles() {
            return this.files;
        }

        public String getUsername() {
            return this.username;
        }

        public String getUsernameShort() {
            return this.usernameShort;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getRevisionShort() {
            return this.revisionShort;
        }

        public Action[] getActions() {
            return this.actions;
        }

        public void getRevisionFile(File originalFile, File revisionFile) {
            if (this.revisionProvider != null) {
                this.revisionProvider.getRevisionFile(originalFile, revisionFile);
            }
        }

        public HistoryEntry getParentEntry(File file) {
            if (this.parentProvider != null) {
                return this.parentProvider.getParentEntry(file);
            }
            return null;
        }

        RevisionProvider getRevisionProvier() {
            return this.revisionProvider;
        }

        MessageEditProvider getMessageEditProvider() {
            return this.messageEditProvider;
        }

        ParentProvider getParentProvider() {
            return this.parentProvider;
        }
    }

    public static final class HistoryEvent {
        private final File[] files;
        private final VCSHistoryProvider source;

        public HistoryEvent(VCSHistoryProvider source, File[] files) {
            this.files = files;
            this.source = source;
        }

        public File[] getFiles() {
            return this.files;
        }

        public VCSHistoryProvider getSource() {
            return this.source;
        }
    }

    public static interface MessageEditProvider {
        public void setMessage(String var1) throws IOException;
    }

    public static interface ParentProvider {
        public HistoryEntry getParentEntry(File var1);
    }

    public static interface RevisionProvider {
        public void getRevisionFile(File var1, File var2);
    }
}

