/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class SVNStatus {
    private SVNURL myURL;
    private File myFile;
    private SVNNodeKind myKind;
    private SVNRevision myRevision;
    private SVNRevision myCommittedRevision;
    private Date myCommittedDate;
    private String myAuthor;
    private SVNStatusType myContentsStatus;
    private SVNStatusType myPropertiesStatus;
    private SVNStatusType myRemoteContentsStatus;
    private SVNStatusType myRemoteNodeStatus;
    private SVNStatusType myRemotePropertiesStatus;
    private boolean myIsLocked;
    private boolean myIsCopied;
    private boolean myIsSwitched;
    private boolean myIsFileExternal;
    private File myConflictNewFile;
    private File myConflictOldFile;
    private File myConflictWrkFile;
    private File myPropRejectFile;
    private String myCopyFromURL;
    private SVNRevision myCopyFromRevision;
    private SVNLock myRemoteLock;
    private SVNLock myLocalLock;
    private Map myEntryProperties;
    private SVNRevision myRemoteRevision;
    private SVNURL myRemoteURL;
    private SVNNodeKind myRemoteKind;
    private String myRemoteAuthor;
    private Date myRemoteDate;
    private Date myLocalContentsDate;
    private Date myLocalPropertiesDate;
    private SVNEntry myEntry;
    private String myChangelistName;
    private int myWorkingCopyFormat;
    private SVNTreeConflictDescription myTreeConflict;
    private boolean myIsConflicted;
    private SVNStatusType myNodeStatus;
    private SVNURL myRepositoryRootURL;
    private String myRepositoryUUID;
    private String myRepositoryRelativePath;
    private boolean myIsVersioned;
    private SVNDepth myDepth;
    private File myMovedToPath;
    private File myMovedFromPath;

    public SVNStatus(SVNURL url, File file, SVNNodeKind kind, SVNRevision revision, SVNRevision committedRevision, Date committedDate, String author, SVNStatusType contentsStatus, SVNStatusType propertiesStatus, SVNStatusType remoteContentsStatus, SVNStatusType remotePropertiesStatus, boolean isLocked, boolean isCopied, boolean isSwitched, boolean isFileExternal, File conflictNewFile, File conflictOldFile, File conflictWrkFile, File projRejectFile, String copyFromURL, SVNRevision copyFromRevision, SVNLock remoteLock, SVNLock localLock, Map entryProperties, String changelistName, int wcFormatVersion, SVNTreeConflictDescription treeConflict) {
        this.myURL = url;
        this.myFile = file;
        this.myKind = kind == null ? SVNNodeKind.NONE : kind;
        this.myRevision = revision == null ? SVNRevision.UNDEFINED : revision;
        this.myCommittedRevision = committedRevision == null ? SVNRevision.UNDEFINED : committedRevision;
        this.myCommittedDate = committedDate;
        this.myAuthor = author;
        this.myContentsStatus = contentsStatus == null ? SVNStatusType.STATUS_NONE : contentsStatus;
        this.myPropertiesStatus = propertiesStatus == null ? SVNStatusType.STATUS_NONE : propertiesStatus;
        this.myRemoteContentsStatus = remoteContentsStatus == null ? SVNStatusType.STATUS_NONE : remoteContentsStatus;
        this.myRemotePropertiesStatus = remotePropertiesStatus == null ? SVNStatusType.STATUS_NONE : remotePropertiesStatus;
        this.myRemoteNodeStatus = SVNStatusType.STATUS_NONE;
        this.myIsLocked = isLocked;
        this.myIsCopied = isCopied;
        this.myIsSwitched = isSwitched;
        this.myIsFileExternal = isFileExternal;
        this.myConflictNewFile = conflictNewFile;
        this.myConflictOldFile = conflictOldFile;
        this.myConflictWrkFile = conflictWrkFile;
        this.myCopyFromURL = copyFromURL;
        this.myCopyFromRevision = copyFromRevision == null ? SVNRevision.UNDEFINED : copyFromRevision;
        this.myRemoteLock = remoteLock;
        this.myLocalLock = localLock;
        this.myPropRejectFile = projRejectFile;
        this.myEntryProperties = entryProperties;
        this.myChangelistName = changelistName;
        this.myWorkingCopyFormat = wcFormatVersion;
        this.myTreeConflict = treeConflict;
        this.myRemoteRevision = SVNRevision.UNDEFINED;
    }

    public SVNStatus() {
        this.setCopyFromRevision(SVNRevision.UNDEFINED);
        this.setRevision(SVNRevision.UNDEFINED);
        this.setRemoteRevision(SVNRevision.UNDEFINED);
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public SVNURL getRemoteURL() {
        return this.myRemoteURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public SVNNodeKind getKind() {
        return this.myKind;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public SVNStatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    public SVNStatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public SVNStatusType getRemoteContentsStatus() {
        return this.myRemoteContentsStatus;
    }

    public SVNStatusType getRemotePropertiesStatus() {
        return this.myRemotePropertiesStatus;
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public boolean isCopied() {
        return this.myIsCopied;
    }

    public boolean isSwitched() {
        return this.myIsSwitched;
    }

    public boolean isFileExternal() {
        return this.myIsFileExternal;
    }

    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    public File getPropRejectFile() {
        return this.myPropRejectFile;
    }

    public String getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNLock getRemoteLock() {
        return this.myRemoteLock;
    }

    public SVNLock getLocalLock() {
        return this.myLocalLock;
    }

    public Map getEntryProperties() {
        return this.myEntryProperties;
    }

    public SVNRevision getRemoteRevision() {
        return this.myRemoteRevision;
    }

    public SVNNodeKind getRemoteKind() {
        return this.myRemoteKind;
    }

    public Date getRemoteDate() {
        return this.myRemoteDate;
    }

    public String getRemoteAuthor() {
        return this.myRemoteAuthor;
    }

    public Date getWorkingContentsDate() {
        if (this.myLocalContentsDate == null) {
            this.myLocalContentsDate = this.getFile() != null && this.getKind() == SVNNodeKind.FILE ? new Date(SVNFileUtil.getFileLastModified(this.getFile())) : new Date(0L);
        }
        return this.myLocalContentsDate;
    }

    public Date getWorkingPropertiesDate() {
        if (this.myLocalPropertiesDate == null) {
            File propFile = null;
            if (this.getFile() != null && this.getKind() == SVNNodeKind.DIR) {
                propFile = new File(this.getFile().getAbsoluteFile(), SVNFileUtil.getAdminDirectoryName());
                propFile = new File(propFile, "dir-props");
            } else if (this.getFile() != null && this.getKind() == SVNNodeKind.FILE) {
                propFile = new File(this.getFile().getAbsoluteFile().getParentFile(), SVNFileUtil.getAdminDirectoryName());
                propFile = new File(propFile, "props/" + this.getFile().getName() + ".svn-work");
            }
            this.myLocalPropertiesDate = propFile != null ? new Date(SVNFileUtil.getFileLastModified(propFile)) : new Date(0L);
        }
        return this.myLocalPropertiesDate;
    }

    public void markExternal() {
        this.myContentsStatus = SVNStatusType.STATUS_EXTERNAL;
    }

    public void setRemoteStatus(SVNStatusType contents, SVNStatusType props, SVNLock lock, SVNNodeKind kind) {
        if (contents == SVNStatusType.STATUS_ADDED && this.myRemoteContentsStatus == SVNStatusType.STATUS_DELETED) {
            contents = SVNStatusType.STATUS_REPLACED;
        }
        this.myRemoteContentsStatus = contents != null ? contents : this.myRemoteContentsStatus;
        SVNStatusType sVNStatusType = this.myRemotePropertiesStatus = props != null ? props : this.myRemotePropertiesStatus;
        if (lock != null) {
            this.myRemoteLock = lock;
        }
        if (kind != null) {
            this.myRemoteKind = kind;
        }
    }

    public void setRemoteStatus(SVNURL url, SVNStatusType contents, SVNStatusType props, SVNLock lock, SVNNodeKind kind, SVNRevision revision, Date date, String author) {
        this.setRemoteStatus(contents, props, lock, kind);
        this.myRemoteURL = url;
        this.myRemoteRevision = revision == null ? SVNRevision.UNDEFINED : revision;
        this.myRemoteDate = date;
        this.myRemoteAuthor = author;
        this.myRemoteKind = kind;
    }

    public void setContentsStatus(SVNStatusType statusType) {
        this.myContentsStatus = statusType;
    }

    public void setEntry(SVNEntry entry) {
        this.myEntry = entry;
    }

    public SVNEntry getEntry() {
        return this.myEntry;
    }

    public String getChangelistName() {
        return this.myChangelistName;
    }

    public SVNTreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public int getWorkingCopyFormat() {
        return this.myWorkingCopyFormat;
    }

    public void setConflicted(boolean isConflicted) {
        this.myIsConflicted = isConflicted;
    }

    public boolean isConflicted() {
        return this.myIsConflicted;
    }

    public boolean isVersioned() {
        if (this.myIsVersioned) {
            return this.myIsVersioned;
        }
        return this.getEntry() != null || this.myEntryProperties != null;
    }

    public SVNStatusType getRemoteNodeStatus() {
        return this.myRemoteNodeStatus;
    }

    public SVNStatusType getCombinedNodeAndContentsStatus() {
        int workingCopyFormat = this.getWorkingCopyFormat();
        SVNStatusType nodeStatus = this.getNodeStatus();
        SVNStatusType contentsStatus = this.getContentsStatus();
        boolean versioned = this.isVersioned();
        boolean conflicted = this.isConflicted();
        return SVNStatus.combineNodeAndContentsStatus(workingCopyFormat, nodeStatus, contentsStatus, versioned, conflicted);
    }

    public SVNStatusType getCombinedRemoteNodeAndContentsStatus() {
        int workingCopyFormat = this.getWorkingCopyFormat();
        SVNStatusType remoteNodeStatus = this.getRemoteNodeStatus();
        SVNStatusType remoteContentsStatus = this.getRemoteContentsStatus();
        return SVNStatus.combineRemoteNodeAndContentsStatus(workingCopyFormat, remoteNodeStatus, remoteContentsStatus);
    }

    public SVNStatusType getNodeStatus() {
        if (this.myNodeStatus == null) {
            return this.myContentsStatus;
        }
        return this.myNodeStatus;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    public String getRepositoryRelativePath() {
        return this.myRepositoryRelativePath;
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    public File getMovedToPath() {
        return this.myMovedToPath;
    }

    public File getMovedFromPath() {
        return this.myMovedFromPath;
    }

    public void setRemoteNodeStatus(SVNStatusType remoteNodeStatus) {
        this.myRemoteNodeStatus = remoteNodeStatus;
    }

    public void setNodeStatus(SVNStatusType nodeStatus) {
        this.myNodeStatus = nodeStatus;
    }

    public void setRepositoryRootURL(SVNURL repositoryRootURL) {
        this.myRepositoryRootURL = repositoryRootURL;
    }

    public void setRepositoryUUID(String repositoryUUID) {
        this.myRepositoryUUID = repositoryUUID;
    }

    public void setRepositoryRelativePath(String repositoryRelativePath) {
        this.myRepositoryRelativePath = repositoryRelativePath;
    }

    public void setURL(SVNURL uRL) {
        this.myURL = uRL;
    }

    public void setFile(File file) {
        this.myFile = file;
    }

    public void setKind(SVNNodeKind kind) {
        this.myKind = kind;
    }

    public void setRevision(SVNRevision revision) {
        this.myRevision = revision;
    }

    public void setCommittedRevision(SVNRevision committedRevision) {
        this.myCommittedRevision = committedRevision;
    }

    public void setCommittedDate(Date committedDate) {
        this.myCommittedDate = committedDate;
    }

    public void setAuthor(String author) {
        this.myAuthor = author;
    }

    public void setPropertiesStatus(SVNStatusType propertiesStatus) {
        this.myPropertiesStatus = propertiesStatus;
    }

    public void setRemoteContentsStatus(SVNStatusType remoteContentsStatus) {
        this.myRemoteContentsStatus = remoteContentsStatus;
    }

    public void setRemotePropertiesStatus(SVNStatusType remotePropertiesStatus) {
        this.myRemotePropertiesStatus = remotePropertiesStatus;
    }

    public void setIsLocked(boolean isLocked) {
        this.myIsLocked = isLocked;
    }

    public void setIsCopied(boolean isCopied) {
        this.myIsCopied = isCopied;
    }

    public void setIsSwitched(boolean isSwitched) {
        this.myIsSwitched = isSwitched;
    }

    public void setIsFileExternal(boolean isFileExternal) {
        this.myIsFileExternal = isFileExternal;
    }

    public void setConflictNewFile(File conflictNewFile) {
        this.myConflictNewFile = conflictNewFile;
    }

    public void setConflictOldFile(File conflictOldFile) {
        this.myConflictOldFile = conflictOldFile;
    }

    public void setConflictWrkFile(File conflictWrkFile) {
        this.myConflictWrkFile = conflictWrkFile;
    }

    public void setPropRejectFile(File propRejectFile) {
        this.myPropRejectFile = propRejectFile;
    }

    public void setCopyFromURL(String copyFromURL) {
        this.myCopyFromURL = copyFromURL;
    }

    public void setCopyFromRevision(SVNRevision copyFromRevision) {
        this.myCopyFromRevision = copyFromRevision;
    }

    public void setRemoteLock(SVNLock remoteLock) {
        this.myRemoteLock = remoteLock;
    }

    public void setLocalLock(SVNLock localLock) {
        this.myLocalLock = localLock;
    }

    public void setEntryProperties(Map entryProperties) {
        this.myEntryProperties = entryProperties;
    }

    public void setRemoteRevision(SVNRevision remoteRevision) {
        this.myRemoteRevision = remoteRevision;
    }

    public void setRemoteURL(SVNURL remoteURL) {
        this.myRemoteURL = remoteURL;
    }

    public void setRemoteKind(SVNNodeKind remoteKind) {
        this.myRemoteKind = remoteKind;
    }

    public void setRemoteAuthor(String remoteAuthor) {
        this.myRemoteAuthor = remoteAuthor;
    }

    public void setRemoteDate(Date remoteDate) {
        this.myRemoteDate = remoteDate;
    }

    public void setLocalContentsDate(Date localContentsDate) {
        this.myLocalContentsDate = localContentsDate;
    }

    public void setLocalPropertiesDate(Date localPropertiesDate) {
        this.myLocalPropertiesDate = localPropertiesDate;
    }

    public void setChangelistName(String changelistName) {
        this.myChangelistName = changelistName;
    }

    public void setWorkingCopyFormat(int workingCopyFormat) {
        this.myWorkingCopyFormat = workingCopyFormat;
    }

    public void setTreeConflict(SVNTreeConflictDescription treeConflict) {
        this.myTreeConflict = treeConflict;
    }

    public void setIsConflicted(boolean isConflicted) {
        this.myIsConflicted = isConflicted;
    }

    public void setIsVersioned(boolean isVersioned) {
        this.myIsVersioned = isVersioned;
    }

    public void setDepth(SVNDepth depth) {
        this.myDepth = depth;
    }

    public void setMovedFromPath(File path) {
        this.myMovedFromPath = path;
    }

    public void setMovedToPath(File path) {
        this.myMovedToPath = path;
    }

    public static SVNStatusType combineNodeAndContentsStatus(int workingCopyFormat, SVNStatusType nodeStatus, SVNStatusType contentsStatus, boolean versioned, boolean conflicted) {
        if (workingCopyFormat >= 29) {
            if (nodeStatus == SVNStatusType.STATUS_CONFLICTED) {
                if (!versioned && conflicted) {
                    return SVNStatusType.STATUS_MISSING;
                }
                return contentsStatus;
            }
            if (nodeStatus == SVNStatusType.STATUS_MODIFIED) {
                return contentsStatus;
            }
            return nodeStatus;
        }
        return contentsStatus;
    }

    public static SVNStatusType combineRemoteNodeAndContentsStatus(int workingCopyFormat, SVNStatusType remoteNodeStatus, SVNStatusType remoteContentsStatus) {
        if (workingCopyFormat >= 31) {
            if (remoteNodeStatus == SVNStatusType.STATUS_MODIFIED) {
                return remoteContentsStatus;
            }
            return remoteNodeStatus;
        }
        return remoteContentsStatus;
    }
}

