/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl17;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.CommitInfo;
import org.apache.subversion.javahl.CommitItem;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.JavaHLObjectFactory;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.ChangelistCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.ConflictResolverCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ImportFilterCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.InheritedProplistCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.PatchCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.ConflictVersion;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DiffOptions;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.JavaHLTypesObjectFactory;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Status;
import org.apache.subversion.javahl.types.Tristate;
import org.apache.subversion.javahl.types.VersionExtended;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHConnector;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunkInfo;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.javahl.JavaHLCompositeLog;
import org.tmatesoft.svn.core.javahl.JavaHLDebugLog;
import org.tmatesoft.svn.core.javahl17.JavaHLAuthenticationProvider;
import org.tmatesoft.svn.core.javahl17.JavaHLAuthenticationStorage;
import org.tmatesoft.svn.core.javahl17.JavaHLEventHandler;
import org.tmatesoft.svn.core.javahl17.JavaHLProgressLog;
import org.tmatesoft.svn.core.javahl17.SVNClientImplVersion;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnAnnotate;
import org.tmatesoft.svn.core.wc2.SvnAnnotateItem;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnDiffStatus;
import org.tmatesoft.svn.core.wc2.SvnDiffSummarize;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnGetMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnGetStatusSummary;
import org.tmatesoft.svn.core.wc2.SvnImport;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnList;
import org.tmatesoft.svn.core.wc2.SvnLog;
import org.tmatesoft.svn.core.wc2.SvnLogMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRelocate;
import org.tmatesoft.svn.core.wc2.SvnRemoteCopy;
import org.tmatesoft.svn.core.wc2.SvnRemoteDelete;
import org.tmatesoft.svn.core.wc2.SvnRemoteMkDir;
import org.tmatesoft.svn.core.wc2.SvnRemoteSetProperty;
import org.tmatesoft.svn.core.wc2.SvnResolve;
import org.tmatesoft.svn.core.wc2.SvnRevert;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnSchedule;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnScheduleForRemoval;
import org.tmatesoft.svn.core.wc2.SvnSetChangelist;
import org.tmatesoft.svn.core.wc2.SvnSetLock;
import org.tmatesoft.svn.core.wc2.SvnSetProperty;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnStatusSummary;
import org.tmatesoft.svn.core.wc2.SvnSuggestMergeSources;
import org.tmatesoft.svn.core.wc2.SvnSwitch;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUnlock;
import org.tmatesoft.svn.core.wc2.SvnUpdate;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;
import org.tmatesoft.svn.core.wc2.SvnWorkingCopyInfo;
import org.tmatesoft.svn.core.wc2.hooks.ISvnCommitHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.tmatesoft.svn.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNClientImpl
implements ISVNClient {
    private static final String APR_ERROR_FIELD_NAME = "aprError";
    private static int instanceCount;
    private SvnOperationFactory svnOperationFactory;
    private boolean shouldDisposeSvnOperationsFactory;
    private String username;
    private String password;
    private UserPasswordCallback prompt;
    private String configDir = SVNWCUtil.getDefaultConfigurationDirectory().getAbsolutePath();
    private DefaultSVNOptions options;
    private ISVNAuthenticationManager authenticationManager;
    private ISVNAuthenticationStorage authenticationStorage;
    private ISVNConflictHandler conflictHandler;
    private JavaHLEventHandler eventHandler;
    private JavaHLCompositeLog debugLog;
    private JavaHLProgressLog progressListener;
    private static ISVNAuthenticationStorage runtimeAuthenticationStorage;
    private ConflictResolverCallback conflictResolverCallback;

    public static SVNClientImpl newInstance() {
        return new SVNClientImpl();
    }

    protected SVNClientImpl() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNClientImpl(SvnOperationFactory svnOperationFactory) {
        this.shouldDisposeSvnOperationsFactory = svnOperationFactory == null;
        this.svnOperationFactory = svnOperationFactory == null ? new SvnOperationFactory() : svnOperationFactory;
        this.svnOperationFactory.setEventHandler(this.getEventHandler());
        Class<SVNClientImpl> clazz = SVNClientImpl.class;
        synchronized (SVNClientImpl.class) {
            ++instanceCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.shouldDisposeSvnOperationsFactory && this.svnOperationFactory != null) {
            this.svnOperationFactory.dispose();
        }
        Class<SVNClientImpl> clazz = SVNClientImpl.class;
        synchronized (SVNClientImpl.class) {
            if (--instanceCount <= 0) {
                instanceCount = 0;
                SVNSSHConnector.shutdown();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public org.apache.subversion.javahl.types.Version getVersion() {
        return SVNClientImplVersion.getInstance();
    }

    @Override
    public String getAdminDirectoryName() {
        return SVNFileUtil.getAdminDirectoryName();
    }

    @Override
    public boolean isAdminDirectory(String name) {
        return name != null && SVNFileUtil.isWindows ? SVNFileUtil.getAdminDirectoryName().equalsIgnoreCase(name) : SVNFileUtil.getAdminDirectoryName().equals(name);
    }

    public ISVNOptions getOptions() {
        if (this.options == null) {
            File configDir = this.configDir == null ? null : new File(this.configDir);
            this.options = SVNWCUtil.createDefaultOptions(configDir, true);
            this.options.setConflictHandler(this.getConflictHandler());
        }
        return this.options;
    }

    protected ISVNConflictHandler getConflictHandler() {
        if (this.conflictHandler == null && this.conflictResolverCallback != null) {
            this.conflictHandler = this.getConflictHandler(this.conflictResolverCallback);
        }
        return this.conflictHandler;
    }

    @Override
    public void status(String path, Depth depth, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals, Collection<String> changelists, StatusCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnGetStatus status = this.svnOperationFactory.createGetStatus();
            status.setDepth(this.getSVNDepth(depth));
            status.setRemote(onServer);
            status.setReportAll(getAll);
            status.setReportIgnored(noIgnore);
            status.setReportExternals(!ignoreExternals);
            status.setApplicalbeChangelists(changelists);
            status.setReceiver(this.getStatusReceiver(callback));
            status.addTarget(this.getTarget(path));
            status.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void list(String url, Revision revision, Revision pegRevision, Depth depth, int direntFields, boolean fetchLocks, ListCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(url));
            SvnList list = this.svnOperationFactory.createList();
            list.setSingleTarget(this.getTarget(url, pegRevision));
            list.setRevision(SVNClientImpl.getSVNRevision(revision));
            list.setDepth(this.getSVNDepth(depth));
            list.setEntryFields(direntFields);
            list.setFetchLocks(fetchLocks);
            list.setReceiver(this.getDirEntryReceiver(callback));
            list.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void username(String username) {
        this.username = username;
        this.updateSvnOperationsFactory();
    }

    @Override
    public void password(String password) {
        this.password = password;
        this.updateSvnOperationsFactory();
    }

    @Override
    public void setPrompt(UserPasswordCallback prompt) {
        this.prompt = prompt;
        this.updateSvnOperationsFactory();
    }

    @Override
    public void logMessages(String path, Revision pegRevision, List<RevisionRange> ranges, boolean stopOnCopy, boolean discoverPath, boolean includeMergedRevisions, Set<String> revProps, long limit, LogMessageCallback callback) throws ClientException {
        this.beforeOperation();
        if (ranges != null) {
            ArrayList<RevisionRange> filteredRanges = new ArrayList<RevisionRange>(ranges.size());
            for (RevisionRange range : ranges) {
                RevisionRange filteredRange = range.getFromRevision() == null && range.getToRevision() == null ? new RevisionRange(new Revision.Number(1L), Revision.HEAD) : range;
                filteredRanges.add(filteredRange);
            }
            ranges = filteredRanges;
        }
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnLog log = this.svnOperationFactory.createLog();
            log.setRevisionRanges(this.getSvnRevisionRanges(ranges));
            log.setStopOnCopy(stopOnCopy);
            log.setDiscoverChangedPaths(discoverPath);
            log.setUseMergeHistory(includeMergedRevisions);
            log.setRevisionProperties(this.getRevisionPropertiesNames(revProps));
            log.setLimit(limit);
            log.setReceiver(this.getLogEntryReceiver(callback));
            log.addTarget(this.getTarget(path, pegRevision));
            log.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, Depth depth, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(destPath));
            SvnCheckout checkout = this.svnOperationFactory.createCheckout();
            checkout.setSource(this.getTarget(moduleName, pegRevision));
            checkout.setSingleTarget(this.getTarget(destPath));
            checkout.setRevision(SVNClientImpl.getSVNRevision(revision));
            checkout.setDepth(this.getSVNDepth(depth));
            checkout.setIgnoreExternals(ignoreExternals);
            checkout.setAllowUnversionedObstructions(allowUnverObstructions);
            long l = (Long)checkout.run();
            return l;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void notification2(ClientNotifyCallback notifyCallback) {
        this.getEventHandler().setNotifyCallback(notifyCallback);
    }

    public JavaHLEventHandler getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new JavaHLEventHandler();
        }
        return this.eventHandler;
    }

    @Override
    public void setConflictResolver(final ConflictResolverCallback callback) {
        this.conflictResolverCallback = callback;
        this.conflictHandler = callback != null ? new ISVNConflictHandler(){

            public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
                ConflictResult result = null;
                try {
                    result = callback.resolve(SVNClientImpl.this.getConflictDescription(conflictDescription));
                }
                catch (ClientException e) {
                    SVNClientImpl.this.throwSvnException(e);
                }
                catch (SubversionException e) {
                    SVNClientImpl.this.throwSvnException(e);
                }
                return result != null ? SVNClientImpl.this.getSVNConflictResult(result) : null;
            }
        } : null;
        this.updateSvnOperationsFactory();
    }

    @Override
    public void setProgressCallback(ProgressCallback listener) {
        this.getDebugLog();
        if (listener != null) {
            this.progressListener = new JavaHLProgressLog(listener);
            this.debugLog.addLogger(this.progressListener);
        } else if (this.progressListener != null) {
            this.debugLog.removeLogger(this.progressListener);
            this.progressListener = null;
        }
    }

    public ISVNDebugLog getDebugLog() {
        if (this.debugLog == null) {
            this.debugLog = new JavaHLCompositeLog();
            this.debugLog.addLogger(SVNDebugLog.getDefaultLog());
            this.debugLog.addLogger(JavaHLDebugLog.getInstance());
        }
        return this.debugLog;
    }

    public void setClientCredentialsStorage(ISVNAuthenticationStorage storage) {
        this.authenticationStorage = storage;
        this.updateSvnOperationsFactory();
    }

    public ISVNAuthenticationStorage getClientCredentialsStorage() {
        if (this.authenticationStorage != null) {
            return this.authenticationStorage;
        }
        return SVNClientImpl.getRuntimeCredentialsStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRuntimeCredentialsStorage(ISVNAuthenticationStorage storage) {
        Class<SVNClientImpl> clazz = SVNClientImpl.class;
        synchronized (SVNClientImpl.class) {
            runtimeAuthenticationStorage = storage == null ? new JavaHLAuthenticationStorage() : storage;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISVNAuthenticationStorage getRuntimeCredentialsStorage() {
        Class<SVNClientImpl> clazz = SVNClientImpl.class;
        synchronized (SVNClientImpl.class) {
            if (runtimeAuthenticationStorage == null) {
                runtimeAuthenticationStorage = new JavaHLAuthenticationStorage();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return runtimeAuthenticationStorage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Set<String> path, boolean force, boolean keepLocal, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            HashSet<String> localPaths = new HashSet<String>();
            HashSet<String> remoteUrls = new HashSet<String>();
            this.fillLocalAndRemoteTargets(path, localPaths, remoteUrls);
            this.removeLocal(localPaths, force, keepLocal);
            this.removeRemote(remoteUrls, revpropTable, handler, callback);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void revert(String path, Depth depth, Collection<String> changelists) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnRevert revert = this.svnOperationFactory.createRevert();
            revert.setDepth(this.getSVNDepth(depth));
            revert.setApplicalbeChangelists(changelists);
            revert.addTarget(this.getTarget(path));
            revert.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void add(String path, Depth depth, boolean force, boolean noIgnores, boolean addParents) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnScheduleForAddition add = this.svnOperationFactory.createScheduleForAddition();
            add.setDepth(this.getSVNDepth(depth));
            add.setForce(force);
            add.setIncludeIgnored(noIgnores);
            add.setAddParents(addParents);
            add.addTarget(this.getTarget(path));
            add.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public long[] update(Set<String> path, Revision revision, Depth depth, boolean depthIsSticky, boolean makeParents, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnUpdate update = this.svnOperationFactory.createUpdate();
            update.setRevision(SVNClientImpl.getSVNRevision(revision));
            update.setDepth(this.getSVNDepth(depth));
            update.setDepthIsSticky(depthIsSticky);
            update.setMakeParents(makeParents);
            update.setIgnoreExternals(ignoreExternals);
            update.setAllowUnversionedObstructions(allowUnverObstructions);
            for (String targetPath : path) {
                update.addTarget(this.getTarget(targetPath));
            }
            long[] lArray = (long[])update.run();
            return lArray;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void commit(Set<String> path, Depth depth, boolean noUnlock, boolean keepChangelist, Collection<String> changelists, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnCommit commit = this.svnOperationFactory.createCommit();
            commit.setDepth(this.getSVNDepth(depth));
            commit.setKeepLocks(noUnlock);
            commit.setKeepChangelists(keepChangelist);
            commit.setApplicalbeChangelists(changelists);
            commit.setRevisionProperties(this.getSVNProperties(revpropTable));
            commit.setCommitHandler(this.getCommitHandler(handler));
            commit.setReceiver(this.getCommitInfoReceiver(callback));
            for (String targetPath : path) {
                commit.addTarget(this.getTarget(targetPath));
            }
            commit.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(List<CopySource> sources, String destPath, boolean copyAsChild, boolean makeParents, boolean ignoreExternals, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(sources, destPath));
            if (SVNPathUtil.isURL(destPath)) {
                this.copyRemote(sources, destPath, copyAsChild, makeParents, revpropTable, handler, callback);
            } else {
                this.copyLocal(sources, destPath, copyAsChild, makeParents, ignoreExternals);
            }
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Set<String> srcPaths, String destPath, boolean force, boolean moveAsChild, boolean makeParents, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(srcPaths, destPath));
            if (SVNPathUtil.isURL(destPath)) {
                this.moveRemote(srcPaths, destPath, moveAsChild, makeParents, revpropTable, handler, callback);
            } else {
                this.moveLocal(srcPaths, destPath, force, moveAsChild, makeParents);
            }
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkdir(Set<String> path, boolean makeParents, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            HashSet<String> localPaths = new HashSet<String>();
            HashSet<String> remoteUrls = new HashSet<String>();
            this.fillLocalAndRemoteTargets(path, localPaths, remoteUrls);
            this.mkdirLocal(localPaths, makeParents);
            this.mkdirRemote(remoteUrls, makeParents, revpropTable, handler, callback);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void cleanup(String path) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnCleanup cleanup = this.svnOperationFactory.createCleanup();
            cleanup.addTarget(this.getTarget(path));
            cleanup.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void resolve(String path, Depth depth, ConflictResult.Choice conflictResult) throws SubversionException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnResolve resolve = this.svnOperationFactory.createResolve();
            resolve.setDepth(this.getSVNDepth(depth));
            resolve.setConflictChoice(this.getSVNConflictChoice(conflictResult));
            resolve.addTarget(this.getTarget(path));
            resolve.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, Depth depth, String nativeEOL) throws ClientException {
        this.beforeOperation();
        try {
            this.getPathPrefix(srcPath, destPath);
            SvnExport export = this.svnOperationFactory.createExport();
            export.setSource(this.getTarget(srcPath, pegRevision));
            export.setSingleTarget(this.getTarget(destPath));
            export.setRevision(SVNClientImpl.getSVNRevision(revision));
            export.setForce(force);
            export.setIgnoreExternals(ignoreExternals);
            export.setDepth(this.getSVNDepth(depth));
            export.setEolStyle(nativeEOL);
            long l = (Long)export.run();
            return l;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public long doSwitch(String path, String url, Revision revision, Revision pegRevision, Depth depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions, boolean ignoreAncestry) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnSwitch svnSwitch = this.svnOperationFactory.createSwitch();
            svnSwitch.setSingleTarget(this.getTarget(path));
            svnSwitch.setSwitchTarget(this.getTarget(url, pegRevision));
            svnSwitch.setRevision(SVNClientImpl.getSVNRevision(revision));
            svnSwitch.setDepth(this.getSVNDepth(depth));
            svnSwitch.setDepthIsSticky(depthIsSticky);
            svnSwitch.setIgnoreExternals(ignoreExternals);
            svnSwitch.setAllowUnversionedObstructions(allowUnverObstructions);
            svnSwitch.setIgnoreAncestry(ignoreAncestry);
            long l = (Long)svnSwitch.run();
            return l;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void doImport(String path, String url, Depth depth, boolean noIgnore, boolean ignoreUnknownNodeTypes, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnImport svnImport = this.svnOperationFactory.createImport();
            svnImport.setDepth(this.getSVNDepth(depth));
            svnImport.setUseGlobalIgnores(!noIgnore);
            svnImport.setForce(ignoreUnknownNodeTypes);
            svnImport.setRevisionProperties(this.getSVNProperties(revpropTable));
            svnImport.setCommitHandler(this.getCommitHandler(handler));
            svnImport.setReceiver(this.getCommitInfoReceiver(callback));
            svnImport.setSource(new File(path));
            svnImport.addTarget(this.getTarget(url));
            svnImport.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public Set<String> suggestMergeSources(String path, Revision pegRevision) throws SubversionException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnSuggestMergeSources suggestMergeSources = this.svnOperationFactory.createSuggestMergeSources();
            suggestMergeSources.setSingleTarget(this.getTarget(path, pegRevision));
            Collection mergeSources = (Collection)suggestMergeSources.run();
            HashSet<String> mergeSourcesStrings = new HashSet<String>();
            for (SVNURL mergeSource : mergeSources) {
                mergeSourcesStrings.add(this.getUrlString(mergeSource));
            }
            HashSet<String> hashSet = mergeSourcesStrings;
            return hashSet;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, Depth depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path1, path2));
            SvnMerge merge = this.svnOperationFactory.createMerge();
            merge.setSources(this.getTarget(path1, revision1), this.getTarget(path2, revision2));
            merge.addTarget(this.getTarget(localPath));
            merge.setForce(force);
            merge.setDepth(this.getSVNDepth(depth));
            merge.setIgnoreAncestry(ignoreAncestry);
            merge.setDryRun(dryRun);
            merge.setRecordOnly(recordOnly);
            merge.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void merge(String path, Revision pegRevision, List<RevisionRange> revisions, String localPath, boolean force, Depth depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path, localPath));
            SvnMerge merge = this.svnOperationFactory.createMerge();
            merge.setSource(this.getTarget(path, pegRevision), false);
            for (RevisionRange revisionRange : revisions) {
                merge.addRevisionRange(this.getSvnRevisionRange(revisionRange));
            }
            merge.addTarget(this.getTarget(localPath));
            merge.setForce(force);
            merge.setDepth(this.getSVNDepth(depth));
            merge.setIgnoreAncestry(ignoreAncestry);
            merge.setDryRun(dryRun);
            merge.setRecordOnly(recordOnly);
            merge.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void mergeReintegrate(String path, Revision pegRevision, String localPath, boolean dryRun) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnMerge merge = this.svnOperationFactory.createMerge();
            merge.setSource(this.getTarget(path, pegRevision), true);
            merge.addTarget(this.getTarget(localPath));
            merge.setDryRun(dryRun);
            merge.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public Mergeinfo getMergeinfo(String path, Revision pegRevision) throws SubversionException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnGetMergeInfo getMergeInfo = this.svnOperationFactory.createGetMergeInfo();
            getMergeInfo.setSingleTarget(this.getTarget(path, pegRevision));
            Mergeinfo mergeinfo = this.getMergeinfo((Map)getMergeInfo.run());
            return mergeinfo;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void getMergeinfoLog(Mergeinfo.LogKind kind, String pathOrUrl, Revision pegRevision, String mergeSourceUrl, Revision srcPegRevision, boolean discoverChangedPaths, Depth depth, Set<String> revProps, LogMessageCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(pathOrUrl, mergeSourceUrl));
            SvnLogMergeInfo logMergeInfo = this.svnOperationFactory.createLogMergeInfo();
            logMergeInfo.setFindMerged(kind == Mergeinfo.LogKind.merged);
            logMergeInfo.setSingleTarget(this.getTarget(pathOrUrl, pegRevision));
            logMergeInfo.setSource(this.getTarget(mergeSourceUrl, srcPegRevision));
            logMergeInfo.setDiscoverChangedPaths(discoverChangedPaths);
            logMergeInfo.setDepth(this.getSVNDepth(depth));
            logMergeInfo.setRevisionProperties(this.getRevisionPropertiesNames(revProps));
            logMergeInfo.setReceiver(this.getLogEntryReceiver(callback));
            logMergeInfo.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        this.beforeOperation();
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(relativeToDir));
            fileOutputStream = new FileOutputStream(outFileName);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            SvnDiffGenerator diffGenerator = new SvnDiffGenerator();
            diffGenerator.setBasePath(new File("").getAbsoluteFile());
            SvnDiff diff = this.svnOperationFactory.createDiff();
            diff.setSources(this.getTarget(target1, revision1), this.getTarget(target2, revision2));
            diff.setRelativeToDirectory(this.getFile(relativeToDir));
            diff.setOutput(bufferedOutputStream);
            diff.setDepth(this.getSVNDepth(depth));
            diff.setApplicalbeChangelists(changelists);
            diff.setIgnoreAncestry(ignoreAncestry);
            diff.setNoDiffDeleted(noDiffDeleted);
            diff.setIgnoreContentType(force);
            diff.setShowCopiesAsAdds(copiesAsAdds);
            diff.setDiffGenerator(diffGenerator);
            diff.run();
        }
        catch (FileNotFoundException e) {
            try {
                throw SVNClientImpl.getClientException(e);
                catch (SVNException e2) {
                    throw SVNClientImpl.getClientException(e2);
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(fileOutputStream);
                SVNFileUtil.closeFile(bufferedOutputStream);
                this.afterOperation();
                throw throwable;
            }
        }
        SVNFileUtil.closeFile(fileOutputStream);
        SVNFileUtil.closeFile(bufferedOutputStream);
        this.afterOperation();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        this.beforeOperation();
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(relativeToDir));
            fileOutputStream = new FileOutputStream(outFileName);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            SvnDiffGenerator diffGenerator = new SvnDiffGenerator();
            diffGenerator.setBasePath(new File("").getAbsoluteFile());
            SvnDiff diff = this.svnOperationFactory.createDiff();
            diff.setSource(this.getTarget(target, pegRevision), SVNClientImpl.getSVNRevision(startRevision), SVNClientImpl.getSVNRevision(endRevision));
            diff.setRelativeToDirectory(this.getFile(relativeToDir));
            diff.setOutput(bufferedOutputStream);
            diff.setDepth(this.getSVNDepth(depth));
            diff.setApplicalbeChangelists(changelists);
            diff.setIgnoreAncestry(ignoreAncestry);
            diff.setNoDiffDeleted(noDiffDeleted);
            diff.setIgnoreContentType(force);
            diff.setShowCopiesAsAdds(copiesAsAdds);
            diff.setDiffGenerator(diffGenerator);
            diff.run();
        }
        catch (FileNotFoundException e) {
            try {
                throw SVNClientImpl.getClientException(e);
                catch (SVNException e2) {
                    throw SVNClientImpl.getClientException(e2);
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(fileOutputStream);
                SVNFileUtil.closeFile(bufferedOutputStream);
                this.afterOperation();
                throw throwable;
            }
        }
        SVNFileUtil.closeFile(fileOutputStream);
        SVNFileUtil.closeFile(bufferedOutputStream);
        this.afterOperation();
    }

    @Override
    public void diffSummarize(String target1, Revision revision1, String target2, Revision revision2, Depth depth, Collection<String> changelists, boolean ignoreAncestry, DiffSummaryCallback receiver) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(target1, target2));
            SvnDiffSummarize diffSummarize = this.svnOperationFactory.createDiffSummarize();
            diffSummarize.setSources(this.getTarget(target1, revision1), this.getTarget(target2, revision2));
            diffSummarize.setDepth(this.getSVNDepth(depth));
            diffSummarize.setApplicalbeChangelists(changelists);
            diffSummarize.setIgnoreAncestry(ignoreAncestry);
            diffSummarize.setReceiver(this.getDiffStatusReceiver(receiver));
            diffSummarize.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void diffSummarize(String target, Revision pegRevision, Revision startRevision, Revision endRevision, Depth depth, Collection<String> changelists, boolean ignoreAncestry, DiffSummaryCallback receiver) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(target));
            SvnDiffSummarize diffSummarize = this.svnOperationFactory.createDiffSummarize();
            diffSummarize.setSource(this.getTarget(target, pegRevision), SVNClientImpl.getSVNRevision(startRevision), SVNClientImpl.getSVNRevision(endRevision));
            diffSummarize.setDepth(this.getSVNDepth(depth));
            diffSummarize.setApplicalbeChangelists(changelists);
            diffSummarize.setIgnoreAncestry(ignoreAncestry);
            diffSummarize.setReceiver(this.getDiffStatusReceiver(receiver));
            diffSummarize.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void properties(String path, Revision revision, Revision pegRevision, Depth depth, Collection<String> changelists, ProplistCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnGetProperties getProperties = this.svnOperationFactory.createGetProperties();
            getProperties.setRevision(SVNClientImpl.getSVNRevision(revision));
            getProperties.setDepth(this.getSVNDepth(depth));
            getProperties.setApplicalbeChangelists(changelists);
            getProperties.setReceiver(this.getSVNPropertiesReceiver(callback));
            getProperties.addTarget(this.getTarget(path, pegRevision));
            getProperties.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void propertySetLocal(Set<String> paths, String name, byte[] value, Depth depth, Collection<String> changelists, boolean force) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(paths));
            SvnSetProperty setProperty = this.svnOperationFactory.createSetProperty();
            setProperty.setPropertyName(name);
            setProperty.setPropertyValue(SVNPropertyValue.create(name, value));
            setProperty.setDepth(this.getSVNDepth(depth));
            setProperty.setApplicalbeChangelists(changelists);
            setProperty.setForce(force);
            for (String path : paths) {
                setProperty.addTarget(this.getTarget(path));
            }
            setProperty.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void propertySetRemote(String path, long baseRev, String name, byte[] value, CommitMessageCallback handler, boolean force, Map<String, String> revpropTable, CommitCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnRemoteSetProperty remoteSetProperty = this.svnOperationFactory.createRemoteSetProperty();
            remoteSetProperty.setSingleTarget(this.getTarget(path));
            remoteSetProperty.setRevision(SVNRevision.create(baseRev));
            remoteSetProperty.setPropertyName(name);
            remoteSetProperty.setPropertyValue(SVNPropertyValue.create(name, value));
            remoteSetProperty.setCommitHandler(this.getCommitHandler(handler));
            remoteSetProperty.setForce(force);
            remoteSetProperty.setRevisionProperties(this.getSVNProperties(revpropTable));
            remoteSetProperty.setReceiver(this.getCommitInfoReceiver(callback));
            remoteSetProperty.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public byte[] revProperty(String path, String name, Revision rev) throws ClientException {
        return this.getProperty(path, name, rev, null, true);
    }

    @Override
    public Map<String, byte[]> revProperties(String path, Revision rev) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnGetProperties getProperties = this.svnOperationFactory.createGetProperties();
            getProperties.setSingleTarget(this.getTarget(path));
            getProperties.setRevision(SVNClientImpl.getSVNRevision(rev));
            getProperties.setRevisionProperties(true);
            final SVNProperties[] svnProperties = new SVNProperties[1];
            getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

                @Override
                public void receive(SvnTarget target, SVNProperties properties) throws SVNException {
                    svnProperties[0] = properties;
                }
            });
            getProperties.run();
            Map<String, byte[]> map = this.getProperties(svnProperties[0]);
            return map;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void setRevProperty(String path, String name, Revision rev, String value, String originalValue, boolean force) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnSetProperty remoteSetProperty = this.svnOperationFactory.createSetProperty();
            remoteSetProperty.setSingleTarget(this.getTarget(path));
            remoteSetProperty.setPropertyName(name);
            remoteSetProperty.setRevision(SVNClientImpl.getSVNRevision(rev));
            remoteSetProperty.setPropertyValue(SVNPropertyValue.create(value));
            remoteSetProperty.setRevisionProperty(true);
            remoteSetProperty.setForce(force);
            remoteSetProperty.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public byte[] propertyGet(String path, String name, Revision revision, Revision pegRevision) throws ClientException {
        return this.getProperty(path, name, revision, pegRevision, false);
    }

    @Override
    public byte[] fileContent(String path, Revision revision, Revision pegRevision) throws ClientException {
        this.beforeOperation();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.streamFileContent(path, revision, pegRevision, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void streamFileContent(String path, Revision revision, Revision pegRevision, OutputStream stream) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnCat cat = this.svnOperationFactory.createCat();
            cat.setSingleTarget(this.getTarget(path, pegRevision));
            cat.setRevision(SVNClientImpl.getSVNRevision(revision));
            cat.setExpandKeywords(true);
            cat.setOutput(stream);
            cat.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void relocate(String from, String to, String path, boolean ignoreExternals) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnRelocate relocate = this.svnOperationFactory.createRelocate();
            relocate.setFromUrl(SVNURL.parseURIEncoded(from));
            relocate.setToUrl(SVNURL.parseURIEncoded(to));
            relocate.setSingleTarget(this.getTarget(path));
            relocate.setIgnoreExternals(ignoreExternals);
            relocate.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions, BlameCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnAnnotate annotate = this.svnOperationFactory.createAnnotate();
            annotate.setSingleTarget(this.getTarget(path, pegRevision));
            annotate.setStartRevision(SVNClientImpl.getSVNRevision(revisionStart));
            annotate.setEndRevision(SVNClientImpl.getSVNRevision(revisionEnd));
            annotate.setIgnoreMimeType(ignoreMimeType);
            annotate.setUseMergeHistory(includeMergedRevisions);
            annotate.setReceiver(this.getAnnotateItemReceiver(callback));
            annotate.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    public static ClientException getClientException(Throwable e) throws ClientException {
        ClientException ce = ClientException.fromException(e);
        ce.initCause(e);
        if (e instanceof SVNException) {
            int errorCode = ((SVNException)e).getErrorMessage().getErrorCode().getCode();
            try {
                Field f = ce.getClass().getSuperclass().getDeclaredField(APR_ERROR_FIELD_NAME);
                if (f != null) {
                    f.setAccessible(true);
                    f.set(ce, errorCode);
                }
            }
            catch (SecurityException e1) {
            }
            catch (NoSuchFieldException e1) {
            }
            catch (IllegalArgumentException e1) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return ce;
    }

    @Override
    public void setConfigDirectory(String configDir) throws ClientException {
        this.configDir = configDir;
        this.updateSvnOperationsFactory();
    }

    @Override
    public String getConfigDirectory() throws ClientException {
        return this.configDir;
    }

    @Override
    public void cancelOperation() throws ClientException {
        this.getEventHandler().cancelOperation();
    }

    @Override
    public void addToChangelist(Set<String> paths, String changelist, Depth depth, Collection<String> changelists) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(paths));
            SvnSetChangelist setChangeList = this.svnOperationFactory.createSetChangelist();
            setChangeList.setChangelistName(changelist);
            setChangeList.setDepth(this.getSVNDepth(depth));
            setChangeList.setApplicalbeChangelists(changelists);
            setChangeList.setRemove(false);
            for (String path : paths) {
                setChangeList.addTarget(this.getTarget(path));
            }
            setChangeList.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void removeFromChangelists(Set<String> paths, Depth depth, Collection<String> changelists) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(paths));
            SvnSetChangelist setChangelist = this.svnOperationFactory.createSetChangelist();
            setChangelist.setDepth(this.getSVNDepth(depth));
            setChangelist.setApplicalbeChangelists(changelists);
            setChangelist.setRemove(true);
            for (String path : paths) {
                setChangelist.addTarget(this.getTarget(path));
            }
            setChangelist.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void getChangelists(String rootPath, Collection<String> changelists, Depth depth, final ChangelistCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(rootPath));
            SvnGetInfo getInfo = this.svnOperationFactory.createGetInfo();
            getInfo.setSingleTarget(this.getTarget(rootPath));
            getInfo.setApplicalbeChangelists(changelists);
            getInfo.setDepth(this.getSVNDepth(depth));
            if (callback != null) {
                getInfo.setReceiver(new ISvnObjectReceiver<SvnInfo>(){

                    @Override
                    public void receive(SvnTarget target, SvnInfo svnInfo) throws SVNException {
                        SvnWorkingCopyInfo wcInfo = svnInfo.getWcInfo();
                        if (wcInfo != null) {
                            String path = SVNClientImpl.this.getFilePath(wcInfo.getPath());
                            String changelist = wcInfo.getChangelist();
                            callback.doChangelist(path, changelist);
                        }
                    }
                });
            }
            getInfo.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void lock(Set<String> path, String comment, boolean force) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnSetLock lock = this.svnOperationFactory.createSetLock();
            lock.setLockMessage(comment);
            lock.setStealLock(force);
            for (String targetPath : path) {
                lock.addTarget(this.getTarget(targetPath));
            }
            lock.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void unlock(Set<String> path, boolean force) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnUnlock unlock = this.svnOperationFactory.createUnlock();
            unlock.setBreakLock(force);
            for (String targetPath : path) {
                unlock.addTarget(this.getTarget(targetPath));
            }
            unlock.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void info2(String pathOrUrl, Revision revision, Revision pegRevision, Depth depth, Collection<String> changelists, InfoCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(pathOrUrl));
            SvnGetInfo info = this.svnOperationFactory.createGetInfo();
            info.setSingleTarget(this.getTarget(pathOrUrl, pegRevision));
            info.setRevision(SVNClientImpl.getSVNRevision(revision));
            info.setDepth(this.getSVNDepth(depth));
            info.setApplicalbeChangelists(changelists);
            info.setReceiver(this.getInfoReceiver(callback));
            info.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public String getVersionInfo(String path, String trailUrl, boolean lastChanged) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnGetStatusSummary getWCId = this.svnOperationFactory.createGetStatusSummary();
            getWCId.setSingleTarget(this.getTarget(path));
            getWCId.setCommitted(lastChanged);
            getWCId.setTrailUrl(trailUrl);
            SvnStatusSummary summary = (SvnStatusSummary)getWCId.run();
            if (summary != null) {
                String string = summary.toString();
                return string;
            }
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
        return null;
    }

    @Override
    public void upgrade(String path) throws ClientException {
        this.beforeOperation();
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnUpgrade upgrade = this.svnOperationFactory.createUpgrade();
            upgrade.setSingleTarget(this.getTarget(path));
            upgrade.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    @Override
    public void patch(String patchPath, String targetPath, boolean dryRun, int stripCount, boolean reverse, boolean ignoreWhitespace, boolean removeTempfiles, PatchCallback callback) throws ClientException {
        throw SVNClientImpl.getClientException(new SVNException(SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Patch operation is not implemented yet.")));
    }

    private SVNDepth getSVNDepth(Depth depth) {
        switch (depth) {
            case empty: {
                return SVNDepth.EMPTY;
            }
            case exclude: {
                return SVNDepth.EXCLUDE;
            }
            case files: {
                return SVNDepth.FILES;
            }
            case immediates: {
                return SVNDepth.IMMEDIATES;
            }
            case infinity: {
                return SVNDepth.INFINITY;
            }
        }
        return SVNDepth.UNKNOWN;
    }

    private Depth getDepth(SVNDepth depth) {
        if (depth == SVNDepth.EMPTY) {
            return Depth.empty;
        }
        if (depth == SVNDepth.EXCLUDE) {
            return Depth.exclude;
        }
        if (depth == SVNDepth.FILES) {
            return Depth.files;
        }
        if (depth == SVNDepth.IMMEDIATES) {
            return Depth.immediates;
        }
        if (depth == SVNDepth.INFINITY) {
            return Depth.infinity;
        }
        return Depth.unknown;
    }

    private Status getStatus(SvnStatus status) throws SVNException {
        String repositoryRelativePath = status.getRepositoryRelativePath() == null ? "" : status.getRepositoryRelativePath();
        SVNURL repositoryRootUrl = status.getRepositoryRootUrl();
        String itemUrl = repositoryRootUrl == null ? null : this.getUrlString(repositoryRootUrl.appendPath(repositoryRelativePath, false));
        int statusFormat = status.getWorkingCopyFormat();
        return new Status(this.getFilePath(status.getPath()), itemUrl, SVNClientImpl.getNodeKind(status.getKind()), status.getRevision(), status.getChangedRevision(), SVNClientImpl.getLongDate(status.getChangedDate()), status.getChangedAuthor(), this.getStatusKind(SVNStatus.combineNodeAndContentsStatus(statusFormat, status.getNodeStatus(), status.getTextStatus(), status.isVersioned(), status.isConflicted())), this.getStatusKind(status.getPropertiesStatus()), this.getStatusKind(SVNStatus.combineRemoteNodeAndContentsStatus(statusFormat, status.getRepositoryNodeStatus(), status.getRepositoryTextStatus())), this.getStatusKind(status.getRepositoryPropertiesStatus()), status.isWcLocked(), status.isCopied(), status.isConflicted(), status.isSwitched(), status.isFileExternal(), SVNClientImpl.getLock(status.getLock()), SVNClientImpl.getLock(status.getRepositoryLock()), status.getRepositoryChangedRevision(), SVNClientImpl.getLongDate(status.getRepositoryChangedDate()), SVNClientImpl.getNodeKind(status.getRepositoryKind()), status.getRepositoryChangedAuthor(), status.getChangelist(), null, null);
    }

    static Lock getLock(SVNLock lock) {
        if (lock == null) {
            return null;
        }
        return new Lock(lock.getOwner(), lock.getPath(), lock.getID(), lock.getComment(), SVNClientImpl.getLongDate(lock.getCreationDate()), SVNClientImpl.getLongDate(lock.getExpirationDate()));
    }

    private static long getLongDate(Date date) {
        SVNDate svnDate = SVNDate.fromDate(date);
        return svnDate.getTimeInMicros();
    }

    private SvnTarget getTarget(String path, Revision revision) {
        SVNRevision svnRevision = SVNClientImpl.getSVNRevision(revision);
        if (SVNPathUtil.isURL(path)) {
            try {
                return SvnTarget.fromURL(SVNURL.parseURIEncoded(path), svnRevision);
            }
            catch (SVNException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return SvnTarget.fromFile(new File(path), svnRevision);
    }

    private SvnTarget getTarget(String path) {
        return this.getTarget(path, null);
    }

    private Status.Kind getStatusKind(SVNStatusType statusType) {
        if (statusType == SVNStatusType.STATUS_ADDED) {
            return Status.Kind.added;
        }
        if (statusType == SVNStatusType.STATUS_CONFLICTED) {
            return Status.Kind.conflicted;
        }
        if (statusType == SVNStatusType.STATUS_DELETED) {
            return Status.Kind.deleted;
        }
        if (statusType == SVNStatusType.STATUS_EXTERNAL) {
            return Status.Kind.external;
        }
        if (statusType == SVNStatusType.STATUS_IGNORED) {
            return Status.Kind.ignored;
        }
        if (statusType == SVNStatusType.STATUS_INCOMPLETE) {
            return Status.Kind.incomplete;
        }
        if (statusType == SVNStatusType.STATUS_MERGED) {
            return Status.Kind.merged;
        }
        if (statusType == SVNStatusType.STATUS_MISSING) {
            return Status.Kind.missing;
        }
        if (statusType == SVNStatusType.STATUS_MODIFIED) {
            return Status.Kind.modified;
        }
        if (statusType == SVNStatusType.STATUS_NAME_CONFLICT) {
            return Status.Kind.unversioned;
        }
        if (statusType == SVNStatusType.STATUS_NONE) {
            return Status.Kind.none;
        }
        if (statusType == SVNStatusType.STATUS_NORMAL) {
            return Status.Kind.normal;
        }
        if (statusType == SVNStatusType.STATUS_OBSTRUCTED) {
            return Status.Kind.obstructed;
        }
        if (statusType == SVNStatusType.STATUS_REPLACED) {
            return Status.Kind.replaced;
        }
        if (statusType == SVNStatusType.STATUS_UNVERSIONED) {
            return Status.Kind.unversioned;
        }
        throw new IllegalArgumentException("Unknown status type: " + statusType);
    }

    private static NodeKind getNodeKind(SVNNodeKind kind) {
        if (kind == SVNNodeKind.DIR) {
            return NodeKind.dir;
        }
        if (kind == SVNNodeKind.FILE) {
            return NodeKind.file;
        }
        if (kind == SVNNodeKind.NONE) {
            return NodeKind.none;
        }
        return NodeKind.unknown;
    }

    static SVNRevision getSVNRevision(Revision revision) {
        if (revision == null) {
            return SVNRevision.UNDEFINED;
        }
        switch (revision.getKind()) {
            case base: {
                return SVNRevision.BASE;
            }
            case committed: {
                return SVNRevision.COMMITTED;
            }
            case date: {
                Revision.DateSpec dateSpec = (Revision.DateSpec)revision;
                return SVNRevision.create(dateSpec.getDate());
            }
            case head: {
                return SVNRevision.HEAD;
            }
            case number: {
                Revision.Number number = (Revision.Number)revision;
                return SVNRevision.create(number.getNumber());
            }
            case previous: {
                return SVNRevision.PREVIOUS;
            }
            case working: {
                return SVNRevision.WORKING;
            }
        }
        return SVNRevision.UNDEFINED;
    }

    private SVNProperties getSVNProperties(Map<String, String> revpropTable) {
        return SVNProperties.wrap(revpropTable);
    }

    private CommitItem getSvnCommitItem(SvnCommitItem commitable) {
        if (commitable == null) {
            return null;
        }
        return JavaHLObjectFactory.createCommitItem(this.getFilePath(commitable.getPath()), SVNClientImpl.getNodeKind(commitable.getKind()), commitable.getFlags(), this.getUrlString(commitable.getUrl()), this.getUrlString(commitable.getCopyFromUrl()), commitable.getCopyFromRevision(), this.getFilePath(commitable.getMovedFromAbsPath()));
    }

    private String getFilePath(File path) {
        if (path == null) {
            return null;
        }
        return path.getPath().replace(File.separatorChar, '/');
    }

    private String getUrlString(SVNURL url) {
        if (url == null) {
            return null;
        }
        return url.toString();
    }

    private ISvnObjectReceiver<SvnStatus> getStatusReceiver(final StatusCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus status) throws SVNException {
                callback.doStatus(target == null ? null : target.getPathOrUrlString(), SVNClientImpl.this.getStatus(status));
            }
        };
    }

    private ISvnCommitHandler getCommitHandler(final CommitMessageCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnCommitHandler(){

            public String getCommitMessage(String message, SvnCommitItem[] commitables) throws SVNException {
                HashSet<CommitItem> commitItems = new HashSet<CommitItem>();
                for (SvnCommitItem commitable : commitables) {
                    commitItems.add(SVNClientImpl.this.getSvnCommitItem(commitable));
                }
                return callback.getLogMessage(commitItems);
            }

            public SVNProperties getRevisionProperties(String message, SvnCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
                return revisionProperties;
            }
        };
    }

    private Collection<SvnRevisionRange> getSvnRevisionRanges(List<RevisionRange> ranges) {
        if (ranges == null) {
            return null;
        }
        ArrayList<SvnRevisionRange> svnRevisionRanges = new ArrayList<SvnRevisionRange>(ranges.size());
        for (RevisionRange range : ranges) {
            svnRevisionRanges.add(this.getSvnRevisionRange(range));
        }
        return svnRevisionRanges;
    }

    private SvnRevisionRange getSvnRevisionRange(RevisionRange range) {
        return SvnRevisionRange.create(SVNClientImpl.getSVNRevision(range.getFromRevision()), SVNClientImpl.getSVNRevision(range.getToRevision()));
    }

    private String[] getRevisionPropertiesNames(Set<String> revProps) {
        if (revProps == null) {
            return null;
        }
        String[] revisionPropertiesNames = new String[revProps.size()];
        int i = 0;
        Iterator<String> i$ = revProps.iterator();
        while (i$.hasNext()) {
            String revProp;
            revisionPropertiesNames[i] = revProp = i$.next();
            ++i;
        }
        return revisionPropertiesNames;
    }

    private ISvnObjectReceiver<SVNLogEntry> getLogEntryReceiver(final LogMessageCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry svnLogEntry) throws SVNException {
                callback.singleMessage(SVNClientImpl.this.getChangePaths(svnLogEntry.getChangedPaths()), svnLogEntry.getRevision(), SVNClientImpl.this.getProperties(svnLogEntry.getRevisionProperties()), svnLogEntry.hasChildren());
            }
        };
    }

    private Set<ChangePath> getChangePaths(Map<String, SVNLogEntryPath> changedPaths) {
        if (changedPaths == null) {
            return null;
        }
        HashSet<ChangePath> changePaths = new HashSet<ChangePath>();
        for (Map.Entry<String, SVNLogEntryPath> entry : changedPaths.entrySet()) {
            SVNLogEntryPath svnLogEntryPath = entry.getValue();
            changePaths.add(new ChangePath(svnLogEntryPath.getPath(), svnLogEntryPath.getCopyRevision(), svnLogEntryPath.getCopyPath(), this.getChangePathAction(svnLogEntryPath.getType()), SVNClientImpl.getNodeKind(svnLogEntryPath.getKind()), Tristate.Unknown, Tristate.Unknown));
        }
        return changePaths;
    }

    private ChangePath.Action getChangePathAction(char type) {
        if (type == 'A') {
            return ChangePath.Action.add;
        }
        if (type == 'M') {
            return ChangePath.Action.modify;
        }
        if (type == 'D') {
            return ChangePath.Action.delete;
        }
        if (type == 'R') {
            return ChangePath.Action.replace;
        }
        throw new IllegalArgumentException("Unknown change action type " + type);
    }

    private Map<String, byte[]> getProperties(SVNProperties svnProperties) {
        if (svnProperties == null) {
            return new HashMap<String, byte[]>();
        }
        HashMap<String, byte[]> properties = new HashMap<String, byte[]>();
        Set<String> svnPropertiesNames = svnProperties.nameSet();
        for (String svnPropertyName : svnPropertiesNames) {
            SVNPropertyValue svnPropertyValue = svnProperties.getSVNPropertyValue(svnPropertyName);
            properties.put(svnPropertyName, SVNPropertyValue.getPropertyAsBytes(svnPropertyValue));
        }
        return properties;
    }

    private static Map<String, String> getRevisionProperties(SVNProperties revisionProperties) {
        if (revisionProperties == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Set<String> svnPropertiesNames = revisionProperties.nameSet();
        for (String svnPropertyName : svnPropertiesNames) {
            SVNPropertyValue svnPropertyValue = revisionProperties.getSVNPropertyValue(svnPropertyName);
            properties.put(svnPropertyName, SVNPropertyValue.getPropertyAsString(svnPropertyValue));
        }
        return properties;
    }

    private ISvnObjectReceiver<SVNProperties> getSVNPropertiesReceiver(final ProplistCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties svnProperties) throws SVNException {
                callback.singlePath(target == null ? null : target.getPathOrUrlString(), SVNClientImpl.this.getProperties(svnProperties));
            }
        };
    }

    private SVNConflictChoice getSVNConflictChoice(ConflictResult.Choice choice) {
        switch (choice) {
            case chooseBase: {
                return SVNConflictChoice.BASE;
            }
            case chooseMerged: {
                return SVNConflictChoice.MERGED;
            }
            case chooseMineConflict: {
                return SVNConflictChoice.MINE_CONFLICT;
            }
            case chooseMineFull: {
                return SVNConflictChoice.MINE_FULL;
            }
            case chooseTheirsConflict: {
                return SVNConflictChoice.THEIRS_CONFLICT;
            }
            case chooseTheirsFull: {
                return SVNConflictChoice.THEIRS_FULL;
            }
            case postpone: {
                return SVNConflictChoice.POSTPONE;
            }
        }
        throw new IllegalArgumentException("Unknown choice kind: " + (Object)((Object)choice));
    }

    private byte[] getProperty(String path, final String name, Revision rev, Revision pegRevision, boolean revisionProperties) throws ClientException {
        try {
            this.getEventHandler().setPathPrefix(this.getPathPrefix(path));
            SvnGetProperties getProperties = this.svnOperationFactory.createGetProperties();
            getProperties.setSingleTarget(this.getTarget(path, pegRevision));
            getProperties.setRevision(SVNClientImpl.getSVNRevision(rev));
            getProperties.setRevisionProperties(revisionProperties);
            final SVNPropertyValue[] propertyValue = new SVNPropertyValue[1];
            getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

                @Override
                public void receive(SvnTarget target, SVNProperties svnProperties) throws SVNException {
                    propertyValue[0] = svnProperties.getSVNPropertyValue(name);
                }
            });
            getProperties.run();
            byte[] byArray = SVNPropertyValue.getPropertyAsBytes(propertyValue[0]);
            return byArray;
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
        finally {
            this.afterOperation();
        }
    }

    private DiffSummary getDiffSummary(SvnDiffStatus diffStatus) {
        return new DiffSummary(diffStatus.getPath(), this.getDiffKind(diffStatus.getModificationType()), diffStatus.isPropertiesModified(), SVNClientImpl.getNodeKind(diffStatus.getKind()));
    }

    private DiffSummary.DiffKind getDiffKind(SVNStatusType type) {
        if (type == SVNStatusType.STATUS_ADDED) {
            return DiffSummary.DiffKind.added;
        }
        if (type == SVNStatusType.STATUS_DELETED) {
            return DiffSummary.DiffKind.deleted;
        }
        if (type == SVNStatusType.STATUS_MODIFIED) {
            return DiffSummary.DiffKind.modified;
        }
        if (type == SVNStatusType.STATUS_NORMAL || type == SVNStatusType.STATUS_NONE) {
            return DiffSummary.DiffKind.normal;
        }
        throw new IllegalArgumentException("Unknown status type: " + type);
    }

    private ISvnObjectReceiver<SvnDiffStatus> getDiffStatusReceiver(final DiffSummaryCallback receiver) {
        if (receiver == null) {
            return null;
        }
        return new ISvnObjectReceiver<SvnDiffStatus>(){

            @Override
            public void receive(SvnTarget target, SvnDiffStatus diffStatus) throws SVNException {
                if (diffStatus == null) {
                    return;
                }
                if (!(diffStatus.isPropertiesModified() || diffStatus.getModificationType() != SVNStatusType.STATUS_NONE && diffStatus.getModificationType() != SVNStatusType.STATUS_NORMAL)) {
                    return;
                }
                receiver.onSummary(SVNClientImpl.this.getDiffSummary(diffStatus));
            }
        };
    }

    private ISvnObjectReceiver<SVNCommitInfo> getCommitInfoReceiver(final CommitCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnObjectReceiver<SVNCommitInfo>(){

            @Override
            public void receive(SvnTarget target, SVNCommitInfo commitInfo) throws SVNException {
                try {
                    SVNURL repositoryRoot = target.getURL();
                    callback.commitInfo(SVNClientImpl.this.getCommitInfo(commitInfo, repositoryRoot));
                }
                catch (ParseException e) {
                    SVNClientImpl.this.throwSvnException(e);
                }
            }
        };
    }

    private void fillLocalAndRemoteTargets(Set<String> path, Set<String> localPaths, Set<String> remoteUrls) {
        for (String targetPath : path) {
            if (SVNPathUtil.isURL(targetPath)) {
                remoteUrls.add(targetPath);
                continue;
            }
            localPaths.add(targetPath);
        }
    }

    private CommitInfo getCommitInfo(SVNCommitInfo commitInfo, SVNURL repositoryRoot) throws ParseException {
        return new CommitInfo(commitInfo.getNewRevision(), SVNDate.formatDate(commitInfo.getDate()), commitInfo.getAuthor(), SVNClientImpl.getErrorMessageString(commitInfo.getErrorMessage()), this.getUrlString(repositoryRoot));
    }

    private static String getErrorMessageString(SVNErrorMessage errorMessage) {
        if (errorMessage == null) {
            return null;
        }
        return errorMessage.getMessage();
    }

    private SvnCopySource getSvnCopySource(CopySource localSource) {
        return SvnCopySource.create(this.getTarget(localSource.getPath(), localSource.getPegRevision()), SVNClientImpl.getSVNRevision(localSource.getRevision()));
    }

    private void mkdirLocal(Set<String> localPaths, boolean makeParents) throws ClientException {
        if (localPaths == null || localPaths.size() == 0) {
            return;
        }
        SvnScheduleForAddition add = this.svnOperationFactory.createScheduleForAddition();
        add.setAddParents(makeParents);
        add.setMkDir(true);
        for (String localPath : localPaths) {
            add.addTarget(this.getTarget(localPath));
        }
        try {
            add.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private void mkdirRemote(Set<String> remoteUrls, boolean makeParents, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        if (remoteUrls == null || remoteUrls.size() == 0) {
            return;
        }
        SvnRemoteMkDir mkdir = this.svnOperationFactory.createMkDir();
        mkdir.setMakeParents(makeParents);
        mkdir.setRevisionProperties(this.getSVNProperties(revpropTable));
        mkdir.setCommitHandler(this.getCommitHandler(handler));
        mkdir.setReceiver(this.getCommitInfoReceiver(callback));
        for (String remoteUrl : remoteUrls) {
            mkdir.addTarget(this.getTarget(remoteUrl));
        }
        try {
            mkdir.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private void removeLocal(Set<String> localPaths, boolean force, boolean keepLocal) throws ClientException {
        if (localPaths == null || localPaths.size() == 0) {
            return;
        }
        SvnScheduleForRemoval remove = this.svnOperationFactory.createScheduleForRemoval();
        remove.setForce(force);
        remove.setDeleteFiles(!keepLocal);
        for (String localPath : localPaths) {
            remove.addTarget(this.getTarget(localPath));
        }
        try {
            remove.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private void removeRemote(Set<String> remoteUrls, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        if (remoteUrls == null || remoteUrls.size() == 0) {
            return;
        }
        SvnRemoteDelete remoteDelete = this.svnOperationFactory.createRemoteDelete();
        remoteDelete.setRevisionProperties(this.getSVNProperties(revpropTable));
        remoteDelete.setCommitHandler(this.getCommitHandler(handler));
        remoteDelete.setReceiver(this.getCommitInfoReceiver(callback));
        for (String remoteUrl : remoteUrls) {
            remoteDelete.addTarget(this.getTarget(remoteUrl));
        }
        try {
            remoteDelete.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private void moveLocal(Set<String> srcPaths, String destPath, boolean force, boolean moveAsChild, boolean makeParents) throws ClientException {
        if (srcPaths == null || srcPaths.size() == 0) {
            return;
        }
        SvnCopy copy = this.svnOperationFactory.createCopy();
        copy.setSingleTarget(this.getTarget(destPath));
        copy.setMakeParents(makeParents);
        copy.setFailWhenDstExists(!moveAsChild);
        copy.setMove(true);
        for (String localPath : srcPaths) {
            copy.addCopySource(SvnCopySource.create(this.getTarget(localPath), SVNRevision.UNDEFINED));
        }
        try {
            copy.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private void moveRemote(Set<String> srcPaths, String destPath, boolean moveAsChild, boolean makeParents, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        if (srcPaths == null || srcPaths.size() == 0) {
            return;
        }
        SvnRemoteCopy remoteCopy = this.svnOperationFactory.createRemoteCopy();
        remoteCopy.setSingleTarget(this.getTarget(destPath));
        remoteCopy.setMakeParents(makeParents);
        remoteCopy.setRevisionProperties(this.getSVNProperties(revpropTable));
        remoteCopy.setCommitHandler(this.getCommitHandler(handler));
        remoteCopy.setReceiver(this.getCommitInfoReceiver(callback));
        remoteCopy.setFailWhenDstExists(!moveAsChild);
        remoteCopy.setMove(true);
        for (String remoteUrl : srcPaths) {
            remoteCopy.addCopySource(SvnCopySource.create(this.getTarget(remoteUrl), SVNRevision.UNDEFINED));
        }
        try {
            remoteCopy.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private void copyLocal(List<CopySource> localSources, String destPath, boolean copyAsChild, boolean makeParents, boolean ignoreExternals) throws ClientException {
        if (localSources == null || localSources.size() == 0) {
            return;
        }
        SvnCopy copy = this.svnOperationFactory.createCopy();
        copy.setSingleTarget(this.getTarget(destPath));
        copy.setMakeParents(makeParents);
        copy.setIgnoreExternals(ignoreExternals);
        copy.setFailWhenDstExists(!copyAsChild);
        copy.setMove(false);
        for (CopySource localSource : localSources) {
            copy.addCopySource(this.getSvnCopySource(localSource));
        }
        try {
            copy.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private void copyRemote(List<CopySource> remoteSources, String destPath, boolean copyAsChild, boolean makeParents, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        if (remoteSources == null || remoteSources.size() == 0) {
            return;
        }
        SvnRemoteCopy remoteCopy = this.svnOperationFactory.createRemoteCopy();
        remoteCopy.setSingleTarget(this.getTarget(destPath));
        remoteCopy.setMakeParents(makeParents);
        remoteCopy.setRevisionProperties(this.getSVNProperties(revpropTable));
        remoteCopy.setCommitHandler(this.getCommitHandler(handler));
        remoteCopy.setReceiver(this.getCommitInfoReceiver(callback));
        remoteCopy.setFailWhenDstExists(!copyAsChild);
        remoteCopy.setMove(false);
        for (CopySource remoteSource : remoteSources) {
            remoteCopy.addCopySource(this.getSvnCopySource(remoteSource));
        }
        try {
            remoteCopy.run();
        }
        catch (SVNException e) {
            throw SVNClientImpl.getClientException(e);
        }
    }

    private ISvnObjectReceiver<SvnInfo> getInfoReceiver(final InfoCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnObjectReceiver<SvnInfo>(){

            @Override
            public void receive(SvnTarget target, SvnInfo info) throws SVNException {
                try {
                    callback.singleInfo(SVNClientImpl.this.getInfo(info));
                }
                catch (ClientException e) {
                    SVNClientImpl.this.throwSvnException(e);
                }
            }
        };
    }

    private Info getInfo(SvnInfo info) throws ClientException {
        boolean hasWcInfo;
        String url = this.getUrlString(info.getUrl());
        String repositoryRoot = this.getUrlString(info.getRepositoryRootUrl());
        boolean bl = hasWcInfo = info.getWcInfo() != null;
        String path = repositoryRoot != null && url != null ? SVNEncodingUtil.uriDecode(SVNPathUtil.getRelativePath(repositoryRoot, url)) : (hasWcInfo ? this.getFilePath(info.getWcInfo().getPath()) : null);
        return new Info(path, hasWcInfo ? this.getFilePath(info.getWcInfo().getWcRoot()) : null, url, info.getRevision(), SVNClientImpl.getNodeKind(info.getKind()), repositoryRoot, info.getRepositoryUuid(), info.getLastChangedRevision(), SVNClientImpl.getLongDate(info.getLastChangedDate()), info.getLastChangedAuthor(), SVNClientImpl.getLock(info.getLock()), hasWcInfo, hasWcInfo ? this.getScheduleKind(info.getWcInfo().getSchedule()) : null, hasWcInfo ? this.getUrlString(info.getWcInfo().getCopyFromUrl()) : null, hasWcInfo ? info.getWcInfo().getCopyFromRevision() : -1L, hasWcInfo ? info.getWcInfo().getRecordedTime() : 0L, hasWcInfo ? this.getChecksum(info.getWcInfo().getChecksum()) : null, hasWcInfo ? info.getWcInfo().getChangelist() : null, hasWcInfo ? info.getWcInfo().getRecordedSize() : -1L, info.getSize(), hasWcInfo ? this.getDepth(info.getWcInfo().getDepth()) : null, hasWcInfo ? this.getConflictDescriptors(info.getWcInfo().getConflicts()) : null);
    }

    private Set<ConflictDescriptor> getConflictDescriptors(Collection<SVNConflictDescription> conflicts) throws ClientException {
        HashSet<ConflictDescriptor> conflictDescriptors = new HashSet<ConflictDescriptor>();
        for (SVNConflictDescription conflict : conflicts) {
            conflictDescriptors.add(this.getConflictDescription(conflict));
        }
        return conflictDescriptors;
    }

    private Checksum getChecksum(SvnChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        return new Checksum(checksum.getDigest().getBytes(), this.getChecksumKind(checksum.getKind()));
    }

    private Checksum.Kind getChecksumKind(SvnChecksum.Kind kind) {
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case md5: {
                return Checksum.Kind.MD5;
            }
            case sha1: {
                return Checksum.Kind.SHA1;
            }
        }
        throw new IllegalArgumentException("Unsupported checksum kind: " + (Object)((Object)kind));
    }

    private Info.ScheduleKind getScheduleKind(SvnSchedule schedule) {
        if (schedule == SvnSchedule.ADD) {
            return Info.ScheduleKind.add;
        }
        if (schedule == SvnSchedule.DELETE) {
            return Info.ScheduleKind.delete;
        }
        if (schedule == SvnSchedule.NORMAL) {
            return Info.ScheduleKind.normal;
        }
        if (schedule == SvnSchedule.REPLACE) {
            return Info.ScheduleKind.replace;
        }
        throw new IllegalArgumentException("Unknown schedule kind: " + (Object)((Object)schedule));
    }

    private Mergeinfo getMergeinfo(Map<SVNURL, SVNMergeRangeList> mergeInfoMap) {
        if (mergeInfoMap == null) {
            return null;
        }
        Mergeinfo mergeinfo = new Mergeinfo();
        for (Map.Entry<SVNURL, SVNMergeRangeList> entry : mergeInfoMap.entrySet()) {
            SVNMergeRange[] ranges;
            SVNURL url = entry.getKey();
            SVNMergeRangeList mergeRangeList = entry.getValue();
            if (mergeRangeList == null) continue;
            String urlString = this.getUrlString(url);
            for (SVNMergeRange range : ranges = mergeRangeList.getRanges()) {
                if (range == null) continue;
                mergeinfo.addRevisionRange(urlString, SVNClientImpl.getRevisionRange(range));
            }
        }
        return mergeinfo;
    }

    private static RevisionRange getRevisionRange(SVNMergeRange revisionRange) {
        if (revisionRange == null) {
            return null;
        }
        long startRevision = revisionRange.getStartRevision();
        long endRevision = revisionRange.getEndRevision();
        return new RevisionRange(Revision.getInstance(startRevision), Revision.getInstance(endRevision));
    }

    private ISvnObjectReceiver<SvnAnnotateItem> getAnnotateItemReceiver(final BlameCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnObjectReceiver<SvnAnnotateItem>(){

            @Override
            public void receive(SvnTarget target, SvnAnnotateItem annotateItem) throws SVNException {
                try {
                    if (annotateItem.isLine()) {
                        Map revisionProperties = SVNClientImpl.this.getProperties(annotateItem.getRevisionProperties());
                        Map mergedRevisionProperties = SVNClientImpl.this.getProperties(annotateItem.getMergedRevisionProperties());
                        callback.singleLine(annotateItem.getLineNumber(), annotateItem.getRevision(), revisionProperties == null || revisionProperties.isEmpty() ? null : revisionProperties, annotateItem.getMergedRevision(), mergedRevisionProperties == null || mergedRevisionProperties.isEmpty() ? null : mergedRevisionProperties, annotateItem.getMergedPath(), annotateItem.getLine(), !SVNRevision.isValidRevisionNumber(annotateItem.getRevision()));
                    }
                }
                catch (ClientException e) {
                    SVNClientImpl.this.throwSvnException(e);
                }
            }
        };
    }

    private ISVNConflictHandler getConflictHandler(final ConflictResolverCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISVNConflictHandler(){

            public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
                try {
                    return SVNClientImpl.this.getSVNConflictResult(callback.resolve(SVNClientImpl.this.getConflictDescription(conflictDescription)));
                }
                catch (SubversionException e) {
                    SVNClientImpl.this.throwSvnException(e);
                    return null;
                }
            }
        };
    }

    private ConflictDescriptor getConflictDescription(SVNConflictDescription conflictDescription) throws ClientException {
        ConflictVersion srcLeft = null;
        ConflictVersion srcRight = null;
        ConflictDescriptor.Operation operation = ConflictDescriptor.Operation.none;
        if (conflictDescription instanceof SVNTreeConflictDescription) {
            SVNTreeConflictDescription treeConflictDescription = (SVNTreeConflictDescription)conflictDescription;
            srcLeft = this.getConflictVersion(treeConflictDescription.getSourceLeftVersion());
            srcRight = this.getConflictVersion(treeConflictDescription.getSourceRightVersion());
            operation = this.getConflictDescriptorOperation(treeConflictDescription.getOperation());
        }
        return new ConflictDescriptor(this.getFilePath(conflictDescription.getPath()), this.getConflictDescriptorKind(conflictDescription), SVNClientImpl.getNodeKind(conflictDescription.getNodeKind()), conflictDescription.getPropertyName(), conflictDescription.getMergeFiles().isBinary(), conflictDescription.getMergeFiles().getMimeType(), this.getConflictDescriptorAction(conflictDescription.getConflictAction()), this.getConflictDescriptorReason(conflictDescription.getConflictReason()), operation, this.getFilePath(conflictDescription.getMergeFiles().getBaseFile()), this.getFilePath(conflictDescription.getMergeFiles().getRepositoryFile()), this.getFilePath(conflictDescription.getMergeFiles().getLocalFile()), this.getFilePath(conflictDescription.getMergeFiles().getResultFile()), srcLeft, srcRight);
    }

    private ConflictDescriptor.Operation getConflictDescriptorOperation(SVNOperation operation) {
        if (operation == null) {
            return null;
        }
        if (operation == SVNOperation.MERGE) {
            return ConflictDescriptor.Operation.merge;
        }
        if (operation == SVNOperation.UPDATE) {
            return ConflictDescriptor.Operation.update;
        }
        if (operation == SVNOperation.SWITCH) {
            return ConflictDescriptor.Operation.switched;
        }
        if (operation == SVNOperation.NONE) {
            return ConflictDescriptor.Operation.none;
        }
        throw new IllegalArgumentException("Unknown operation: " + operation);
    }

    private ConflictVersion getConflictVersion(SVNConflictVersion conflictVersion) {
        if (conflictVersion == null) {
            return null;
        }
        return JavaHLTypesObjectFactory.createConflictVersion(this.getUrlString(conflictVersion.getRepositoryRoot()), null, conflictVersion.getPegRevision(), conflictVersion.getPath(), SVNClientImpl.getNodeKind(conflictVersion.getKind()));
    }

    private SVNConflictResult getSVNConflictResult(ConflictResult conflictResult) {
        return new SVNConflictResult(this.getSVNConflictChoice(conflictResult.getChoice()), this.getFile(conflictResult.getMergedPath()));
    }

    private ConflictDescriptor.Action getConflictDescriptorAction(SVNConflictAction conflictAction) {
        if (conflictAction == null) {
            return null;
        }
        if (conflictAction == SVNConflictAction.ADD) {
            return ConflictDescriptor.Action.add;
        }
        if (conflictAction == SVNConflictAction.DELETE) {
            return ConflictDescriptor.Action.delete;
        }
        if (conflictAction == SVNConflictAction.EDIT) {
            return ConflictDescriptor.Action.edit;
        }
        if (conflictAction == SVNConflictAction.REPLACE) {
            return ConflictDescriptor.Action.replace;
        }
        throw new IllegalArgumentException("Unknown conflict action: " + conflictAction);
    }

    private ConflictDescriptor.Reason getConflictDescriptorReason(SVNConflictReason conflictReason) {
        if (conflictReason == null) {
            return null;
        }
        if (conflictReason == SVNConflictReason.ADDED) {
            return ConflictDescriptor.Reason.added;
        }
        if (conflictReason == SVNConflictReason.DELETED) {
            return ConflictDescriptor.Reason.deleted;
        }
        if (conflictReason == SVNConflictReason.EDITED) {
            return ConflictDescriptor.Reason.edited;
        }
        if (conflictReason == SVNConflictReason.MISSING) {
            return ConflictDescriptor.Reason.missing;
        }
        if (conflictReason == SVNConflictReason.OBSTRUCTED) {
            return ConflictDescriptor.Reason.obstructed;
        }
        if (conflictReason == SVNConflictReason.REPLACED) {
            return ConflictDescriptor.Reason.replaced;
        }
        if (conflictReason == SVNConflictReason.UNVERSIONED) {
            return ConflictDescriptor.Reason.unversioned;
        }
        if (conflictReason == SVNConflictReason.MOVED_AWAY) {
            return ConflictDescriptor.Reason.moved_away;
        }
        if (conflictReason == SVNConflictReason.MOVED_HERE) {
            return ConflictDescriptor.Reason.moved_here;
        }
        throw new IllegalArgumentException("Unknown conflict reason: " + conflictReason);
    }

    private static ClientNotifyInformation.Action getClientNotifyInformationAction(SVNEventAction action) {
        if (action == null) {
            return null;
        }
        if (action == SVNEventAction.ADD) {
            return ClientNotifyInformation.Action.add;
        }
        if (action == SVNEventAction.ANNOTATE) {
            return ClientNotifyInformation.Action.blame_revision;
        }
        if (action == SVNEventAction.CHANGELIST_CLEAR) {
            return ClientNotifyInformation.Action.changelist_clear;
        }
        if (action == SVNEventAction.CHANGELIST_MOVED) {
            return ClientNotifyInformation.Action.changelist_moved;
        }
        if (action == SVNEventAction.CHANGELIST_SET) {
            return ClientNotifyInformation.Action.changelist_set;
        }
        if (action == SVNEventAction.COMMIT_ADDED) {
            return ClientNotifyInformation.Action.commit_added;
        }
        if (action == SVNEventAction.COMMIT_COMPLETED) {
            return null;
        }
        if (action == SVNEventAction.COMMIT_DELETED) {
            return ClientNotifyInformation.Action.commit_deleted;
        }
        if (action == SVNEventAction.COMMIT_DELTA_SENT) {
            return ClientNotifyInformation.Action.commit_postfix_txdelta;
        }
        if (action == SVNEventAction.COMMIT_REPLACED) {
            return ClientNotifyInformation.Action.commit_replaced;
        }
        if (action == SVNEventAction.COMMIT_MODIFIED) {
            return ClientNotifyInformation.Action.commit_modified;
        }
        if (action == SVNEventAction.COPY) {
            return ClientNotifyInformation.Action.copy;
        }
        if (action == SVNEventAction.DELETE) {
            return ClientNotifyInformation.Action.delete;
        }
        if (action == SVNEventAction.FAILED_EXTERNAL) {
            return ClientNotifyInformation.Action.failed_external;
        }
        if (action == SVNEventAction.FAILED_REVERT) {
            return ClientNotifyInformation.Action.failed_revert;
        }
        if (action == SVNEventAction.FOREIGN_MERGE_BEGIN) {
            return ClientNotifyInformation.Action.foreign_merge_begin;
        }
        if (action == SVNEventAction.LOCK_FAILED) {
            return ClientNotifyInformation.Action.failed_lock;
        }
        if (action == SVNEventAction.LOCKED) {
            return ClientNotifyInformation.Action.locked;
        }
        if (action == SVNEventAction.MERGE_BEGIN) {
            return ClientNotifyInformation.Action.merge_begin;
        }
        if (action == SVNEventAction.MERGE_COMPLETE) {
            return ClientNotifyInformation.Action.merge_completed;
        }
        if (action == SVNEventAction.PATCH) {
            return ClientNotifyInformation.Action.patch;
        }
        if (action == SVNEventAction.PATCH_APPLIED_HUNK) {
            return ClientNotifyInformation.Action.patch_applied_hunk;
        }
        if (action == SVNEventAction.PATCH_REJECTED_HUNK) {
            return ClientNotifyInformation.Action.patch_rejected_hunk;
        }
        if (action == SVNEventAction.PROGRESS) {
            return null;
        }
        if (action == SVNEventAction.PROPERTY_ADD) {
            return ClientNotifyInformation.Action.property_added;
        }
        if (action == SVNEventAction.PROPERTY_DELETE) {
            return ClientNotifyInformation.Action.property_deleted;
        }
        if (action == SVNEventAction.PROPERTY_DELETE_NONEXISTENT) {
            return ClientNotifyInformation.Action.property_deleted_nonexistent;
        }
        if (action == SVNEventAction.PROPERTY_MODIFY) {
            return ClientNotifyInformation.Action.property_modified;
        }
        if (action == SVNEventAction.RESOLVED) {
            return ClientNotifyInformation.Action.resolved;
        }
        if (action == SVNEventAction.RESTORE) {
            return ClientNotifyInformation.Action.restore;
        }
        if (action == SVNEventAction.REVERT) {
            return ClientNotifyInformation.Action.revert;
        }
        if (action == SVNEventAction.REVPROP_DELETE) {
            return ClientNotifyInformation.Action.revprop_deleted;
        }
        if (action == SVNEventAction.REVPROPER_SET) {
            return ClientNotifyInformation.Action.revprop_set;
        }
        if (action == SVNEventAction.SKIP) {
            return ClientNotifyInformation.Action.skip;
        }
        if (action == SVNEventAction.SKIP_CONFLICTED) {
            return ClientNotifyInformation.Action.skip_conflicted;
        }
        if (action == SVNEventAction.STATUS_COMPLETED) {
            return ClientNotifyInformation.Action.status_completed;
        }
        if (action == SVNEventAction.STATUS_EXTERNAL) {
            return ClientNotifyInformation.Action.status_external;
        }
        if (action == SVNEventAction.TREE_CONFLICT) {
            return ClientNotifyInformation.Action.tree_conflict;
        }
        if (action == SVNEventAction.UNLOCK_FAILED) {
            return ClientNotifyInformation.Action.failed_unlock;
        }
        if (action == SVNEventAction.UNLOCKED) {
            return ClientNotifyInformation.Action.unlocked;
        }
        if (action == SVNEventAction.UPDATE_ADD) {
            return ClientNotifyInformation.Action.update_add;
        }
        if (action == SVNEventAction.UPDATE_COMPLETED) {
            return ClientNotifyInformation.Action.update_completed;
        }
        if (action == SVNEventAction.UPDATE_DELETE) {
            return ClientNotifyInformation.Action.update_delete;
        }
        if (action == SVNEventAction.UPDATE_EXISTS) {
            return ClientNotifyInformation.Action.exists;
        }
        if (action == SVNEventAction.UPDATE_EXTERNAL) {
            return ClientNotifyInformation.Action.update_external;
        }
        if (action == SVNEventAction.UPDATE_EXTERNAL_REMOVED) {
            return ClientNotifyInformation.Action.update_external_removed;
        }
        if (action == SVNEventAction.UPDATE_NONE) {
            return ClientNotifyInformation.Action.update_update;
        }
        if (action == SVNEventAction.UPDATE_REPLACE) {
            return ClientNotifyInformation.Action.update_replaced;
        }
        if (action == SVNEventAction.UPDATE_SHADOWED_ADD) {
            return ClientNotifyInformation.Action.update_shadowed_add;
        }
        if (action == SVNEventAction.UPDATE_SHADOWED_DELETE) {
            return ClientNotifyInformation.Action.update_shadowed_delete;
        }
        if (action == SVNEventAction.UPDATE_SHADOWED_UPDATE) {
            return ClientNotifyInformation.Action.update_shadowed_update;
        }
        if (action == SVNEventAction.UPDATE_SKIP_ACCESS_DENINED) {
            return ClientNotifyInformation.Action.update_skip_access_denied;
        }
        if (action == SVNEventAction.UPDATE_SKIP_OBSTRUCTION) {
            return ClientNotifyInformation.Action.update_skip_obstruction;
        }
        if (action == SVNEventAction.UPDATE_SKIP_WORKING_ONLY) {
            return ClientNotifyInformation.Action.update_skip_working_only;
        }
        if (action == SVNEventAction.UPDATE_STARTED) {
            return ClientNotifyInformation.Action.update_started;
        }
        if (action == SVNEventAction.UPDATE_UPDATE) {
            return ClientNotifyInformation.Action.update_update;
        }
        if (action == SVNEventAction.UPGRADE) {
            return ClientNotifyInformation.Action.upgraded_path;
        }
        if (action == SVNEventAction.UPGRADED_PATH) {
            return ClientNotifyInformation.Action.upgraded_path;
        }
        if (action == SVNEventAction.PATH_NONEXISTENT) {
            return ClientNotifyInformation.Action.path_nonexistent;
        }
        if (action == SVNEventAction.MERGE_ELIDE_INFO) {
            return ClientNotifyInformation.Action.merge_elide_info;
        }
        if (action == SVNEventAction.MERGE_RECORD_INFO) {
            return ClientNotifyInformation.Action.merge_record_info;
        }
        if (action == SVNEventAction.MERGE_RECORD_INFO_BEGIN) {
            return ClientNotifyInformation.Action.merge_record_info_begin;
        }
        if (action == SVNEventAction.MERGE_RECORD_INFO_BEGIN) {
            return ClientNotifyInformation.Action.merge_record_info_begin;
        }
        return null;
    }

    private ConflictDescriptor.Kind getConflictDescriptorKind(SVNConflictDescription conflictDescription) {
        if (conflictDescription == null) {
            return null;
        }
        if (conflictDescription.isTextConflict()) {
            return ConflictDescriptor.Kind.text;
        }
        if (conflictDescription.isPropertyConflict()) {
            return ConflictDescriptor.Kind.property;
        }
        if (conflictDescription.isTreeConflict()) {
            return ConflictDescriptor.Kind.tree;
        }
        throw new IllegalArgumentException("Unknown conflict kind: " + conflictDescription);
    }

    private File getFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    private ISvnObjectReceiver<SVNDirEntry> getDirEntryReceiver(final ListCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ISvnObjectReceiver<SVNDirEntry>(){

            @Override
            public void receive(SvnTarget target, SVNDirEntry dirEntry) throws SVNException {
                callback.doEntry(SVNClientImpl.this.getDirEntry(dirEntry), SVNClientImpl.getLock(dirEntry.getLock()));
            }
        };
    }

    private DirEntry getDirEntry(SVNDirEntry dirEntry) {
        if (dirEntry == null) {
            return null;
        }
        String repositoryRootString = this.getUrlString(dirEntry.getRepositoryRoot());
        String urlString = this.getUrlString(dirEntry.getURL());
        String absolutePath = SVNPathUtil.getRelativePath(repositoryRootString, urlString);
        return new DirEntry(dirEntry.getRelativePath(), absolutePath, SVNClientImpl.getNodeKind(dirEntry.getKind()), dirEntry.getSize(), dirEntry.hasProperties(), dirEntry.getRevision(), SVNClientImpl.getLongDate(dirEntry.getDate()), dirEntry.getAuthor());
    }

    static ClientNotifyInformation getClientNotifyInformation(String pathPrefix, SVNEvent event, String path) {
        ClientNotifyInformation.Action action = SVNClientImpl.getClientNotifyInformationAction(event.getAction());
        if (action == null) {
            return null;
        }
        long hunkOriginalStart = -1L;
        long hunkOriginalLength = -1L;
        long hunkModifiedStart = -1L;
        long hunkModifiedLength = -1L;
        long hunkMatchedLine = -1L;
        int hunkFuzz = -1;
        Object info = event.getInfo();
        if (info != null && info instanceof SVNPatchHunkInfo) {
            SVNPatchHunkInfo hunkInfo = (SVNPatchHunkInfo)info;
            hunkOriginalStart = hunkInfo.getHunk().getOriginal().getStart();
            hunkOriginalLength = hunkInfo.getHunk().getOriginal().getLength();
            hunkModifiedStart = hunkInfo.getHunk().getModified().getStart();
            hunkModifiedLength = hunkInfo.getHunk().getModified().getLength();
            hunkFuzz = hunkInfo.getFuzz();
        }
        return new ClientNotifyInformation(path, action, SVNClientImpl.getNodeKind(event.getNodeKind()), event.getMimeType(), SVNClientImpl.getLock(event.getLock()), SVNClientImpl.getErrorMessageString(event.getErrorMessage()), SVNClientImpl.getClientNotifyInformationStatus(event.getContentsStatus()), SVNClientImpl.getClientNotifyInformationStatus(event.getPropertiesStatus()), SVNClientImpl.getClientNotifyInformationLockStatus(event.getLockStatus()), event.getRevision(), event.getChangelistName(), SVNClientImpl.getRevisionRange(event.getMergeRange()), pathPrefix, event.getPropertyName(), SVNClientImpl.getRevisionProperties(event.getRevisionProperties()), event.getPreviousRevision(), hunkOriginalStart, hunkOriginalLength, hunkModifiedStart, hunkModifiedLength, hunkMatchedLine, hunkFuzz);
    }

    private static ClientNotifyInformation.LockStatus getClientNotifyInformationLockStatus(SVNStatusType lockStatus) {
        if (lockStatus == null) {
            return null;
        }
        if (lockStatus == SVNStatusType.LOCK_LOCKED) {
            return ClientNotifyInformation.LockStatus.locked;
        }
        if (lockStatus == SVNStatusType.LOCK_INAPPLICABLE || lockStatus == SVNStatusType.INAPPLICABLE) {
            return ClientNotifyInformation.LockStatus.inapplicable;
        }
        if (lockStatus == SVNStatusType.LOCK_UNCHANGED) {
            return ClientNotifyInformation.LockStatus.unchanged;
        }
        if (lockStatus == SVNStatusType.LOCK_UNKNOWN) {
            return ClientNotifyInformation.LockStatus.unknown;
        }
        if (lockStatus == SVNStatusType.LOCK_UNLOCKED) {
            return ClientNotifyInformation.LockStatus.unlocked;
        }
        throw new IllegalArgumentException("Unknown lock status: " + lockStatus);
    }

    private static ClientNotifyInformation.Status getClientNotifyInformationStatus(SVNStatusType status) {
        if (status == null) {
            return null;
        }
        if (status == SVNStatusType.CHANGED) {
            return ClientNotifyInformation.Status.changed;
        }
        if (status == SVNStatusType.CONFLICTED) {
            return ClientNotifyInformation.Status.conflicted;
        }
        if (status == SVNStatusType.CONFLICTED_UNRESOLVED) {
            return ClientNotifyInformation.Status.conflicted;
        }
        if (status == SVNStatusType.INAPPLICABLE) {
            return ClientNotifyInformation.Status.inapplicable;
        }
        if (status == SVNStatusType.MERGED) {
            return ClientNotifyInformation.Status.merged;
        }
        if (status == SVNStatusType.MISSING) {
            return ClientNotifyInformation.Status.missing;
        }
        if (status == SVNStatusType.OBSTRUCTED) {
            return ClientNotifyInformation.Status.obstructed;
        }
        if (status == SVNStatusType.UNCHANGED) {
            return ClientNotifyInformation.Status.unchanged;
        }
        if (status == SVNStatusType.UNKNOWN) {
            return ClientNotifyInformation.Status.unknown;
        }
        throw new IllegalArgumentException("Unknown status type: " + status);
    }

    private String getPathPrefix(String pathOrUrl) {
        if (pathOrUrl == null) {
            return null;
        }
        if (SVNPathUtil.isURL(pathOrUrl)) {
            return null;
        }
        File file = this.getFile(pathOrUrl);
        if (file == null) {
            return null;
        }
        boolean isFile = file.isFile();
        if (isFile) {
            File parentFile = SVNFileUtil.getParentFile(file);
            if (parentFile == null) {
                return null;
            }
            return this.getFilePath(parentFile.getAbsoluteFile());
        }
        return this.getFilePath(file.getAbsoluteFile());
    }

    private String getPathPrefix(Collection<?> pathsOrUrls) {
        if (pathsOrUrls == null || pathsOrUrls.size() == 0) {
            return null;
        }
        String commonAncestor = null;
        for (Object pathOrUrl : pathsOrUrls) {
            String pathOrUrlString = null;
            if (pathOrUrl instanceof String) {
                pathOrUrlString = (String)pathOrUrl;
            } else if (pathOrUrl instanceof CopySource) {
                pathOrUrlString = ((CopySource)pathOrUrl).getPath();
            }
            if (pathOrUrlString == null) continue;
            commonAncestor = this.combinePathPrefixes(commonAncestor, pathOrUrlString);
        }
        return this.getPathPrefix(commonAncestor);
    }

    private String getPathPrefix(Collection<?> pathsOrUrls, String destPath) {
        String pathPrefix1 = this.getPathPrefix(pathsOrUrls);
        String pathPrefix2 = this.getPathPrefix(destPath);
        return this.combinePathPrefixes(pathPrefix1, pathPrefix2);
    }

    private String getPathPrefix(String pathOrUrl1, String pathOrUrl2) {
        return this.combinePathPrefixes(this.getPathPrefix(pathOrUrl1), this.getPathPrefix(pathOrUrl2));
    }

    private String combinePathPrefixes(String pathPrefix1, String pathPrefix2) {
        if (pathPrefix1 == null) {
            return pathPrefix2;
        }
        if (pathPrefix2 == null) {
            return pathPrefix1;
        }
        return SVNPathUtil.getCommonPathAncestor(pathPrefix1, pathPrefix2);
    }

    private void updateSvnOperationsFactory() {
        File configDir = this.configDir == null ? null : new File(this.configDir);
        this.options = SVNWCUtil.createDefaultOptions(configDir, true);
        this.options.setConflictHandler(this.conflictHandler);
        this.authenticationManager = SVNWCUtil.createDefaultAuthenticationManager(configDir, this.username, this.password, this.options.isAuthStorageEnabled());
        if (this.prompt != null) {
            this.authenticationManager.setAuthenticationProvider(new JavaHLAuthenticationProvider(this.prompt));
        } else {
            this.authenticationManager.setAuthenticationProvider(null);
        }
        if (this.authenticationManager instanceof DefaultSVNAuthenticationManager) {
            ((DefaultSVNAuthenticationManager)this.authenticationManager).setRuntimeStorage(this.getClientCredentialsStorage());
        }
        if (this.svnOperationFactory != null) {
            this.svnOperationFactory.setAuthenticationManager(this.authenticationManager);
            this.svnOperationFactory.setOptions(this.options);
            this.svnOperationFactory.setEventHandler(this.getEventHandler());
        }
    }

    static String versionString() {
        return Version.getVersionString();
    }

    static int versionMajor() {
        return Version.getMajorVersion();
    }

    static int versionMinor() {
        return Version.getMinorVersion();
    }

    static int versionMicro() {
        return Version.getMicroVersion();
    }

    static long versionRevisionNumber() {
        return Version.getRevisionNumber();
    }

    private void throwSvnException(Exception e) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        SVNErrorManager.error(errorMessage, e, SVNLogType.CLIENT);
    }

    private void resetLog() {
        if (this.progressListener != null) {
            this.progressListener.reset();
        }
    }

    private void beforeOperation() {
        this.getEventHandler().setCancelOperation(false);
    }

    private void afterOperation() {
        this.getEventHandler().setCancelOperation(false);
        this.getEventHandler().resetPathPrefix();
        this.resetLog();
    }

    @Override
    public VersionExtended getVersionExtended(boolean verbose) {
        return null;
    }

    @Override
    public void add(String path, Depth depth, boolean force, boolean noIgnores, boolean noAutoProps, boolean addParents) throws ClientException {
    }

    @Override
    public void move(Set<String> srcPaths, String destPath, boolean force, boolean moveAsChild, boolean makeParents, boolean metadataOnly, boolean allowMixRev, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
    }

    @Override
    public void doImport(String path, String url, Depth depth, boolean noIgnore, boolean noAutoProps, boolean ignoreUnknownNodeTypes, Map<String, String> revpropTable, ImportFilterCallback importFilterCallback, CommitMessageCallback messageHandler, CommitCallback commitCallback) throws ClientException {
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, OutputStream outStream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, OutputStream outStream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly) throws ClientException {
    }

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, OutputStream outStream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
    }

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
    }

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, OutputStream outStream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly) throws ClientException {
    }

    @Override
    public void properties(String path, Revision revision, Revision pegRevision, Depth depth, Collection<String> changelists, InheritedProplistCallback callback) throws ClientException {
    }

    @Override
    public byte[] propertyGet(String path, String name, Revision revision, Revision pegRevision, Collection<String> changelists) throws ClientException {
        return null;
    }

    @Override
    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, Depth depth, boolean ignoreMergeinfo, boolean diffIgnoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
    }

    @Override
    public void merge(String path, Revision pegRevision, List<RevisionRange> revisions, String localPath, boolean force, Depth depth, boolean ignoreMergeinfo, boolean diffIgnoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
    }

    @Override
    public void getMergeinfoLog(Mergeinfo.LogKind kind, String pathOrUrl, Revision pegRevision, String mergeSourceUrl, Revision srcPegRevision, Revision srcStartRevision, Revision srcEndRevision, boolean discoverChangedPaths, Depth depth, Set<String> revProps, LogMessageCallback callback) throws ClientException {
    }
}

