/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SvnConflictReport;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgMergePegged
extends SvnNgOperationRunner<Void, SvnMerge> {
    @Override
    public boolean isApplicable(SvnMerge operation, SvnWcGeneration wcGeneration) throws SVNException {
        return super.isApplicable(operation, wcGeneration) && !operation.isReintegrate() && operation.getSource() != null && operation.getRevisionRanges() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        SvnConflictReport conflictReport;
        if (((SvnMerge)this.getOperation()).getRevisionRanges() == null || ((SvnMerge)this.getOperation()).getRevisionRanges().isEmpty()) {
            return null;
        }
        File lockPath = this.getLockPath(this.getFirstTarget());
        if (((SvnMerge)this.getOperation()).isDryRun()) {
            SvnNgMergeDriver.MergeData mergeData = this.merge(this.getFirstTarget());
            conflictReport = mergeData.conflictReport;
        } else {
            try {
                lockPath = context.acquireWriteLock(lockPath, false, true);
                SvnNgMergeDriver.MergeData mergeData = this.merge(this.getFirstTarget());
                conflictReport = mergeData.conflictReport;
            }
            finally {
                context.releaseWriteLock(lockPath);
                this.sleepForTimestamp();
            }
        }
        SvnNgMergeDriver.makeMergeConflictError(conflictReport);
        return null;
    }

    private File getLockPath(File firstTarget) throws SVNException {
        SVNNodeKind kind = this.getWcContext().readKind(firstTarget, false);
        if (kind == SVNNodeKind.DIR) {
            return firstTarget;
        }
        return SVNFileUtil.getParentFile(firstTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SvnNgMergeDriver.MergeData merge(File target) throws SVNException {
        SVNNodeKind targetKind;
        SVNURL url;
        SVNFileType ft = SVNFileType.getType(target);
        if (ft == SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Path ''{0}'' does not exist", (Object)target);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((url = this.getRepositoryAccess().getTargetURL(((SvnMerge)this.getOperation()).getSource())) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)((SvnMerge)this.getOperation()).getSource());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((targetKind = this.getWcContext().readKind(target, false)) != SVNNodeKind.DIR && targetKind != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Merge target ''{0}'' does not exist in the working copy", (Object)target);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SvnNgMergeDriver mergeDriver = new SvnNgMergeDriver(this.getWcContext(), (SvnMerge)this.getOperation(), this.getRepositoryAccess(), ((SvnMerge)this.getOperation()).getMergeOptions());
        mergeDriver.ensureWcIsSuitableForMerge(target, ((SvnMerge)this.getOperation()).isAllowMixedRevisions(), true, true);
        SVNURL wcReposRootURL = this.getWcContext().getNodeReposInfo((File)target).reposRootUrl;
        boolean sameRepos = true;
        SVNRepository repos = this.getRepositoryAccess().createRepository(url, null, false);
        List<SvnNgMergeDriver.MergeSource> sources = null;
        try {
            SVNURL sourceRootURL = repos.getRepositoryRoot(true);
            sources = mergeDriver.normalizeMergeSources(((SvnMerge)this.getOperation()).getSource(), url, sourceRootURL, ((SvnMerge)this.getOperation()).getSource().getResolvedPegRevision(), SvnCodec.oldRevisionRanges(((SvnMerge)this.getOperation()).getRevisionRanges()), repos);
            if (!wcReposRootURL.equals(sourceRootURL)) {
                String targetUuid = this.getWcContext().getNodeReposInfo((File)target).reposUuid;
                String sourceUuid = repos.getRepositoryUUID(true);
                sameRepos = targetUuid.equals(sourceUuid);
            }
            SvnNgMergeDriver.MergeData mergeData = mergeDriver.doMerge(null, sources, target, repos, true, sameRepos, ((SvnMerge)this.getOperation()).isIgnoreAncestry(), ((SvnMerge)this.getOperation()).isForce(), ((SvnMerge)this.getOperation()).isDryRun(), ((SvnMerge)this.getOperation()).isRecordOnly(), null, false, false, ((SvnMerge)this.getOperation()).getDepth(), ((SvnMerge)this.getOperation()).getMergeOptions());
            return mergeData;
        }
        finally {
            repos.closeSession();
        }
    }
}

