/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNUpdateEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCConflictDescription17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgAdd;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgReposToWcCopy;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgMergeCallback2
implements ISvnDiffCallback2 {
    private final SvnNgMergeDriver mergeDriver;
    private FileBaton currentFile;
    private SVNWCContext context;
    private SvnNgRepositoryAccess repositoryAccess;

    public SvnNgMergeCallback2(SVNWCContext context, SvnNgMergeDriver mergeDriver, SvnNgRepositoryAccess repositoryAccess) {
        this.context = context;
        this.mergeDriver = mergeDriver;
        this.repositoryAccess = repositoryAccess;
    }

    @Override
    public void fileOpened(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SvnDiffSource copyFromSource, boolean createDirBaton, Object dirBaton) throws SVNException {
        DirectoryBaton currentDirectory = (DirectoryBaton)dirBaton;
        if (createDirBaton && currentDirectory == null) {
            currentDirectory = new DirectoryBaton();
            currentDirectory.treeConflictReason = null;
            currentDirectory.treeConflictAction = SVNConflictAction.EDIT;
            currentDirectory.skipReason = SVNStatusType.UNKNOWN;
            result.newBaton = currentDirectory;
        }
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        this.currentFile = new FileBaton();
        this.currentFile.treeConflictReason = null;
        this.currentFile.treeConflictAction = SVNConflictAction.EDIT;
        this.currentFile.skipReason = SVNStatusType.UNKNOWN;
        if (currentDirectory != null) {
            this.currentFile.parentBaton = currentDirectory;
            this.currentFile.shadowed = currentDirectory.shadowed;
            this.currentFile.skipReason = currentDirectory.skipReason;
        }
        if (!this.currentFile.shadowed) {
            if (leftSource != null) {
                if (rightSource == null) {
                    this.currentFile.treeConflictAction = SVNConflictAction.DELETE;
                }
                SVNWCContext.ObstructionData obstructionData = this.performObstructionCheck(localAbsPath);
                SVNStatusType obstructionState = obstructionData.obstructionState;
                boolean isDeleted = obstructionData.deleted;
                boolean isExcluded = obstructionData.excluded;
                SVNNodeKind kind = obstructionData.kind;
                SVNDepth parentDepth = obstructionData.parentDepth;
                if (obstructionState != SVNStatusType.INAPPLICABLE) {
                    this.currentFile.shadowed = true;
                    this.currentFile.treeConflictReason = SVNConflictReason.SKIP;
                    this.currentFile.skipReason = obstructionState;
                    return;
                }
                if (isDeleted) {
                    kind = SVNNodeKind.NONE;
                }
                if (kind == SVNNodeKind.NONE) {
                    this.currentFile.shadowed = true;
                    if (currentDirectory != null && (isExcluded || parentDepth != SVNDepth.UNKNOWN && parentDepth.compareTo(SVNDepth.FILES) < 0)) {
                        this.currentFile.shadowed = true;
                        this.currentFile.treeConflictReason = SVNConflictReason.SKIP;
                        this.currentFile.skipReason = SVNStatusType.MISSING;
                        return;
                    }
                    if (isDeleted) {
                        this.currentFile.treeConflictReason = SVNConflictReason.DELETED;
                    } else {
                        this.currentFile.treeConflictReason = SVNConflictReason.MISSING;
                    }
                    result.skip = true;
                    this.currentFile.markFileEdited(localAbsPath);
                    return;
                }
                if (kind != SVNNodeKind.FILE) {
                    this.currentFile.shadowed = true;
                    this.currentFile.treeConflictReason = SVNConflictReason.OBSTRUCTED;
                    result.skip = true;
                    this.currentFile.markFileEdited(localAbsPath);
                    return;
                }
                if (rightSource == null) {
                    this.currentFile.treeConflictAction = SVNConflictAction.DELETE;
                    this.currentFile.markFileEdited(localAbsPath);
                    if (this.currentFile.shadowed) {
                        return;
                    }
                    if (currentDirectory != null && currentDirectory.deleteState != null && currentDirectory.deleteState.foundEdit) {
                        result.skip = true;
                    }
                }
            } else {
                SVNWCConflictDescription17 oldTreeConflict = null;
                this.currentFile.added = true;
                this.currentFile.treeConflictAction = SVNConflictAction.ADD;
                if (currentDirectory != null && currentDirectory.pendingDeletes != null && currentDirectory.pendingDeletes.containsKey(localAbsPath)) {
                    this.currentFile.addIsReplace = true;
                    this.currentFile.treeConflictAction = SVNConflictAction.REPLACE;
                    currentDirectory.pendingDeletes.remove(localAbsPath);
                }
                if (currentDirectory != null && currentDirectory.newTreeConflicts != null && currentDirectory.newTreeConflicts.containsKey(localAbsPath)) {
                    oldTreeConflict = (SVNWCConflictDescription17)currentDirectory.newTreeConflicts.get(localAbsPath);
                    this.currentFile.treeConflictAction = SVNConflictAction.REPLACE;
                    this.currentFile.treeConflictReason = oldTreeConflict.getReason();
                    this.recordTreeConflict(localAbsPath, currentDirectory, SVNNodeKind.FILE, this.currentFile.treeConflictAction, this.currentFile.treeConflictReason, oldTreeConflict, false);
                    if (oldTreeConflict.getReason() != SVNConflictReason.DELETED && oldTreeConflict.getReason() != SVNConflictReason.MOVED_AWAY) {
                        result.skip = true;
                        return;
                    }
                } else if (!(this.mergeDriver.dryRun && (currentDirectory != null && currentDirectory.added || this.currentFile.addIsReplace))) {
                    SVNWCContext.ObstructionData obstructionData = this.performObstructionCheck(localAbsPath);
                    SVNStatusType obstructionState = obstructionData.obstructionState;
                    boolean isDeleted = obstructionData.deleted;
                    boolean excluded = obstructionData.excluded;
                    SVNNodeKind kind = obstructionData.kind;
                    SVNDepth parentDepth = obstructionData.parentDepth;
                    if (obstructionState != SVNStatusType.INAPPLICABLE) {
                        this.currentFile.shadowed = true;
                        this.currentFile.treeConflictReason = SVNConflictReason.SKIP;
                        this.currentFile.skipReason = obstructionState;
                    } else if (kind != SVNNodeKind.NONE && !isDeleted) {
                        this.currentFile.shadowed = true;
                        this.currentFile.treeConflictReason = SVNConflictReason.OBSTRUCTED;
                    }
                }
                this.currentFile.markFileEdited(localAbsPath);
            }
        }
    }

    @Override
    public void fileChanged(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, File leftFile, File rightFile, SVNProperties leftProps, SVNProperties rightProps, boolean fileModified, SVNProperties propChanges) throws SVNException {
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        assert (localAbsPath != null && SVNFileUtil.isAbsolute(localAbsPath));
        assert (leftFile == null || SVNFileUtil.isAbsolute(leftFile));
        assert (rightFile == null || SVNFileUtil.isAbsolute(rightFile));
        this.currentFile.markFileEdited(localAbsPath);
        if (this.currentFile.shadowed) {
            if (this.currentFile.treeConflictReason == null) {
                this.recordSkip(localAbsPath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SHADOWED_UPDATE, this.currentFile.skipReason);
            }
            return;
        }
        SVNStatusType propertyState = SVNStatusType.UNCHANGED;
        SVNStatusType textState = SVNStatusType.UNCHANGED;
        propChanges = this.prepareMergePropsChanged(localAbsPath, propChanges);
        SVNConflictVersion[] conflictVersions = this.makeConflictVersions(localAbsPath, SVNNodeKind.FILE, this.mergeDriver.reposRootUrl, this.mergeDriver.mergeSource, this.mergeDriver.targetAbsPath);
        SVNConflictVersion left = conflictVersions[0];
        SVNConflictVersion right = conflictVersions[1];
        if ((this.mergeDriver.recordOnly || leftFile == null) && propChanges.size() > 0) {
            SVNWCContext.MergePropertiesInfo mergePropertiesInfo = this.context.mergeProperties(localAbsPath, left, right, leftProps, propChanges, this.mergeDriver.dryRun, null);
            propertyState = mergePropertiesInfo.mergeOutcome;
            if (propertyState == SVNStatusType.CONFLICTED) {
                if (this.mergeDriver.conflictedPaths == null) {
                    this.mergeDriver.conflictedPaths = new HashSet<File>();
                }
                this.mergeDriver.conflictedPaths.add(localAbsPath);
            }
        }
        if (!this.mergeDriver.recordOnly && leftFile != null) {
            String targetLabel = ".working";
            String leftLabel = ".merge-left.r" + leftSource.getRevision();
            String rightLabel = ".merge-right.r" + rightSource.getRevision();
            boolean hasLocalModifications = this.context.isTextModified(localAbsPath, false);
            MergeOutcome mergeOutcome = this.merge(leftFile, rightFile, localAbsPath, leftLabel, rightLabel, targetLabel, left, right, this.mergeDriver.dryRun, this.mergeDriver.diff3Cmd, this.mergeDriver.diffOptions, leftProps, propChanges, true, true, null);
            SVNStatusType contentOutcome = mergeOutcome.mergeContentOutcome;
            propertyState = mergeOutcome.mergePropsOutcome;
            if (contentOutcome == SVNStatusType.CONFLICTED || propertyState == SVNStatusType.CONFLICTED) {
                if (this.mergeDriver.conflictedPaths == null) {
                    this.mergeDriver.conflictedPaths = new HashSet<File>();
                }
                this.mergeDriver.conflictedPaths.add(localAbsPath);
            }
            textState = contentOutcome == SVNStatusType.CONFLICTED ? SVNStatusType.CONFLICTED : (hasLocalModifications && contentOutcome != SVNStatusType.UNCHANGED ? SVNStatusType.MERGED : (contentOutcome == SVNStatusType.MERGED ? SVNStatusType.CHANGED : (contentOutcome == SVNStatusType.NO_MERGE ? SVNStatusType.MISSING : SVNStatusType.UNCHANGED)));
        }
        if (textState == SVNStatusType.CONFLICTED || textState == SVNStatusType.MERGED || textState == SVNStatusType.CHANGED || propertyState == SVNStatusType.CONFLICTED || propertyState == SVNStatusType.MERGED || propertyState == SVNStatusType.CHANGED) {
            this.recordUpdateUpdate(localAbsPath, SVNNodeKind.FILE, textState, propertyState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(SvnDiffCallbackResult result, File relPath, SvnDiffSource copyFromSource, SvnDiffSource rightSource, File copyFromFile, File rightFile, SVNProperties copyFromProps, SVNProperties rightProps) throws SVNException {
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        this.currentFile.markFileEdited(localAbsPath);
        if (this.currentFile.shadowed) {
            if (this.currentFile.treeConflictReason == null) {
                this.recordSkip(localAbsPath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SHADOWED_ADD, this.currentFile.skipReason);
            }
            return;
        }
        if (this.mergeDriver.recordOnly) {
            return;
        }
        if ((this.mergeDriver.mergeSource.ancestral || this.mergeDriver.reintegrateMerge) && (this.currentFile.parentBaton == null || this.currentFile.parentBaton.added)) {
            if (this.mergeDriver.addedPaths == null) {
                this.mergeDriver.addedPaths = new HashSet<File>();
            }
            this.mergeDriver.addedPaths.add(localAbsPath);
        }
        InputStream pristineStream = null;
        InputStream newStream = null;
        SVNProperties newProps = null;
        try {
            if (!this.mergeDriver.dryRun) {
                SVNProperties pristineProps;
                long copyFromRevision;
                SVNURL copyFromUrl;
                if (this.mergeDriver.sameRepos) {
                    File child = SVNFileUtil.skipAncestor(this.mergeDriver.targetAbsPath, localAbsPath);
                    assert (child != null);
                    copyFromUrl = this.mergeDriver.mergeSource.url2.appendPath(SVNFileUtil.getFilePath(child), false);
                    copyFromRevision = rightSource.getRevision();
                    this.checkReposMatch(this.mergeDriver.reposRootUrl, localAbsPath, copyFromUrl);
                    pristineStream = SVNFileUtil.openFileForReading(rightFile);
                    newStream = null;
                    pristineProps = rightProps;
                    newProps = null;
                    if (pristineProps.containsName("svn:mergeinfo")) {
                        if (this.mergeDriver.pathsWithNewMergeInfo == null) {
                            this.mergeDriver.pathsWithNewMergeInfo = new HashSet<File>();
                        }
                        this.mergeDriver.pathsWithNewMergeInfo.add(localAbsPath);
                    }
                } else {
                    copyFromUrl = null;
                    copyFromRevision = -1L;
                    pristineStream = SVNFileUtil.DUMMY_IN;
                    newStream = SVNFileUtil.openFileForReading(rightFile);
                    pristineProps = new SVNProperties();
                    newProps = new SVNProperties();
                    SvnNgPropertiesManager.categorizeProperties(rightProps, newProps, null, null);
                    newProps.remove("svn:mergeinfo");
                }
                SvnNgReposToWcCopy.addFileToWc(this.context, localAbsPath, pristineStream, newStream, pristineProps, newProps, copyFromUrl, copyFromRevision);
                this.mergeDriver.useSleep = true;
            }
            this.recordUpdateAdd(localAbsPath, SVNNodeKind.FILE, this.currentFile.addIsReplace);
        }
        finally {
            SVNFileUtil.closeFile(pristineStream);
            SVNFileUtil.closeFile(newStream);
        }
    }

    @Override
    public void fileDeleted(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, File leftFile, SVNProperties leftProps) throws SVNException {
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        this.currentFile.markFileEdited(localAbsPath);
        if (this.currentFile.shadowed) {
            if (this.currentFile.treeConflictReason == null) {
                this.recordSkip(localAbsPath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SHADOWED_DELETE, this.currentFile.skipReason);
            }
            return;
        }
        if (this.mergeDriver.recordOnly) {
            return;
        }
        boolean same = this.mergeDriver.forceDelete ? true : this.areFilesSame(leftFile, leftProps, localAbsPath);
        if (this.currentFile.parentBaton != null && this.currentFile.parentBaton.deleteState != null) {
            if (same) {
                this.currentFile.parentBaton.deleteState.comparedAbsPaths.add(localAbsPath);
            } else {
                this.currentFile.parentBaton.deleteState.foundEdit = true;
            }
            return;
        }
        if (same) {
            if (!this.mergeDriver.dryRun) {
                SvnNgRemove.delete(this.context, localAbsPath, null, false, false, null);
            }
            if (this.mergeDriver.pathsWithDeletedMergeInfo == null) {
                this.mergeDriver.pathsWithDeletedMergeInfo = new HashSet<File>();
            }
            this.mergeDriver.pathsWithDeletedMergeInfo.add(localAbsPath);
            this.recordUpdateDelete(localAbsPath, SVNNodeKind.FILE, this.currentFile.parentBaton);
        } else {
            this.recordTreeConflict(localAbsPath, this.currentFile.parentBaton, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.EDITED, null, true);
        }
    }

    @Override
    public void fileClosed(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(errorMessage, SVNLogType.WC);
    }

    @Override
    public void dirOpened(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SvnDiffSource copyFromSource, Object dirBaton) throws SVNException {
        DirectoryBaton currentDirectory = (DirectoryBaton)dirBaton;
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        DirectoryBaton db = new DirectoryBaton();
        db.treeConflictReason = null;
        db.treeConflictAction = SVNConflictAction.EDIT;
        db.skipReason = SVNStatusType.UNKNOWN;
        DirectoryBaton pdb = currentDirectory;
        result.newBaton = db;
        if (pdb != null) {
            db.parentBaton = pdb;
            db.shadowed = pdb.shadowed;
            db.skipReason = pdb.skipReason;
        }
        if (db.shadowed) {
            if (leftSource == null) {
                db.added = true;
            }
        } else if (leftSource != null) {
            if (rightSource == null) {
                db.treeConflictAction = SVNConflictAction.DELETE;
            }
            SVNWCContext.ObstructionData obstructionData = this.performObstructionCheck(localAbsPath);
            SVNStatusType obstructionState = obstructionData.obstructionState;
            boolean isDeleted = obstructionData.deleted;
            boolean excluded = obstructionData.excluded;
            SVNNodeKind kind = obstructionData.kind;
            SVNDepth parentDepth = obstructionData.parentDepth;
            if (obstructionState != SVNStatusType.INAPPLICABLE) {
                db.shadowed = true;
                if (obstructionState == SVNStatusType.OBSTRUCTED && this.context.getDb().isWCRoot(localAbsPath)) {
                    db.treeConflictReason = SVNConflictReason.WC_SKIP;
                    return;
                }
                db.treeConflictReason = SVNConflictReason.SKIP;
                db.skipReason = obstructionState;
                if (rightSource == null) {
                    result.skipChildren = true;
                    result.skip = true;
                    db.markDirectoryEdited(localAbsPath);
                }
                return;
            }
            if (isDeleted) {
                kind = SVNNodeKind.NONE;
            }
            if (kind == SVNNodeKind.NONE) {
                db.shadowed = true;
                if (pdb != null && (excluded || parentDepth != SVNDepth.UNKNOWN && parentDepth.compareTo(SVNDepth.IMMEDIATES) < 0)) {
                    db.shadowed = true;
                    db.treeConflictReason = SVNConflictReason.SKIP;
                    db.skipReason = SVNStatusType.MISSING;
                    return;
                }
                if (isDeleted) {
                    db.treeConflictReason = SVNConflictReason.DELETED;
                } else {
                    db.treeConflictReason = SVNConflictReason.MISSING;
                }
                result.skip = true;
                result.skipChildren = true;
                db.markDirectoryEdited(localAbsPath);
                return;
            }
            if (kind != SVNNodeKind.DIR) {
                db.shadowed = true;
                db.treeConflictReason = SVNConflictReason.OBSTRUCTED;
                result.skip = true;
                result.skipChildren = true;
                db.markDirectoryEdited(localAbsPath);
                return;
            }
            if (rightSource == null) {
                db.treeConflictAction = SVNConflictAction.DELETE;
                db.markDirectoryEdited(localAbsPath);
                if (db.shadowed) {
                    result.skipChildren = true;
                    return;
                }
                db.deleteState = pdb != null ? pdb.deleteState : null;
                if (db.deleteState != null && db.deleteState.foundEdit) {
                    result.skip = true;
                    result.skipChildren = true;
                } else if (this.mergeDriver.forceDelete) {
                    result.skipChildren = true;
                } else if (db.deleteState == null) {
                    db.deleteState = new DirectoryDeleteBaton();
                    db.deleteState.delRoot = db;
                    db.deleteState.comparedAbsPaths = new HashSet();
                }
            }
        } else {
            SVNWCConflictDescription17 oldTc = null;
            db.added = true;
            db.treeConflictAction = SVNConflictAction.ADD;
            if (pdb != null && pdb.pendingDeletes != null && pdb.pendingDeletes.containsKey(localAbsPath)) {
                db.addIsReplace = true;
                db.treeConflictAction = SVNConflictAction.REPLACE;
                pdb.pendingDeletes.remove(localAbsPath);
            }
            if (pdb != null && pdb.newTreeConflicts != null && pdb.newTreeConflicts.containsKey(localAbsPath)) {
                oldTc = (SVNWCConflictDescription17)pdb.newTreeConflicts.get(localAbsPath);
                db.treeConflictAction = SVNConflictAction.REPLACE;
                db.treeConflictReason = oldTc.getReason();
                if (oldTc.getReason() != SVNConflictReason.DELETED && oldTc.getReason() != SVNConflictReason.MOVED_AWAY) {
                    result.skip = true;
                    result.skipChildren = true;
                    this.recordTreeConflict(localAbsPath, pdb, SVNNodeKind.DIR, db.treeConflictAction, db.treeConflictReason, oldTc, false);
                    return;
                }
            }
            if (!(this.mergeDriver.dryRun && (pdb != null && pdb.added || db.addIsReplace))) {
                SVNWCContext.ObstructionData obstructionData = this.performObstructionCheck(localAbsPath);
                SVNStatusType obstructionState = obstructionData.obstructionState;
                boolean isDeleted = obstructionData.deleted;
                SVNNodeKind kind = obstructionData.kind;
                if (obstructionState == SVNStatusType.OBSTRUCTED && (isDeleted || kind == SVNNodeKind.NONE) && SVNFileType.getType(localAbsPath) == SVNFileType.DIRECTORY) {
                    obstructionState = SVNStatusType.INAPPLICABLE;
                    db.addExisting = true;
                }
                if (obstructionState != SVNStatusType.INAPPLICABLE) {
                    db.shadowed = true;
                    db.treeConflictReason = SVNConflictReason.SKIP;
                    db.skipReason = obstructionState;
                } else if (kind != SVNNodeKind.NONE && !isDeleted) {
                    db.shadowed = true;
                    db.treeConflictReason = SVNConflictReason.OBSTRUCTED;
                }
            }
            db.markDirectoryEdited(localAbsPath);
            if (!db.shadowed) {
                if (this.mergeDriver.recordOnly) {
                    result.skip = true;
                    result.skipChildren = true;
                } else if (!this.mergeDriver.dryRun) {
                    if (!db.addExisting) {
                        SVNFileUtil.ensureDirectoryExists(localAbsPath);
                    }
                    if (oldTc != null) {
                        this.context.deleteTreeConflict(localAbsPath);
                    }
                    if (this.mergeDriver.sameRepos) {
                        SVNURL originalUrl = this.mergeDriver.mergeSource.url2.appendPath(SVNFileUtil.getFilePath(relPath), false);
                        SvnNgAdd svnNgAdd = new SvnNgAdd();
                        svnNgAdd.setWcContext(this.context);
                        svnNgAdd.add(localAbsPath, SVNDepth.INFINITY, originalUrl, rightSource.getRevision(), false);
                    } else {
                        SvnNgAdd svnNgAdd = new SvnNgAdd();
                        svnNgAdd.setWcContext(this.context);
                        svnNgAdd.addFromDisk(localAbsPath, null, false);
                    }
                    if (oldTc != null) {
                        this.recordTreeConflict(localAbsPath, pdb, SVNNodeKind.DIR, db.treeConflictAction, db.treeConflictReason, oldTc, false);
                    }
                }
            }
            if (!db.shadowed && !this.mergeDriver.recordOnly) {
                this.recordUpdateAdd(localAbsPath, SVNNodeKind.DIR, db.addIsReplace);
            }
        }
    }

    @Override
    public void dirChanged(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SVNProperties leftProps, SVNProperties rightProps, SVNProperties propChanges, Object dirBaton) throws SVNException {
        DirectoryBaton currentDirectory = (DirectoryBaton)dirBaton;
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        DirectoryBaton db = currentDirectory;
        this.handlePendingNotifications(db);
        db.markDirectoryEdited(localAbsPath);
        if (db.shadowed) {
            if (db.treeConflictReason == null) {
                this.recordSkip(localAbsPath, SVNNodeKind.DIR, SVNEventAction.UPDATE_SHADOWED_UPDATE, db.skipReason);
            }
            return;
        }
        SVNProperties props = this.prepareMergePropsChanged(localAbsPath, propChanges);
        if (props.size() > 0) {
            SVNConflictVersion[] conflictVersions = this.makeConflictVersions(localAbsPath, SVNNodeKind.DIR, this.mergeDriver.reposRootUrl, this.mergeDriver.mergeSource, this.mergeDriver.targetAbsPath);
            SVNConflictVersion left = conflictVersions[0];
            SVNConflictVersion right = conflictVersions[1];
            SVNWCContext.MergePropertiesInfo mergePropertiesInfo = this.context.mergeProperties(localAbsPath, left, right, leftProps, props, this.mergeDriver.dryRun, null);
            SVNStatusType propState = mergePropertiesInfo.mergeOutcome;
            if (propState == SVNStatusType.CONFLICTED) {
                if (this.mergeDriver.conflictedPaths == null) {
                    this.mergeDriver.conflictedPaths = new HashSet<File>();
                }
                this.mergeDriver.conflictedPaths.add(localAbsPath);
            }
            if (propState == SVNStatusType.CONFLICTED || propState == SVNStatusType.MERGED || propState == SVNStatusType.CHANGED) {
                this.recordUpdateUpdate(localAbsPath, SVNNodeKind.FILE, SVNStatusType.INAPPLICABLE, propState);
            }
        }
    }

    @Override
    public void dirDeleted(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SVNProperties leftProps, Object dirBaton) throws SVNException {
        DirectoryBaton currentDirectory = (DirectoryBaton)dirBaton;
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        DirectoryBaton db = currentDirectory;
        this.handlePendingNotifications(db);
        db.markDirectoryEdited(localAbsPath);
        if (db.shadowed) {
            if (db.treeConflictReason == null) {
                this.recordSkip(localAbsPath, SVNNodeKind.DIR, SVNEventAction.UPDATE_SHADOWED_DELETE, db.skipReason);
            }
            return;
        }
        if (this.mergeDriver.recordOnly) {
            return;
        }
        SVNProperties workingProps = this.context.getActualProps(localAbsPath);
        boolean same = this.mergeDriver.forceDelete ? true : this.arePropertiesSame(leftProps, workingProps);
        DirectoryDeleteBaton delBaton = db.deleteState;
        assert (delBaton != null);
        if (!same) {
            delBaton.foundEdit = true;
        } else {
            delBaton.comparedAbsPaths.add(localAbsPath);
        }
        if (delBaton.delRoot != db) {
            return;
        }
        if (delBaton.foundEdit) {
            same = false;
        } else if (this.mergeDriver.forceDelete) {
            same = true;
        } else {
            block21: {
                try {
                    SVNStatusEditor17 statusEditor17 = new SVNStatusEditor17(localAbsPath, this.context, this.context.getOptions(), false, true, SVNDepth.INFINITY, new VerifyTouchedByDelCheck(delBaton));
                    statusEditor17.walkStatus(localAbsPath, SVNDepth.INFINITY, true, false, true, null);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CEASE_INVOCATION) break block21;
                    throw e;
                }
            }
            boolean bl = same = !delBaton.foundEdit;
        }
        if (same && !this.mergeDriver.dryRun) {
            try {
                SvnNgRemove.delete(this.context, localAbsPath, null, false, false, null);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                    throw e;
                }
                same = false;
            }
        }
        if (!same) {
            this.recordTreeConflict(localAbsPath, db.parentBaton, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.EDITED, null, true);
        } else {
            if (workingProps != null && workingProps.containsName("svn:mergeinfo")) {
                if (this.mergeDriver.pathsWithDeletedMergeInfo != null) {
                    this.mergeDriver.pathsWithDeletedMergeInfo = new HashSet<File>();
                }
                this.mergeDriver.pathsWithDeletedMergeInfo.add(localAbsPath);
            }
            this.recordUpdateDelete(localAbsPath, SVNNodeKind.DIR, db.parentBaton);
        }
    }

    @Override
    public void dirAdded(SvnDiffCallbackResult result, File relPath, SvnDiffSource copyFromSource, SvnDiffSource rightSource, SVNProperties copyFromProps, SVNProperties rightProps, Object dirBaton) throws SVNException {
        DirectoryBaton currentDirectory = (DirectoryBaton)dirBaton;
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        DirectoryBaton db = currentDirectory;
        this.handlePendingNotifications(db);
        db.markDirectoryEdited(localAbsPath);
        if (db.shadowed) {
            if (db.treeConflictReason == null) {
                this.recordSkip(localAbsPath, SVNNodeKind.DIR, SVNEventAction.UPDATE_SHADOWED_ADD, db.skipReason);
            }
            return;
        }
        assert (db.edited && !this.mergeDriver.recordOnly);
        if (!(!this.mergeDriver.mergeSource.ancestral && !this.mergeDriver.reintegrateMerge || db.parentBaton != null && db.parentBaton.added)) {
            if (this.mergeDriver.addedPaths == null) {
                this.mergeDriver.addedPaths = new HashSet<File>();
            }
            this.mergeDriver.addedPaths.add(localAbsPath);
        }
        if (this.mergeDriver.sameRepos) {
            SVNProperties newPristineProps = rightProps;
            File parentAbsPath = SVNFileUtil.getParentFile(localAbsPath);
            File child = SVNFileUtil.skipAncestor(this.mergeDriver.targetAbsPath, localAbsPath);
            assert (child != null);
            SVNURL copyFromUrl = this.mergeDriver.mergeSource.url2.appendPath(SVNFileUtil.getFilePath(child), false);
            long copyFromRevision = rightSource.getRevision();
            this.checkReposMatch(this.mergeDriver.reposRootUrl, localAbsPath, copyFromUrl);
            if (!this.mergeDriver.dryRun) {
                this.completeDirectoryAdd(localAbsPath, newPristineProps, copyFromUrl, copyFromRevision);
            }
            if (newPristineProps.containsName("svn:mergeinfo")) {
                if (this.mergeDriver.pathsWithNewMergeInfo == null) {
                    this.mergeDriver.pathsWithNewMergeInfo = new HashSet<File>();
                }
                this.mergeDriver.pathsWithNewMergeInfo.add(localAbsPath);
            }
        } else {
            SVNProperties newProps = new SVNProperties();
            SvnNgPropertiesManager.categorizeProperties(rightProps, newProps, null, null);
            newProps.remove("svn:mergeinfo");
            SVNWCContext.MergePropertiesInfo mergePropertiesInfo = this.context.mergeProperties(localAbsPath, null, null, new SVNProperties(), newProps, this.mergeDriver.dryRun, null);
            if (mergePropertiesInfo.mergeOutcome == SVNStatusType.CONFLICTED) {
                if (this.mergeDriver.conflictedPaths == null) {
                    this.mergeDriver.conflictedPaths = new HashSet<File>();
                }
                this.mergeDriver.conflictedPaths.add(localAbsPath);
            }
        }
    }

    public void dirPropsChanged(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SVNProperties leftProps, SVNProperties rightProps, SVNProperties propChanges) throws SVNException {
    }

    @Override
    public void dirClosed(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, Object dirBaton) throws SVNException {
        DirectoryBaton currentDirectory = (DirectoryBaton)dirBaton;
        this.handlePendingNotifications(currentDirectory);
    }

    @Override
    public void nodeAbsent(SvnDiffCallbackResult result, File relPath, Object dirBaton) throws SVNException {
        File localAbsPath = SVNFileUtil.createFilePath(this.mergeDriver.targetAbsPath, relPath);
        this.recordSkip(localAbsPath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP, SVNStatusType.MISSING);
    }

    private void handlePendingNotifications(DirectoryBaton db) throws SVNException {
        if (this.context.getEventHandler() != null && db.pendingDeletes != null) {
            for (Map.Entry entry : db.pendingDeletes.entrySet()) {
                File delAbsPath = (File)entry.getKey();
                SVNNodeKind kind = (SVNNodeKind)entry.getValue();
                SVNEvent event = SVNEventFactory.createSVNEvent(delAbsPath, kind, null, -1L, SVNEventAction.UPDATE_DELETE, SVNEventAction.UPDATE_DELETE, null, null);
                this.context.getEventHandler().handleEvent(event, -1.0);
            }
            db.pendingDeletes = null;
        }
    }

    private MergeOutcome merge(File leftAbsPath, File rightAbsPath, File targetAbsPath, String leftLabel, String rightLabel, String targetLabel, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, boolean dryRun, String diff3Cmd, SVNDiffOptions mergeOptions, SVNProperties originalProps, SVNProperties propChanges, boolean mergeContentNeeded, boolean mergePropsNeeded, ISVNConflictHandler conflictResolver) throws SVNException {
        assert (SVNFileUtil.isAbsolute(leftAbsPath));
        assert (SVNFileUtil.isAbsolute(rightAbsPath));
        assert (SVNFileUtil.isAbsolute(targetAbsPath));
        SVNSkel conflictSkel = null;
        SVNSkel workItems = null;
        MergeOutcome result = new MergeOutcome();
        File dirAbsPath = SVNFileUtil.getParentFile(targetAbsPath);
        if (!dryRun) {
            this.context.writeCheck(dirAbsPath);
        }
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.context.getDb().readInfo(targetAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
        boolean conflicted = nodeInfoStructure.is(StructureFields.NodeInfo.conflicted);
        boolean hadProps = nodeInfoStructure.is(StructureFields.NodeInfo.hadProps);
        boolean propMods = nodeInfoStructure.is(StructureFields.NodeInfo.propsMod);
        if (kind != ISVNWCDb.SVNWCDbKind.File || status == ISVNWCDb.SVNWCDbStatus.Normal && status == ISVNWCDb.SVNWCDbStatus.Added) {
            result.mergeContentOutcome = SVNStatusType.NO_MERGE;
            if (mergePropsNeeded) {
                result.mergePropsOutcome = SVNStatusType.UNCHANGED;
            }
            return result;
        }
        if (conflicted) {
            SVNWCContext.ConflictInfo conflictInfo = this.context.getConflicted(targetAbsPath, true, true, true);
            boolean textConflicted = conflictInfo.textConflicted;
            boolean propConflicted = conflictInfo.propConflicted;
            boolean treeConflicted = conflictInfo.treeConflicted;
            if (textConflicted || propConflicted || treeConflicted) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Can''t merge into conflicted node ''{0}''", (Object)targetAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        }
        SVNProperties pristineProps = null;
        if (mergePropsNeeded && hadProps) {
            pristineProps = this.context.getDb().readPristineProperties(targetAbsPath);
        } else if (mergePropsNeeded) {
            pristineProps = new SVNProperties();
        }
        SVNProperties oldActualProps = propMods ? this.context.getDb().readProperties(targetAbsPath) : (pristineProps != null ? pristineProps : new SVNProperties());
        SVNProperties newActualProps = null;
        if (mergePropsNeeded) {
            Set<String> propChangesNames = propChanges.nameSet();
            for (String propName : propChangesNames) {
                if (SVNProperty.isRegularProperty(propName)) continue;
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "The property ''{0}'' may not be merged into ''{1}''.", propName, targetAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            SVNWCContext.MergePropertiesInfo mergePropertiesInfo = new SVNWCContext.MergePropertiesInfo();
            mergePropertiesInfo.conflictSkel = conflictSkel;
            this.context.mergeProperties3(mergePropertiesInfo, targetAbsPath, originalProps, pristineProps, oldActualProps, propChanges);
            conflictSkel = mergePropertiesInfo.conflictSkel;
            newActualProps = mergePropertiesInfo.newActualProperties;
            result.mergePropsOutcome = mergePropertiesInfo.mergeOutcome;
        }
        SVNWCContext.MergeInfo mergeInfo = this.context.merge(workItems, conflictSkel, leftAbsPath, rightAbsPath, targetAbsPath, targetAbsPath, leftLabel, rightLabel, targetLabel, oldActualProps, dryRun, mergeOptions, propChanges);
        conflictSkel = mergeInfo.conflictSkel;
        workItems = mergeInfo.workItems;
        result.mergeContentOutcome = mergeInfo.mergeOutcome;
        if (!dryRun) {
            if (conflictSkel != null) {
                SvnWcDbConflicts.conflictSkelOpMerge(conflictSkel, leftVersion, rightVersion);
                SVNSkel workItem = SvnWcDbConflicts.createConflictMarkers(this.context.getDb(), targetAbsPath, conflictSkel);
                workItems = SVNWCContext.wqMerge(workItems, workItem);
            }
            if (newActualProps != null) {
                this.context.getDb().opSetProps(targetAbsPath, newActualProps, conflictSkel, SVNWCContext.hasMagicProperty(propChanges), workItems);
            } else if (conflictSkel != null) {
                this.context.getDb().opMarkConflict(targetAbsPath, conflictSkel, workItems);
            } else if (workItems != null) {
                this.context.getDb().addWorkQueue(targetAbsPath, workItems);
            }
            if (workItems != null) {
                this.context.wqRun(targetAbsPath);
            }
            if (conflictSkel != null && conflictResolver != null) {
                this.context.invokeConflictResolver(targetAbsPath, conflictSkel, conflictResolver, this.context.getEventHandler());
            }
            SVNWCContext.ConflictInfo conflictInfo = this.context.getConflicted(targetAbsPath, true, true, false);
            if (result.mergePropsOutcome == SVNStatusType.CONFLICTED && !conflictInfo.propConflicted) {
                result.mergePropsOutcome = SVNStatusType.MERGED;
            }
            if (result.mergeContentOutcome == SVNStatusType.CONFLICTED && !conflictInfo.textConflicted) {
                result.mergeContentOutcome = SVNStatusType.MERGED;
            }
        }
        return result;
    }

    private void recordUpdateUpdate(File localAbsPath, SVNNodeKind kind, SVNStatusType contentState, SVNStatusType propState) throws SVNException {
        ISVNEventHandler eventHandler;
        if (this.mergeDriver.mergeSource.ancestral || this.mergeDriver.reintegrateMerge) {
            if (this.mergeDriver.mergedPaths == null) {
                this.mergeDriver.mergedPaths = new HashSet<File>();
            }
            this.mergeDriver.mergedPaths.add(localAbsPath);
        }
        if ((eventHandler = this.context.getEventHandler()) != null) {
            this.notifyMergeBegin(localAbsPath, false);
            SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, kind, null, -1L, contentState, propState, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.UPDATE_UPDATE, SVNEventAction.UPDATE_UPDATE, null, null);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    private void recordUpdateAdd(File localAbsPath, SVNNodeKind kind, boolean notifyReplaced) throws SVNException {
        ISVNEventHandler eventHandler;
        if (this.mergeDriver.mergeSource.ancestral || this.mergeDriver.reintegrateMerge) {
            if (this.mergeDriver.mergedPaths == null) {
                this.mergeDriver.mergedPaths = new HashSet<File>();
            }
            this.mergeDriver.mergedPaths.add(localAbsPath);
        }
        if ((eventHandler = this.context.getEventHandler()) != null) {
            this.notifyMergeBegin(localAbsPath, false);
            SVNEventAction action = SVNEventAction.UPDATE_ADD;
            if (notifyReplaced) {
                action = SVNEventAction.UPDATE_REPLACE;
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, kind, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, action, action, null, null);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    private void recordUpdateDelete(File localAbsPath, SVNNodeKind kind, DirectoryBaton parentBaton) throws SVNException {
        if (this.mergeDriver.mergeSource.ancestral || this.mergeDriver.reintegrateMerge) {
            if (this.mergeDriver.addedPaths != null) {
                this.mergeDriver.addedPaths.remove(localAbsPath);
            }
            if (this.mergeDriver.mergedPaths == null) {
                this.mergeDriver.mergedPaths = new HashSet<File>();
            }
            this.mergeDriver.mergedPaths.add(localAbsPath);
        }
        this.notifyMergeBegin(localAbsPath, true);
        if (parentBaton != null) {
            if (parentBaton.pendingDeletes == null) {
                parentBaton.pendingDeletes = new HashMap();
            }
            parentBaton.pendingDeletes.put(localAbsPath, kind);
        }
    }

    private void notifyMergeBegin(File localAbsPath, boolean deleteAction) throws SVNException {
        SVNMergeRange mergeRange;
        File notifyAbsPath;
        SVNMergeRange nRange = new SVNMergeRange(-1L, -1L, true);
        if (this.context.getEventHandler() == null) {
            return;
        }
        if (this.mergeDriver.mergeSource.ancestral) {
            long[] nRangeRevisions = new long[2];
            SvnNgMergeDriver.MergePath child = SvnNgMergeDriver.findNearestAncestorWithIntersectingRanges(nRangeRevisions, this.mergeDriver.notifyBegin.nodesWithMergeInfo, !deleteAction, localAbsPath);
            nRange.setStartRevision(nRangeRevisions[0]);
            nRange.setEndRevision(nRangeRevisions[1]);
            if (child == null && deleteAction) {
                child = SvnNgMergeDriver.findNearestAncestor(this.mergeDriver.notifyBegin.nodesWithMergeInfo, true, localAbsPath);
            }
            assert (child != null);
            if (child == null) {
                return;
            }
            if (this.mergeDriver.notifyBegin.lastAbsPath != null && child.absPath.equals(this.mergeDriver.notifyBegin.lastAbsPath)) {
                return;
            }
            this.mergeDriver.notifyBegin.lastAbsPath = child.absPath;
            if (child.absent || child.remainingRanges.getSize() == 0 || !SVNRevision.isValidRevisionNumber(nRange.getStartRevision())) {
                return;
            }
            notifyAbsPath = child.absPath;
        } else {
            if (this.mergeDriver.notifyBegin.lastAbsPath != null) {
                return;
            }
            notifyAbsPath = this.mergeDriver.targetAbsPath;
            this.mergeDriver.notifyBegin.lastAbsPath = this.mergeDriver.targetAbsPath;
        }
        if (SVNRevision.isValidRevisionNumber(nRange.getStartRevision())) {
            this.removeSourceGap(nRange, this.mergeDriver.implicitSrcGap);
            mergeRange = nRange;
        } else {
            mergeRange = null;
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(notifyAbsPath, SVNNodeKind.UNKNOWN, null, -1L, this.mergeDriver.sameRepos ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, this.mergeDriver.sameRepos ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, mergeRange);
        this.context.getEventHandler().handleEvent(event, -1.0);
    }

    private void checkReposMatch(SVNURL reposRootUrl, File localAbsPath, SVNURL url) throws SVNException {
        if (!SVNPathUtil.isAncestor(reposRootUrl.toString(), url.toString())) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "URL ''{0}'' of ''{1}'' is not in repository ''{2}''", url, localAbsPath, reposRootUrl);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }

    private void removeSourceGap(SVNMergeRange range, SVNMergeRangeList implicitSrcGap) {
        if (implicitSrcGap != null) {
            SVNMergeRange gapRange = implicitSrcGap.getRanges()[0];
            if (range.getStartRevision() < range.getEndRevision()) {
                if (gapRange.getStartRevision() == range.getStartRevision()) {
                    range.setStartRevision(gapRange.getEndRevision());
                }
            } else if (gapRange.getStartRevision() == range.getEndRevision()) {
                range.setEndRevision(gapRange.getEndRevision());
            }
        }
    }

    private SVNProperties prepareMergePropsChanged(File localAbsPath, SVNProperties propChanges) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbsPath));
        SVNProperties props = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(propChanges, props, null, null);
        if (this.mergeDriver.recordOnly && props.size() != 0) {
            SVNProperties mergeInfoProps = new SVNProperties();
            for (String propName : props.nameSet()) {
                SVNPropertyValue propertyValue = props.getSVNPropertyValue(propName);
                if (!propName.equals("svn:mergeinfo")) continue;
                mergeInfoProps.put(propName, propertyValue);
            }
            props = mergeInfoProps;
        }
        if (props.size() > 0) {
            if (!this.mergeDriver.sameRepos) {
                props = SvnNgMergeCallback.omitMergeInfoChanges(props);
            }
            if (!(this.mergeDriver.mergeSource.rev1 >= this.mergeDriver.mergeSource.rev2 && this.mergeDriver.mergeSource.ancestral || !this.mergeDriver.isHonorMergeInfo() && !this.mergeDriver.reintegrateMerge)) {
                props = this.filterSelfReferentialMergeInfo(props, localAbsPath, this.mergeDriver.repos2);
            }
        }
        SVNProperties propUpdates = props;
        if (props.size() > 0) {
            for (String propName : props.nameSet()) {
                if (!propName.equals("svn:mergeinfo")) continue;
                boolean hasPristineMergeInfo = false;
                SVNProperties pristineProps = this.context.getPristineProps(localAbsPath);
                if (pristineProps != null && pristineProps.containsName("svn:mergeinfo")) {
                    hasPristineMergeInfo = true;
                }
                SVNPropertyValue propertyValue = props.getSVNPropertyValue(propName);
                if (!hasPristineMergeInfo && propertyValue != null) {
                    if (this.mergeDriver.pathsWithNewMergeInfo == null) {
                        this.mergeDriver.pathsWithNewMergeInfo = new HashSet<File>();
                    }
                    this.mergeDriver.pathsWithNewMergeInfo.add(localAbsPath);
                    continue;
                }
                if (!hasPristineMergeInfo || propertyValue != null) continue;
                if (this.mergeDriver.pathsWithDeletedMergeInfo == null) {
                    this.mergeDriver.pathsWithDeletedMergeInfo = new HashSet<File>();
                }
                this.mergeDriver.pathsWithDeletedMergeInfo.add(localAbsPath);
            }
        }
        return propUpdates;
    }

    private SVNConflictVersion[] makeConflictVersions(File victimAbsPath, SVNNodeKind nodeKind, SVNURL rootUrl, SvnNgMergeDriver.MergeSource mergeSource, File targetAbsPath) {
        File child = SVNFileUtil.skipAncestor(targetAbsPath, victimAbsPath);
        assert (child != null);
        String leftPath = SVNPathUtil.getRelativePath(rootUrl.toDecodedString(), mergeSource.url1.toDecodedString());
        String rightPath = SVNPathUtil.getRelativePath(rootUrl.toDecodedString(), mergeSource.url2.toDecodedString());
        SVNConflictVersion[] svnConflictVersions = new SVNConflictVersion[]{new SVNConflictVersion(rootUrl, SVNPathUtil.append(leftPath, SVNFileUtil.getFilePath(child)), mergeSource.rev1, nodeKind), new SVNConflictVersion(rootUrl, SVNPathUtil.append(rightPath, SVNFileUtil.getFilePath(child)), mergeSource.rev2, nodeKind)};
        return svnConflictVersions;
    }

    private void recordSkip(File localAbsPath, SVNNodeKind kind, SVNEventAction action, SVNStatusType state) throws SVNException {
        ISVNEventHandler eventHandler;
        if (this.mergeDriver.recordOnly) {
            return;
        }
        if (this.mergeDriver.mergeSource.ancestral || this.mergeDriver.reintegrateMerge) {
            if (this.mergeDriver.skippedPaths == null) {
                this.mergeDriver.skippedPaths = new HashSet<File>();
            }
            this.mergeDriver.skippedPaths.add(localAbsPath);
        }
        if ((eventHandler = this.context.getEventHandler()) != null) {
            this.notifyMergeBegin(localAbsPath, false);
            SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, kind, null, -1L, state, state, SVNStatusType.LOCK_UNKNOWN, action, action, null, null);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    private SVNWCContext.ObstructionData performObstructionCheck(File localAbsPath) throws SVNException {
        return this.context.checkForObstructions(localAbsPath, localAbsPath.equals(this.mergeDriver.targetAbsPath));
    }

    private void recordTreeConflict(File localAbsPath, DirectoryBaton parentBaton, SVNNodeKind nodeKind, SVNConflictAction action, SVNConflictReason reason, SVNWCConflictDescription17 existingConflict, boolean notifyTreeConflict) throws SVNException {
        ISVNEventHandler eventHandler;
        if (this.mergeDriver.mergeSource.ancestral || this.mergeDriver.reintegrateMerge) {
            if (this.mergeDriver.treeConflictedPaths == null) {
                this.mergeDriver.treeConflictedPaths = new HashSet<File>();
            }
            this.mergeDriver.treeConflictedPaths.add(localAbsPath);
        }
        if (this.mergeDriver.conflictedPaths == null) {
            this.mergeDriver.conflictedPaths = new HashSet<File>();
        }
        this.mergeDriver.conflictedPaths.add(localAbsPath);
        if (!this.mergeDriver.recordOnly && !this.mergeDriver.dryRun) {
            if (reason == SVNConflictReason.DELETED) {
                SVNWCContext.NodeMovedAway nodeMovedAway = this.context.nodeWasMovedAway(localAbsPath);
                File movedToAbsPath = nodeMovedAway.movedToAbsPath;
                if (movedToAbsPath != null) {
                    reason = SVNConflictReason.MOVED_AWAY;
                }
            } else if (reason == SVNConflictReason.ADDED) {
                SVNWCContext.NodeMovedHere nodeMovedHere = this.context.nodeWasMovedHere(localAbsPath);
                File movedFromAbsPath = nodeMovedHere.movedFromAbsPath;
                if (movedFromAbsPath != null) {
                    reason = SVNConflictReason.MOVED_HERE;
                }
            }
            SVNConflictVersion[] conflictVersions = this.makeConflictVersions(localAbsPath, nodeKind, this.mergeDriver.reposRootUrl, this.mergeDriver.mergeSource, this.mergeDriver.targetAbsPath);
            SVNConflictVersion left = conflictVersions[0];
            SVNConflictVersion right = conflictVersions[1];
            if (existingConflict != null && existingConflict.getSrcLeftVersion() != null) {
                left = existingConflict.getSrcLeftVersion();
            }
            SVNWCConflictDescription17 conflict = new SVNWCConflictDescription17();
            conflict.setLocalAbspath(localAbsPath);
            conflict.setNodeKind(nodeKind);
            conflict.setOperation(SVNOperation.MERGE);
            conflict.setSrcLeftVersion(left);
            conflict.setSrcRightVersion(right);
            conflict.setAction(action);
            conflict.setReason(reason);
            if (existingConflict != null) {
                this.context.deleteTreeConflict(localAbsPath);
            }
            this.context.addTreeConflict(conflict);
            if (parentBaton != null) {
                if (parentBaton.newTreeConflicts == null) {
                    parentBaton.newTreeConflicts = new HashMap();
                }
                parentBaton.newTreeConflicts.put(localAbsPath, conflict);
            }
        }
        if ((eventHandler = this.context.getEventHandler()) != null && notifyTreeConflict) {
            this.notifyMergeBegin(localAbsPath, false);
            SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, nodeKind, null, -1L, SVNEventAction.TREE_CONFLICT, SVNEventAction.TREE_CONFLICT, null, null);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNProperties filterSelfReferentialMergeInfo(SVNProperties props, File targetAbsPath, SVNRepository svnRepository) throws SVNException {
        Structure<StructureFields.NodeOriginInfo> nodeOrigin = this.context.getNodeOrigin(targetAbsPath, false, StructureFields.NodeOriginInfo.isCopy, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.reposUuid);
        boolean isCopy = nodeOrigin.is(StructureFields.NodeOriginInfo.isCopy);
        long revision = nodeOrigin.lng(StructureFields.NodeOriginInfo.revision);
        File reposRelPath = (File)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRelpath);
        SVNURL reposRootUrl = (SVNURL)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRootUrl);
        String reposUuid = (String)nodeOrigin.get(StructureFields.NodeOriginInfo.reposUuid);
        if (isCopy || reposRelPath == null) {
            return null;
        }
        SVNURL url = reposRootUrl.appendPath(SVNFileUtil.getFilePath(reposRelPath), false);
        SVNProperties adjustedProps = new SVNProperties();
        Set<String> propNames = props.nameSet();
        for (String propName : propNames) {
            Map mergeInfo;
            SVNPropertyValue propertyValue = props.getSVNPropertyValue(propName);
            if (!propName.equals("svn:mergeinfo") || propertyValue == null || SVNPropertyValue.getPropertyAsBytes(propertyValue).length == 0) {
                adjustedProps.put(propName, propertyValue);
                continue;
            }
            try {
                mergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(SVNPropertyValue.getPropertyAsString(propertyValue)), null);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    adjustedProps.put(propName, propertyValue);
                    continue;
                }
                throw e;
            }
            SplitMergeInfo splitMergeInfo = this.splitMergeInfoOnRevision(mergeInfo, revision);
            mergeInfo = splitMergeInfo.mergeInfo;
            Map youngerMergeInfo = splitMergeInfo.youngerMergeInfo;
            Map<String, SVNMergeRangeList> filteredYoungerMergeInfo = null;
            if (youngerMergeInfo != null) {
                SVNURL mergeSourceRootUrl = svnRepository.getRepositoryRoot(true);
                for (Map.Entry entry : youngerMergeInfo.entrySet()) {
                    SVNMergeRange[] ranges;
                    String sourcePath = (String)entry.getKey();
                    SVNMergeRangeList rangeList = (SVNMergeRangeList)entry.getValue();
                    SVNMergeRangeList adjustedRangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
                    SVNURL mergeSourceUrl = mergeSourceRootUrl.appendPath(sourcePath.substring(1), false);
                    for (SVNMergeRange range : ranges = rangeList.getRanges()) {
                        try {
                            SVNURL startUrl = this.reposLocations(url, revision, reposRootUrl, reposUuid, range.getStartRevision() + 1L, svnRepository);
                            if (startUrl.equals(mergeSourceUrl)) continue;
                            adjustedRangeList.pushRange(range.getStartRevision(), range.getEndRevision(), range.isInheritable());
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.CLIENT_UNRELATED_RESOURCES && e.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND && e.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NO_SUCH_REVISION) continue;
                            adjustedRangeList.pushRange(range.getStartRevision(), range.getEndRevision(), range.isInheritable());
                        }
                    }
                    if (adjustedRangeList.getSize() == 0) continue;
                    if (filteredYoungerMergeInfo == null) {
                        filteredYoungerMergeInfo = new HashMap<String, SVNMergeRangeList>();
                    }
                    filteredYoungerMergeInfo.put(sourcePath, adjustedRangeList);
                }
            }
            Map<String, SVNMergeRangeList> filteredMergeInfo = null;
            if (mergeInfo != null) {
                SVNURL oldUrl = svnRepository.getLocation();
                try {
                    svnRepository.setLocation(url, false);
                    Map<String, SVNMergeRangeList> implicitMergeInfo = this.repositoryAccess.getHistoryAsMergeInfo(svnRepository, SvnTarget.fromURL(url), revision, -1L);
                    filteredMergeInfo = SVNMergeInfoUtil.removeMergeInfo(implicitMergeInfo, mergeInfo, true);
                }
                finally {
                    if (oldUrl != null) {
                        svnRepository.setLocation(oldUrl, false);
                    }
                }
            }
            if (filteredMergeInfo != null && filteredYoungerMergeInfo != null) {
                filteredMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(filteredMergeInfo, filteredYoungerMergeInfo);
            } else if (filteredYoungerMergeInfo != null) {
                filteredMergeInfo = filteredYoungerMergeInfo;
            }
            if (filteredMergeInfo == null || filteredMergeInfo.size() <= 0) continue;
            String filteredMergeInfoString = SVNMergeInfoUtil.formatMergeInfoToString(filteredMergeInfo, null);
            adjustedProps.put("svn:mergeinfo", filteredMergeInfoString);
        }
        return adjustedProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNURL reposLocations(SVNURL url, long pegRevision, SVNURL reposRootUrl, String reposUuid, long opRevision, SVNRepository svnRepository) throws SVNException {
        SVNURL oldUrl = SvnNgMergeDriver.ensureSessionURL(svnRepository, url);
        try {
            SVNURL startUrl;
            Structure<SvnRepositoryAccess.LocationsInfo> locations = this.repositoryAccess.getLocations(svnRepository, SvnTarget.fromURL(url), SVNRevision.create(pegRevision), SVNRevision.create(opRevision), SVNRevision.HEAD);
            SVNURL sVNURL = startUrl = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
            return sVNURL;
        }
        finally {
            svnRepository.setLocation(oldUrl, false);
        }
    }

    private SplitMergeInfo splitMergeInfoOnRevision(Map<String, SVNMergeRangeList> mergeInfo, long revision) {
        SplitMergeInfo splitMergeInfo = new SplitMergeInfo();
        splitMergeInfo.youngerMergeInfo = null;
        splitMergeInfo.mergeInfo = mergeInfo;
        block0: for (Map.Entry<String, SVNMergeRangeList> entry : mergeInfo.entrySet()) {
            String mergeSourcePath = entry.getKey();
            SVNMergeRangeList rangeList = entry.getValue();
            SVNMergeRange[] ranges = rangeList.getRanges();
            for (int i = 0; i < ranges.length; ++i) {
                SVNMergeRange range = ranges[i];
                if (range.getEndRevision() < revision) continue;
                SVNMergeRangeList youngerRangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
                for (int j = i; j < ranges.length; ++j) {
                    SVNMergeRange youngerRange = ranges[j].dup();
                    if (i == j && range.getStartRevision() + 1L <= revision) {
                        youngerRange.setStartRevision(revision);
                        range.setEndRevision(revision);
                    }
                    youngerRangeList.pushRange(youngerRange.getStartRevision(), youngerRange.getEndRevision(), youngerRange.isInheritable());
                }
                if (splitMergeInfo.youngerMergeInfo == null) {
                    splitMergeInfo.youngerMergeInfo = new HashMap();
                }
                splitMergeInfo.youngerMergeInfo.put(mergeSourcePath, youngerRangeList);
                splitMergeInfo.mergeInfo = SVNMergeInfoUtil.removeMergeInfo(splitMergeInfo.youngerMergeInfo, splitMergeInfo.mergeInfo);
                continue block0;
            }
        }
        return splitMergeInfo;
    }

    private boolean areFilesSame(File olderAbsPath, SVNProperties originalProps, File mineAbsPath) throws SVNException {
        SVNProperties workingProps = this.context.getActualProps(mineAbsPath);
        boolean same = this.arePropertiesSame(originalProps, workingProps);
        if (same) {
            return !this.context.compareAndVerify(mineAbsPath, olderAbsPath, workingProps != null && workingProps.size() > 0, false, false);
        }
        return same;
    }

    private boolean arePropertiesSame(SVNProperties originalProps, SVNProperties workingProps) {
        SVNProperties propDiff = originalProps == null ? workingProps : originalProps.compareTo(workingProps);
        Set<String> propNames = propDiff.nameSet();
        for (String propName : propNames) {
            if (!SVNProperty.isRegularProperty(propName) || "svn:mergeinfo".equals(propName)) continue;
            return false;
        }
        return true;
    }

    private void completeDirectoryAdd(File localAbsPath, SVNProperties newOriginalProps, SVNURL copyFromUrl, long copyFromRevision) throws SVNException {
        SVNErrorMessage errorMessage;
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.context.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.originalReposRelpath, StructureFields.NodeInfo.originalRootUrl, StructureFields.NodeInfo.originalUuid, StructureFields.NodeInfo.originalRevision, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
        File originalReposRelPath = (File)nodeInfoStructure.get(StructureFields.NodeInfo.originalReposRelpath);
        SVNURL originalRootUrl = (SVNURL)nodeInfoStructure.get(StructureFields.NodeInfo.originalRootUrl);
        String originalUuid = (String)nodeInfoStructure.get(StructureFields.NodeInfo.originalUuid);
        long originalRevision = nodeInfoStructure.lng(StructureFields.NodeInfo.originalRevision);
        boolean hadProps = nodeInfoStructure.is(StructureFields.NodeInfo.hadProps);
        boolean propsMod = nodeInfoStructure.is(StructureFields.NodeInfo.propsMod);
        if (status != ISVNWCDb.SVNWCDbStatus.Added || kind != ISVNWCDb.SVNWCDbKind.Dir || hadProps || propsMod || originalReposRelPath == null) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' is not an unmodified copied directory", (Object)localAbsPath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (originalRevision != copyFromRevision || !copyFromUrl.equals(originalRootUrl.appendPath(SVNFileUtil.getFilePath(originalReposRelPath), false))) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Copyfrom ''{0}'' doesn''t match original location of ''{1}''", copyFromUrl, localAbsPath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        SVNProperties regularProps = new SVNProperties();
        SVNProperties entryProps = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(newOriginalProps, regularProps, entryProps, null);
        newOriginalProps = regularProps;
        SVNUpdateEditor17.AccumulatedChangeInfo accumulatedChangeInfo = SVNUpdateEditor17.accumulateLastChange(null, entryProps);
        String changedAuthor = accumulatedChangeInfo.changedAuthor;
        SVNDate changedDate = accumulatedChangeInfo.changedDate;
        long changedRev = accumulatedChangeInfo.changedRev;
        this.context.getDb().opCopyDir(localAbsPath, newOriginalProps, changedRev, changedDate, changedAuthor, originalReposRelPath, originalRootUrl, originalUuid, originalRevision, null, false, SVNDepth.INFINITY, null, null);
    }

    private class DirectoryBaton {
        private DirectoryBaton parentBaton;
        private boolean shadowed;
        private boolean edited;
        private SVNConflictReason treeConflictReason;
        private SVNConflictAction treeConflictAction;
        private SVNStatusType skipReason;
        private boolean added;
        private boolean addIsReplace;
        private boolean addExisting;
        private Map<File, SVNNodeKind> pendingDeletes;
        private Map<File, SVNWCConflictDescription17> newTreeConflicts;
        private DirectoryDeleteBaton deleteState;

        private DirectoryBaton() {
        }

        public void markDirectoryEdited(File localAbsPath) throws SVNException {
            if (this.edited) {
                return;
            }
            if (this.parentBaton != null && !this.parentBaton.edited) {
                File dirAbsPath = SVNFileUtil.getFileDir(localAbsPath);
                this.parentBaton.markDirectoryEdited(dirAbsPath);
            }
            this.edited = true;
            if (!this.shadowed) {
                return;
            }
            if (this.parentBaton != null && this.parentBaton.deleteState != null && this.treeConflictReason != null) {
                this.parentBaton.deleteState.foundEdit = true;
            } else if (this.treeConflictReason == SVNConflictReason.SKIP || this.treeConflictReason == SVNConflictReason.WC_SKIP) {
                ISVNEventHandler eventHandler = SvnNgMergeCallback2.this.context.getEventHandler();
                if (eventHandler != null) {
                    SvnNgMergeCallback2.this.notifyMergeBegin(localAbsPath, false);
                    SVNEventAction eventAction = this.treeConflictReason == SVNConflictReason.SKIP ? SVNEventAction.SKIP : SVNEventAction.UPDATE_SKIP_OBSTRUCTION;
                    SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.DIR, null, -1L, this.skipReason, this.skipReason, SVNStatusType.LOCK_UNKNOWN, eventAction, eventAction, null, null);
                    eventHandler.handleEvent(event, -1.0);
                }
                if (((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.mergeSource.ancestral || ((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.reintegrateMerge) {
                    if (((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.skippedPaths == null) {
                        ((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.skippedPaths = new HashSet<File>();
                    }
                    ((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.skippedPaths.add(localAbsPath);
                }
            } else if (this.treeConflictReason != null) {
                SvnNgMergeCallback2.this.recordTreeConflict(localAbsPath, this.parentBaton, SVNNodeKind.FILE, this.treeConflictAction, this.treeConflictReason, null, true);
            }
        }
    }

    private static class DirectoryDeleteBaton {
        private DirectoryBaton delRoot;
        private boolean foundEdit;
        private Set<File> comparedAbsPaths;

        private DirectoryDeleteBaton() {
        }
    }

    private class FileBaton {
        private DirectoryBaton parentBaton;
        private boolean shadowed;
        private boolean edited;
        private SVNConflictReason treeConflictReason;
        private SVNConflictAction treeConflictAction;
        private SVNStatusType skipReason;
        private boolean added;
        private boolean addIsReplace;

        private FileBaton() {
        }

        public void markFileEdited(File localAbsPath) throws SVNException {
            if (this.edited) {
                return;
            }
            if (this.parentBaton != null && !this.parentBaton.edited) {
                File dirAbsPath = SVNFileUtil.getFileDir(localAbsPath);
                this.parentBaton.markDirectoryEdited(dirAbsPath);
            }
            this.edited = true;
            if (!this.shadowed) {
                return;
            }
            if (this.parentBaton != null && this.parentBaton.deleteState != null && this.treeConflictReason != null) {
                this.parentBaton.deleteState.foundEdit = true;
            } else if (this.treeConflictReason == SVNConflictReason.SKIP || this.treeConflictReason == SVNConflictReason.WC_SKIP) {
                ISVNEventHandler eventHandler = SvnNgMergeCallback2.this.context.getEventHandler();
                if (eventHandler != null) {
                    SvnNgMergeCallback2.this.notifyMergeBegin(localAbsPath, false);
                    SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.FILE, null, -1L, this.skipReason, this.skipReason, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.SKIP, SVNEventAction.SKIP, null, null);
                    eventHandler.handleEvent(event, -1.0);
                }
                if (((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.mergeSource.ancestral || ((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.reintegrateMerge) {
                    if (((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.skippedPaths == null) {
                        ((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.skippedPaths = new HashSet<File>();
                    }
                    ((SvnNgMergeCallback2)SvnNgMergeCallback2.this).mergeDriver.skippedPaths.add(localAbsPath);
                }
            } else if (this.treeConflictReason != null) {
                SvnNgMergeCallback2.this.recordTreeConflict(localAbsPath, this.parentBaton, SVNNodeKind.FILE, this.treeConflictAction, this.treeConflictReason, null, true);
            }
        }
    }

    private static class MergeOutcome {
        private SVNStatusType mergeContentOutcome;
        private SVNStatusType mergePropsOutcome;

        private MergeOutcome() {
        }
    }

    private static class SplitMergeInfo {
        private Map<String, SVNMergeRangeList> youngerMergeInfo;
        private Map<String, SVNMergeRangeList> mergeInfo;

        private SplitMergeInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerifyTouchedByDelCheck
    implements ISvnObjectReceiver<SvnStatus> {
        private final DirectoryDeleteBaton deleteBaton;

        private VerifyTouchedByDelCheck(DirectoryDeleteBaton deleteBaton) {
            this.deleteBaton = deleteBaton;
        }

        @Override
        public void receive(SvnTarget target, SvnStatus status) throws SVNException {
            File localAbsPath = target.getFile();
            if (this.deleteBaton.comparedAbsPaths.contains(localAbsPath)) {
                return;
            }
            if (status.getNodeStatus().equals(SVNStatusType.STATUS_DELETED) || status.getNodeStatus().equals(SVNStatusType.STATUS_IGNORED) || status.getNodeStatus().equals(SVNStatusType.STATUS_NONE)) {
                return;
            }
            this.deleteBaton.foundEdit = true;
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CEASE_INVOCATION);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }
}

