/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc17.ISVNDirFetcher;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNUpdateEditor17
implements ISVNUpdateEditor {
    private SVNWCContext myWCContext;
    private String myTargetBasename;
    private File myAnchorAbspath;
    private File myTargetAbspath;
    private String[] myExtensionPatterns;
    private long myTargetRevision;
    private SVNDepth myRequestedDepth;
    private boolean myIsDepthSticky;
    private boolean myIsUseCommitTimes;
    private boolean rootOpened;
    private boolean myIsTargetDeleted;
    private boolean myIsUnversionedObstructionsAllowed;
    private File mySwitchRelpath;
    private SVNURL myReposRootURL;
    private String myReposUuid;
    private Set<File> mySkippedTrees = new HashSet<File>();
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNExternalsStore myExternalsStore;
    private DirectoryBaton myCurrentDirectory;
    private FileBaton myCurrentFile;
    private boolean myAddsAsModification = true;
    private Map<File, Map<String, SVNDirEntry>> myDirEntries;
    private boolean myIsCleanCheckout;
    private File myWCRootAbsPath;
    private Map<File, Map<String, SVNProperties>> myInheritableProperties;
    private ISVNConflictHandler myConflictHandler;

    public static ISVNUpdateEditor createUpdateEditor(SVNWCContext context, long targetRevision, File anchorAbspath, String targetName, Map<File, Map<String, SVNProperties>> inheritableProperties, boolean useCommitTimes, SVNURL switchURL, SVNDepth depth, boolean depthIsSticky, boolean allowUnversionedObstructions, boolean addsAsModifications, boolean serverPerformsFiltering, boolean cleanCheckout, ISVNDirFetcher dirFetcher, SVNExternalsStore externalsStore, String[] preservedExtensions, ISVNConflictHandler conflictHandler) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        ISVNWCDb.WCDbRepositoryInfo repositoryInfo = context.getDb().scanBaseRepository(anchorAbspath, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
        assert (repositoryInfo != null && repositoryInfo.rootUrl != null && repositoryInfo.uuid != null);
        if (switchURL != null && !SVNURLUtil.isAncestor(repositoryInfo.rootUrl, switchURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}'' is not the same repository as ''{1}''", switchURL, repositoryInfo.rootUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNUpdateEditor17 editor = new SVNUpdateEditor17();
        editor.myIsUseCommitTimes = useCommitTimes;
        editor.myTargetRevision = targetRevision;
        editor.myReposRootURL = repositoryInfo.rootUrl;
        editor.myReposUuid = repositoryInfo.uuid;
        editor.myWCContext = context;
        editor.myTargetBasename = targetName;
        editor.myAnchorAbspath = anchorAbspath;
        editor.myWCRootAbsPath = context.getDb().getWCRoot(anchorAbspath);
        editor.myInheritableProperties = inheritableProperties;
        if (switchURL != null) {
            editor.mySwitchRelpath = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(repositoryInfo.rootUrl.getPath(), switchURL.getPath()));
        }
        editor.myTargetAbspath = "".equals(targetName) || targetName == null ? anchorAbspath : SVNFileUtil.createFilePath(anchorAbspath, targetName);
        editor.myRequestedDepth = depth;
        editor.myIsDepthSticky = depthIsSticky;
        editor.myIsUnversionedObstructionsAllowed = allowUnversionedObstructions;
        editor.myAddsAsModification = addsAsModifications;
        editor.myIsCleanCheckout = cleanCheckout;
        editor.myExtensionPatterns = preservedExtensions;
        editor.myExternalsStore = externalsStore;
        editor.myConflictHandler = conflictHandler;
        if (dirFetcher != null) {
            editor.initExcludedDirectoryEntries(dirFetcher);
        }
        ISVNUpdateEditor result = editor;
        if (!serverPerformsFiltering && !depthIsSticky) {
            result = new SVNAmbientDepthFilterEditor17(result, context, anchorAbspath, targetName, true);
        }
        return (ISVNUpdateEditor)SVNCancellableEditor.newInstance(result, context.getEventHandler(), null);
    }

    public static ISVNUpdateEditor createUpdateEditor(SVNWCContext wcContext, File anchorAbspath, String target, Map<File, Map<String, SVNProperties>> inheritableProperties, SVNURL reposRoot, SVNURL switchURL, SVNExternalsStore externalsStore, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExts, ISVNDirFetcher dirFetcher) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        ISVNWCDb.WCDbInfo info = wcContext.getDb().readInfo(anchorAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.reposId, ISVNWCDb.WCDbInfo.InfoField.reposRootUrl, ISVNWCDb.WCDbInfo.InfoField.reposUuid);
        if (info.status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo addition = wcContext.getDb().scanAddition(anchorAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposUuid);
            info.reposRootUrl = addition.reposRootUrl;
            info.reposUuid = addition.reposUuid;
        }
        assert (info.reposRootUrl != null && info.reposUuid != null);
        if (switchURL != null && !SVNPathUtil.isAncestor(info.reposRootUrl.toDecodedString(), switchURL.toDecodedString())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", switchURL.toDecodedString(), info.reposRootUrl.toDecodedString());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return new SVNUpdateEditor17(wcContext, anchorAbspath, target, inheritableProperties, info.reposRootUrl, info.reposUuid, switchURL, externalsStore, allowUnversionedObstructions, depthIsSticky, depth, preservedExts, dirFetcher);
    }

    private SVNUpdateEditor17() {
        this.myDirEntries = new HashMap<File, Map<String, SVNDirEntry>>();
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.mySkippedTrees = new HashSet<File>();
    }

    public SVNUpdateEditor17(SVNWCContext wcContext, File anchorAbspath, String targetBasename, Map<File, Map<String, SVNProperties>> inheritableProperties, SVNURL reposRootUrl, String reposUuid, SVNURL switchURL, SVNExternalsStore externalsStore, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExts, ISVNDirFetcher dirFetcher) throws SVNException {
        this.myWCContext = wcContext;
        this.myAnchorAbspath = anchorAbspath;
        this.myTargetBasename = targetBasename;
        this.myIsUnversionedObstructionsAllowed = allowUnversionedObstructions;
        this.myTargetRevision = -1L;
        this.myRequestedDepth = depth;
        this.myIsDepthSticky = depthIsSticky;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myExtensionPatterns = preservedExts;
        this.myTargetAbspath = anchorAbspath;
        this.myReposRootURL = reposRootUrl;
        this.myReposUuid = reposUuid;
        this.myExternalsStore = externalsStore;
        this.myIsUseCommitTimes = this.myWCContext.getOptions().isUseCommitTimes();
        if (this.myTargetBasename != null) {
            this.myTargetAbspath = SVNFileUtil.createFilePath(this.myTargetAbspath, this.myTargetBasename);
        }
        if ("".equals(this.myTargetBasename)) {
            this.myTargetBasename = null;
        }
        this.mySwitchRelpath = switchURL != null ? SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(reposRootUrl.getPath(), switchURL.getPath())) : null;
        if (dirFetcher != null) {
            this.initExcludedDirectoryEntries(dirFetcher);
        }
        this.myConflictHandler = this.myWCContext.getOptions().getConflictResolver();
        this.myInheritableProperties = inheritableProperties;
    }

    private void initExcludedDirectoryEntries(ISVNDirFetcher dirFetcher) throws SVNException {
        if (!this.myIsDepthSticky && SVNDepth.EMPTY.compareTo(this.myRequestedDepth) <= 0 && this.myRequestedDepth.compareTo(SVNDepth.INFINITY) < 0 && this.myRequestedDepth != SVNDepth.UNKNOWN) {
            ISVNWCDb.WCDbBaseInfo info;
            block7: {
                this.myDirEntries = new HashMap<File, Map<String, SVNDirEntry>>();
                info = null;
                try {
                    info = this.myWCContext.getDb().getBaseInfo(this.myTargetAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
                }
                catch (SVNException e) {
                    info = null;
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block7;
                    throw e;
                }
            }
            if (info != null && info.kind == ISVNWCDb.SVNWCDbKind.Dir && info.status == ISVNWCDb.SVNWCDbStatus.Normal) {
                File dirReposRelPath;
                Map<String, SVNDirEntry> dirEntries;
                if (info.depth.compareTo(this.myRequestedDepth) > 0 && (dirEntries = dirFetcher.fetchEntries(this.myReposRootURL, dirReposRelPath = this.mySwitchRelpath != null ? this.mySwitchRelpath : info.reposRelPath)) != null && !dirEntries.isEmpty()) {
                    this.myDirEntries.put(dirReposRelPath, dirEntries);
                }
                if (this.myRequestedDepth == SVNDepth.IMMEDIATES) {
                    Set<String> children = this.myWCContext.getDb().getBaseChildren(this.myTargetAbspath);
                    for (String child : children) {
                        File dirReposRelPath2;
                        Map<String, SVNDirEntry> dirEntries2;
                        File childAbsPath = SVNFileUtil.createFilePath(this.myTargetAbspath, child);
                        info = this.myWCContext.getDb().getBaseInfo(childAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
                        if (info.kind != ISVNWCDb.SVNWCDbKind.Dir || info.status != ISVNWCDb.SVNWCDbStatus.Normal || info.depth.compareTo(SVNDepth.EMPTY) <= 0 || (dirEntries2 = dirFetcher.fetchEntries(this.myReposRootURL, dirReposRelPath2 = this.mySwitchRelpath != null ? SVNFileUtil.createFilePath(this.mySwitchRelpath, child) : info.reposRelPath)) == null || dirEntries2.isEmpty()) continue;
                        this.myDirEntries.put(dirReposRelPath2, dirEntries2);
                    }
                }
            }
        }
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    @Override
    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    private void rememberSkippedTree(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        File relativePath = SVNWCUtils.skipAncestor(this.getWCRootAbsPath(), localAbspath);
        this.mySkippedTrees.add(relativePath);
    }

    private File getWCRootAbsPath() throws SVNException {
        if (this.myWCRootAbsPath == null) {
            this.myWCRootAbsPath = this.myWCContext.getDb().getWCRoot(this.myAnchorAbspath);
        }
        return this.myWCRootAbsPath;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        boolean conflictIgnored;
        ISVNWCDb.SVNWCDbStatus baseStatus = ISVNWCDb.SVNWCDbStatus.Normal;
        this.rootOpened = true;
        this.myCurrentDirectory = this.makeDirectoryBaton(null, null, false);
        try {
            AlreadyInTreeConflictInfo alreadyInTreeConflictInfo = this.alreadyInATreeConflict(this.myCurrentDirectory.localAbsolutePath);
            boolean alreadyConflicted = alreadyInTreeConflictInfo.conflicted;
            conflictIgnored = alreadyInTreeConflictInfo.ignored;
            if (alreadyConflicted) {
                this.rememberSkippedTree(this.myCurrentDirectory.localAbsolutePath);
                this.rememberSkippedTree(this.myTargetAbspath);
                this.myCurrentDirectory.skipThis = true;
                this.myCurrentDirectory.alreadyNotified = true;
                this.doNotification(this.myTargetAbspath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, null, null);
                return;
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            boolean alreadyConflicted = false;
            conflictIgnored = false;
        }
        Structure<StructureFields.NodeInfo> nodeInfoStructure = this.myWCContext.getDb().readInfo(this.myCurrentDirectory.localAbsolutePath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.changedRev, StructureFields.NodeInfo.changedDate, StructureFields.NodeInfo.changedAuthor, StructureFields.NodeInfo.depth, StructureFields.NodeInfo.haveWork);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
        this.myCurrentDirectory.oldRevision = nodeInfoStructure.lng(StructureFields.NodeInfo.revision);
        this.myCurrentDirectory.oldReposRelPath = (File)nodeInfoStructure.get(StructureFields.NodeInfo.reposRelPath);
        this.myCurrentDirectory.changedAuthor = (String)nodeInfoStructure.get(StructureFields.NodeInfo.changedAuthor);
        this.myCurrentDirectory.changedRevsion = nodeInfoStructure.lng(StructureFields.NodeInfo.changedRev);
        this.myCurrentDirectory.changedDate = (SVNDate)nodeInfoStructure.get(StructureFields.NodeInfo.changedDate);
        this.myCurrentDirectory.ambientDepth = (SVNDepth)nodeInfoStructure.get(StructureFields.NodeInfo.depth);
        boolean haveWork = nodeInfoStructure.is(StructureFields.NodeInfo.haveWork);
        if (conflictIgnored) {
            this.myCurrentDirectory.shadowed = true;
        } else if (haveWork) {
            ISVNWCDb.SVNWCDbBaseMovedToData baseMovedToData = this.myWCContext.getDb().baseMovedTo(this.myCurrentDirectory.localAbsolutePath);
            File moveSrcRootAbsPath = baseMovedToData.moveSrcRootAbsPath;
            if (moveSrcRootAbsPath != null || "".equals(this.myTargetBasename)) {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(this.myCurrentDirectory.localAbsolutePath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
                baseStatus = baseInfo.status;
                this.myCurrentDirectory.oldRevision = baseInfo.revision;
                this.myCurrentDirectory.oldReposRelPath = baseInfo.reposRelPath;
                this.myCurrentDirectory.changedRevsion = baseInfo.changedRev;
                this.myCurrentDirectory.changedDate = baseInfo.changedDate;
                this.myCurrentDirectory.changedAuthor = baseInfo.changedAuthor;
                this.myCurrentDirectory.ambientDepth = baseInfo.depth;
            }
            if (moveSrcRootAbsPath != null) {
                SVNSkel treeConflict = SVNSkel.createEmptyList();
                SvnWcDbConflicts.addTreeConflict(treeConflict, this.myWCContext.getDb(), moveSrcRootAbsPath, SVNConflictReason.MOVED_AWAY, SVNConflictAction.EDIT, moveSrcRootAbsPath);
                if (this.myCurrentDirectory.equals(moveSrcRootAbsPath)) {
                    this.completeConflict(treeConflict, moveSrcRootAbsPath, this.myCurrentDirectory.oldReposRelPath, this.myCurrentDirectory.oldRevision, this.myCurrentDirectory.newRelativePath, SVNNodeKind.DIR, SVNNodeKind.DIR);
                    this.myWCContext.getDb().opMarkConflict(moveSrcRootAbsPath, treeConflict, null);
                    this.doNotification(moveSrcRootAbsPath, SVNNodeKind.DIR, SVNEventAction.TREE_CONFLICT, null, null);
                } else {
                    this.myCurrentDirectory.editConflict = treeConflict;
                }
            }
            this.myCurrentDirectory.shadowed = true;
        } else {
            baseStatus = status;
        }
        if ("".equals(this.myTargetBasename)) {
            this.myCurrentDirectory.wasIncomplete = baseStatus == ISVNWCDb.SVNWCDbStatus.Incomplete;
            this.myWCContext.getDb().opStartDirectoryUpdateTemp(this.myCurrentDirectory.localAbsolutePath, this.myCurrentDirectory.newRelativePath, this.myTargetRevision);
        }
    }

    private void doNotification(File localAbspath, SVNNodeKind kind, SVNEventAction action, SVNURL url, SVNURL previousURL) throws SVNException {
        if (this.myWCContext.getEventHandler() != null) {
            SVNEvent event = new SVNEvent(localAbspath, kind, null, -1L, null, null, null, null, action, null, null, null, null, null, null);
            event.setURL(url);
            event.setPreviousURL(previousURL);
            this.myWCContext.getEventHandler().handleEvent(event, 0.0);
        }
    }

    private AlreadyInTreeConflictInfo alreadyInATreeConflict(File localAbspath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(localAbspath));
        File ancestorAbspath = localAbspath;
        boolean conflicted = false;
        boolean ignored = false;
        while (ancestorAbspath != null) {
            SVNWCContext.ConflictInfo conflictInfo = this.myWCContext.getConflicted(ancestorAbspath, false, false, true);
            conflicted = conflictInfo.treeConflicted;
            ignored = conflictInfo.ignored;
            if (conflicted || ignored || this.myWCContext.getDb().isWCRoot(ancestorAbspath)) break;
            ancestorAbspath = SVNFileUtil.getParentFile(ancestorAbspath);
        }
        return new AlreadyInTreeConflictInfo(conflicted, ignored);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        String expectedName;
        ISVNWCDb.SVNWCDbStatus baseStatus;
        SVNURL previousURL;
        if (this.myCurrentDirectory.skipThis) {
            return;
        }
        this.myCurrentDirectory.markEdited();
        String base = SVNFileUtil.getFileName(SVNFileUtil.createFilePath(path));
        File localAbsPath = SVNFileUtil.createFilePath(this.myCurrentDirectory.localAbsolutePath, base);
        boolean isRoot = this.myWCContext.getDb().isWCRoot(localAbsPath);
        if (isRoot) {
            this.rememberSkippedTree(localAbsPath);
            this.doNotification(localAbsPath, SVNNodeKind.UNKNOWN, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
            return;
        }
        boolean deletingTarget = localAbsPath.equals(this.myTargetAbspath);
        ISVNWCDb.WCDbInfo info = this.myWCContext.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.haveBase, ISVNWCDb.WCDbInfo.InfoField.haveWork);
        SVNURL sVNURL = previousURL = info.reposRelPath != null ? SVNWCUtils.join(this.myReposRootURL, info.reposRelPath) : null;
        if (!info.haveWork) {
            baseStatus = info.status;
            ISVNWCDb.SVNWCDbKind baseKind = info.kind;
        } else {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
            baseStatus = baseInfo.status;
            ISVNWCDb.SVNWCDbKind baseKind = baseInfo.kind;
            info.reposRelPath = baseInfo.reposRelPath;
            info.revision = baseInfo.revision;
        }
        boolean deletingSwitched = this.myCurrentDirectory.oldReposRelPath != null && info.reposRelPath != null ? (expectedName = SVNPathUtil.getRelativePath(this.myCurrentDirectory.oldReposRelPath.getPath(), info.reposRelPath.getPath())) == null || !expectedName.equals(base) : false;
        if (this.myCurrentDirectory.shadowed) {
            info.conflicted = false;
        } else if (info.conflicted) {
            NodeAlreadyConflictedInfo alreadyConflicted = this.isNodeAlreadyConflicted(localAbsPath);
            info.conflicted = alreadyConflicted.conflicted;
        }
        if (info.conflicted) {
            this.rememberSkippedTree(localAbsPath);
            this.doNotification(localAbsPath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, null, null);
            return;
        }
        if (baseStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || baseStatus == ISVNWCDb.SVNWCDbStatus.Excluded || baseStatus == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
            this.myWCContext.getDb().removeBase(localAbsPath, false, false, false, -1L, null, null);
            if (deletingTarget) {
                this.myIsTargetDeleted = true;
            }
            return;
        }
        boolean queueDeletes = true;
        SVNSkel treeConflict = null;
        if (!this.myCurrentDirectory.shadowed && !this.myCurrentDirectory.editedObstructed) {
            treeConflict = this.checkTreeConflict(localAbsPath, info.status, true, info.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNConflictAction.DELETE);
        } else {
            queueDeletes = false;
        }
        boolean keepAsWorking = false;
        if (treeConflict != null) {
            if (this.myCurrentDirectory.deletionConflicts == null) {
                this.myCurrentDirectory.deletionConflicts = new HashMap();
            }
            this.myCurrentDirectory.deletionConflicts.put(base, treeConflict);
            Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this.myWCContext.getDb(), localAbsPath, treeConflict);
            SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
            if (reason == SVNConflictReason.EDITED || reason == SVNConflictReason.OBSTRUCTED) {
                keepAsWorking = true;
            } else if (reason != SVNConflictReason.DELETED && reason != SVNConflictReason.MOVED_AWAY && reason != SVNConflictReason.REPLACED) {
                throw new IllegalStateException();
            }
        }
        this.completeConflict(treeConflict, localAbsPath, info.reposRelPath, info.revision, null, info.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.NONE);
        if (!deletingTarget && !deletingSwitched) {
            this.myWCContext.getDb().removeBase(localAbsPath, keepAsWorking, queueDeletes, false, -1L, treeConflict, null);
        } else {
            this.myWCContext.getDb().removeBase(localAbsPath, keepAsWorking, queueDeletes, false, this.getTargetRevision(), treeConflict, null);
            if (deletingTarget) {
                this.myIsTargetDeleted = true;
            } else {
                this.rememberSkippedTree(localAbsPath);
            }
        }
        this.myWCContext.wqRun(this.myCurrentDirectory.localAbsolutePath);
        if (treeConflict != null) {
            this.doNotification(localAbsPath, SVNNodeKind.UNKNOWN, SVNEventAction.TREE_CONFLICT, null, null);
        } else {
            SVNEventAction action = SVNEventAction.UPDATE_DELETE;
            if (this.myCurrentDirectory.shadowed || this.myCurrentDirectory.editedObstructed) {
                action = SVNEventAction.UPDATE_SHADOWED_DELETE;
            }
            this.doNotification(localAbsPath, info.kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, action, null, previousURL);
        }
    }

    private NodeAlreadyConflictedInfo isNodeAlreadyConflicted(File localAbspath) throws SVNException {
        NodeAlreadyConflictedInfo alreadyConflictedInfo = new NodeAlreadyConflictedInfo();
        List<SVNConflictDescription> conflicts = this.myWCContext.getDb().readConflicts(localAbspath);
        for (SVNConflictDescription cd : conflicts) {
            if (cd.isTreeConflict()) {
                alreadyConflictedInfo.conflicted = true;
                alreadyConflictedInfo.conflictIgnored = false;
                return alreadyConflictedInfo;
            }
            if (!cd.isPropertyConflict() && !cd.isTextConflict()) continue;
            SVNWCContext.ConflictInfo info = this.myWCContext.getConflicted(localAbspath, true, true, true);
            alreadyConflictedInfo.conflicted = info.textConflicted || info.propConflicted || info.treeConflicted;
            alreadyConflictedInfo.conflictIgnored = info.ignored;
            return alreadyConflictedInfo;
        }
        alreadyConflictedInfo.conflicted = false;
        alreadyConflictedInfo.conflictIgnored = false;
        return alreadyConflictedInfo;
    }

    private SVNSkel checkTreeConflict(File localAbspath, ISVNWCDb.SVNWCDbStatus workingStatus, boolean existsInRepos, SVNNodeKind expectedKind, SVNConflictAction action) throws SVNException {
        SVNErrorMessage errorMessage;
        SVNConflictReason reason = null;
        boolean modified = false;
        boolean allModsAreDeleted = false;
        File moveSrcOpRootAbsPath = null;
        switch (workingStatus) {
            case Added: 
            case MovedHere: 
            case Copied: {
                if (!existsInRepos) {
                    assert (action == SVNConflictAction.ADD);
                    if (workingStatus == ISVNWCDb.SVNWCDbStatus.Added) {
                        this.myWCContext.getDb().scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status);
                    }
                    if (workingStatus == ISVNWCDb.SVNWCDbStatus.MovedHere) {
                        reason = SVNConflictReason.MOVED_HERE;
                        break;
                    }
                    reason = SVNConflictReason.ADDED;
                    break;
                }
                ISVNWCDb.SVNWCDbBaseMovedToData baseMovedToData = this.myWCContext.getDb().baseMovedTo(localAbspath);
                moveSrcOpRootAbsPath = baseMovedToData.moveSrcOpRootAbsPath;
                if (moveSrcOpRootAbsPath != null) {
                    reason = SVNConflictReason.MOVED_AWAY;
                    break;
                }
                reason = SVNConflictReason.REPLACED;
                break;
            }
            case Deleted: {
                ISVNWCDb.SVNWCDbBaseMovedToData baseMovedToData = this.myWCContext.getDb().baseMovedTo(localAbspath);
                moveSrcOpRootAbsPath = baseMovedToData.moveSrcOpRootAbsPath;
                if (moveSrcOpRootAbsPath != null) {
                    reason = SVNConflictReason.MOVED_AWAY;
                    break;
                }
                reason = SVNConflictReason.DELETED;
                break;
            }
            case Incomplete: 
            case Normal: {
                if (action == SVNConflictAction.EDIT) {
                    SVNNodeKind diskKind;
                    if (existsInRepos && (diskKind = SVNFileType.getNodeKind(SVNFileType.getType(localAbspath))) != expectedKind && diskKind != SVNNodeKind.NONE) {
                        reason = SVNConflictReason.OBSTRUCTED;
                        break;
                    }
                    return null;
                }
                assert (action == SVNConflictAction.DELETE);
                SVNWCContext.TreeLocalModsInfo treeLocalModsInfo = this.myWCContext.hasLocalMods(localAbspath, this.myAnchorAbspath);
                modified = treeLocalModsInfo.modificationsFound;
                boolean bl = allModsAreDeleted = !treeLocalModsInfo.nonDeleteModificationsFound;
                if (!modified) break;
                if (allModsAreDeleted) {
                    reason = SVNConflictReason.DELETED;
                    break;
                }
                reason = SVNConflictReason.EDITED;
                break;
            }
            case ServerExcluded: 
            case Excluded: 
            case NotPresent: {
                return null;
            }
            case BaseDeleted: {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL);
                SVNErrorManager.error(err, SVNLogType.WC);
                break;
            }
        }
        if (reason == null) {
            return null;
        }
        if (reason == SVNConflictReason.EDITED || reason == SVNConflictReason.OBSTRUCTED || reason == SVNConflictReason.DELETED || reason == SVNConflictReason.MOVED_AWAY || reason == SVNConflictReason.REPLACED) {
            if (action != SVNConflictAction.EDIT && action != SVNConflictAction.DELETE && action != SVNConflictAction.REPLACE) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Unexpected attempt to add a node at path '{{0}}'", (Object)localAbspath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        } else if ((reason == SVNConflictReason.ADDED || reason == SVNConflictReason.MOVED_HERE) && action != SVNConflictAction.ADD) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Unexpected attempt to edit, delete, or replace a node at path '{{0}}'", (Object)localAbspath);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        SVNSkel conflict = SvnWcDbConflicts.createConflictSkel();
        SvnWcDbConflicts.addTreeConflict(conflict, this.myWCContext.getDb(), localAbspath, reason, action, moveSrcOpRootAbsPath);
        return conflict;
    }

    @Override
    public void absentDir(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.DIR);
    }

    @Override
    public void absentFile(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.FILE);
    }

    private void absentEntry(String path, SVNNodeKind nodeKind) throws SVNException {
        if (this.myCurrentDirectory.skipThis) {
            return;
        }
        String name = SVNPathUtil.tail(path);
        ISVNWCDb.SVNWCDbKind absentKind = nodeKind == SVNNodeKind.DIR ? ISVNWCDb.SVNWCDbKind.Dir : ISVNWCDb.SVNWCDbKind.File;
        this.myCurrentDirectory.markEdited();
        File localAbsPath = SVNFileUtil.createFilePath(this.myCurrentDirectory.localAbsolutePath, name);
        ISVNWCDb.WCDbInfo info = null;
        ISVNWCDb.SVNWCDbStatus status = null;
        ISVNWCDb.SVNWCDbKind kind = null;
        try {
            info = this.myWCContext.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind);
            status = info.status;
            kind = info.kind;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            status = ISVNWCDb.SVNWCDbStatus.NotPresent;
            kind = ISVNWCDb.SVNWCDbKind.Unknown;
        }
        if ((status != ISVNWCDb.SVNWCDbStatus.Normal || kind != ISVNWCDb.SVNWCDbKind.Dir) && status != ISVNWCDb.SVNWCDbStatus.NotPresent && status != ISVNWCDb.SVNWCDbStatus.ServerExcluded && status != ISVNWCDb.SVNWCDbStatus.Excluded) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File reposRelPath = SVNFileUtil.createFilePath(this.myCurrentDirectory.newRelativePath, name);
        this.myWCContext.getDb().addBaseExcludedNode(localAbsPath, reposRelPath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, absentKind, ISVNWCDb.SVNWCDbStatus.ServerExcluded, null, null);
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        boolean versionedLocallyAndPresent;
        boolean conflicted;
        ISVNWCDb.SVNWCDbKind wcKind;
        ISVNWCDb.SVNWCDbStatus status;
        assert (copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision) || copyFromPath == null && !SVNRevision.isValidRevisionNumber(copyFromRevision));
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentDirectory = this.makeDirectoryBaton(path, this.myCurrentDirectory, true);
        DirectoryBaton db = this.myCurrentDirectory;
        if (db.skipThis) {
            return;
        }
        db.markEdited();
        boolean conflictIgnored = false;
        if (this.myTargetAbspath.equals(db.localAbsolutePath)) {
            db.ambientDepth = this.myRequestedDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : this.myRequestedDepth;
        } else if (this.myRequestedDepth == SVNDepth.IMMEDIATES || this.myRequestedDepth == SVNDepth.UNKNOWN && pb.ambientDepth == SVNDepth.IMMEDIATES) {
            db.ambientDepth = SVNDepth.EMPTY;
        } else {
            db.ambientDepth = SVNDepth.INFINITY;
        }
        if (SVNFileUtil.getAdminDirectoryName().equals(db.name)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': object of the same name as the administrative directory", (Object)db.localAbsolutePath);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(db.localAbsolutePath));
        boolean error = false;
        try {
            ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(db.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.reposRelPath);
            status = readInfo.status;
            wcKind = readInfo.kind;
            conflicted = readInfo.conflicted;
            versionedLocallyAndPresent = false;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            error = true;
            wcKind = ISVNWCDb.SVNWCDbKind.Unknown;
            status = ISVNWCDb.SVNWCDbStatus.Normal;
            conflicted = false;
            versionedLocallyAndPresent = false;
        }
        if (!error) {
            if (wcKind == ISVNWCDb.SVNWCDbKind.Dir && status == ISVNWCDb.SVNWCDbStatus.Normal) {
                this.myWCContext.getDb().addBaseNotPresentNode(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, ISVNWCDb.SVNWCDbKind.File, null, null);
                this.rememberSkippedTree(db.localAbsolutePath);
                db.skipThis = true;
                db.alreadyNotified = true;
                this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, db.getURL(), db.getPreviousURL());
                return;
            }
            if (status == ISVNWCDb.SVNWCDbStatus.Normal && (wcKind == ISVNWCDb.SVNWCDbKind.File || wcKind == ISVNWCDb.SVNWCDbKind.Symlink)) {
                this.rememberSkippedTree(db.localAbsolutePath);
                db.skipThis = true;
                db.alreadyNotified = true;
                this.doNotification(db.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, db.getURL(), db.getPreviousURL());
                return;
            }
            versionedLocallyAndPresent = wcKind == ISVNWCDb.SVNWCDbKind.Unknown ? false : SVNUpdateEditor17.isNodePresent(status);
        }
        SVNSkel treeConflict = null;
        if (conflicted) {
            if (pb.deletionConflicts != null) {
                treeConflict = (SVNSkel)pb.deletionConflicts.get(db.name);
            }
            if (treeConflict != null) {
                Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this.myWCContext.getDb(), db.localAbsolutePath, treeConflict);
                SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
                treeConflict = SvnWcDbConflicts.createConflictSkel();
                SvnWcDbConflicts.addTreeConflict(treeConflict, this.myWCContext.getDb(), db.localAbsolutePath, reason, SVNConflictAction.REPLACE, null);
                db.editConflict = treeConflict;
                treeConflict = null;
                db.shadowed = true;
                conflicted = false;
            } else {
                NodeAlreadyConflictedInfo alreadyConflicted = this.isNodeAlreadyConflicted(db.localAbsolutePath);
                conflicted = alreadyConflicted.conflicted;
                conflictIgnored = alreadyConflicted.conflictIgnored;
            }
        }
        if (conflicted) {
            this.rememberSkippedTree(db.localAbsolutePath);
            db.skipThis = true;
            db.alreadyNotified = true;
            this.myWCContext.getDb().addBaseNotPresentNode(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, ISVNWCDb.SVNWCDbKind.Dir, null, null);
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.SKIP_CONFLICTED, db.getURL(), db.getPreviousURL());
            return;
        }
        if (conflictIgnored) {
            db.shadowed = true;
        }
        if (!db.shadowed) {
            if (versionedLocallyAndPresent) {
                boolean localIsNonDir;
                ISVNWCDb.SVNWCDbStatus addStatus = ISVNWCDb.SVNWCDbStatus.Normal;
                if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                    addStatus = this.myWCContext.getDb().scanAddition((File)((DirectoryBaton)db).localAbsolutePath, (ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[])new ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[]{ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status}).status;
                }
                boolean bl = localIsNonDir = wcKind != ISVNWCDb.SVNWCDbKind.Dir && status != ISVNWCDb.SVNWCDbStatus.Deleted;
                if (!this.myAddsAsModification || localIsNonDir || addStatus != ISVNWCDb.SVNWCDbStatus.Added) {
                    treeConflict = this.checkTreeConflict(db.localAbsolutePath, status, false, wcKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNConflictAction.ADD);
                }
                if (treeConflict == null) {
                    db.addExisted = true;
                } else {
                    db.shadowed = true;
                }
            } else if (kind != SVNNodeKind.NONE) {
                db.obstructionFound = true;
                if (kind != SVNNodeKind.DIR || !this.myIsUnversionedObstructionsAllowed) {
                    db.shadowed = true;
                    treeConflict = SvnWcDbConflicts.createConflictSkel();
                    SvnWcDbConflicts.addTreeConflict(treeConflict, this.myWCContext.getDb(), db.localAbsolutePath, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, null);
                    db.editConflict = treeConflict;
                }
            }
        }
        if (treeConflict != null) {
            this.completeConflict(treeConflict, db.localAbsolutePath, db.oldReposRelPath, db.oldRevision, db.newRelativePath, wcKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.DIR);
        }
        this.myWCContext.getDb().opSetNewDirToIncompleteTemp(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, db.ambientDepth, db.shadowed && db.obstructionFound, !db.shadowed && status == ISVNWCDb.SVNWCDbStatus.Added, treeConflict, null);
        if (!db.shadowed) {
            SVNFileUtil.ensureDirectoryExists(db.localAbsolutePath);
        }
        if (treeConflict != null) {
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.TREE_CONFLICT, null, null);
        }
        if (this.myWCContext.getEventHandler() != null && !db.alreadyNotified && !db.addExisted) {
            SVNEventAction action = db.shadowed ? SVNEventAction.UPDATE_SHADOWED_ADD : (db.obstructionFound || db.addExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_ADD);
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, action, db.getURL(), db.getPreviousURL());
        }
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        ISVNWCDb.SVNWCDbStatus baseStatus;
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentDirectory = this.makeDirectoryBaton(path, pb, false);
        DirectoryBaton db = this.myCurrentDirectory;
        if (db.skipThis) {
            return;
        }
        boolean isWCRoot = this.myWCContext.getDb().isWCRoot(db.localAbsolutePath);
        if (isWCRoot) {
            this.rememberSkippedTree(db.localAbsolutePath);
            db.skipThis = true;
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
            return;
        }
        this.myWCContext.writeCheck(db.localAbsolutePath);
        ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(db.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.reposRelPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedAuthor, ISVNWCDb.WCDbInfo.InfoField.depth, ISVNWCDb.WCDbInfo.InfoField.haveWork, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.haveWork);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        ISVNWCDb.SVNWCDbKind wcKind = readInfo.kind;
        db.oldRevision = readInfo.revision;
        db.ambientDepth = readInfo.depth;
        db.changedRevsion = readInfo.changedRev;
        db.changedAuthor = readInfo.changedAuthor;
        db.changedDate = readInfo.changedDate;
        db.oldReposRelPath = readInfo.reposRelPath;
        boolean haveWork = readInfo.haveWork;
        boolean conflicted = readInfo.conflicted;
        SVNSkel treeConflict = null;
        if (!haveWork) {
            baseStatus = status;
        } else {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(db.localAbsolutePath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
            baseStatus = baseInfo.status;
            db.oldRevision = baseInfo.revision;
            db.ambientDepth = baseInfo.depth;
            db.changedAuthor = baseInfo.changedAuthor;
            db.changedDate = baseInfo.changedDate;
            db.changedRevsion = baseInfo.changedRev;
            db.oldReposRelPath = baseInfo.reposRelPath;
        }
        db.wasIncomplete = baseStatus == ISVNWCDb.SVNWCDbStatus.Incomplete;
        boolean conflictIgnored = false;
        if (db.shadowed) {
            conflicted = false;
        } else if (conflicted) {
            NodeAlreadyConflictedInfo alreadyConflicted = this.isNodeAlreadyConflicted(db.localAbsolutePath);
            conflicted = alreadyConflicted.conflicted;
            conflictIgnored = alreadyConflicted.conflictIgnored;
        }
        if (conflicted) {
            this.rememberSkippedTree(db.localAbsolutePath);
            db.skipThis = true;
            db.alreadyNotified = true;
            this.doNotification(db.localAbsolutePath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, null, null);
            return;
        }
        if (conflictIgnored) {
            db.shadowed = true;
        }
        if (!db.shadowed) {
            treeConflict = this.checkTreeConflict(db.localAbsolutePath, status, true, wcKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNConflictAction.EDIT);
        }
        if (treeConflict != null) {
            db.editConflict = treeConflict;
            Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this.myWCContext.getDb(), db.localAbsolutePath, treeConflict);
            SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
            assert (reason == SVNConflictReason.DELETED || reason == SVNConflictReason.MOVED_AWAY || reason == SVNConflictReason.REPLACED || reason == SVNConflictReason.OBSTRUCTED);
            if (reason == SVNConflictReason.OBSTRUCTED) {
                db.editedObstructed = true;
            } else {
                db.shadowed = true;
            }
        }
        this.myWCContext.getDb().opStartDirectoryUpdateTemp(db.localAbsolutePath, db.newRelativePath, this.myTargetRevision);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentDirectory.skipThis) {
            return;
        }
        if (this.myCurrentDirectory.propChanges == null) {
            this.myCurrentDirectory.propChanges = new SVNProperties();
        }
        this.myCurrentDirectory.propChanges.put(name, value);
        if (!this.myCurrentDirectory.edited && SVNProperty.isRegularProperty(name)) {
            this.myCurrentDirectory.markEdited();
        }
    }

    @Override
    public void closeDir() throws SVNException {
        Map<String, SVNDirEntry> newChildren;
        SVNPropertyValue newWCDavURL;
        DirectoryBaton db = this.myCurrentDirectory;
        if (db.skipThis) {
            this.maybeBumpDirInfo(db.bumpInfo);
            this.myCurrentDirectory = this.myCurrentDirectory.parentBaton;
            return;
        }
        SVNSkel conflictSkel = null;
        if (db.edited) {
            conflictSkel = db.editConflict;
        }
        SVNSkel allWorkItems = null;
        SVNProperties regularProps = new SVNProperties();
        SVNProperties entryProps = new SVNProperties();
        SVNProperties davProps = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(db.propChanges, regularProps, entryProps, davProps);
        SVNPropertyValue sVNPropertyValue = newWCDavURL = davProps != null ? davProps.getSVNPropertyValue("svn:wc:ra_dav:version-url") : null;
        if (newWCDavURL == null) {
            davProps = null;
        }
        SVNProperties actualProps = null;
        SVNProperties baseProps = null;
        actualProps = (!db.addingDir || db.addExisted) && !db.shadowed ? this.myWCContext.getActualProps(db.localAbsolutePath) : new SVNProperties();
        baseProps = db.addExisted ? this.myWCContext.getDb().readPristineProperties(db.localAbsolutePath) : (!db.addingDir ? this.myWCContext.getDb().getBaseProps(db.localAbsolutePath) : new SVNProperties());
        SVNStatusType[] propStatus = new SVNStatusType[]{SVNStatusType.UNKNOWN};
        SVNProperties newBaseProps = null;
        SVNProperties newActualProps = null;
        long newChangedRev = -1L;
        SVNDate newChangedDate = null;
        String newChangedAuthor = null;
        if (db.wasIncomplete) {
            SVNProperties propertiesToDelete = new SVNProperties(baseProps);
            if (regularProps == null) {
                regularProps = new SVNProperties();
            }
            for (String name : regularProps.nameSet()) {
                propertiesToDelete.remove(name);
            }
            for (String name : propertiesToDelete.nameSet()) {
                regularProps.put(name, SVNPropertyValue.create(null));
            }
        }
        if (regularProps != null && regularProps.size() > 0) {
            if (this.myExternalsStore != null && regularProps.containsName("svn:externals")) {
                String newValue = regularProps.getStringValue("svn:externals");
                String oldValue = baseProps.getStringValue("svn:externals");
                if (!(oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null)) {
                    this.myExternalsStore.addExternal(db.localAbsolutePath, oldValue, newValue);
                    this.myExternalsStore.addDepth(db.localAbsolutePath, db.ambientDepth);
                }
            }
            if (db.shadowed) {
                actualProps = db.addingDir ? new SVNProperties() : baseProps;
            }
            newBaseProps = new SVNProperties(baseProps);
            newBaseProps.putAll(regularProps);
            SVNWCContext.MergePropertiesInfo mergeProperiesInfo = null;
            mergeProperiesInfo = this.myWCContext.mergeProperties3(mergeProperiesInfo, db.localAbsolutePath, null, baseProps, actualProps, regularProps);
            newActualProps = mergeProperiesInfo.newActualProperties;
            propStatus[0] = mergeProperiesInfo.mergeOutcome;
            conflictSkel = mergeProperiesInfo.conflictSkel;
            newActualProps.removeNullValues();
            newBaseProps.removeNullValues();
        }
        AccumulatedChangeInfo change = SVNUpdateEditor17.accumulateLastChange(db.localAbsolutePath, entryProps);
        newChangedRev = change.changedRev;
        newChangedDate = change.changedDate;
        newChangedAuthor = change.changedAuthor;
        Map<String, SVNDirEntry> map = newChildren = this.myDirEntries != null ? this.myDirEntries.get(db.newRelativePath) : null;
        if (newChildren != null) {
            for (String childName : newChildren.keySet()) {
                File childAbsPath;
                SVNDirEntry childEntry;
                block30: {
                    childEntry = newChildren.get(childName);
                    childAbsPath = SVNFileUtil.createFilePath(db.localAbsolutePath, childName);
                    if (db.ambientDepth.compareTo(SVNDepth.IMMEDIATES) < 0 && childEntry.getKind() == SVNNodeKind.DIR) continue;
                    try {
                        this.myWCContext.getDb().getBaseInfo(childAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status);
                        if (!this.myWCContext.getDb().isWCRoot(childAbsPath)) {
                            continue;
                        }
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block30;
                        throw e;
                    }
                }
                File childRelPath = SVNFileUtil.createFilePath(db.newRelativePath, childName);
                ISVNWCDb.SVNWCDbKind childKind = childEntry.getKind() == SVNNodeKind.DIR ? ISVNWCDb.SVNWCDbKind.Dir : ISVNWCDb.SVNWCDbKind.File;
                this.myWCContext.getDb().addBaseNotPresentNode(childAbsPath, childRelPath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, childKind, null, null);
            }
        }
        if (db.notPresentFiles != null && db.notPresentFiles.size() > 0) {
            for (String fileName : db.notPresentFiles) {
                File childAbsPath = SVNFileUtil.createFilePath(db.localAbsolutePath, fileName);
                File childRelPath = SVNFileUtil.createFilePath(db.newRelativePath, fileName);
                this.myWCContext.getDb().addBaseNotPresentNode(childAbsPath, childRelPath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, ISVNWCDb.SVNWCDbKind.File, null, null);
            }
        }
        if (db.parentBaton != null || "".equals(this.myTargetBasename) || this.myTargetBasename == null) {
            SVNProperties props;
            if (newChangedRev >= 0L) {
                db.changedRevsion = newChangedRev;
            }
            if (newChangedDate != null && newChangedDate.getTime() != 0L) {
                db.changedDate = newChangedDate;
            }
            if (newChangedAuthor != null) {
                db.changedAuthor = newChangedAuthor;
            }
            if (db.ambientDepth == SVNDepth.UNKNOWN) {
                db.ambientDepth = SVNDepth.INFINITY;
            }
            if (this.myIsDepthSticky && db.ambientDepth != this.myRequestedDepth && (this.myRequestedDepth == SVNDepth.INFINITY || db.localAbsolutePath.equals(this.myTargetAbspath) && this.myRequestedDepth.compareTo(db.ambientDepth) > 0)) {
                db.ambientDepth = this.myRequestedDepth;
            }
            if ((props = newBaseProps) == null) {
                props = baseProps;
            }
            if (davProps != null) {
                davProps.removeNullValues();
            }
            Map<String, SVNProperties> iprops = null;
            if (conflictSkel != null) {
                this.completeConflict(conflictSkel, db.localAbsolutePath, db.oldReposRelPath, db.oldRevision, db.newRelativePath, SVNNodeKind.DIR, SVNNodeKind.DIR);
                SVNSkel workItem = this.myWCContext.conflictCreateMarker(conflictSkel, db.localAbsolutePath);
                allWorkItems = SVNWCContext.wqMerge(allWorkItems, workItem);
            }
            if (this.myInheritableProperties != null) {
                iprops = this.myInheritableProperties.remove(db.localAbsolutePath);
            }
            this.myWCContext.getDb().addBaseDirectory(db.localAbsolutePath, db.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, props, db.changedRevsion, db.changedDate, db.changedAuthor, null, db.ambientDepth, davProps != null && !davProps.isEmpty() ? davProps : null, conflictSkel, !db.shadowed && newBaseProps != null, newActualProps, iprops, allWorkItems);
        }
        this.myWCContext.wqRun(db.localAbsolutePath);
        if (conflictSkel != null && this.myConflictHandler != null) {
            this.myWCContext.invokeConflictResolver(db.localAbsolutePath, conflictSkel, this.myConflictHandler, ISVNCanceller.NULL);
        }
        if (!db.alreadyNotified && this.myWCContext.getEventHandler() != null && db.edited) {
            SVNEventAction action = null;
            action = db.shadowed || db.editedObstructed ? SVNEventAction.UPDATE_SHADOWED_UPDATE : (db.obstructionFound || db.addExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_UPDATE);
            SVNEvent event = new SVNEvent(db.localAbsolutePath, SVNNodeKind.DIR, null, this.myTargetRevision, null, propStatus[0], null, null, action, null, null, null, null, null, null);
            event.setPreviousRevision(db.oldRevision);
            event.setURL(db.getURL());
            event.setPreviousURL(db.getPreviousURL());
            this.myWCContext.getEventHandler().handleEvent(event, 0.0);
        }
        this.maybeBumpDirInfo(db.bumpInfo);
        this.myCurrentDirectory = this.myCurrentDirectory.parentBaton;
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        FileBaton fb;
        assert (copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision) || copyFromPath == null && !SVNRevision.isValidRevisionNumber(copyFromRevision));
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentFile = fb = this.makeFileBaton(pb, path, true);
        if (fb.skipThis) {
            return;
        }
        fb.markEdited();
        if (SVNFileUtil.getAdminDirectoryName().equals(fb.name)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'' : object of the same name as the administrative directory", (Object)fb.localAbsolutePath);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        SVNNodeKind kind = SVNNodeKind.NONE;
        ISVNWCDb.SVNWCDbKind wcKind = ISVNWCDb.SVNWCDbKind.Unknown;
        ISVNWCDb.SVNWCDbStatus status = ISVNWCDb.SVNWCDbStatus.Normal;
        boolean conflicted = false;
        boolean versionedLocallyAndPresent = false;
        boolean error = false;
        boolean conflictIgnored = false;
        SVNSkel treeConflict = null;
        if (!this.myIsCleanCheckout) {
            kind = SVNFileType.getNodeKind(SVNFileType.getType(fb.localAbsolutePath));
            try {
                ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(fb.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.reposRelPath);
                status = readInfo.status;
                wcKind = readInfo.kind;
                conflicted = readInfo.conflicted;
                versionedLocallyAndPresent = SVNUpdateEditor17.isNodePresent(status);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                    throw e;
                }
                error = true;
                wcKind = ISVNWCDb.SVNWCDbKind.Unknown;
                conflicted = false;
                versionedLocallyAndPresent = false;
            }
        }
        if (!error) {
            if (wcKind == ISVNWCDb.SVNWCDbKind.Dir && status == ISVNWCDb.SVNWCDbStatus.Normal) {
                if (pb.notPresentFiles == null) {
                    pb.notPresentFiles = new HashSet();
                }
                pb.notPresentFiles.add(fb.name);
                this.rememberSkippedTree(fb.localAbsolutePath);
                fb.skipThis = true;
                fb.alreadyNotified = true;
                this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, fb.getURL(), fb.getPreviousURL());
                return;
            }
            if (status == ISVNWCDb.SVNWCDbStatus.Normal && (wcKind == ISVNWCDb.SVNWCDbKind.File || wcKind == ISVNWCDb.SVNWCDbKind.Symlink)) {
                this.rememberSkippedTree(fb.localAbsolutePath);
                fb.skipThis = true;
                fb.alreadyNotified = true;
                this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, fb.getURL(), fb.getPreviousURL());
                return;
            }
            versionedLocallyAndPresent = wcKind == ISVNWCDb.SVNWCDbKind.Unknown ? false : SVNUpdateEditor17.isNodePresent(status);
        }
        if (fb.shadowed) {
            conflicted = false;
        } else if (conflicted) {
            if (pb.deletionConflicts != null) {
                treeConflict = (SVNSkel)pb.deletionConflicts.get(fb.name);
            }
            if (treeConflict != null) {
                Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this.myWCContext.getDb(), fb.localAbsolutePath, treeConflict);
                SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
                treeConflict = SvnWcDbConflicts.createConflictSkel();
                SvnWcDbConflicts.addTreeConflict(treeConflict, this.myWCContext.getDb(), fb.localAbsolutePath, reason, SVNConflictAction.REPLACE, null);
                fb.editConflict = treeConflict;
                treeConflict = null;
                fb.shadowed = true;
                conflicted = false;
            } else {
                NodeAlreadyConflictedInfo alreadyConflicted = this.isNodeAlreadyConflicted(fb.localAbsolutePath);
                conflicted = alreadyConflicted.conflicted;
                conflictIgnored = alreadyConflicted.conflictIgnored;
            }
        }
        if (conflicted) {
            this.rememberSkippedTree(fb.localAbsolutePath);
            fb.skipThis = true;
            fb.alreadyNotified = true;
            if (pb.notPresentFiles == null) {
                pb.notPresentFiles = new HashSet();
            }
            pb.notPresentFiles.add(fb.name);
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, fb.getURL(), fb.getPreviousURL());
            return;
        }
        if (conflictIgnored) {
            fb.shadowed = true;
        }
        if (!fb.shadowed) {
            if (versionedLocallyAndPresent) {
                boolean localIsFile = false;
                if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                    status = this.myWCContext.getDb().scanAddition((File)((FileBaton)fb).localAbsolutePath, (ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[])new ISVNWCDb.WCDbAdditionInfo.AdditionInfoField[]{ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status}).status;
                }
                boolean bl = localIsFile = wcKind == ISVNWCDb.SVNWCDbKind.File || wcKind == ISVNWCDb.SVNWCDbKind.Symlink;
                if (!this.myAddsAsModification || !localIsFile || status != ISVNWCDb.SVNWCDbStatus.Added) {
                    treeConflict = this.checkTreeConflict(fb.localAbsolutePath, status, false, wcKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNConflictAction.ADD);
                }
                if (treeConflict == null) {
                    fb.addExisted = true;
                } else {
                    fb.shadowed = true;
                }
            } else if (kind != SVNNodeKind.NONE) {
                fb.obstructionFound = true;
                if (kind != SVNNodeKind.FILE || !this.myIsUnversionedObstructionsAllowed) {
                    fb.shadowed = true;
                    treeConflict = SvnWcDbConflicts.createConflictSkel();
                    SvnWcDbConflicts.addTreeConflict(treeConflict, this.myWCContext.getDb(), fb.localAbsolutePath, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, null);
                }
            }
        }
        if (pb.parentBaton != null || this.myTargetBasename == null || "".equals(this.myTargetBasename) || !fb.localAbsolutePath.equals(this.myTargetAbspath)) {
            if (pb.notPresentFiles == null) {
                pb.notPresentFiles = new HashSet();
            }
            pb.notPresentFiles.add(fb.name);
        }
        if (treeConflict != null) {
            this.completeConflict(treeConflict, fb.localAbsolutePath, fb.oldReposRelPath, fb.oldRevision, fb.newRelativePath, wcKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.FILE);
            this.myWCContext.getDb().opMarkConflict(fb.localAbsolutePath, treeConflict, null);
            fb.alreadyNotified = true;
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.TREE_CONFLICT, fb.getURL(), fb.getPreviousURL());
        }
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        FileBaton fb;
        DirectoryBaton pb = this.myCurrentDirectory;
        this.myCurrentFile = fb = this.makeFileBaton(pb, path, false);
        if (fb.skipThis) {
            return;
        }
        boolean isRoot = this.myWCContext.getDb().isWCRoot(fb.localAbsolutePath);
        if (isRoot) {
            this.rememberSkippedTree(fb.localAbsolutePath);
            fb.skipThis = true;
            fb.alreadyNotified = true;
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
            return;
        }
        boolean conflicted = false;
        boolean conflictIgnored = false;
        ISVNWCDb.SVNWCDbKind kind = ISVNWCDb.SVNWCDbKind.Unknown;
        SVNSkel treeConflict = null;
        ISVNWCDb.WCDbInfo readInfo = this.myWCContext.getDb().readInfo(fb.localAbsolutePath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.changedDate, ISVNWCDb.WCDbInfo.InfoField.changedRev, ISVNWCDb.WCDbInfo.InfoField.checksum, ISVNWCDb.WCDbInfo.InfoField.haveWork, ISVNWCDb.WCDbInfo.InfoField.conflicted, ISVNWCDb.WCDbInfo.InfoField.propsMod, ISVNWCDb.WCDbInfo.InfoField.reposRelPath);
        ISVNWCDb.SVNWCDbStatus status = readInfo.status;
        fb.changedAuthor = readInfo.changedAuthor;
        fb.changedDate = readInfo.changedDate;
        fb.changedRevison = readInfo.changedRev;
        fb.oldRevision = readInfo.revision;
        fb.originalChecksum = readInfo.checksum;
        fb.oldReposRelPath = readInfo.reposRelPath;
        fb.localPropMods = readInfo.propsMod;
        conflicted = readInfo.conflicted;
        if (readInfo.haveWork) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(fb.localAbsolutePath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
            fb.changedAuthor = baseInfo.changedAuthor;
            fb.changedDate = baseInfo.changedDate;
            fb.changedRevison = baseInfo.changedRev;
            fb.oldRevision = baseInfo.revision;
            fb.originalChecksum = baseInfo.checksum;
            fb.oldReposRelPath = baseInfo.reposRelPath;
        }
        if (fb.shadowed) {
            conflicted = false;
        } else if (conflicted) {
            NodeAlreadyConflictedInfo alreadyConflicted = this.isNodeAlreadyConflicted(fb.localAbsolutePath);
            conflicted = alreadyConflicted.conflicted;
            conflictIgnored = alreadyConflicted.conflictIgnored;
        }
        if (conflicted) {
            this.rememberSkippedTree(fb.localAbsolutePath);
            fb.skipThis = true;
            fb.alreadyNotified = true;
            this.doNotification(fb.localAbsolutePath, SVNNodeKind.UNKNOWN, SVNEventAction.SKIP_CONFLICTED, fb.getURL(), fb.getPreviousURL());
            return;
        }
        if (conflictIgnored) {
            fb.shadowed = true;
        }
        if (!fb.shadowed) {
            treeConflict = this.checkTreeConflict(fb.localAbsolutePath, status, true, kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNConflictAction.EDIT);
        }
        if (treeConflict != null) {
            fb.editConflict = treeConflict;
            Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this.myWCContext.getDb(), fb.localAbsolutePath, treeConflict);
            SVNConflictReason reason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
            assert (reason == SVNConflictReason.DELETED || reason == SVNConflictReason.MOVED_AWAY || reason == SVNConflictReason.REPLACED || reason == SVNConflictReason.OBSTRUCTED);
            if (reason == SVNConflictReason.OBSTRUCTED) {
                fb.editObstructed = true;
            } else {
                fb.shadowed = true;
            }
        }
    }

    @Override
    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        FileBaton fb = this.myCurrentFile;
        if (fb.skipThis) {
            return;
        }
        this.myCurrentFile.propChanges.put(propertyName, propertyValue);
        if (!fb.edited && SVNProperty.isRegularProperty(propertyName)) {
            fb.markEdited();
        }
        if (!fb.shadowed && "svn:special".equals(propertyName)) {
            boolean wasSymlink;
            boolean becomesSymlink = propertyValue != null;
            boolean modified = false;
            if (fb.addingFile) {
                wasSymlink = becomesSymlink;
            } else {
                SVNProperties props = this.myWCContext.getDb().getBaseProps(fb.localAbsolutePath);
                boolean bl = wasSymlink = props != null && props.getSVNPropertyValue("svn:special") != null;
            }
            if (wasSymlink != becomesSymlink && (modified = fb.localPropMods ? true : this.myWCContext.isTextModified(fb.localAbsolutePath, false))) {
                if (fb.editConflict == null) {
                    fb.editConflict = SvnWcDbConflicts.createConflictSkel();
                }
                SvnWcDbConflicts.addTreeConflict(fb.editConflict, this.myWCContext.getDb(), fb.localAbsolutePath, SVNConflictReason.EDITED, SVNConflictAction.REPLACE, null);
                this.completeConflict(fb.editConflict, fb.localAbsolutePath, fb.oldReposRelPath, fb.oldRevision, fb.newRelativePath, SVNNodeKind.FILE, SVNNodeKind.FILE);
                ((SVNWCDb)this.myWCContext.getDb()).opMakeCopy(fb.localAbsolutePath, fb.editConflict, null);
                this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.TREE_CONFLICT, fb.getURL(), fb.getPreviousURL());
                fb.shadowed = true;
                fb.addExisted = false;
                fb.alreadyNotified = true;
            }
        }
    }

    @Override
    public void closeFile(String path, String expectedMd5Digest) throws SVNException {
        Map<String, SVNProperties> iprops;
        SVNWCContext.MergePropertiesInfo info;
        SVNPropertyValue newWCDavURL;
        FileBaton fb = this.myCurrentFile;
        if (fb.skipThis) {
            this.maybeBumpDirInfo(fb.bumpInfo);
            return;
        }
        SVNSkel conflictSkel = null;
        if (fb.edited) {
            conflictSkel = fb.editConflict;
        }
        SvnChecksum expectedMd5Checksum = null;
        if (expectedMd5Digest != null) {
            expectedMd5Checksum = new SvnChecksum(SvnChecksum.Kind.md5, expectedMd5Digest);
        }
        if (expectedMd5Checksum != null && fb.newTextBaseMD5Digest != null && !expectedMd5Checksum.getDigest().equals(fb.newTextBaseMD5Digest)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", fb.localAbsolutePath, expectedMd5Checksum, fb.newTextBaseMD5Digest);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNProperties regularPropChanges = new SVNProperties();
        SVNProperties entryProps = new SVNProperties();
        SVNProperties davProps = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(fb.propChanges, regularPropChanges, entryProps, davProps);
        SVNPropertyValue sVNPropertyValue = newWCDavURL = davProps != null ? davProps.getSVNPropertyValue("svn:wc:ra_dav:version-url") : null;
        if (newWCDavURL == null) {
            davProps = null;
        }
        AccumulatedChangeInfo lastChange = SVNUpdateEditor17.accumulateLastChange(fb.localAbsolutePath, entryProps);
        long newChangedRev = lastChange.changedRev;
        SVNDate newChangedDate = lastChange.changedDate;
        String newChangedAuthor = lastChange.changedAuthor;
        if (newChangedRev >= 0L) {
            fb.changedRevison = newChangedRev;
        }
        if (newChangedDate != null) {
            fb.changedDate = newChangedDate;
        }
        if (newChangedAuthor != null) {
            fb.changedAuthor = newChangedAuthor;
        }
        SVNStatusType lockState = SVNStatusType.LOCK_UNCHANGED;
        for (String name : entryProps.nameSet()) {
            if (!"svn:entry:lock-token".equals(name) || this.mySwitchRelpath != null && !fb.newRelativePath.equals(fb.oldReposRelPath)) continue;
            assert (entryProps.getStringValue(name) == null);
            this.myWCContext.getDb().removeLock(fb.localAbsolutePath);
            lockState = SVNStatusType.LOCK_UNLOCKED;
            break;
        }
        SVNProperties localActualProps = null;
        SVNProperties currentBaseProps = null;
        SVNProperties currentActualProps = null;
        if (!(fb.addingFile && !fb.addExisted || fb.shadowed)) {
            localActualProps = this.myWCContext.getActualProps(fb.localAbsolutePath);
        }
        if (localActualProps == null) {
            localActualProps = new SVNProperties();
        }
        if (fb.addExisted) {
            currentBaseProps = this.myWCContext.getDb().readPristineProperties(fb.localAbsolutePath);
            currentActualProps = localActualProps;
        } else if (!fb.addingFile) {
            currentBaseProps = this.myWCContext.getDb().getBaseProps(fb.localAbsolutePath);
            currentActualProps = localActualProps;
        }
        if (currentBaseProps == null) {
            currentBaseProps = new SVNProperties();
        }
        if (currentActualProps == null) {
            currentActualProps = new SVNProperties();
        }
        SVNStatusType[] propState = new SVNStatusType[]{SVNStatusType.UNKNOWN};
        SVNStatusType contentState = null;
        SVNProperties newBaseProps = new SVNProperties();
        SVNProperties newActualProps = new SVNProperties();
        SVNSkel allWorkItems = null;
        boolean keepRecordedInfo = false;
        if (!fb.shadowed) {
            boolean installPristine = false;
            info = new SVNWCContext.MergePropertiesInfo();
            info.newActualProperties = newActualProps;
            info.newBaseProperties = new SVNProperties(currentBaseProps);
            info.newBaseProperties.putAll(regularPropChanges);
            info.conflictSkel = conflictSkel;
            info = this.myWCContext.mergeProperties3(info, fb.localAbsolutePath, null, currentBaseProps, currentActualProps, regularPropChanges);
            newActualProps = info.newActualProperties;
            newBaseProps = info.newBaseProperties;
            propState[0] = info.mergeOutcome;
            conflictSkel = info.conflictSkel;
            allWorkItems = SVNWCContext.wqMerge(allWorkItems, info.workItems);
            newActualProps.removeNullValues();
            newBaseProps.removeNullValues();
            File installFrom = null;
            if (!fb.obstructionFound && !fb.editObstructed) {
                MergeFileInfo fileInfo = new MergeFileInfo();
                fileInfo.conflictSkel = conflictSkel;
                fileInfo.workItem = allWorkItems;
                try {
                    fileInfo = this.mergeFile(fb, fileInfo, currentActualProps, fb.changedDate);
                    contentState = fileInfo.contentState;
                    installFrom = fileInfo.installFrom;
                    installPristine = fileInfo.installPristine;
                    conflictSkel = fileInfo.conflictSkel;
                }
                catch (SVNException e) {
                    if (SVNWCContext.isErrorAccess(e)) {
                        this.doNotification(fb.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.UPDATE_SKIP_ACCESS_DENINED, fb.getURL(), fb.getPreviousURL());
                        this.rememberSkippedTree(fb.localAbsolutePath);
                        fb.skipThis = true;
                        this.maybeBumpDirInfo(fb.bumpInfo);
                        return;
                    }
                    throw e;
                }
                if (fileInfo != null) {
                    allWorkItems = SVNWCContext.wqMerge(allWorkItems, fileInfo.workItem);
                }
            } else {
                installPristine = false;
                contentState = fb.newTextBaseSHA1Checksum != null ? SVNStatusType.CHANGED : SVNStatusType.UNCHANGED;
            }
            if (installPristine) {
                boolean recordFileInfo = installFrom == null;
                SVNSkel wi = this.myWCContext.wqBuildFileInstall(fb.localAbsolutePath, installFrom, this.myIsUseCommitTimes, recordFileInfo);
                allWorkItems = SVNWCContext.wqMerge(allWorkItems, wi);
            } else if (lockState == SVNStatusType.LOCK_UNLOCKED && !fb.obstructionFound) {
                SVNSkel wi = this.myWCContext.wqBuildSyncFileFlags(fb.localAbsolutePath);
                allWorkItems = SVNWCContext.wqMerge(allWorkItems, wi);
            }
            if (!installPristine && contentState == SVNStatusType.UNCHANGED) {
                keepRecordedInfo = true;
            }
            if (installFrom != null && !fb.localAbsolutePath.equals(installFrom)) {
                SVNSkel wi = this.myWCContext.wqBuildFileRemove(fb.localAbsolutePath, installFrom);
                allWorkItems = SVNWCContext.wqMerge(allWorkItems, wi);
            }
        } else {
            SVNProperties fakeActualProperties = fb.addingFile ? new SVNProperties() : currentBaseProps;
            info = new SVNWCContext.MergePropertiesInfo();
            info.newActualProperties = newActualProps;
            info.newBaseProperties = newBaseProps;
            info.conflictSkel = conflictSkel;
            info = this.myWCContext.mergeProperties3(info, fb.localAbsolutePath, null, currentBaseProps, fakeActualProperties, regularPropChanges);
            conflictSkel = info.conflictSkel;
            newActualProps = info.newActualProperties;
            newBaseProps = info.newBaseProperties;
            propState[0] = info.mergeOutcome;
            allWorkItems = SVNWCContext.wqMerge(allWorkItems, info.workItems);
            contentState = fb.newTextBaseSHA1Checksum != null ? SVNStatusType.CHANGED : SVNStatusType.UNCHANGED;
        }
        SvnChecksum newChecksum = fb.newTextBaseSHA1Checksum;
        if (newChecksum == null) {
            newChecksum = fb.originalChecksum;
        }
        if (conflictSkel != null) {
            this.completeConflict(conflictSkel, fb.localAbsolutePath, fb.oldReposRelPath, fb.oldRevision, fb.newRelativePath, SVNNodeKind.FILE, SVNNodeKind.FILE);
            SVNSkel workItem = this.myWCContext.conflictCreateMarker(conflictSkel, fb.localAbsolutePath);
            allWorkItems = SVNWCContext.wqMerge(allWorkItems, workItem);
        }
        if (this.myInheritableProperties != null && (iprops = this.myInheritableProperties.get(fb.localAbsolutePath)) != null) {
            this.myInheritableProperties.remove(fb.localAbsolutePath);
        }
        if (davProps != null) {
            davProps.removeNullValues();
        }
        iprops = null;
        if (this.myInheritableProperties != null) {
            iprops = this.myInheritableProperties.remove(fb.localAbsolutePath);
        }
        this.myWCContext.getDb().addBaseFile(fb.localAbsolutePath, fb.newRelativePath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, newBaseProps, fb.changedRevison, fb.changedDate, fb.changedAuthor, newChecksum, davProps != null && !davProps.isEmpty() ? davProps : null, fb.addExisted && fb.addingFile, !fb.shadowed && newBaseProps != null, newActualProps, keepRecordedInfo, fb.shadowed && fb.obstructionFound, iprops, conflictSkel, allWorkItems);
        if (conflictSkel != null && this.myConflictHandler != null) {
            this.myWCContext.invokeConflictResolver(fb.localAbsolutePath, conflictSkel, this.myConflictHandler, ISVNCanceller.NULL);
        }
        if (fb.directoryBaton.notPresentFiles != null) {
            fb.directoryBaton.notPresentFiles.remove(fb.name);
        }
        if (this.myWCContext.getEventHandler() != null && !fb.alreadyNotified && (fb.edited || lockState == SVNStatusType.LOCK_UNLOCKED)) {
            SVNEventAction action = SVNEventAction.UPDATE_UPDATE;
            if (fb.edited) {
                if (fb.shadowed || fb.editObstructed) {
                    action = fb.addingFile ? SVNEventAction.UPDATE_SHADOWED_ADD : SVNEventAction.UPDATE_SHADOWED_UPDATE;
                } else if (fb.obstructionFound || fb.addExisted) {
                    if (contentState != SVNStatusType.CONFLICTED) {
                        action = SVNEventAction.UPDATE_EXISTS;
                    }
                } else if (fb.addingFile) {
                    action = SVNEventAction.UPDATE_ADD;
                }
            } else {
                assert (lockState == SVNStatusType.LOCK_UNLOCKED);
                action = SVNEventAction.UPDATE_BROKEN_LOCK;
            }
            String mimeType = this.myWCContext.getProperty(fb.localAbsolutePath, "svn:mime-type");
            SVNEvent event = SVNEventFactory.createSVNEvent(fb.localAbsolutePath, SVNNodeKind.FILE, mimeType, this.myTargetRevision, contentState, propState[0], lockState, action, null, null, null);
            SVNURL url = fb.getURL();
            event.setPreviousRevision(fb.oldRevision);
            event.setURL(url);
            this.myWCContext.getEventHandler().handleEvent(event, 0.0);
        }
        this.maybeBumpDirInfo(fb.bumpInfo);
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.rootOpened && ("".equals(this.myTargetBasename) || this.myTargetBasename == null)) {
            this.myWCContext.getDb().opSetBaseIncompleteTemp(this.myAnchorAbspath, false);
        }
        if (!this.myIsTargetDeleted) {
            this.myWCContext.getDb().opBumpRevisionPostUpdate(this.myTargetAbspath, this.myRequestedDepth, this.mySwitchRelpath, this.myReposRootURL, this.myReposUuid, this.myTargetRevision, this.mySkippedTrees, this.myInheritableProperties, this.myWCContext.getEventHandler());
            if (this.myTargetBasename == null || "".equals(this.myTargetBasename)) {
                ISVNWCDb.SVNWCDbStatus status = null;
                boolean error = false;
                try {
                    status = this.myWCContext.getDb().getBaseInfo((File)this.myTargetAbspath, (ISVNWCDb.WCDbBaseInfo.BaseInfoField[])new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.status}).status;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                        throw e;
                    }
                    error = true;
                }
                if (!error && status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    this.myWCContext.getDb().removeBase(this.myTargetAbspath);
                }
            }
        }
        this.myWCContext.wqRun(this.myAnchorAbspath);
        return null;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public void applyTextDelta(String path, String expectedChecksum) throws SVNException {
        InputStream source;
        FileBaton fb = this.myCurrentFile;
        if (fb.skipThis) {
            return;
        }
        fb.markEdited();
        SvnChecksum expectedBaseChecksum = expectedChecksum != null ? new SvnChecksum(SvnChecksum.Kind.md5, expectedChecksum) : null;
        SvnChecksum recordedBaseChecksum = fb.originalChecksum;
        if (recordedBaseChecksum != null && expectedBaseChecksum != null && recordedBaseChecksum.getKind() != SvnChecksum.Kind.md5) {
            recordedBaseChecksum = this.myWCContext.getDb().getPristineMD5(this.myAnchorAbspath, recordedBaseChecksum);
        }
        if (recordedBaseChecksum != null && expectedBaseChecksum != null && !expectedBaseChecksum.equals(recordedBaseChecksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}'':\n    expected:  ''{1}''\n   recorded:  ''{2}''\n", fb.localAbsolutePath, expectedBaseChecksum, recordedBaseChecksum);
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        if (!fb.addingFile) {
            source = this.myWCContext.getDb().readPristine(fb.localAbsolutePath, fb.originalChecksum);
            if (source == null) {
                source = SVNFileUtil.DUMMY_IN;
            }
        } else {
            source = SVNFileUtil.DUMMY_IN;
        }
        if (recordedBaseChecksum == null) {
            recordedBaseChecksum = expectedBaseChecksum;
        }
        if (recordedBaseChecksum != null) {
            fb.expectedSourceChecksum = new SvnChecksum(recordedBaseChecksum.getKind(), recordedBaseChecksum.getDigest());
            if (source != SVNFileUtil.DUMMY_IN) {
                source = new SVNChecksumInputStream(source, "MD5");
                fb.sourceChecksumStream = (SVNChecksumInputStream)source;
            }
        }
        SVNWCContext.WritableBaseInfo openWritableBase = this.myWCContext.openWritableBase(fb.localAbsolutePath, false, true);
        OutputStream target = openWritableBase.stream;
        fb.newTextBaseTmpAbsPath = openWritableBase.tempBaseAbspath;
        this.myDeltaProcessor.applyTextDelta(source, target, true);
        fb.newTextBaseSHA1ChecksumStream = openWritableBase.sha1ChecksumStream;
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.myCurrentFile.skipThis) {
            return SVNFileUtil.DUMMY_OUT;
        }
        try {
            this.myDeltaProcessor.textDeltaChunk(diffWindow);
        }
        catch (SVNException svne) {
            this.myDeltaProcessor.textDeltaEnd();
            SVNFileUtil.deleteFile(this.myCurrentFile.newTextBaseTmpAbsPath);
            this.myCurrentFile.newTextBaseTmpAbsPath = null;
            throw svne;
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        if (this.myCurrentFile.skipThis) {
            return;
        }
        this.myCurrentFile.newTextBaseMD5Digest = this.myDeltaProcessor.textDeltaEnd();
        if (this.myCurrentFile.newTextBaseSHA1ChecksumStream != null) {
            this.myCurrentFile.newTextBaseSHA1Checksum = new SvnChecksum(SvnChecksum.Kind.sha1, this.myCurrentFile.newTextBaseSHA1ChecksumStream.getDigest());
        }
        if (this.myCurrentFile.expectedSourceChecksum != null && this.myCurrentFile.expectedSourceChecksum.getKind() == SvnChecksum.Kind.md5) {
            String actualSourceChecksum;
            String string = actualSourceChecksum = this.myCurrentFile.sourceChecksumStream != null ? this.myCurrentFile.sourceChecksumStream.getDigest() : null;
            if (!this.myCurrentFile.expectedSourceChecksum.getDigest().equals(actualSourceChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch while updating ''{0}''; expected: ''{1}'', actual: ''{2}''", this.myCurrentFile.localAbsolutePath, this.myCurrentFile.expectedSourceChecksum.getDigest(), actualSourceChecksum);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (this.myCurrentFile.newTextBaseTmpAbsPath != null && this.myCurrentFile.newTextBaseSHA1Checksum != null && this.myCurrentFile.newTextBaseMD5Digest != null) {
            this.myWCContext.getDb().installPristine(this.myCurrentFile.newTextBaseTmpAbsPath, this.myCurrentFile.newTextBaseSHA1Checksum, new SvnChecksum(SvnChecksum.Kind.md5, this.myCurrentFile.newTextBaseMD5Digest));
        }
        if (this.myCurrentFile.originalChecksum != null && this.myCurrentFile.newTextBaseSHA1Checksum != null && this.myCurrentFile.originalChecksum.equals(this.myCurrentFile.newTextBaseSHA1Checksum)) {
            this.myCurrentFile.newTextBaseSHA1Checksum = null;
        }
    }

    private DirectoryBaton makeDirectoryBaton(String path, DirectoryBaton parent, boolean adding) throws SVNException {
        DirectoryBaton d = new DirectoryBaton();
        if (path != null) {
            d.name = SVNPathUtil.tail(path);
            d.localAbsolutePath = SVNFileUtil.createFilePath(parent.localAbsolutePath, d.name);
        } else {
            d.name = null;
            d.localAbsolutePath = this.myAnchorAbspath;
        }
        if (this.mySwitchRelpath != null) {
            if (parent == null) {
                if ("".equals(this.myTargetBasename) || this.myTargetBasename == null) {
                    d.newRelativePath = this.mySwitchRelpath;
                } else {
                    d.newRelativePath = this.myWCContext.getDb().scanBaseRepository((File)((DirectoryBaton)d).localAbsolutePath, (ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[])new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath}).relPath;
                }
            } else if (parent.parentBaton == null && this.myTargetBasename.equals(d.name)) {
                d.newRelativePath = this.mySwitchRelpath;
            } else {
                d.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, d.name);
            }
        } else if (adding) {
            d.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, d.name);
        } else {
            d.newRelativePath = this.myWCContext.getDb().scanBaseRepository((File)((DirectoryBaton)d).localAbsolutePath, (ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[])new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath}).relPath;
        }
        BumpDirectoryInfo bdi = new BumpDirectoryInfo();
        bdi.parent = parent != null ? parent.bumpInfo : null;
        bdi.refCount = 1;
        if (parent != null) {
            bdi.parent.refCount++;
        }
        d.parentBaton = parent;
        d.bumpInfo = bdi;
        d.oldRevision = -1L;
        d.addingDir = adding;
        d.changedRevsion = -1L;
        d.notPresentFiles = new HashSet();
        if (parent != null) {
            d.skipThis = parent.skipThis;
            d.shadowed = parent.shadowed || parent.editedObstructed;
        }
        d.ambientDepth = SVNDepth.UNKNOWN;
        d.propChanges = new SVNProperties();
        return d;
    }

    private FileBaton makeFileBaton(DirectoryBaton parent, String path, boolean adding) throws SVNException {
        FileBaton f = new FileBaton();
        f.name = SVNPathUtil.tail(path);
        f.oldRevision = -1L;
        f.localAbsolutePath = SVNFileUtil.createFilePath(parent.localAbsolutePath, f.name);
        if (this.mySwitchRelpath != null) {
            if (parent.parentBaton == null && this.myTargetBasename != null && f.name.equals(this.myTargetBasename)) {
                f.newRelativePath = this.mySwitchRelpath;
            } else {
                f.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, f.name);
            }
        } else if (adding) {
            f.newRelativePath = SVNFileUtil.createFilePath(parent.newRelativePath, f.name);
        } else {
            f.newRelativePath = this.myWCContext.getDb().scanBaseRepository((File)((FileBaton)f).localAbsolutePath, (ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[])new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.relPath}).relPath;
        }
        f.bumpInfo = parent.bumpInfo;
        f.addingFile = adding;
        f.skipThis = parent.skipThis;
        f.shadowed = parent.shadowed | parent.editedObstructed;
        f.directoryBaton = parent;
        f.changedRevison = -1L;
        f.bumpInfo.refCount++;
        f.propChanges = new SVNProperties();
        return f;
    }

    private static boolean isNodePresent(ISVNWCDb.SVNWCDbStatus status) {
        return status != ISVNWCDb.SVNWCDbStatus.ServerExcluded && status != ISVNWCDb.SVNWCDbStatus.Excluded && status != ISVNWCDb.SVNWCDbStatus.NotPresent;
    }

    private SVNTreeConflictDescription createTreeConflict(File localAbspath, SVNConflictReason reason, SVNConflictAction action, SVNNodeKind theirNodeKind, File theirRelpath) throws SVNException {
        SVNNodeKind conflictNodeKind;
        File rightReposRelpath;
        SVNURL reposRootUrl;
        File leftReposRelpath;
        long leftRevision;
        assert (reason != null);
        SVNNodeKind leftKind = null;
        File addedReposRelpath = null;
        if (reason == SVNConflictReason.ADDED) {
            leftKind = SVNNodeKind.NONE;
            leftRevision = -1L;
            leftReposRelpath = null;
            ISVNWCDb.WCDbAdditionInfo scanAddition = this.myWCContext.getDb().scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRelPath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl);
            ISVNWCDb.SVNWCDbStatus addedStatus = scanAddition.status;
            addedReposRelpath = scanAddition.reposRelPath;
            reposRootUrl = scanAddition.reposRootUrl;
            assert (addedStatus == ISVNWCDb.SVNWCDbStatus.Added || addedStatus == ISVNWCDb.SVNWCDbStatus.Copied || addedStatus == ISVNWCDb.SVNWCDbStatus.MovedHere);
        } else if (reason == SVNConflictReason.UNVERSIONED) {
            leftKind = SVNNodeKind.NONE;
            leftRevision = -1L;
            leftReposRelpath = null;
            reposRootUrl = this.myReposRootURL;
        } else {
            assert (reason == SVNConflictReason.EDITED || reason == SVNConflictReason.DELETED || reason == SVNConflictReason.REPLACED || reason == SVNConflictReason.OBSTRUCTED);
            ISVNWCDb.WCDbBaseInfo baseInfo = this.myWCContext.getDb().getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl);
            ISVNWCDb.SVNWCDbKind baseKind = baseInfo.kind;
            leftRevision = baseInfo.revision;
            leftReposRelpath = baseInfo.reposRelPath;
            reposRootUrl = baseInfo.reposRootUrl;
            if (baseKind == ISVNWCDb.SVNWCDbKind.File || baseKind == ISVNWCDb.SVNWCDbKind.Symlink) {
                leftKind = SVNNodeKind.FILE;
            } else if (baseKind == ISVNWCDb.SVNWCDbKind.Dir) {
                leftKind = SVNNodeKind.DIR;
            } else {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL), SVNLogType.WC);
            }
        }
        assert (reposRootUrl.equals(this.myReposRootURL));
        if (this.mySwitchRelpath != null) {
            if (theirRelpath != null) {
                rightReposRelpath = theirRelpath;
            } else {
                rightReposRelpath = this.mySwitchRelpath;
                rightReposRelpath = SVNFileUtil.createFilePath(rightReposRelpath.getPath() + "_THIS_IS_INCOMPLETE");
            }
        } else {
            File file = rightReposRelpath = reason == SVNConflictReason.ADDED ? addedReposRelpath : leftReposRelpath;
            if (rightReposRelpath == null) {
                rightReposRelpath = theirRelpath;
            }
        }
        assert (rightReposRelpath != null);
        SVNNodeKind sVNNodeKind = conflictNodeKind = action == SVNConflictAction.DELETE ? leftKind : theirNodeKind;
        assert (conflictNodeKind == SVNNodeKind.FILE || conflictNodeKind == SVNNodeKind.DIR);
        SVNConflictVersion srcLeftVersion = leftReposRelpath == null ? null : new SVNConflictVersion(reposRootUrl, leftReposRelpath.getPath(), leftRevision, leftKind);
        SVNConflictVersion srcRightVersion = new SVNConflictVersion(reposRootUrl, rightReposRelpath.getPath(), this.myTargetRevision, theirNodeKind);
        return new SVNTreeConflictDescription(localAbspath, conflictNodeKind, action, reason, this.mySwitchRelpath != null ? SVNOperation.SWITCH : SVNOperation.UPDATE, srcLeftVersion, srcRightVersion);
    }

    private void maybeBumpDirInfo(BumpDirectoryInfo bdi) throws SVNException {
        while (bdi != null) {
            if (--bdi.refCount > 0) {
                return;
            }
            bdi = bdi.parent;
        }
    }

    public static AccumulatedChangeInfo accumulateLastChange(File localAbspath, SVNProperties entryProps) throws SVNException {
        AccumulatedChangeInfo info = new AccumulatedChangeInfo();
        info.changedRev = -1L;
        info.changedDate = null;
        info.changedAuthor = null;
        if (entryProps != null) {
            for (String propertyName : entryProps.nameSet()) {
                String propertyValue = entryProps.getStringValue(propertyName);
                if (propertyValue == null) continue;
                if ("svn:entry:last-author".equals(propertyName)) {
                    info.changedAuthor = propertyValue;
                    continue;
                }
                if ("svn:entry:committed-rev".equals(propertyName)) {
                    info.changedRev = Long.valueOf(propertyValue);
                    continue;
                }
                if (!"svn:entry:committed-date".equals(propertyName)) continue;
                info.changedDate = SVNDate.parseDate(propertyValue);
            }
        }
        return info;
    }

    public static SVNWCContext.MergeInfo performFileMerge(SVNWCContext.MergeInfo mergeInfo, SVNWCContext context, File localAbsPath, File wriAbsPath, SvnChecksum newChecksum, SvnChecksum originalChecksum, SVNProperties actualProperties, String[] extPatterns, long oldRevision, long targetRevision, SVNProperties propChanges) throws SVNException {
        File mergeLeft = null;
        boolean deleteLeft = false;
        File newTextBaseTmpAbsPath = context.getDb().getPristinePath(wriAbsPath, newChecksum);
        if (extPatterns == null || extPatterns.length > 0) {
            // empty if block
        }
        if (oldRevision < 0L) {
            oldRevision = 0L;
        }
        String oldRevStr = String.format(".r%s%s%s", oldRevision, "", "");
        String newRevStr = String.format(".r%s%s%s", targetRevision, "", "");
        String mineStr = String.format(".mine%s%s", "", "");
        if (originalChecksum == null) {
            File tmpDir = context.getDb().getWCRootTempDir(wriAbsPath);
            mergeLeft = SVNFileUtil.createUniqueFile(tmpDir, "file", "tmp", false);
            deleteLeft = true;
        } else {
            mergeLeft = context.getDb().getPristinePath(wriAbsPath, originalChecksum);
        }
        mergeInfo = context.merge(mergeInfo.workItems, mergeInfo.conflictSkel, mergeLeft, newTextBaseTmpAbsPath, localAbsPath, wriAbsPath, oldRevStr, newRevStr, mineStr, actualProperties, false, null, propChanges);
        boolean bl = mergeInfo.foundTextConflict = mergeInfo.mergeOutcome == SVNStatusType.CONFLICTED;
        if (deleteLeft) {
            SVNSkel workItem = context.wqBuildFileRemove(wriAbsPath, mergeLeft);
            SVNWCContext.wqMerge(mergeInfo.workItems, workItem);
        }
        return mergeInfo;
    }

    private MergeFileInfo mergeFile(FileBaton fb, MergeFileInfo mergeFileInfo, SVNProperties actualProps, SVNDate lastChangedDate) throws SVNException {
        DirectoryBaton pb = fb.directoryBaton;
        boolean magicPropsChanged = false;
        boolean foundTextConflict = false;
        assert (!(fb.shadowed || fb.obstructionFound || fb.editObstructed));
        if (mergeFileInfo == null) {
            mergeFileInfo = new MergeFileInfo();
        }
        mergeFileInfo.workItem = null;
        mergeFileInfo.installPristine = false;
        mergeFileInfo.contentState = SVNStatusType.UNCHANGED;
        mergeFileInfo.installFrom = null;
        boolean isLocallyModified = fb.addingFile && !fb.addExisted ? false : this.myWCContext.isTextModified(fb.localAbsolutePath, false);
        SVNProperties propChanges = fb.propChanges;
        if (!isLocallyModified && fb.newTextBaseSHA1Checksum != null) {
            mergeFileInfo.installPristine = true;
        } else if (fb.newTextBaseSHA1Checksum != null) {
            SVNWCContext.MergeInfo mergeInfo = new SVNWCContext.MergeInfo();
            mergeInfo.conflictSkel = mergeFileInfo.conflictSkel;
            mergeInfo.workItems = mergeFileInfo.workItem;
            mergeInfo = SVNUpdateEditor17.performFileMerge(mergeInfo, this.myWCContext, fb.localAbsolutePath, pb.localAbsolutePath, fb.newTextBaseSHA1Checksum, fb.addExisted ? null : fb.originalChecksum, actualProps, this.myExtensionPatterns, fb.oldRevision, this.myTargetRevision, propChanges);
            mergeFileInfo.workItem = SVNWCContext.wqMerge(mergeFileInfo.workItem, mergeInfo.workItems);
            mergeFileInfo.contentState = mergeInfo.mergeOutcome;
            mergeFileInfo.conflictSkel = mergeInfo.conflictSkel;
            foundTextConflict = mergeInfo.foundTextConflict;
        } else {
            magicPropsChanged = SVNWCContext.hasMagicProperty(propChanges);
            SVNWCContext.TranslateInfo translateInfo = this.myWCContext.getTranslateInfo(fb.localAbsolutePath, actualProps, true, false, false, true, false);
            if (magicPropsChanged || translateInfo.keywords != null && !translateInfo.keywords.isEmpty()) {
                if (isLocallyModified) {
                    File tmpText = null;
                    tmpText = this.myWCContext.getTranslatedFile(fb.localAbsolutePath, fb.localAbsolutePath, true, true, false, false, false);
                    mergeFileInfo.installPristine = true;
                    mergeFileInfo.installFrom = tmpText;
                } else {
                    mergeFileInfo.installPristine = true;
                }
            }
        }
        mergeFileInfo.contentState = foundTextConflict ? SVNStatusType.CONFLICTED : (fb.newTextBaseSHA1Checksum != null ? (isLocallyModified ? SVNStatusType.MERGED : SVNStatusType.CHANGED) : SVNStatusType.UNCHANGED);
        return mergeFileInfo;
    }

    public void completeConflict(SVNSkel conflict, File localAbsPath, File oldReposRelPath, long oldRevision, File newReposRelPath, SVNNodeKind localKind, SVNNodeKind targetKind) throws SVNException {
        if (conflict == null) {
            return;
        }
        boolean isComplete = SvnWcDbConflicts.isConflictSkelComplete(conflict);
        if (isComplete) {
            return;
        }
        SVNConflictVersion originalVersion = oldReposRelPath != null ? new SVNConflictVersion(this.myReposRootURL, SVNFileUtil.getFilePath(oldReposRelPath), oldRevision, localKind) : null;
        SVNConflictVersion targetVersion = newReposRelPath != null ? new SVNConflictVersion(this.myReposRootURL, SVNFileUtil.getFilePath(newReposRelPath), this.myTargetRevision, targetKind) : null;
        if (this.mySwitchRelpath != null) {
            SvnWcDbConflicts.conflictSkelOpSwitch(conflict, originalVersion, targetVersion);
        } else {
            SvnWcDbConflicts.conflictSkelOpUpdate(conflict, originalVersion, targetVersion);
        }
    }

    public static class AccumulatedChangeInfo {
        public long changedRev;
        public SVNDate changedDate;
        public String changedAuthor;
    }

    private static class AlreadyInTreeConflictInfo {
        public boolean conflicted;
        public boolean ignored;

        private AlreadyInTreeConflictInfo(boolean conflicted, boolean ignored) {
            this.conflicted = conflicted;
            this.ignored = ignored;
        }
    }

    private static class BumpDirectoryInfo {
        private int refCount;
        private BumpDirectoryInfo parent;

        private BumpDirectoryInfo() {
        }
    }

    private class DirectoryBaton {
        private String name;
        private File localAbsolutePath;
        private File newRelativePath;
        private long oldRevision;
        private File oldReposRelPath;
        DirectoryBaton parentBaton;
        private boolean skipThis;
        private boolean alreadyNotified;
        private boolean addingDir;
        private boolean shadowed;
        private boolean editedObstructed;
        private long changedRevsion;
        private SVNDate changedDate;
        private String changedAuthor;
        private Map<String, SVNSkel> deletionConflicts;
        private Set<String> notPresentFiles;
        private boolean obstructionFound;
        private boolean addExisted;
        private SVNProperties propChanges;
        private boolean edited;
        private SVNSkel editConflict;
        private BumpDirectoryInfo bumpInfo;
        private SVNDepth ambientDepth;
        private boolean wasIncomplete;

        private DirectoryBaton() {
        }

        public void markEdited() throws SVNException {
            if (this.edited) {
                return;
            }
            if (this.parentBaton != null) {
                this.parentBaton.markEdited();
            }
            this.edited = true;
            if (this.editConflict != null) {
                SVNUpdateEditor17.this.completeConflict(this.editConflict, this.localAbsolutePath, this.oldReposRelPath, this.oldRevision, this.newRelativePath, SVNNodeKind.DIR, SVNNodeKind.DIR);
                SVNUpdateEditor17.this.myWCContext.getDb().opMarkConflict(this.localAbsolutePath, this.editConflict, null);
                SVNUpdateEditor17.this.doNotification(this.localAbsolutePath, SVNNodeKind.DIR, SVNEventAction.TREE_CONFLICT, this.getURL(), this.getPreviousURL());
                this.alreadyNotified = true;
            }
        }

        public SVNURL getURL() throws SVNException {
            if (this.newRelativePath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.newRelativePath);
            }
            return null;
        }

        public SVNURL getPreviousURL() throws SVNException {
            if (this.oldReposRelPath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.oldReposRelPath);
            }
            return null;
        }
    }

    private class FileBaton {
        private String name;
        private File localAbsolutePath;
        private File newRelativePath;
        private long oldRevision;
        private File oldReposRelPath;
        private DirectoryBaton directoryBaton;
        private boolean skipThis;
        private boolean alreadyNotified;
        private boolean addingFile;
        private boolean obstructionFound;
        private boolean addExisted;
        private boolean shadowed;
        private boolean editObstructed;
        private long changedRevison;
        private SVNDate changedDate;
        private String changedAuthor;
        private SvnChecksum newTextBaseMd5Checksum;
        private SvnChecksum newTextBaseSha1Checksum;
        private SvnChecksum originalChecksum;
        private SVNProperties propChanges;
        private boolean localPropMods;
        private BumpDirectoryInfo bumpInfo;
        private boolean edited;
        private SVNSkel editConflict;
        File newTextBaseTmpAbsPath;
        SVNChecksumInputStream sourceChecksumStream;
        SVNChecksumOutputStream newTextBaseSHA1ChecksumStream;
        SvnChecksum expectedSourceChecksum;
        String newTextBaseMD5Digest;
        public SvnChecksum newTextBaseSHA1Checksum;

        private FileBaton() {
        }

        public void markEdited() throws SVNException {
            if (this.edited) {
                return;
            }
            if (this.directoryBaton != null) {
                this.directoryBaton.markEdited();
            }
            this.edited = true;
            if (this.editConflict != null) {
                SVNUpdateEditor17.this.completeConflict(this.editConflict, this.localAbsolutePath, this.oldReposRelPath, this.oldRevision, this.newRelativePath, SVNNodeKind.FILE, SVNNodeKind.FILE);
                SVNUpdateEditor17.this.myWCContext.getDb().opMarkConflict(this.localAbsolutePath, this.editConflict, null);
                SVNUpdateEditor17.this.doNotification(this.localAbsolutePath, SVNNodeKind.FILE, SVNEventAction.TREE_CONFLICT, this.getURL(), this.getPreviousURL());
                this.alreadyNotified = true;
            }
        }

        public SVNURL getURL() throws SVNException {
            if (this.newRelativePath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.newRelativePath);
            }
            return null;
        }

        public SVNURL getPreviousURL() throws SVNException {
            if (this.oldReposRelPath != null) {
                return SVNWCUtils.join(SVNUpdateEditor17.this.myReposRootURL, this.oldReposRelPath);
            }
            return null;
        }
    }

    private static class MergeFileInfo {
        public SVNSkel workItem;
        public boolean installPristine;
        public File installFrom;
        public SVNStatusType contentState;
        public SVNSkel conflictSkel;

        private MergeFileInfo() {
        }
    }

    private static class NodeAlreadyConflictedInfo {
        public boolean conflicted;
        public boolean conflictIgnored;

        private NodeAlreadyConflictedInfo() {
        }
    }
}

