/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.ISVNFileContentFetcher;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPropertiesManager {
    private static final Collection NOT_ALLOWED_FOR_FILE = new SVNHashSet();
    private static final Collection NOT_ALLOWED_FOR_DIR = new SVNHashSet();

    public static void validateRevisionProperties(SVNProperties revisionProperties) throws SVNException {
        if (SVNPropertiesManager.hasSVNProperties(revisionProperties)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Standard properties can't be set explicitly as revision properties");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
    }

    public static boolean setWCProperty(SVNWCAccess access, File path, String propName, SVNPropertyValue propValue, boolean write) throws SVNException {
        SVNEntry entry = access.getVersionedEntry(path, false);
        SVNAdminArea dir = entry.getKind() == SVNNodeKind.DIR ? access.retrieve(path) : access.retrieve(path.getParentFile());
        SVNVersionedProperties wcProps = dir.getWCProperties(entry.getName());
        SVNPropertyValue oldValue = wcProps.getPropertyValue(propName);
        wcProps.setPropertyValue(propName, propValue);
        if (write) {
            dir.saveWCProperties(false);
        }
        return oldValue == null ? propValue != null : !oldValue.equals(propValue);
    }

    public static SVNPropertyValue getWCProperty(SVNWCAccess access, File path, String propName) throws SVNException {
        SVNEntry entry = access.getEntry(path, false);
        if (entry == null) {
            return null;
        }
        SVNAdminArea dir = entry.getKind() == SVNNodeKind.DIR ? access.retrieve(path) : access.retrieve(path.getParentFile());
        return dir.getWCProperties(entry.getName()).getPropertyValue(propName);
    }

    public static void deleteWCProperties(SVNAdminArea dir, String name, boolean recursive) throws SVNException {
        SVNVersionedProperties props;
        if (name != null && (props = dir.getWCProperties(name)) != null) {
            props.removeAll();
        }
        if (recursive || name == null) {
            Iterator entries = dir.entries(false);
            while (entries.hasNext()) {
                SVNEntry entry = (SVNEntry)entries.next();
                SVNVersionedProperties props2 = dir.getWCProperties(entry.getName());
                if (props2 != null) {
                    props2.removeAll();
                }
                if (entry.isFile() || dir.getThisDirName().equals(entry.getName()) || !recursive) continue;
                SVNAdminArea childDir = dir.getWCAccess().retrieve(dir.getFile(entry.getName()));
                SVNPropertiesManager.deleteWCProperties(childDir, null, true);
            }
        }
        dir.saveWCProperties(false);
    }

    public static SVNPropertyValue getProperty(SVNWCAccess access, File path, String propName) throws SVNException {
        SVNEntry entry = access.getEntry(path, false);
        if (entry == null) {
            return null;
        }
        String[] cachableProperties = entry.getCachableProperties();
        if (cachableProperties != null && SVNPropertiesManager.contains(cachableProperties, propName)) {
            String[] presentProperties = entry.getPresentProperties();
            if (presentProperties == null || !SVNPropertiesManager.contains(presentProperties, propName)) {
                return null;
            }
            if (SVNProperty.isBooleanProperty(propName)) {
                return SVNProperty.getValueOfBooleanProperty(propName);
            }
        }
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            return SVNPropertiesManager.getWCProperty(access, path, propName);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", (Object)propName);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SVNAdminArea dir = entry.getKind() == SVNNodeKind.DIR ? access.retrieve(path) : access.retrieve(path.getParentFile());
        return dir.getProperties(entry.getName()).getPropertyValue(propName);
    }

    public static boolean setProperty(final SVNWCAccess access, final File path, String propName, SVNPropertyValue propValue, boolean skipChecks) throws SVNException {
        boolean modified;
        SVNVersionedProperties properties;
        SVNPropertyValue oldValue;
        boolean updateTimeStamp;
        SVNEntry entry;
        if (SVNProperty.isWorkingCopyProperty(propName)) {
            return SVNPropertiesManager.setWCProperty(access, path, propName, propValue, true);
        }
        if (SVNProperty.isEntryProperty(propName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", (Object)propName);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SVNAdminArea dir = (entry = access.getVersionedEntry(path, false)).isDirectory() ? access.retrieve(path) : access.retrieve(path.getParentFile());
        boolean bl = updateTimeStamp = "svn:eol-style".equals(propName) || "svnkit:charset".equals(propName);
        if (propValue != null && SVNProperty.isSVNProperty(propName)) {
            propValue = SVNPropertiesManager.validatePropertyValue(path, entry.getKind(), propName, propValue, skipChecks, access.getOptions(), new ISVNFileContentFetcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fetchFileContent(OutputStream os) throws SVNException {
                    InputStream is = SVNFileUtil.openFileForReading(path, SVNLogType.WC);
                    try {
                        SVNTranslator.copy(is, os);
                    }
                    catch (IOExceptionWrapper ioew) {
                        throw ioew.getOriginalException();
                    }
                    catch (IOException e) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR), e, SVNLogType.DEFAULT);
                    }
                    finally {
                        SVNFileUtil.closeFile(is);
                    }
                }

                public boolean fileIsBinary() throws SVNException {
                    SVNPropertyValue mimeType = SVNPropertiesManager.getProperty(access, path, "svn:mime-type");
                    return mimeType != null && SVNProperty.isBinaryMimeType(mimeType.getString());
                }

                public SVNPropertyValue getProperty(String propertyName) throws SVNException {
                    return SVNPropertiesManager.getProperty(access, path, propertyName);
                }
            });
        }
        if (entry.getKind() == SVNNodeKind.FILE && "svn:executable".equals(propName)) {
            if (propValue == null) {
                SVNFileUtil.setExecutable(path, false);
            } else {
                propValue = SVNProperty.getValueOfBooleanProperty(propName);
                SVNFileUtil.setExecutable(path, true);
            }
        }
        if (entry.getKind() == SVNNodeKind.FILE && "svn:needs-lock".equals(propName)) {
            if (propValue == null) {
                SVNFileUtil.setReadonly(path, false);
            } else {
                propValue = SVNProperty.getValueOfBooleanProperty(propName);
            }
        }
        SVNEventAction action = (oldValue = (properties = dir.getProperties(entry.getName())).getPropertyValue(propName)) == null ? (propValue == null ? SVNEventAction.PROPERTY_DELETE_NONEXISTENT : SVNEventAction.PROPERTY_ADD) : (propValue == null ? SVNEventAction.PROPERTY_DELETE : SVNEventAction.PROPERTY_MODIFY);
        if (!updateTimeStamp && entry.getKind() == SVNNodeKind.FILE && "svn:keywords".equals(propName)) {
            Collection oldKeywords = SVNPropertiesManager.getKeywords(oldValue == null ? null : oldValue.getString());
            Collection newKeywords = SVNPropertiesManager.getKeywords(propValue == null ? null : propValue.getString());
            updateTimeStamp = !((Object)oldKeywords).equals(newKeywords);
        }
        SVNLog log = dir.getLog();
        if (updateTimeStamp) {
            SVNProperties command = new SVNProperties();
            command.put("name", entry.getName());
            command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), (String)null);
            log.addCommand("modify-entry", command, false);
        }
        properties.setPropertyValue(propName, propValue);
        dir.saveVersionedProperties(log, false);
        log.save();
        dir.runLogs();
        boolean bl2 = oldValue == null ? propValue != null : (modified = !oldValue.equals(propValue));
        if (modified || action == SVNEventAction.PROPERTY_DELETE_NONEXISTENT) {
            dir.getWCAccess().handleEvent(new SVNEvent(path, entry.getKind(), null, -1L, null, null, null, null, action, action, null, null, null, null, null));
        }
        return modified;
    }

    public static SVNStatusType mergeProperties(SVNWCAccess wcAccess, File path, SVNProperties baseProperties, SVNProperties diff, boolean baseMerge, boolean dryRun) throws SVNException {
        SVNEntry entry = wcAccess.getVersionedEntry(path, false);
        File parent = null;
        String name = null;
        if (entry.isDirectory()) {
            parent = path;
            name = "";
        } else if (entry.isFile()) {
            parent = path.getParentFile();
            name = entry.getName();
        }
        SVNLog log = null;
        SVNAdminArea dir = wcAccess.retrieve(parent);
        if (!dryRun) {
            log = dir.getLog();
        }
        SVNStatusType result = dir.mergeProperties(name, baseProperties, diff, null, null, baseMerge, dryRun, log);
        if (!dryRun) {
            log.save();
            dir.runLogs();
        }
        return result;
    }

    public static Map computeAutoProperties(ISVNOptions options, File file, Map properties) throws SVNException {
        String mimeType;
        if (!(properties = options.applyAutoProperties(file, properties)).containsKey("svn:mime-type") && (mimeType = SVNFileUtil.detectMimeType(file, options.getFileExtensionsToMimeTypes())) != null) {
            properties.put("svn:mime-type", mimeType);
        }
        if (SVNProperty.isBinaryMimeType((String)properties.get("svn:mime-type"))) {
            properties.remove("svn:eol-style");
            properties.remove("svnkit:charset");
        }
        if (!properties.containsKey("svn:executable") && SVNFileUtil.isExecutable(file)) {
            properties.put("svn:executable", "");
        }
        return properties;
    }

    public static Map getWorkingCopyPropertyValues(File path, SVNEntry entry, final String propName, SVNDepth depth, final boolean base) throws SVNException {
        final SVNHashMap pathsToPropValues = new SVNHashMap();
        ISVNEntryHandler handler = new ISVNEntryHandler(){

            public void handleEntry(File itemPath, SVNEntry itemEntry) throws SVNException {
                SVNAdminArea adminArea = itemEntry.getAdminArea();
                if (itemEntry.isDirectory() && !itemEntry.getName().equals(adminArea.getThisDirName())) {
                    return;
                }
                if (itemEntry.isScheduledForAddition() && base || itemEntry.isScheduledForDeletion() && !base) {
                    return;
                }
                SVNPropertyValue propValue = null;
                SVNWCAccess access = adminArea.getWCAccess();
                if (base) {
                    SVNEntry pathEntry = access.getEntry(itemPath, false);
                    if (pathEntry != null) {
                        SVNAdminArea pathArea = pathEntry.getAdminArea();
                        SVNVersionedProperties baseProps = pathArea.getBaseProperties(pathEntry.getName());
                        propValue = baseProps.getPropertyValue(propName);
                    }
                } else {
                    SVNEntry pathEntry = access.getEntry(itemPath, true);
                    if (pathEntry != null) {
                        SVNAdminArea pathArea = pathEntry.getAdminArea();
                        SVNVersionedProperties workingProps = pathArea.getProperties(pathEntry.getName());
                        propValue = workingProps.getPropertyValue(propName);
                    }
                }
                if (propValue != null) {
                    pathsToPropValues.put(itemPath, propValue);
                }
            }

            public void handleError(File path, SVNErrorMessage error) throws SVNException {
                while (error.hasChildErrorMessage()) {
                    error = error.getChildErrorMessage();
                }
                if (error.getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    return;
                }
                SVNErrorManager.error(error, SVNLogType.WC);
            }
        };
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        SVNAdminArea adminArea = entry.getAdminArea();
        if (entry.isDirectory() && depth.compareTo(SVNDepth.FILES) >= 0) {
            SVNWCAccess wcAccess = adminArea.getWCAccess();
            wcAccess.walkEntries(path, handler, false, depth);
        } else {
            handler.handleEntry(path, entry);
        }
        return pathsToPropValues;
    }

    public static void recordWCMergeInfo(File path, Map mergeInfo, SVNWCAccess wcAccess) throws SVNException {
        SVNPropertyValue value = null;
        if (mergeInfo != null) {
            value = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo, null));
        }
        SVNPropertiesManager.setProperty(wcAccess, path, "svn:mergeinfo", value, true);
    }

    public static Map parseMergeInfo(File path, SVNEntry entry, boolean base) throws SVNException {
        Map fileToProp = SVNPropertiesManager.getWorkingCopyPropertyValues(path, entry, "svn:mergeinfo", SVNDepth.EMPTY, base);
        Map<String, SVNMergeRangeList> result = null;
        SVNPropertyValue propValue = (SVNPropertyValue)fileToProp.get(path);
        if (propValue != null && propValue.getString() != null) {
            result = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue.getString()), result);
        }
        return result;
    }

    public static boolean isValidPropertyName(String name) throws SVNException {
        if (name == null || name.length() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Property name is empty");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (!Character.isLetter(name.charAt(0)) && name.charAt(0) != ':' && name.charAt(0) != '_') {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '-' || name.charAt(i) == '.' || name.charAt(i) == ':' || name.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean propNeedsTranslation(String propertyName) {
        return SVNProperty.isSVNProperty(propertyName);
    }

    private static Collection getKeywords(String value) {
        SVNHashSet keywords = new SVNHashSet();
        if (value == null || "".equals(value.trim())) {
            return keywords;
        }
        StringTokenizer tokens = new StringTokenizer(value, " \t\n\r");
        while (tokens.hasMoreTokens()) {
            keywords.add(tokens.nextToken().toLowerCase());
        }
        return keywords;
    }

    private static boolean contains(String[] values, String value) {
        for (int i = 0; value != null && i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static SVNPropertyValue validatePropertyValue(Object path, SVNNodeKind kind, String name, SVNPropertyValue value, boolean force, ISVNOptions options, ISVNFileContentFetcher fileContentFetcher) throws SVNException {
        SVNErrorMessage error;
        if (value == null) {
            return value;
        }
        SVNPropertiesManager.validatePropertyName(path, name, kind);
        if (SVNProperty.isSVNProperty(name) && value.isString()) {
            String str = value.getString();
            str = str.replaceAll("\r\n", "\n");
            str = str.replace('\r', '\n');
            value = SVNPropertyValue.create(str);
        }
        if (!force && "svn:eol-style".equals(name)) {
            if (SVNTranslator.getEOL((value = SVNPropertyValue.create(value.getString().trim())).getString(), options) == null) {
                error = SVNErrorMessage.create(SVNErrorCode.IO_UNKNOWN_EOL, "Unrecognized line ending style for ''{0}''", path);
                SVNErrorManager.error(error, SVNLogType.DEFAULT);
            }
            SVNPropertiesManager.validateEOLProperty(path, fileContentFetcher);
        } else if (!force && "svnkit:charset".equals(name)) {
            value = SVNPropertyValue.create(value.getString().trim());
            try {
                SVNTranslator.getCharset(value.getString(), null, path, options);
            }
            catch (SVNException e) {
                SVNErrorMessage error2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Charset ''{0}'' is not supported on this computer", (Object)value.getString());
                SVNErrorManager.error(error2, SVNLogType.DEFAULT);
            }
            if (fileContentFetcher != null && fileContentFetcher.fileIsBinary()) {
                error = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has binary mime type property", path);
                SVNErrorManager.error(error, SVNLogType.DEFAULT);
            }
        } else if (!force && "svn:mime-type".equals(name)) {
            value = SVNPropertyValue.create(value.getString().trim());
            SVNPropertiesManager.validateMimeType(value.getString());
            if (SVNProperty.isBinaryMimeType(value.getString()) && fileContentFetcher != null && fileContentFetcher.getProperty("svn:eol-style") != null) {
                error = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has svn:eol-style property set and thus cannot have binary mime type", path);
                SVNErrorManager.error(error, SVNLogType.DEFAULT);
            }
        } else if ("svn:ignore".equals(name) || "svn:global-ignores".equals(name) || "svn:externals".equals(name)) {
            SVNExternal[] externals;
            List<String> duplicateTargets;
            if (!value.getString().endsWith("\n")) {
                value = SVNPropertyValue.create(value.getString().concat("\n"));
            }
            if ("svn:externals".equals(name) && (duplicateTargets = SVNExternal.findTargetDuplications(externals = SVNExternal.parseExternals(path, value.getString()))) != null && duplicateTargets.size() > 0) {
                StringBuilder moreString = new StringBuilder();
                if (duplicateTargets.size() > 1) {
                    moreString.append(" (").append(duplicateTargets.size()).append(" more duplicate targets found)");
                }
                String absolutePath = path instanceof File ? ((File)path).getAbsolutePath() : new File(path.toString()).getAbsolutePath();
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DUPLICATE_EXTERNALS_TARGET, "Invalid {0} property on ''{1}'': target ''{2}'' appears more than once{3}", "svn:externals", absolutePath, duplicateTargets.get(0), moreString.toString());
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        } else if ("svn:keywords".equals(name)) {
            value = SVNPropertyValue.create(value.getString().trim());
        } else if ("svn:executable".equals(name) || "svn:special".equals(name) || "svn:needs-lock".equals(name)) {
            value = SVNPropertyValue.create("*");
        } else if ("svn:mergeinfo".equals(name)) {
            Map<String, SVNMergeRangeList> mergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(value.getString()), null);
            if (kind != SVNNodeKind.DIR && SVNMergeInfoUtil.isNonInheritable(mergeInfo)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Cannot set non-inheritable mergeinfo on a non-directory (''{0}'')", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (mergeInfo != null) {
                value = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo, null));
            }
        }
        return value;
    }

    private static boolean hasSVNProperties(SVNProperties props) {
        if (props == null) {
            return false;
        }
        for (String propName : props.nameSet()) {
            if (!SVNProperty.isSVNProperty(propName)) continue;
            return true;
        }
        return false;
    }

    private static void validatePropertyName(Object path, String name, SVNNodeKind kind) throws SVNException {
        SVNErrorMessage err = null;
        if (kind == SVNNodeKind.DIR) {
            if (NOT_ALLOWED_FOR_DIR.contains(name)) {
                err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a directory (''{1}'')", name, path);
            }
        } else if (kind == SVNNodeKind.FILE) {
            if (NOT_ALLOWED_FOR_FILE.contains(name)) {
                err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot set ''{0}'' on a file (''{1}'')", name, path);
            }
        } else {
            err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "''{0}'' is not a file or directory", path);
        }
        if (err != null) {
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
    }

    public static void validateMimeType(String value) throws SVNException {
        String type = value.indexOf(59) >= 0 ? value.substring(0, value.indexOf(59)) : value;
        SVNErrorMessage err = null;
        if (type.length() == 0) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' has empty media type", (Object)value);
        } else if (type.indexOf(47) < 0) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' does not contain ''/''", (Object)value);
        } else if (!Character.isLetterOrDigit(type.charAt(type.length() - 1))) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_MIME_TYPE, "MIME type ''{0}'' ends with non-alphanumeric character", (Object)value);
        }
        if (err != null) {
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
    }

    public static String determineEncodingByMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if (!SVNProperty.isTextMimeType(mimeType)) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(mimeType, ";", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!(token = token.trim()).startsWith("charset") || !(token = token.substring("charset".length()).trim()).startsWith("=")) continue;
            return token.substring("=".length()).trim();
        }
        return null;
    }

    public static void validateEOLProperty(Object path, ISVNFileContentFetcher fetcher) throws SVNException {
        if (fetcher == null) {
            return;
        }
        SVNPropertyValue charset = fetcher.getProperty("svnkit:charset");
        OutputStream out = SVNTranslator.getTranslatingOutputStream(SVNFileUtil.DUMMY_OUT, SVNPropertyValue.getPropertyAsString(charset), new byte[0], false, null, false);
        try {
            fetcher.fetchFileContent(out);
        }
        catch (SVNException e) {
            SVNPropertiesManager.handleInconsistentEOL(e, path);
            throw e;
        }
        finally {
            try {
                out.close();
            }
            catch (IOExceptionWrapper wrapper) {
                SVNPropertiesManager.handleInconsistentEOL(wrapper.getOriginalException(), path);
                throw wrapper.getOriginalException();
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), SVNLogType.DEFAULT);
            }
        }
        if (fetcher.fileIsBinary()) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has binary mime type property", path);
            SVNErrorManager.error(error, SVNLogType.WC);
        }
    }

    private static void handleInconsistentEOL(SVNException svne, Object path) throws SVNException {
        Throwable cause;
        SVNErrorMessage errorMessage;
        for (errorMessage = svne.getErrorMessage(); errorMessage != null && errorMessage.getErrorCode() != SVNErrorCode.IO_INCONSISTENT_EOL; errorMessage = errorMessage.getChildErrorMessage()) {
        }
        if (errorMessage != null && errorMessage.getErrorCode() == SVNErrorCode.IO_INCONSISTENT_EOL) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "File ''{0}'' has inconsistent newlines", path);
            SVNErrorManager.error(error, SVNLogType.DEFAULT);
        }
        if ((cause = svne.getCause()) == null) {
            return;
        }
        if (cause instanceof SVNException) {
            SVNPropertiesManager.handleInconsistentEOL((SVNException)cause, path);
        } else if (cause instanceof IOExceptionWrapper) {
            IOExceptionWrapper wrapper = (IOExceptionWrapper)cause;
            SVNPropertiesManager.handleInconsistentEOL(wrapper.getOriginalException(), path);
        }
    }

    static {
        NOT_ALLOWED_FOR_FILE.add("svn:ignore");
        NOT_ALLOWED_FOR_FILE.add("svn:externals");
        NOT_ALLOWED_FOR_FILE.add("svn:global-ignores");
        NOT_ALLOWED_FOR_FILE.add("svn:auto-props");
        NOT_ALLOWED_FOR_DIR.add("svn:executable");
        NOT_ALLOWED_FOR_DIR.add("svn:keywords");
        NOT_ALLOWED_FOR_DIR.add("svn:eol-style");
        NOT_ALLOWED_FOR_DIR.add("svnkit:charset");
        NOT_ALLOWED_FOR_DIR.add("svn:needs-lock");
        NOT_ALLOWED_FOR_DIR.add("svn:mime-type");
    }
}

