/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAmbientDepthFilterEditor
implements ISVNEditor {
    private ISVNEditor myDelegate;
    private SVNWCAccess myWCAccess;
    private File myAnchor;
    private String myTarget;
    private DirBaton myCurrentDirBaton;
    private FileBaton myCurrentFileBaton;
    private LinkedList myDirs;

    public static ISVNEditor wrap(ISVNEditor editor, SVNAdminAreaInfo info, boolean depthIsSticky) {
        if (!depthIsSticky) {
            return new SVNAmbientDepthFilterEditor(editor, info.getWCAccess(), info.getAnchor().getRoot(), info.getTargetName());
        }
        return editor;
    }

    private SVNAmbientDepthFilterEditor(ISVNEditor delegate, SVNWCAccess wcAccess, File anchor, String target) {
        this.myDelegate = delegate;
        this.myWCAccess = wcAccess;
        this.myAnchor = anchor;
        this.myTarget = target;
        this.myDirs = new LinkedList();
    }

    public void abortEdit() throws SVNException {
        this.myDelegate.abortEdit();
    }

    public void absentDir(String path) throws SVNException {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentDir(path);
    }

    public void absentFile(String path) throws SVNException {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentFile(path);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(path, parentBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myCurrentDirBaton.myAmbientDepth = path.equals(this.myTarget) ? SVNDepth.INFINITY : (parentBaton.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
        this.myDelegate.addDir(path, copyFromPath, copyFromRevision);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, path);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.addFile(path, copyFromPath, copyFromRevision);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeDirProperty(name, value);
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeFileProperty(path, propertyName, propertyValue);
    }

    public void closeDir() throws SVNException {
        DirBaton closedDir = (DirBaton)this.myDirs.removeLast();
        this.myCurrentDirBaton = this.myDirs.isEmpty() ? null : (DirBaton)this.myDirs.getLast();
        if (closedDir.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeDir();
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return this.myDelegate.closeEdit();
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeFile(path, textChecksum);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        File fullPath;
        SVNEntry entry;
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if (this.myCurrentDirBaton.myAmbientDepth.compareTo(SVNDepth.IMMEDIATES) < 0 && (entry = this.myWCAccess.getEntry(fullPath = new File(this.myAnchor, path), false)) == null) {
            return;
        }
        this.myDelegate.deleteEntry(path, revision);
    }

    public void openDir(String path, long revision) throws SVNException {
        DirBaton parentBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(path, parentBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openDir(path, revision);
        SVNEntry entry = this.myWCAccess.getEntry(this.myCurrentDirBaton.myPath, false);
        if (entry != null) {
            this.myCurrentDirBaton.myAmbientDepth = entry.getDepth();
        }
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, path);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openFile(path, revision);
    }

    public void openRoot(long revision) throws SVNException {
        SVNEntry entry;
        this.myCurrentDirBaton = this.makeDirBaton(null, null);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if ((this.myTarget == null || "".equals(this.myTarget)) && (entry = this.myWCAccess.getEntry(this.myCurrentDirBaton.myPath, false)) != null) {
            this.myCurrentDirBaton.myAmbientDepth = entry.getDepth();
        }
        this.myDelegate.openRoot(revision);
    }

    public void targetRevision(long revision) throws SVNException {
        this.myDelegate.targetRevision(revision);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.applyTextDelta(path, baseChecksum);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return SVNFileUtil.DUMMY_OUT;
        }
        return this.myDelegate.textDeltaChunk(path, diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.textDeltaEnd(path);
    }

    private FileBaton makeFileBaton(DirBaton parentBaton, String path) throws SVNException {
        SVNEntry entry;
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor.makeFileBation(): path == null");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        FileBaton fileBaton = new FileBaton();
        if (parentBaton.myIsAmbientlyExcluded) {
            fileBaton.myIsAmbientlyExcluded = true;
            return fileBaton;
        }
        if (parentBaton.myAmbientDepth == SVNDepth.EMPTY && (entry = this.myWCAccess.getEntry(new File(this.myAnchor, path), false)) == null) {
            fileBaton.myIsAmbientlyExcluded = true;
        }
        return fileBaton;
    }

    private DirBaton makeDirBaton(String path, DirBaton parentBaton) throws SVNException {
        SVNEntry entry;
        if (parentBaton != null && path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor.makeDirBation(): parentBaton != null while path == null");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (parentBaton != null && parentBaton.myIsAmbientlyExcluded) {
            this.myDirs.addLast(parentBaton);
            return parentBaton;
        }
        DirBaton dirBaton = new DirBaton();
        this.myDirs.addLast(dirBaton);
        dirBaton.myPath = this.myAnchor;
        if (path != null) {
            dirBaton.myPath = new File(this.myAnchor, path);
        }
        if (parentBaton != null && (parentBaton.myAmbientDepth == SVNDepth.EMPTY || parentBaton.myAmbientDepth == SVNDepth.FILES) && (entry = this.myWCAccess.getEntry(dirBaton.myPath, false)) == null) {
            dirBaton.myIsAmbientlyExcluded = true;
            return dirBaton;
        }
        dirBaton.myAmbientDepth = SVNDepth.UNKNOWN;
        return dirBaton;
    }

    private class DirBaton {
        boolean myIsAmbientlyExcluded;
        SVNDepth myAmbientDepth;
        File myPath;

        private DirBaton() {
        }
    }

    private class FileBaton {
        boolean myIsAmbientlyExcluded;

        private FileBaton() {
        }
    }
}

