/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.revprop;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNFSFSPackedRevPropsManifest {
    private final long firstRevision;
    private final List<String> packNames;

    public static SVNFSFSPackedRevPropsManifest fromFile(File manifestFile, long revision, long maxFilesPerDirectory) throws SVNException {
        long firstRevision = revision < maxFilesPerDirectory ? 1L : revision - revision % maxFilesPerDirectory;
        return SVNFSFSPackedRevPropsManifest.fromString(firstRevision, SVNFileUtil.readFile(manifestFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SVNFSFSPackedRevPropsManifest fromString(long firstRevision, String manifestString) throws SVNException {
        Object packName;
        ArrayList<String> packNames = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new StringReader(manifestString));
            while ((packName = bufferedReader.readLine()) != null) {
                packNames.add((String)packName);
            }
            packName = new SVNFSFSPackedRevPropsManifest(firstRevision, packNames);
        }
        catch (IOException e) {
            try {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                SVNErrorManager.error(errorMessage, e, SVNLogType.FSFS);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(bufferedReader);
                throw throwable;
            }
            SVNFileUtil.closeFile(bufferedReader);
            return null;
        }
        SVNFileUtil.closeFile(bufferedReader);
        return packName;
    }

    private SVNFSFSPackedRevPropsManifest(long firstRevision, List<String> packNames) {
        this.firstRevision = firstRevision;
        this.packNames = packNames;
    }

    public long getFirstRevision() {
        return this.firstRevision;
    }

    public int getRevisionsCount() {
        return this.packNames.size();
    }

    public String updatePackName(long firstRevision, int revisionsCount) throws SVNException {
        int start = (int)(firstRevision - this.firstRevision);
        int end = start + revisionsCount;
        String oldName = this.packNames.get(start);
        int pos = oldName.indexOf(46);
        if (pos < 0) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Packed file '{{0}}' misses a tag", (Object)oldName);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        long tag = -1L;
        try {
            tag = Long.valueOf(oldName.substring(pos + ".".length()));
        }
        catch (NumberFormatException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Packed file '{{0}}' misses a tag", (Object)oldName);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        String newName = firstRevision + "." + ++tag;
        for (int index = start; index < end; ++index) {
            this.packNames.set(index, newName);
        }
        return newName;
    }

    public String getPackName(long revision) {
        int revisionIndex = (int)(revision - this.getFirstRevision());
        return this.packNames.get(revisionIndex);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String packName : this.packNames) {
            stringBuilder.append(packName).append('\n');
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private long firstRevision = -1L;
        private final List<String> packNames = new ArrayList<String>();

        public SVNFSFSPackedRevPropsManifest build() {
            return new SVNFSFSPackedRevPropsManifest(this.firstRevision, this.packNames);
        }

        public void setFirstRevision(long firstRevision) {
            this.firstRevision = firstRevision;
        }

        public void addPackName(String packName) {
            this.packNames.add(packName);
        }
    }
}

