/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.util;

import de.proveo.idm.core.util.Version;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class VersionsCompareUtil {
    public static boolean isVersionGreater(String version1, String version2) {
        Version v1 = VersionsCompareUtil.parseVersion(version1);
        Version v2 = VersionsCompareUtil.parseVersion(version2);
        if (v1 == null) {
            return false;
        }
        return v1.compareTo(v2) > 0;
    }

    public static boolean isVersionGreaterOrEqual(String version1, String version2) {
        Version v1 = VersionsCompareUtil.parseVersion(version1);
        Version v2 = VersionsCompareUtil.parseVersion(version2);
        if (v1 == null) {
            return false;
        }
        return v1.compareTo(v2) >= 0;
    }

    public static boolean isVersionLesser(String version1, String version2) {
        Version v1 = VersionsCompareUtil.parseVersion(version1);
        Version v2 = VersionsCompareUtil.parseVersion(version2);
        if (v1 == null) {
            return false;
        }
        return v1.compareTo(v2) < 0;
    }

    public static boolean isVersionLesserOrEqual(String version1, String version2) {
        Version v1 = VersionsCompareUtil.parseVersion(version1);
        Version v2 = VersionsCompareUtil.parseVersion(version2);
        if (v1 == null) {
            return false;
        }
        return v1.compareTo(v2) <= 0;
    }

    private static Version parseVersion(String version) {
        if (version == null) {
            return null;
        }
        String suffix = null;
        String[] versionParts = StringUtils.split((String)version, (String)".");
        if (version.contains("-")) {
            String[] versionAndSuffix = StringUtils.split((String)version, (String)"-");
            versionParts = StringUtils.split((String)versionAndSuffix[0], (String)".");
            suffix = "";
            for (int i = 1; i < versionAndSuffix.length; ++i) {
                suffix = suffix + versionAndSuffix[i];
                if (i + 1 >= versionAndSuffix.length) continue;
                suffix = suffix + "-";
            }
        }
        ArrayList<Integer> versionNumbers = new ArrayList<Integer>();
        for (String versionPart : versionParts) {
            try {
                versionNumbers.add(Integer.parseInt(versionPart));
            }
            catch (NumberFormatException ex) {
                suffix = suffix == null ? versionPart : versionPart + "-" + suffix;
            }
        }
        if (versionNumbers.isEmpty()) {
            return null;
        }
        int[] vn = new int[versionNumbers.size()];
        for (int i = 0; i < versionNumbers.size(); ++i) {
            vn[i] = (Integer)versionNumbers.get(i);
        }
        return new Version(suffix, vn);
    }
}

