/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.util;

import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class VersionUtil {
    private static final Logger log = Logger.getLogger(VersionUtil.class.getName());
    protected static final String VERSION_RESOURCE_FILE = "/de/proveo/idm/core/version.properties";
    protected static final String PROP_APP_VERSION = "appversion";
    protected static final String PROP_REVISION_NUMBER = "svnversion";
    protected static final ReentrantLock lock = new ReentrantLock();
    protected static VersionUtil instance = null;
    protected final Properties repoProperties = new Properties();

    private VersionUtil() {
        InputStream is = null;
        try {
            is = VersionUtil.class.getResourceAsStream(VERSION_RESOURCE_FILE);
            this.repoProperties.load(is);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not load version properties from /de/proveo/idm/core/version.properties", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public String getApplicationVersion() {
        return this.repoProperties.getProperty(PROP_APP_VERSION);
    }

    public static VersionUtil getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new VersionUtil();
            }
            VersionUtil versionUtil = instance;
            return versionUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public String getSvnRevision() {
        return this.repoProperties.getProperty(PROP_REVISION_NUMBER);
    }
}

