/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.util;

public class Version
implements Comparable<Version> {
    private int[] versionNumbers;
    private String suffix;

    public Version(String suffix, int ... versionNumbers) {
        this.suffix = suffix;
        this.versionNumbers = versionNumbers;
    }

    public int[] getVersionNumbers() {
        return this.versionNumbers;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean hasSuffix() {
        return this.suffix != null && this.suffix.trim().length() != 0;
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        if (this.versionNumbers.length == 0 && version.versionNumbers.length == 0) {
            return 0;
        }
        if (version.versionNumbers.length == 0) {
            return 1;
        }
        if (this.versionNumbers.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.versionNumbers.length; ++i) {
            if (i >= version.versionNumbers.length) continue;
            if (this.versionNumbers[i] < version.versionNumbers[i]) {
                return -1;
            }
            if (this.versionNumbers[i] <= version.versionNumbers[i]) continue;
            return 1;
        }
        if (this.hasSuffix() != version.hasSuffix()) {
            if (this.hasSuffix()) {
                return -1;
            }
            return 1;
        }
        if (this.hasSuffix() && version.hasSuffix() && !this.suffix.equals(version.suffix)) {
            return this.suffix.compareTo(version.suffix);
        }
        return 0;
    }
}

