/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.options;

import de.proveo.idm.core.gui.navigation.api.AppearancePreferencesProvider;
import de.proveo.idm.core.gui.navigation.api.ExtendedValue;
import de.proveo.idm.core.options.AppearanceOptionsPanelController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class AppearancePanel
extends JPanel {
    private final DefaultComboBoxModel languageCmbBoxModel;
    private final DefaultComboBoxModel timeZoneCmbBoxModel;
    private final AppearanceOptionsPanelController controller;
    private JLabel dateTimePatternLbl;
    private JButton dateTimePatternResetDefaultBtn;
    private JTextField dateTimePatternTxt;
    private JLabel durationPatternLbl;
    private JButton durationPatternResetDefaultBtn;
    private JTextField durationPatternTxt;
    private JComboBox languageCmbBox;
    private JLabel languageLbl;
    private JLabel languageRequiresRestartLbl;
    private JButton languageResetDefaultBtn;
    private JCheckBox mainFrameUndecoratedChkBox;
    private JLabel timeZoneLbl;
    private JButton timeZoneResetDefaultBtn;
    private JComboBox timeZonesCmbBox;
    private JButton undecoratedResetDefaultBtn;

    AppearancePanel(AppearanceOptionsPanelController controller) {
        this.controller = controller;
        String[] timeZoneIds = TimeZone.getAvailableIDs();
        TreeMap<String, ExtendedValue> timeZonesSet = new TreeMap<String, ExtendedValue>();
        for (String timeZoneId : timeZoneIds) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            timeZonesSet.put(timeZone.getDisplayName(), new ExtendedValue(timeZoneId, timeZone.getDisplayName()));
        }
        ExtendedValue[] timeZoneValues = new ExtendedValue[timeZonesSet.size() + 1];
        timeZoneValues[0] = new ExtendedValue("", "");
        int index = 1;
        Collection timeZoneCol = timeZonesSet.values();
        for (ExtendedValue value : timeZoneCol) {
            timeZoneValues[index++] = value;
        }
        this.timeZoneCmbBoxModel = new DefaultComboBoxModel<ExtendedValue>(timeZoneValues);
        Locale[] locales = Locale.getAvailableLocales();
        TreeMap<String, ExtendedValue> localesSet = new TreeMap<String, ExtendedValue>();
        for (Locale locale : locales) {
            String displayName = locale.getDisplayName();
            if (displayName == null || displayName.trim().length() == 0) continue;
            String country = locale.getCountry();
            String language = locale.getLanguage();
            String id = null;
            if (country != null && country.trim().length() != 0) {
                id = country.trim();
            }
            if (language == null || language.trim().length() == 0) continue;
            id = id == null || id.length() == 0 ? language.trim() : id + "-" + language.trim();
            localesSet.put(displayName, new ExtendedValue(id, displayName));
        }
        ExtendedValue[] localesValues = new ExtendedValue[localesSet.size() + 1];
        localesValues[0] = new ExtendedValue("", NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.defaultLanguage.text"));
        index = 1;
        Collection localesCol = localesSet.values();
        for (ExtendedValue value : localesCol) {
            localesValues[index++] = value;
        }
        this.languageCmbBoxModel = new DefaultComboBoxModel<ExtendedValue>(localesValues);
        this.initComponents();
    }

    private void initComponents() {
        this.timeZoneLbl = new JLabel();
        this.timeZonesCmbBox = new JComboBox();
        this.mainFrameUndecoratedChkBox = new JCheckBox();
        this.undecoratedResetDefaultBtn = new JButton();
        this.timeZoneResetDefaultBtn = new JButton();
        this.dateTimePatternLbl = new JLabel();
        this.dateTimePatternTxt = new JTextField();
        this.durationPatternLbl = new JLabel();
        this.durationPatternTxt = new JTextField();
        this.dateTimePatternResetDefaultBtn = new JButton();
        this.durationPatternResetDefaultBtn = new JButton();
        this.languageLbl = new JLabel();
        this.languageCmbBox = new JComboBox();
        this.languageResetDefaultBtn = new JButton();
        this.languageRequiresRestartLbl = new JLabel();
        this.timeZoneLbl.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.timeZoneLbl, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.timeZoneLbl.text"));
        this.timeZoneLbl.setToolTipText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.timeZoneLbl.toolTipText"));
        this.timeZonesCmbBox.setModel(this.timeZoneCmbBoxModel);
        this.timeZonesCmbBox.setToolTipText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.timeZonesCmbBox.toolTipText"));
        this.timeZonesCmbBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AppearancePanel.this.timeZonesCmbBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.mainFrameUndecoratedChkBox, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.mainFrameUndecoratedChkBox.text"));
        this.mainFrameUndecoratedChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearancePanel.this.mainFrameUndecoratedChkBoxActionPerformed(evt);
            }
        });
        this.undecoratedResetDefaultBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/options/resetDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.undecoratedResetDefaultBtn, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.undecoratedResetDefaultBtn.text"));
        this.undecoratedResetDefaultBtn.setToolTipText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.undecoratedResetDefaultBtn.toolTipText"));
        this.undecoratedResetDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearancePanel.this.undecoratedResetDefaultBtnActionPerformed(evt);
            }
        });
        this.timeZoneResetDefaultBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/options/resetDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.timeZoneResetDefaultBtn, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.timeZoneResetDefaultBtn.text"));
        this.timeZoneResetDefaultBtn.setToolTipText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.timeZoneResetDefaultBtn.toolTipText"));
        this.timeZoneResetDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearancePanel.this.timeZoneResetDefaultBtnActionPerformed(evt);
            }
        });
        this.dateTimePatternLbl.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.dateTimePatternLbl, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.dateTimePatternLbl.text"));
        this.dateTimePatternTxt.setText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.dateTimePatternTxt.text"));
        this.dateTimePatternTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AppearancePanel.this.dateTimePatternTxtKeyReleased(evt);
            }
        });
        this.durationPatternLbl.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.durationPatternLbl, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.durationPatternLbl.text"));
        this.durationPatternTxt.setText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.durationPatternTxt.text"));
        this.durationPatternTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AppearancePanel.this.durationPatternTxtKeyReleased(evt);
            }
        });
        this.dateTimePatternResetDefaultBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/options/resetDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.dateTimePatternResetDefaultBtn, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.dateTimePatternResetDefaultBtn.text"));
        this.dateTimePatternResetDefaultBtn.setToolTipText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.dateTimePatternResetDefaultBtn.toolTipText"));
        this.dateTimePatternResetDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearancePanel.this.dateTimePatternResetDefaultBtnActionPerformed(evt);
            }
        });
        this.durationPatternResetDefaultBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/options/resetDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.durationPatternResetDefaultBtn, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.durationPatternResetDefaultBtn.text"));
        this.durationPatternResetDefaultBtn.setToolTipText(NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.durationPatternResetDefaultBtn.toolTipText"));
        this.durationPatternResetDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearancePanel.this.durationPatternResetDefaultBtnActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.languageLbl, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.languageLbl.text"));
        this.languageCmbBox.setModel(this.languageCmbBoxModel);
        this.languageCmbBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AppearancePanel.this.languageCmbBoxItemStateChanged(evt);
            }
        });
        this.languageResetDefaultBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/options/resetDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.languageResetDefaultBtn, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.languageResetDefaultBtn.text"));
        this.languageResetDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearancePanel.this.languageResetDefaultBtnActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.languageRequiresRestartLbl, (String)NbBundle.getMessage(AppearancePanel.class, (String)"AppearancePanel.languageRequiresRestartLbl.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.durationPatternLbl, -2, 141, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.languageLbl).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.dateTimePatternLbl, -1, 141, Short.MAX_VALUE).addComponent(this.timeZoneLbl, -1, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.durationPatternTxt, -2, 200, -2).addComponent(this.dateTimePatternTxt, -2, 200, -2)).addComponent(this.mainFrameUndecoratedChkBox))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.languageRequiresRestartLbl).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.languageCmbBox, 0, -1, Short.MAX_VALUE).addComponent(this.timeZonesCmbBox, 0, 270, Short.MAX_VALUE))))).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.undecoratedResetDefaultBtn).addComponent(this.dateTimePatternResetDefaultBtn).addComponent(this.timeZoneResetDefaultBtn).addComponent(this.durationPatternResetDefaultBtn)).addComponent(this.languageResetDefaultBtn)))).addContainerGap(82, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageLbl).addComponent(this.languageCmbBox, -2, -1, -2).addComponent(this.languageResetDefaultBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageRequiresRestartLbl).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.timeZoneResetDefaultBtn).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeZoneLbl).addComponent(this.timeZonesCmbBox, -2, -1, -2))).addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateTimePatternTxt, -2, -1, -2).addComponent(this.dateTimePatternLbl)).addComponent(this.dateTimePatternResetDefaultBtn)).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.durationPatternTxt, -2, -1, -2).addComponent(this.durationPatternLbl)).addComponent(this.durationPatternResetDefaultBtn)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mainFrameUndecoratedChkBox).addComponent(this.undecoratedResetDefaultBtn)).addContainerGap(60, Short.MAX_VALUE)));
    }

    private void timeZonesCmbBoxItemStateChanged(ItemEvent evt) {
        if (1 == evt.getStateChange()) {
            this.controller.changed();
        }
    }

    private void mainFrameUndecoratedChkBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void undecoratedResetDefaultBtnActionPerformed(ActionEvent evt) {
        this.mainFrameUndecoratedChkBox.setSelected(false);
        this.controller.changed();
    }

    private void timeZoneResetDefaultBtnActionPerformed(ActionEvent evt) {
        this.setSelectedValue(this.languageCmbBox, "");
        this.controller.changed();
    }

    private void durationPatternTxtKeyReleased(KeyEvent evt) {
        this.controller.changed();
    }

    private void dateTimePatternTxtKeyReleased(KeyEvent evt) {
        this.controller.changed();
    }

    private void dateTimePatternResetDefaultBtnActionPerformed(ActionEvent evt) {
        this.dateTimePatternTxt.setText("dd MMM yy HH:mm:ss");
        this.controller.changed();
    }

    private void durationPatternResetDefaultBtnActionPerformed(ActionEvent evt) {
        this.durationPatternTxt.setText("D 0H:0m:0s");
        this.controller.changed();
    }

    private void languageCmbBoxItemStateChanged(ItemEvent evt) {
        if (1 == evt.getStateChange()) {
            this.controller.changed();
        }
    }

    private void languageResetDefaultBtnActionPerformed(ActionEvent evt) {
        this.setSelectedValue(this.languageCmbBox, "US-en");
        this.controller.changed();
    }

    void load() {
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        this.setSelectedValue(this.languageCmbBox, prefs.get("AppearancePreferencesProvider.language", "US-en"));
        this.setSelectedValue(this.timeZonesCmbBox, prefs.get("AppearancePreferencesProvider.timezone", ""));
        this.mainFrameUndecoratedChkBox.setSelected(prefs.getBoolean("AppearancePreferencesProvider.frameUndecorated", false));
        this.dateTimePatternTxt.setText(prefs.get("AppearancePreferencesProvider.dateTimePattern", "dd MMM yy HH:mm:ss"));
        this.durationPatternTxt.setText(prefs.get("AppearancePreferencesProvider.durationPattern", "D 0H:0m:0s"));
    }

    void store() {
        ExtendedValue val;
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        String value = "";
        Object obj = this.languageCmbBox.getSelectedItem();
        if (obj != null && obj instanceof ExtendedValue) {
            val = (ExtendedValue)obj;
            value = val.getValue().toString();
        }
        prefs.put("AppearancePreferencesProvider.language", value);
        value = "";
        obj = this.timeZonesCmbBox.getSelectedItem();
        if (obj != null && obj instanceof ExtendedValue) {
            val = (ExtendedValue)obj;
            value = val.getValue().toString();
        }
        prefs.put("AppearancePreferencesProvider.timezone", value);
        prefs.putBoolean("AppearancePreferencesProvider.frameUndecorated", this.mainFrameUndecoratedChkBox.isSelected());
        prefs.put("AppearancePreferencesProvider.dateTimePattern", this.dateTimePatternTxt.getText());
        prefs.put("AppearancePreferencesProvider.durationPattern", this.durationPatternTxt.getText());
    }

    boolean valid() {
        String dateTimePattern = this.dateTimePatternTxt.getText();
        if (dateTimePattern == null || dateTimePattern.trim().length() == 0) {
            return false;
        }
        String durationPattern = this.durationPatternTxt.getText();
        if (durationPattern == null || durationPattern.trim().length() == 0) {
            return false;
        }
        return this.timeZonesCmbBox.getSelectedItem() != null;
    }

    private void setSelectedValue(JComboBox cmbBox, Object value) {
        int index = ((DefaultComboBoxModel)cmbBox.getModel()).getIndexOf(value);
        if (index == -1) {
            for (int i = 0; i < cmbBox.getItemCount(); ++i) {
                ExtendedValue extValue;
                Object item = cmbBox.getItemAt(i);
                if (item == null || !(item instanceof ExtendedValue) || !ObjectUtils.equals((Object)value, (Object)(extValue = (ExtendedValue)item).getValue())) continue;
                cmbBox.setSelectedItem(item);
                return;
            }
        } else {
            cmbBox.setSelectedItem(value);
        }
    }
}

