/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public final class TableEditorStopper
extends FocusAdapter
implements PropertyChangeListener {
    private Component focused;
    private JTable table;

    private TableEditorStopper(JTable table) {
        this.table = table;
        table.addPropertyChangeListener("tableCellEditor", this);
    }

    public static void ensureEditingStopWhenTableLosesFocus(JTable table) {
        new TableEditorStopper(table);
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.focused != null) {
            this.focused.removeFocusListener(this);
            this.focused = e.getOppositeComponent();
            if (this.table == this.focused || this.table.isAncestorOf(this.focused)) {
                this.focused.addFocusListener(this);
            } else {
                this.focused = null;
                TableCellEditor editor = this.table.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.focused != null) {
            this.focused.removeFocusListener(this);
        }
        this.focused = this.table.getEditorComponent();
        if (this.focused != null) {
            this.focused.addFocusListener(this);
        }
    }
}

