/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import java.util.Observable;
import java.util.Observer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class ProgressDisplayer
implements Observer,
Runnable {
    private ProgressHandle handle;
    private int maxWorkUnits;
    private int currentWorkUnits;
    private boolean isIndeterminate = false;
    protected int value;
    protected volatile boolean finished = false;

    public ProgressDisplayer(String displayName) {
        this(displayName, Integer.MIN_VALUE, null);
    }

    public ProgressDisplayer(String displayName, int maxWorkUnits) throws IllegalArgumentException {
        this(displayName, maxWorkUnits, null);
    }

    public ProgressDisplayer(String displayName, int maxWorkUnits, Cancellable obj) throws IllegalArgumentException {
        if (maxWorkUnits != Integer.MIN_VALUE && maxWorkUnits <= 0) {
            throw new IllegalArgumentException("Maximum amount of work units cannot be below or equal to 0");
        }
        this.handle = obj != null ? ProgressHandleFactory.createHandle((String)displayName, (Cancellable)obj) : ProgressHandleFactory.createHandle((String)displayName);
        this.maxWorkUnits = maxWorkUnits;
        if (this.maxWorkUnits == Integer.MIN_VALUE) {
            this.handle.start();
        } else {
            this.handle.start(maxWorkUnits);
        }
    }

    public void progress(int workUnits) {
        if (workUnits > 0 && workUnits < this.maxWorkUnits && workUnits > this.currentWorkUnits) {
            this.currentWorkUnits = workUnits;
            if (this.isIndeterminate) {
                this.maxWorkUnits = 100;
                this.switchToDeterminate();
            }
            this.handle.progress(workUnits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        int newValue;
        if (arg instanceof Integer && (newValue = ((Integer)arg).intValue()) > this.value) {
            this.value = newValue;
            ProgressDisplayer progressDisplayer = this;
            synchronized (progressDisplayer) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.isIndeterminate) {
            this.maxWorkUnits = 100;
            this.switchToDeterminate();
        }
        try {
            while (!this.finished) {
                ProgressDisplayer progressDisplayer = this;
                synchronized (progressDisplayer) {
                    this.wait();
                    if (this.value <= 99 && !this.isIndeterminate) {
                        this.progress(this.value);
                    }
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        finally {
            this.finish();
        }
    }

    public void setDescription(String msg) {
        this.handle.progress(msg);
    }

    public void switchToIndeterminate() {
        this.isIndeterminate = true;
        this.handle.switchToIndeterminate();
    }

    public void switchToDeterminate() {
        this.isIndeterminate = false;
        this.handle.switchToDeterminate(this.maxWorkUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.handle.finish();
        this.finished = true;
        ProgressDisplayer progressDisplayer = this;
        synchronized (progressDisplayer) {
            this.notify();
        }
    }
}

