/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import de.proveo.idm.core.gui.util.DialogUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

public class PresentationMode {
    private static final Logger log = Logger.getLogger(PresentationMode.class.getName());
    public static final String PROP_PRESENTATION_MODE = "PresentationMode.enabled";
    private static final String PROP_PRESENTATION_PASSWORD = "PresentationMode.password";
    private static final ReentrantLock lock = new ReentrantLock();
    private static PresentationMode instance = null;
    private final List<RestorableTopComponent> closedTopComponents = new ArrayList<RestorableTopComponent>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean presentationMode = false;

    private PresentationMode() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public static PresentationMode getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new PresentationMode();
            }
            PresentationMode presentationMode = instance;
            return presentationMode;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isPresentationMode() {
        return this.presentationMode;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public boolean setPresentationMode(boolean presentationMode) {
        if (this.presentationMode == presentationMode) {
            return false;
        }
        if (presentationMode) {
            Object n = DialogUtil.showYesNoCancelQuestionDialog(NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.passwordQuestion.msg"), NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.passwordQuestion.title"));
            if (DialogUtil.YES_OPTION.equals(n)) {
                char[] pass = Keyring.read((String)PROP_PRESENTATION_PASSWORD);
                DialogUtil.PasswordInputLine pil = new DialogUtil.PasswordInputLine(NbBundle.getMessage(PresentationMode.class, (String)PROP_PRESENTATION_PASSWORD), NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.setPassword.title"), ArrayUtils.clone((char[])pass), 2, -1);
                Object l = DialogUtil.showDialogDescriptor(pil, false);
                while (DialogUtil.OK_OPTION.equals(l)) {
                    pass = pil.getPassword();
                    if (pass != null && pass.length != 0) {
                        DialogUtil.PasswordInputLine pil2 = new DialogUtil.PasswordInputLine(NbBundle.getMessage(PresentationMode.class, (String)PROP_PRESENTATION_PASSWORD), NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.reenterPassword.title"), 2, -1);
                        Object m = DialogUtil.showDialogDescriptor(pil2, false);
                        while (DialogUtil.OK_OPTION.equals(m)) {
                            if (ObjectUtils.equals((Object)new String(ArrayUtils.clone((char[])pass)), (Object)new String(pil2.getPassword()))) {
                                Keyring.save((String)PROP_PRESENTATION_PASSWORD, (char[])ArrayUtils.clone((char[])pass), (String)"Password to leave presentation mode.");
                                break;
                            }
                            DialogUtil.showErrorDialog(NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.reenteredPasswordWrong.msg"), NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.reenteredPasswordWrong.title"));
                            m = DialogUtil.showDialogDescriptor(pil2, false);
                        }
                        if (DialogUtil.OK_OPTION.equals(m)) break;
                        return false;
                    }
                    l = DialogUtil.showDialogDescriptor(pil, false);
                }
                if (!DialogUtil.OK_OPTION.equals(l)) {
                    return false;
                }
            } else {
                if (!DialogUtil.NO_OPTION.equals(n)) {
                    return false;
                }
                Keyring.delete((String)PROP_PRESENTATION_PASSWORD);
            }
        } else {
            char[] pass = Keyring.read((String)PROP_PRESENTATION_PASSWORD);
            if (pass != null && pass.length != 0) {
                DialogUtil.PasswordInputLine pil = new DialogUtil.PasswordInputLine(NbBundle.getMessage(PresentationMode.class, (String)PROP_PRESENTATION_PASSWORD), NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.enterPassword.title"), 2, -1);
                Object n = DialogUtil.showDialogDescriptor(pil, false);
                while (DialogUtil.OK_OPTION.equals(n) && !ObjectUtils.equals((Object)new String(ArrayUtils.clone((char[])pass)), (Object)new String(pil.getPassword()))) {
                    DialogUtil.showErrorDialog(NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.enteredPasswordWrong.msg"), NbBundle.getMessage(PresentationMode.class, (String)"PresentationMode.enteredPasswordWrong.title"));
                    pil.setPassword(new char[0]);
                    n = DialogUtil.showDialogDescriptor(pil, false);
                }
                if (!DialogUtil.OK_OPTION.equals(n)) {
                    return false;
                }
            }
        }
        this.presentationMode = presentationMode;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                MainWindow mainWindow = MainWindow.getInstance();
                boolean fullScreen = !mainWindow.isFullScreenMode();
                mainWindow.setFullScreenMode(fullScreen);
                mainWindow.getJMenuBar().setVisible(!fullScreen);
                PresentationMode.this.handleTopComponentVisibility();
                PresentationMode.this.pcs.firePropertyChange(PresentationMode.PROP_PRESENTATION_MODE, !PresentationMode.this.presentationMode, PresentationMode.this.presentationMode);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTopComponentVisibility() {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (this.presentationMode) {
            List<RestorableTopComponent> list = this.closedTopComponents;
            synchronized (list) {
                this.closedTopComponents.clear();
                Set modes = wm.getModes();
                for (Mode m : modes) {
                    TopComponent[] comps;
                    if (wm.isEditorMode(m)) continue;
                    for (TopComponent tc : comps = wm.getOpenedTopComponents(m)) {
                        this.closedTopComponents.add(new RestorableTopComponent(tc, m, wm.isTopComponentFloating(tc), wm.isTopComponentMinimized(tc)));
                        if (tc.canClose()) {
                            int counter = 0;
                            while (wm.isTopComponentBusy(tc)) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception ex) {
                                    log.log(Level.INFO, "While waiting for top component '" + tc.getDisplayName() + "' (" + tc.getClass().getName() + ") to finish some task runs into", ex);
                                }
                                if (++counter < 600) continue;
                                log.log(Level.INFO, "Timeout: top component ''{0}'' ({1}) is still busy after 5 min., close top component now without waiting to finish its task!", new Object[]{tc.getDisplayName(), tc.getClass().getName()});
                                break;
                            }
                            tc.close();
                            continue;
                        }
                        log.log(Level.INFO, "Cannot close top component ''{0}'' ({1}), closing not allowed!", new Object[]{tc.getDisplayName(), tc.getClass().getName()});
                    }
                }
            }
        }
        List<RestorableTopComponent> list = this.closedTopComponents;
        synchronized (list) {
            for (RestorableTopComponent rtc : this.closedTopComponents) {
                TopComponent tc = rtc.getTopComponent();
                rtc.getMode().dockInto(tc);
                if (rtc.isFloating()) {
                    wm.setTopComponentFloating(tc, true);
                }
                if (rtc.isMinimized()) {
                    wm.setTopComponentMinimized(tc, true);
                }
                tc.open();
            }
        }
    }

    private class RestorableTopComponent {
        private final TopComponent topComponent;
        private final Mode mode;
        private final boolean floating;
        private final boolean minimized;

        public RestorableTopComponent(TopComponent topComponent, Mode mode, boolean floating, boolean minimized) {
            this.topComponent = topComponent;
            this.mode = mode;
            this.floating = floating;
            this.minimized = minimized;
        }

        public Mode getMode() {
            return this.mode;
        }

        public TopComponent getTopComponent() {
            return this.topComponent;
        }

        public boolean isFloating() {
            return this.floating;
        }

        public boolean isMinimized() {
            return this.minimized;
        }
    }
}

