/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import de.proveo.idm.core.util.ApplicationTimer;
import java.awt.event.ActionListener;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;

public class NotificationUtil {
    private static final ImageIcon INFO_ICON = new ImageIcon(NotificationUtil.class.getResource("/de/proveo/idm/core/gui/util/info.png"));
    private static final ImageIcon WARN_ICON = new ImageIcon(NotificationUtil.class.getResource("/de/proveo/idm/core/gui/util/warn.png"));
    private static final ImageIcon ERROR_ICON = new ImageIcon(NotificationUtil.class.getResource("/de/proveo/idm/core/gui/util/error.png"));

    public static Notification notifyInfo(String title, String details) {
        return NotificationUtil.notifyInfo(title, details, null);
    }

    public static Notification notifyInfo(String title, String details, ActionListener al) {
        return NotificationUtil.notifyInfo(title, details, al, NotificationDisplayer.Priority.LOW);
    }

    public static Notification notifyInfo(String title, String details, ActionListener al, NotificationDisplayer.Priority prio) {
        return NotificationUtil.notify(title, details, INFO_ICON, al, prio);
    }

    public static Notification notifyInfoAutoClear(String title, String details, long clearAfterMs) {
        return NotificationUtil.notifyInfoAutoClear(title, details, null, clearAfterMs);
    }

    public static Notification notifyInfoAutoClear(String title, String details, ActionListener al, long clearAfterMs) {
        return NotificationUtil.notifyInfoAutoClear(title, details, al, NotificationDisplayer.Priority.LOW, clearAfterMs);
    }

    public static Notification notifyInfoAutoClear(String title, String details, ActionListener al, NotificationDisplayer.Priority prio, long clearAfterMs) {
        return NotificationUtil.notifyAutoClear(title, details, INFO_ICON, al, prio, clearAfterMs);
    }

    public static Notification notifyInfoAutoClearSilent(String title, String details, long clearAfterMs) {
        return NotificationUtil.notifyInfoAutoClearSilent(title, details, null, clearAfterMs);
    }

    public static Notification notifyInfoAutoClearSilent(String title, String details, ActionListener al, long clearAfterMs) {
        return NotificationUtil.notifyInfoAutoClear(title, details, al, NotificationDisplayer.Priority.SILENT, clearAfterMs);
    }

    public static Notification notifyInfoSilent(String title, String details) {
        return NotificationUtil.notifyInfoSilent(title, details, null);
    }

    public static Notification notifyInfoSilent(String title, String details, ActionListener al) {
        return NotificationUtil.notifyInfo(title, details, al, NotificationDisplayer.Priority.SILENT);
    }

    public static Notification notifyWarn(String title, String details) {
        return NotificationUtil.notifyWarn(title, details, null);
    }

    public static Notification notifyWarn(String title, String details, ActionListener al) {
        return NotificationUtil.notifyWarn(title, details, al, NotificationDisplayer.Priority.NORMAL);
    }

    public static Notification notifyWarn(String title, String details, ActionListener al, NotificationDisplayer.Priority prio) {
        return NotificationUtil.notify(title, details, WARN_ICON, al, prio);
    }

    public static Notification notifyError(String title, String details) {
        return NotificationUtil.notifyError(title, details, null);
    }

    public static Notification notifyError(String title, String details, ActionListener al) {
        return NotificationUtil.notifyError(title, details, al, NotificationDisplayer.Priority.HIGH);
    }

    public static Notification notifyError(String title, String details, ActionListener al, NotificationDisplayer.Priority prio) {
        return NotificationUtil.notify(title, details, ERROR_ICON, al, prio);
    }

    public static Notification notify(String title, String details, Icon icon, ActionListener al, NotificationDisplayer.Priority prio) {
        return NotificationUtil.notifyAutoClear(title, details, icon, al, prio, -1L);
    }

    public static Notification notifyAutoClear(String title, String details, Icon icon, ActionListener al, NotificationDisplayer.Priority prio, long clearAfterMs) {
        final Notification n = NotificationDisplayer.getDefault().notify(title, icon, details, al, prio);
        if (clearAfterMs > 0L) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    n.clear();
                }
            };
            ApplicationTimer.getTimer().schedule(task, clearAfterMs);
        }
        return n;
    }
}

