/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.HelpCtx;

public class MultipleChoiceSelectorPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultComboBoxModel model = null;
    private final String message;
    private String helpId;
    private JComboBox choiceCB;
    private JLabel messageLbl;

    public MultipleChoiceSelectorPanel(String helpId, String message, String ... choices) {
        this.helpId = helpId;
        this.message = message;
        this.initComponents();
        this.model = new DefaultComboBoxModel<String>(choices);
        this.choiceCB.setModel(this.model);
        this.choiceCB.setSelectedIndex(0);
    }

    public HelpCtx getHelpCtx() {
        if (this.helpId == null) {
            return null;
        }
        return new HelpCtx(this.helpId);
    }

    public String getSelection() {
        Object selected = this.choiceCB.getSelectedItem();
        if (selected != null) {
            return selected.toString();
        }
        return null;
    }

    private void initComponents() {
        this.messageLbl = new MultilineLabel(this.message);
        this.choiceCB = new JComboBox();
        this.messageLbl.setText(this.message);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLbl, -1, -1, Short.MAX_VALUE).addComponent(this.choiceCB, GroupLayout.Alignment.TRAILING, 0, 326, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLbl, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.choiceCB, -2, -1, -2).addContainerGap()));
    }

    private class MultilineLabel
    extends JLabel {
        public MultilineLabel(String text) {
            super(text);
        }

        @Override
        public void setText(String text) {
            if (text.contains("\n")) {
                text = "<html>" + StringUtils.replace((String)text, (String)"\n", (String)"<br>") + "</html>";
            }
            super.setText(text);
        }
    }
}

