/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.xml.sax.SAXException;

public class MenuUtil {
    private static final Logger log = Logger.getLogger(MenuUtil.class.getName());
    private static final String GENERATED_LAYER_FILE_LOCATION = "/META-INF/generated-layer.xml";
    private static final String POSITION_ATTRIBUTE_NAME = "position";
    private static final String SEPARATOR_AFTER = "separatorAfter";
    private static final String SEPARATOR_BEFORE = "separatorBefore";

    public static List<Action> actionsForPaths(String ... paths) throws SAXException {
        ArrayList<Action> subActions = new ArrayList<Action>();
        List<Action> actions = new ArrayList();
        HashMap<Action, String> actionPaths = new HashMap<Action, String>();
        for (String path : paths) {
            List actionsForPath = Utilities.actionsForPath((String)path);
            for (Action a : actionsForPath) {
                if (a == null || MenuUtil.containsClass(actions, a.getClass())) continue;
                actions.add(a);
                actionPaths.put(a, path);
                if (!(a instanceof Presenter.Popup)) continue;
                subActions.addAll(MenuUtil.findSubActions((Presenter.Popup)a));
            }
        }
        actions = MenuUtil.removeAllWithSameClass(actions, subActions);
        ArrayList<ActionAndPath> actionsAndPaths = new ArrayList<ActionAndPath>();
        for (Action a : actions) {
            actionsAndPaths.add(new ActionAndPath(a, (String)actionPaths.get(a)));
        }
        return MenuUtil.sortActions(actionsAndPaths);
    }

    public static JMenuItem getPopupPresenter(Action action, Lookup lookup, String ... paths) {
        JMenu menu = new JMenu(action);
        try {
            List<Action> actionsForPath = MenuUtil.actionsForPaths(paths);
            for (Action a : actionsForPath) {
                if (lookup != null && a != null && a instanceof ContextAwareAction) {
                    Action contextAwareAction = ((ContextAwareAction)a).createContextAwareInstance(lookup);
                    if (contextAwareAction != null) {
                        a = contextAwareAction;
                    }
                    if (a instanceof Presenter.Popup) {
                        JMenuItem item = ((Presenter.Popup)a).getPopupPresenter();
                        if (item == null) continue;
                        menu.add(item);
                        continue;
                    }
                }
                if (a != null) {
                    menu.add(a);
                    continue;
                }
                menu.add(new JSeparator(0));
            }
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return menu;
    }

    private static List<Action> findSubActions(Presenter.Popup subMenu) {
        ArrayList<Action> actions = new ArrayList<Action>();
        JMenuItem presenterItem = subMenu.getPopupPresenter();
        if (presenterItem != null && presenterItem instanceof JMenu) {
            JMenu menu = (JMenu)presenterItem;
            for (int i = 0; i < menu.getItemCount(); ++i) {
                JMenuItem item = menu.getItem(i);
                if (item == null) continue;
                Action a = item.getAction();
                if (a instanceof Presenter.Popup) {
                    actions.addAll(MenuUtil.findSubActions((Presenter.Popup)a));
                }
                actions.add(a);
            }
        }
        return actions;
    }

    private static List<Action> sortActions(List<ActionAndPath> actionsAndPaths) throws SAXException {
        try {
            TreeMap<Integer, Object> tmp = new TreeMap<Integer, Object>();
            for (ActionAndPath actionAndPath : actionsAndPaths) {
                TreeMap<Integer, Action> seperators;
                Action action = actionAndPath.getAction();
                if (action == null) continue;
                URL layerUrl = action.getClass().getResource(GENERATED_LAYER_FILE_LOCATION);
                XMLFileSystem fileSystem = new XMLFileSystem(layerUrl);
                FileObject root = fileSystem.getRoot();
                ActionPosition aPosition = MenuUtil.getActionPosition(action, actionAndPath.getPath(), root);
                int pos2 = Integer.MIN_VALUE;
                if (aPosition != null) {
                    pos2 = aPosition.getPosition();
                }
                while (tmp.containsKey(pos2)) {
                    ++pos2;
                }
                tmp.put(pos2, action);
                FileObject searchForSep = root;
                if (aPosition != null && (searchForSep = aPosition.getFileObject().getParent()) == null && (searchForSep = aPosition.getFileObject()) == null) {
                    searchForSep = root;
                }
                if ((seperators = MenuUtil.findSeparatorsForAction(action, searchForSep)).isEmpty()) continue;
                for (int pos2 : seperators.keySet()) {
                    while (tmp.containsKey(pos2) && tmp.get(pos2) != null) {
                        ++pos2;
                    }
                    tmp.put(pos2, null);
                }
            }
            ArrayList<Action> ret = new ArrayList<Action>();
            Collection col = tmp.values();
            for (Action action : col) {
                ret.add(action);
            }
            return ret;
        }
        catch (Exception ex) {
            ArrayList<Action> actions = new ArrayList<Action>();
            for (ActionAndPath a : actionsAndPaths) {
                actions.add(a.getAction());
            }
            return actions;
        }
    }

    private static ActionPosition getActionPosition(Action action, String path, FileObject fileObject) {
        if (fileObject != null) {
            FileObject[] children;
            String fileObjectClassName;
            String actionClassName = action.getClass().getName();
            if (actionClassName.equals(fileObjectClassName = fileObject.getName().replaceAll("-", ".")) && fileObject.getPath().startsWith(path)) {
                Object position = fileObject.getAttribute(POSITION_ATTRIBUTE_NAME);
                try {
                    return new ActionPosition(fileObject, Integer.valueOf(position.toString()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            for (FileObject child : children = fileObject.getChildren()) {
                ActionPosition pos = MenuUtil.getActionPosition(action, path, child);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    private static TreeMap<Integer, Action> findSeparatorsForAction(Action action, FileObject fileObject) {
        TreeMap<Integer, Action> ret = new TreeMap<Integer, Action>();
        if (fileObject != null) {
            FileObject[] children;
            String separatorAfterName = action.getClass().getName() + "." + SEPARATOR_AFTER;
            String separatorBeforeName = action.getClass().getName() + "." + SEPARATOR_BEFORE;
            String fileObjectClassName = fileObject.getName().replaceAll("-", ".");
            if (separatorAfterName.equals(fileObjectClassName) || separatorBeforeName.equals(fileObjectClassName)) {
                Object position = fileObject.getAttribute(POSITION_ATTRIBUTE_NAME);
                try {
                    int pos = Integer.valueOf(position.toString());
                    while (ret.containsKey(pos)) {
                        ++pos;
                    }
                    ret.put(pos, null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            for (FileObject child : children = fileObject.getChildren()) {
                TreeMap<Integer, Action> tmp = MenuUtil.findSeparatorsForAction(action, child);
                if (tmp.isEmpty()) continue;
                for (int pos : tmp.keySet()) {
                    while (ret.containsKey(pos)) {
                        ++pos;
                    }
                    ret.put(pos, null);
                }
            }
        }
        return ret;
    }

    private static boolean containsClass(List list, Class clazz) {
        if (list == null || clazz == null) {
            return false;
        }
        for (Object o : list) {
            if (!clazz.equals(o.getClass())) continue;
            return true;
        }
        return false;
    }

    private static List removeAllWithSameClass(List list, List remove) {
        if (list == null) {
            return new ArrayList();
        }
        if (remove == null) {
            return new ArrayList();
        }
        if (list.isEmpty() || remove.isEmpty()) {
            return new ArrayList(list);
        }
        ArrayList l = new ArrayList(list);
        for (Object o : list) {
            if (o == null) continue;
            for (Object r : remove) {
                if (r == null || !r.getClass().equals(o.getClass())) continue;
                l.remove(r);
            }
        }
        return l;
    }

    private static class ActionAndPath {
        private Action action;
        private String path;

        public ActionAndPath(Action action, String path) {
            this.action = action;
            this.path = path;
        }

        public Action getAction() {
            return this.action;
        }

        public String getPath() {
            return this.path;
        }
    }

    private static class ActionPosition {
        private FileObject fileObject;
        private int position;

        public ActionPosition(FileObject fileObject, int position) {
            this.fileObject = fileObject;
            this.position = position;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

