/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.util;

import de.proveo.idm.core.gui.LoginPanel;
import de.proveo.idm.core.gui.TextInputPanel;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.impl.IDMCredentials;
import de.proveo.idm.core.gui.util.NotificationMessage;
import de.proveo.idm.core.gui.util.Validatable;
import de.proveo.idm.core.gui.util.ValidationListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Keymap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.netbeans.api.keyring.Keyring;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public final class DialogUtil
extends DialogDescriptor {
    private static final Logger log = Logger.getLogger(DialogUtil.class.getName());
    public static final Icon DEFAULT_LOGIN_IMAGE_LEFT = new ImageIcon(DialogUtil.class.getResource("/de/proveo/idm/core/gui/util/login_default_left.png"));
    public static final Icon DEFAULT_LOGIN_IMAGE_RIGHT = new ImageIcon(DialogUtil.class.getResource("/de/proveo/idm/core/gui/util/login_default_right.png"));
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private static DialogDisplayer displayer = null;

    private DialogUtil() {
        super(null, null);
    }

    private static String convertToMultilineText(String text) {
        if (text.contains("\n")) {
            return "<html>" + StringUtils.replace((String)text, (String)"\n", (String)"<br>") + "</html>";
        }
        return text;
    }

    private static String ensureMessageLength(String text, int length) {
        return WordUtils.wrap((String)text, (int)length);
    }

    public static DialogDescriptor createDialogDescriptor(Object message, String title, boolean modal, int type) {
        return DialogUtil.createDialogDescriptor(message, title, modal, type, new Object[]{OK_OPTION});
    }

    public static DialogDescriptor createDialogDescriptor(Object message, String title, boolean modal, int type, Object[] options) {
        final DialogDescriptor dd = new DialogDescriptor(message, title);
        dd.setMessageType(type);
        dd.setModal(modal);
        if (options != null) {
            dd.setOptions(options);
        }
        if (message instanceof HelpCtx.Provider) {
            dd.setHelpCtx(((HelpCtx.Provider)message).getHelpCtx());
        } else if (message instanceof HelpCtx) {
            dd.setHelpCtx((HelpCtx)message);
        }
        if (message instanceof Validatable) {
            final Validatable v = (Validatable)message;
            final NotificationLineSupport nls = dd.createNotificationLineSupport();
            dd.setValid(v.checkValidation());
            DialogUtil.showNotificationMessage(nls, v.getNotificationMessage());
            v.addValidationListener(new ValidationListener(){

                @Override
                public void validationChanged() {
                    dd.setValid(v.checkValidation());
                    DialogUtil.showNotificationMessage(nls, v.getNotificationMessage());
                }

                @Override
                public void notificationChanged() {
                    DialogUtil.showNotificationMessage(nls, v.getNotificationMessage());
                }
            });
        }
        return dd;
    }

    private static void showNotificationMessage(NotificationLineSupport nls, NotificationMessage msg) {
        if (msg != null) {
            String msgString = msg.getMessage();
            int msgType = msg.getMessageType();
            switch (msgType) {
                case 0: {
                    nls.setErrorMessage(msgString);
                    break;
                }
                case 2: {
                    nls.setWarningMessage(msgString);
                    break;
                }
                case 1: {
                    nls.setInformationMessage(msgString);
                    break;
                }
                default: {
                    log.log(Level.WARNING, "Unknown validation message type: {0}. Will show it as an error message.", msgType);
                    nls.setErrorMessage(msgString);
                    break;
                }
            }
        } else {
            nls.clearMessages();
        }
    }

    public static DialogDescriptor createDialogDescriptor(Object message, String title, boolean modal, int type, int optionType) {
        DialogDescriptor dd = DialogUtil.createDialogDescriptor(message, title, modal, type, null);
        dd.setOptionType(optionType);
        return dd;
    }

    public static void configureWizardDescriptorPanels(WizardDescriptor.Panel[] panels) {
        String[] steps = new String[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            Component c = panels[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_image", ImageUtilities.loadImage((String)"de/proveo/idm/core/gui/util/wizardBanner.png"));
        }
    }

    private static JFileChooser createFileChooser(File currentDirectory, boolean acceptAllFileFilterUsed, boolean multiSelectionEnabled, boolean fileHidingEnabled, int fileSelectionMode, FileFilter ... filters) {
        JFileChooser fc = new JFileChooser();
        if (currentDirectory != null) {
            fc.setCurrentDirectory(currentDirectory);
            if (currentDirectory.isFile()) {
                fc.setSelectedFile(currentDirectory);
            }
        }
        fc.setAcceptAllFileFilterUsed(filters == null || filters.length == 0 || acceptAllFileFilterUsed);
        fc.setMultiSelectionEnabled(multiSelectionEnabled);
        fc.setFileHidingEnabled(fileHidingEnabled);
        fc.setFileSelectionMode(fileSelectionMode);
        if (filters != null && filters.length > 0) {
            for (FileFilter filter : filters) {
                fc.addChoosableFileFilter(filter);
            }
            fc.setFileFilter(filters[0]);
        }
        return fc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File[] showFileChooserDialog(FILE_DIALOG_TYPE type, String propertyName, String assumedFileName, boolean acceptAllFileFilterUsed, boolean multiSelectionEnabled, boolean fileHidingEnabled, int fileSelectionMode, FileFilter ... filters) {
        Preferences prefs = NbPreferences.forModule(DialogUtil.class);
        File currentDirectory = null;
        String currentDirectoryPath = prefs.get(propertyName, System.getProperty("user.home"));
        if (currentDirectoryPath != null) {
            currentDirectory = new File(currentDirectoryPath);
            if (!currentDirectory.exists()) {
                currentDirectory = null;
            } else if (fileSelectionMode == 1 && currentDirectory.isFile()) {
                currentDirectory = currentDirectory.getParentFile();
            }
        }
        if (FILE_DIALOG_TYPE.SAVE.equals((Object)type) && multiSelectionEnabled) {
            multiSelectionEnabled = false;
        }
        File[] ret = null;
        JFileChooser fc = DialogUtil.createFileChooser(currentDirectory, acceptAllFileFilterUsed, multiSelectionEnabled, fileHidingEnabled, fileSelectionMode, filters);
        if (fileSelectionMode != 1 && assumedFileName != null && assumedFileName.trim().length() != 0) {
            if (currentDirectory != null) {
                String parentDir = currentDirectory.getPath();
                if (currentDirectory.isFile()) {
                    parentDir = currentDirectory.getParentFile().getAbsolutePath();
                }
                if (!parentDir.endsWith(File.separator)) {
                    parentDir = parentDir + File.separator;
                }
                assumedFileName = parentDir + assumedFileName;
            }
            fc.setSelectedFile(new File(assumedFileName));
        }
        int n = 1;
        if (FILE_DIALOG_TYPE.OPEN.equals((Object)type)) {
            n = fc.showOpenDialog(WindowManager.getDefault().getMainWindow());
        } else if (FILE_DIALOG_TYPE.SAVE.equals((Object)type)) {
            n = fc.showSaveDialog(WindowManager.getDefault().getMainWindow());
        }
        while (true) {
            File selectedFile;
            block36: {
                block37: {
                    block35: {
                        block33: {
                            int n2;
                            String[] stringArray;
                            boolean fileExtFound;
                            String[] extensions;
                            block34: {
                                block32: {
                                    FileNameExtensionFilter extFileFilter;
                                    FileFilter selectedFileFilter;
                                    if (n != 0 || ret != null) break block32;
                                    if (multiSelectionEnabled) {
                                        ret = fc.getSelectedFiles();
                                        continue;
                                    }
                                    selectedFile = fc.getSelectedFile();
                                    if (selectedFile == null) continue;
                                    if (FILE_DIALOG_TYPE.SAVE.equals((Object)type) && !selectedFile.exists()) {
                                        String filename = selectedFile.getName();
                                        boolean valid = true;
                                        try {
                                            File aFile = File.createTempFile("file_creation_test_" + filename, null);
                                            aFile.delete();
                                        }
                                        catch (IOException e) {
                                            valid = false;
                                        }
                                        if (!valid) {
                                            DialogUtil.showErrorDialog(NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.fileNameInvalid.msg"), NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.fileNameInvalid.title"));
                                            ret = null;
                                            n = fc.showSaveDialog(WindowManager.getDefault().getMainWindow());
                                            continue;
                                        }
                                    }
                                    if (!FILE_DIALOG_TYPE.SAVE.equals((Object)type) || fileSelectionMode != 0 || (selectedFileFilter = fc.getFileFilter()) == null || selectedFileFilter.equals(fc.getAcceptAllFileFilter()) || !(selectedFileFilter instanceof FileNameExtensionFilter) || (extensions = (extFileFilter = (FileNameExtensionFilter)selectedFileFilter).getExtensions()) == null) break block33;
                                    fileExtFound = false;
                                    stringArray = extensions;
                                    n2 = stringArray.length;
                                    break block34;
                                }
                                if (ret == null) return ret;
                                if (ret.length <= 0) return ret;
                                File newDirectory = ret[0];
                                if (multiSelectionEnabled) {
                                    newDirectory = newDirectory.getParentFile();
                                }
                                prefs.put(propertyName, newDirectory.getAbsolutePath());
                                try {
                                    prefs.flush();
                                    return ret;
                                }
                                catch (BackingStoreException ex) {
                                    log.log(Level.WARNING, "Could not save new path for " + propertyName, ex);
                                }
                                return ret;
                            }
                            for (int i = 0; i < n2; ++i) {
                                String ext = stringArray[i];
                                if (!selectedFile.getName().endsWith("." + ext)) continue;
                                fileExtFound = true;
                                break;
                            }
                            if (!fileExtFound) {
                                selectedFile = new File(selectedFile.getAbsolutePath() + "." + extensions[0]);
                                fc.setSelectedFile(selectedFile);
                            }
                        }
                        if (!FILE_DIALOG_TYPE.SAVE.equals((Object)type) || !selectedFile.exists() || selectedFile.isDirectory()) break block35;
                        Object overwrite = DialogUtil.showYesNoCancelQuestionDialog(NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.fileExists.msg", (Object)selectedFile.getName()), NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.fileExists.title"));
                        if (NO_OPTION.equals(overwrite)) {
                            ret = null;
                            n = fc.showSaveDialog(WindowManager.getDefault().getMainWindow());
                            continue;
                        }
                        if (!YES_OPTION.equals(overwrite)) {
                            return null;
                        }
                        break block36;
                    }
                    if (!FILE_DIALOG_TYPE.SAVE.equals((Object)type) || fileSelectionMode == 0 || selectedFile.exists()) break block37;
                    Object create = DialogUtil.showYesNoCancelQuestionDialog(NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.folderNotExists.msg", (Object)selectedFile.getName()), NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.folderNotExists.title"));
                    if (YES_OPTION.equals(create)) {
                        boolean folderCreated;
                        try {
                            folderCreated = selectedFile.mkdirs();
                        }
                        catch (Throwable ex) {
                            folderCreated = false;
                        }
                        if (!folderCreated) {
                            DialogUtil.showErrorDialog(NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.folderNotCreated.msg", (Object)selectedFile.getName()), NbBundle.getMessage(DialogUtil.class, (String)"DialogUtil.fileChooser.folderNotCreated.title"));
                            ret = null;
                            n = fc.showSaveDialog(WindowManager.getDefault().getMainWindow());
                            continue;
                        }
                        break block36;
                    } else {
                        if (!NO_OPTION.equals(create)) {
                            return null;
                        }
                        ret = null;
                        n = fc.showSaveDialog(WindowManager.getDefault().getMainWindow());
                        continue;
                    }
                }
                if (FILE_DIALOG_TYPE.OPEN.equals((Object)type) && !selectedFile.exists()) {
                    ret = null;
                    n = fc.showOpenDialog(WindowManager.getDefault().getMainWindow());
                    continue;
                }
            }
            ret = new File[]{selectedFile};
        }
    }

    public static File showSingleOpenFileChooserDialog(String propertyName, boolean acceptAllFileFilterUsed, boolean fileHidingEnabled, int fileSelectionMode, FileFilter ... filters) {
        File[] ret = DialogUtil.showFileChooserDialog(FILE_DIALOG_TYPE.OPEN, propertyName, null, acceptAllFileFilterUsed, false, fileHidingEnabled, fileSelectionMode, filters);
        if (ret != null && ret.length > 0) {
            return ret[0];
        }
        return null;
    }

    public static File[] showMultiOpenFileChooserDialog(String propertyName, boolean acceptAllFileFilterUsed, boolean fileHidingEnabled, int fileSelectionMode, FileFilter ... filters) {
        return DialogUtil.showFileChooserDialog(FILE_DIALOG_TYPE.OPEN, propertyName, null, acceptAllFileFilterUsed, true, fileHidingEnabled, fileSelectionMode, filters);
    }

    public static File showSaveFileChooserDialog(String propertyName, boolean acceptAllFileFilterUsed, boolean fileHidingEnabled, int fileSelectionMode, FileFilter ... filters) {
        File[] ret = DialogUtil.showFileChooserDialog(FILE_DIALOG_TYPE.SAVE, propertyName, null, acceptAllFileFilterUsed, false, fileHidingEnabled, fileSelectionMode, filters);
        if (ret != null && ret.length > 0) {
            return ret[0];
        }
        return null;
    }

    public static File showSaveFileChooserDialog(String propertyName, String assumedFileName, boolean acceptAllFileFilterUsed, boolean fileHidingEnabled, int fileSelectionMode, FileFilter ... filters) {
        File[] ret = DialogUtil.showFileChooserDialog(FILE_DIALOG_TYPE.SAVE, propertyName, assumedFileName, acceptAllFileFilterUsed, false, fileHidingEnabled, fileSelectionMode, filters);
        if (ret != null && ret.length > 0) {
            return ret[0];
        }
        return null;
    }

    public static Credentials showLoginDialog(String message, String title, String passwordPropertyKey, String username, Icon leftImage, Icon rightImag) {
        return DialogUtil.showLoginDialog(message, title, passwordPropertyKey, username, true, leftImage, rightImag);
    }

    public static Credentials showLoginDialog(String message, String title, String passwordPropertyKey, String username, boolean usernameVisible, Icon leftImage, Icon rightImage) {
        LoginPanel loginPanel = new LoginPanel();
        loginPanel.setMessage(message);
        loginPanel.setUsername(username);
        loginPanel.setUsernameFieldEnabled(usernameVisible);
        loginPanel.setPassword(Keyring.read((String)String.format(passwordPropertyKey, username)));
        loginPanel.setImage(leftImage, rightImage);
        DialogDescriptor dd = DialogUtil.createDialogDescriptor((Object)loginPanel, title, true, -1, 2);
        Object n = DialogUtil.showDialogDescriptor(dd, false);
        if (OK_OPTION.equals(n)) {
            String user = loginPanel.getUsername();
            char[] password = loginPanel.getPassword();
            boolean storePasswords = loginPanel.isStorePassword();
            if (storePasswords) {
                Keyring.save((String)String.format(passwordPropertyKey, user), (char[])ArrayUtils.clone((char[])password), (String)"");
            } else {
                Keyring.delete((String)String.format(passwordPropertyKey, user));
            }
            Preferences prefs = NbPreferences.forModule(LoginPanel.class);
            prefs.putBoolean("login.storePasswords", storePasswords);
            try {
                prefs.flush();
            }
            catch (Throwable ex) {
                log.log(Level.WARNING, "Could not save store passwords property", ex);
            }
            return new IDMCredentials(user, ArrayUtils.clone((char[])password));
        }
        return null;
    }

    public static String showInputDialog(String message, String title, String errorMessage) {
        DialogDescriptor dd;
        Object n;
        TextInputPanel inputPanel = new TextInputPanel(message);
        if (errorMessage != null) {
            inputPanel.setErrorMessage(errorMessage);
        }
        if (OK_OPTION.equals(n = DialogUtil.showDialogDescriptor(dd = DialogUtil.createDialogDescriptor((Object)inputPanel, title, true, -1, 2), false))) {
            return inputPanel.getText();
        }
        return null;
    }

    public static Object showMessageDialog(Object message, String title, int type) {
        return DialogUtil.showMessageDialog(message, title, true, type, new Object[]{OK_OPTION});
    }

    public static Object showMessageDialog(Object message, String title, boolean modal, int type) {
        DialogDescriptor dd = DialogUtil.createDialogDescriptor(message, title, modal, type);
        return DialogUtil.showDialogDescriptor(dd);
    }

    public static Object showMessageDialog(Object message, String title, boolean modal, int type, int optionType) {
        DialogDescriptor dd = DialogUtil.createDialogDescriptor(message, title, modal, type, optionType);
        return DialogUtil.showDialogDescriptor(dd);
    }

    public static Object showMessageDialog(Object message, String title, boolean modal, int type, Object[] options) {
        DialogDescriptor dd = DialogUtil.createDialogDescriptor(message, title, modal, type, options);
        return DialogUtil.showDialogDescriptor(dd);
    }

    public static Object showWarnDialog(Object message) {
        return DialogUtil.showWarnDialog(message, null);
    }

    public static Object showWarnDialog(Object message, String title) {
        return DialogUtil.showMessageDialog(message, title, 2);
    }

    public static Object showInfoDialog(Object message) {
        return DialogUtil.showInfoDialog(message, null);
    }

    public static Object showInfoDialog(Object message, String title) {
        return DialogUtil.showMessageDialog(message, title, 1);
    }

    public static Object showYesNoQuestionDialog(Object message) {
        return DialogUtil.showYesNoQuestionDialog(message, null);
    }

    public static Object showYesNoQuestionDialog(Object message, String title) {
        DialogDescriptor dd = DialogUtil.createDialogDescriptor(message, title, true, 3, 0);
        return DialogUtil.showDialogDescriptor(dd);
    }

    public static Object showYesNoCancelQuestionDialog(Object message) {
        return DialogUtil.showYesNoCancelQuestionDialog(message, null);
    }

    public static Object showYesNoCancelQuestionDialog(Object message, String title) {
        DialogDescriptor dd = DialogUtil.createDialogDescriptor(message, title, true, 3, 1);
        return DialogUtil.showDialogDescriptor(dd);
    }

    public static Object showOkCancelQuestionDialog(Object message) {
        return DialogUtil.showOkCancelQuestionDialog(message, null);
    }

    public static Object showOkCancelQuestionDialog(Object message, String title) {
        DialogDescriptor dd = DialogUtil.createDialogDescriptor(message, title, true, 3, 2);
        return DialogUtil.showDialogDescriptor(dd);
    }

    public static Object showErrorDialog(Object message) {
        return DialogUtil.showErrorDialog(message, null);
    }

    public static Object showErrorDialog(Object message, String title) {
        return DialogUtil.showMessageDialog(message, title, 0);
    }

    public static Object showDialogDescriptor(DialogDescriptor dd) {
        return DialogUtil.showDialogDescriptor(dd, true);
    }

    public static Object showDialogDescriptor(DialogDescriptor dd, boolean resizable) {
        Dialog d;
        Window owner;
        if (displayer == null) {
            displayer = DialogDisplayer.getDefault();
        }
        if ((owner = (d = displayer.createDialog(dd)).getOwner()) == null && SwingUtilities.isEventDispatchThread()) {
            owner = WindowManager.getDefault().getMainWindow();
        }
        d.pack();
        if (owner != null) {
            d.setLocationRelativeTo(owner);
        } else {
            d.setLocationByPlatform(true);
        }
        d.setResizable(resizable);
        d.setVisible(true);
        d.toFront();
        d.requestFocusInWindow();
        d.requestFocus();
        return dd.getValue();
    }

    @Deprecated
    public static Object showNotifyDescriptor(NotifyDescriptor nd) {
        if (displayer == null) {
            displayer = DialogDisplayer.getDefault();
        }
        if (nd instanceof DialogDescriptor) {
            DialogDescriptor dd = (DialogDescriptor)nd;
            return DialogUtil.showDialogDescriptor(dd);
        }
        return displayer.notify(nd);
    }

    public static class PasswordInputLine
    extends InputLine {
        protected char[] initialPass;

        public PasswordInputLine(String text, String title) {
            super(text, title);
        }

        public PasswordInputLine(String text, String title, int optionType, int messageType) {
            super(text, title, optionType, messageType);
        }

        public PasswordInputLine(String text, String title, char[] initialPass, int optionType, int messageType) {
            super(text, title, optionType, messageType);
            this.initialPass = initialPass;
        }

        @Override
        protected Component createDesign(String text) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            JLabel textLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)textLabel, (String)text);
            boolean longText = text.length() > 20;
            this.textField = this.initialPass != null ? new JPasswordField(new String(this.initialPass), 25) : new JPasswordField(25);
            textLabel.setLabelFor(this.textField);
            this.textField.requestFocus();
            GroupLayout layout = new GroupLayout(panel);
            panel.setLayout(layout);
            if (longText) {
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(textLabel, -1, -1, Short.MAX_VALUE).addGap(32, 32, 32)).addComponent(this.textField)).addContainerGap()));
            } else {
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField, -1, 207, Short.MAX_VALUE).addContainerGap()));
            }
            if (longText) {
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
            } else {
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(textLabel).addComponent(this.textField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
            }
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            Keymap map = this.textField.getKeymap();
            map.removeKeyStrokeBinding(enter);
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
            return panel;
        }

        public char[] getPassword() {
            return ((JPasswordField)this.textField).getPassword();
        }

        public void setPassword(char[] password) {
            if (password == null) {
                password = new char[]{};
            }
            ((JPasswordField)this.textField).setText(new String(password));
        }
    }

    public static class InputLine
    extends DialogDescriptor {
        protected JTextField textField;

        public InputLine(String text, String title) {
            this(text, title, 2, -1);
        }

        public InputLine(String text, String title, int optionType, int messageType) {
            super(null, title);
            super.setOptionType(optionType);
            super.setMessageType(messageType);
            super.setMessage((Object)this.createDesign(text));
        }

        public String getInputText() {
            return this.textField.getText();
        }

        public void setInputText(String text) {
            this.textField.setText(text);
            this.textField.selectAll();
        }

        protected Component createDesign(String text) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            JLabel textLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)textLabel, (String)text);
            boolean longText = text.length() > 80;
            this.textField = new JTextField(25);
            textLabel.setLabelFor(this.textField);
            this.textField.requestFocus();
            GroupLayout layout = new GroupLayout(panel);
            panel.setLayout(layout);
            if (longText) {
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(textLabel, -1, -1, Short.MAX_VALUE).addGap(32, 32, 32)).addComponent(this.textField)).addContainerGap()));
            } else {
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField, -1, 207, Short.MAX_VALUE).addContainerGap()));
            }
            if (longText) {
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
            } else {
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(textLabel).addComponent(this.textField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
            }
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            Keymap map = this.textField.getKeymap();
            map.removeKeyStrokeBinding(enter);
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
            return panel;
        }
    }

    private static enum FILE_DIALOG_TYPE {
        OPEN,
        SAVE;

    }
}

