/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.toolbars;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class ChangeLogLevelAction
extends CallableSystemAction {
    private static final Logger log = Logger.getLogger(ChangeLogLevelAction.class.getName());
    private final JPanel toolbarComponent = new JPanel(new BorderLayout());
    private final JLabel logLabel = new JLabel(NbBundle.getMessage(ChangeLogLevelAction.class, (String)"ChangeLogLevelAction.logLevel"));
    private final JComboBox cmbBoxLogLevel;

    public ChangeLogLevelAction() {
        this.toolbarComponent.setOpaque(false);
        this.logLabel.setOpaque(false);
        this.cmbBoxLogLevel = new JComboBox<Level>(new Level[]{Level.ALL, Level.FINE, Level.FINER, Level.FINEST, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF});
        this.cmbBoxLogLevel.setPreferredSize(new Dimension(this.cmbBoxLogLevel.getPreferredSize().width, 20));
        Level currentLevel = log.getLevel();
        this.cmbBoxLogLevel.setSelectedItem(currentLevel == null ? Level.INFO : currentLevel);
        this.cmbBoxLogLevel.setToolTipText(NbBundle.getMessage(ChangeLogLevelAction.class, (String)"ChangeLogLevelAction.logLevel.tooltip"));
        this.cmbBoxLogLevel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem;
                if (1 == e.getStateChange() && (selectedItem = ChangeLogLevelAction.this.cmbBoxLogLevel.getSelectedItem()) != null) {
                    Level previousLevel = log.getLevel();
                    Level selectedLevel = Level.parse(selectedItem.toString());
                    if (!selectedLevel.equals(previousLevel)) {
                        log.log(Level.INFO, "Switching log level from ''{0}'' to ''{1}''", new Object[]{previousLevel, selectedLevel});
                        LogManager logManager = LogManager.getLogManager();
                        Enumeration<String> loggerNames = logManager.getLoggerNames();
                        while (loggerNames.hasMoreElements()) {
                            String loggerName = loggerNames.nextElement();
                            Logger logger = logManager.getLogger(loggerName);
                            if (logger == null) continue;
                            logger.setLevel(selectedLevel);
                        }
                    }
                }
            }
        });
        this.toolbarComponent.add((Component)this.logLabel, "West");
        this.toolbarComponent.add((Component)this.cmbBoxLogLevel, "Center");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(ChangeLogLevelAction.class, (String)"ChangeLogLevelAction.name");
    }

    public Component getToolbarPresenter() {
        return this.toolbarComponent;
    }

    public void performAction() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

