/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.nodes;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

public abstract class PropertyChangeNode
extends AbstractNode {
    private static final Logger log = Logger.getLogger(PropertyChangeNode.class.getName());
    protected volatile boolean sheetCreated = false;

    public PropertyChangeNode(Children children) {
        super(children);
    }

    public PropertyChangeNode(Children children, Lookup lookup) {
        super(children, lookup);
    }

    protected Sheet createSheet() {
        this.sheetCreated = true;
        return super.createSheet();
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void fireSheetChanged() {
        if (!this.sheetCreated) {
            return;
        }
        try {
            Node.PropertySet[] propSets;
            Sheet sheet = this.getSheet();
            for (Node.PropertySet propSet : propSets = sheet.cloneSheet().toArray()) {
                sheet.remove(propSet.getName());
            }
            Sheet newSheet = this.createSheet();
            this.setSheet(newSheet);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "PropertyChangeNode.fireSheetChanged() runs into", ex);
        }
    }

    public abstract Object getMarkerId();
}

