/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.filter;

import de.proveo.idm.core.gui.navigation.filter.NavigationFilter;
import org.openide.nodes.Node;

public class TextFilter
implements NavigationFilter {
    private String pattern;
    private boolean matchCase;

    public TextFilter(String filter) {
        this(filter, true);
    }

    public TextFilter(String filter, boolean matchCase) {
        this.matchCase = matchCase;
        this.pattern = filter;
    }

    @Override
    public boolean filter(Object obj) {
        if (obj instanceof Node) {
            obj = ((Node)obj).getDisplayName();
        }
        if (obj instanceof String) {
            String p = this.matchCase ? this.pattern : this.pattern.toLowerCase();
            String other = this.matchCase ? (String)obj : ((String)obj).toLowerCase();
            return other.indexOf(p) != -1;
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    @Override
    public boolean isViable(Node node) {
        if (this.filter(node.getDisplayName())) {
            return true;
        }
        if (!node.isLeaf()) {
            Node[] childrenNodes;
            for (Node child : childrenNodes = node.getChildren().getNodes()) {
                if (!this.isViable(child)) continue;
                return true;
            }
        }
        return false;
    }
}

