/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.api.impl;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.LocalDevice;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.NavigationItemManager;
import de.proveo.idm.core.gui.navigation.api.NavigationManager;
import de.proveo.idm.core.gui.navigation.api.favorites.Favorites;
import de.proveo.idm.core.gui.navigation.api.favorites.FavoritesChildrenProviderFactory;
import de.proveo.idm.core.gui.navigation.api.favorites.SelfSaveFavoritesItem;
import de.proveo.idm.core.gui.navigation.api.impl.LocalNavigationItem;
import de.proveo.idm.core.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LocalNavigationManager
implements NavigationManager {
    private final NavigationItemManager navigationItemManager = (NavigationItemManager)Lookup.getDefault().lookup(NavigationItemManager.class);
    private NavigationItem favorites = null;
    private NavigationItem callback = null;

    @Override
    public boolean isAllowedInfomanNode(Node node, Device.DeviceType deviceType) {
        SelfSaveFavoritesItem localItem = (SelfSaveFavoritesItem)node.getLookup().lookup(SelfSaveFavoritesItem.class);
        if (localItem != null) {
            LocalDevice infoman;
            if (!(deviceType.equals((Object)Device.DeviceType.ANY) || deviceType.equals((Object)Device.DeviceType.UNKNOWN) || deviceType.equals((Object)localItem.getDeviceType()))) {
                return false;
            }
            if (localItem instanceof LocalDevice && !(infoman = (LocalDevice)((Object)localItem)).isConnected()) {
                return false;
            }
        }
        return true;
    }

    public NavigationItem getFavorites() {
        return this.favorites;
    }

    public NavigationItem getCallbackGroup() {
        return this.callback;
    }

    @Override
    public void init() {
        LocalNavigationItem local = new LocalNavigationItem(NbBundle.getMessage(LocalNavigationManager.class, (String)"LocalNavigationManager.rootNode.name"));
        Favorites favoritesItem = new Favorites(NbBundle.getMessage(LocalNavigationManager.class, (String)"LocalNavigationManager.nodes.favorites.name"), local);
        LocalNavigationItem callbackItem = new LocalNavigationItem(NbBundle.getMessage(LocalNavigationManager.class, (String)"LocalNavigationManager.nodes.callback.name"), local);
        this.load(favoritesItem);
        if (!favoritesItem.getChildren().isEmpty()) {
            this.navigationItemManager.addTopLevel(local);
            this.favorites = favoritesItem;
            this.callback = callbackItem;
        }
    }

    private void load(NavigationItem favoritesItem) {
        ArrayList<FavoriteChildItem> favoriteItems = new ArrayList<FavoriteChildItem>();
        Collection favoritesChildrenProvider = Lookup.getDefault().lookupAll(FavoritesChildrenProviderFactory.class);
        for (FavoritesChildrenProviderFactory provider : favoritesChildrenProvider) {
            favoriteItems.add(new FavoriteChildItem(provider.getNavigationItem(), provider.load()));
        }
        for (FavoriteChildItem favItem : favoriteItems) {
            NavigationItem item = favItem.getItem();
            List<NavigationItem> children = favItem.getChildren();
            for (NavigationItem child : children) {
                item.addChild(child);
            }
            favoritesItem.addChild(item);
        }
    }

    @Override
    public void store() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Collection favoritesChildrenProvider = Lookup.getDefault().lookupAll(FavoritesChildrenProviderFactory.class);
                for (FavoritesChildrenProviderFactory provider : favoritesChildrenProvider) {
                    provider.store();
                }
            }
        };
        ThreadPool.getInstance().execute(run);
    }

    private class FavoriteChildItem {
        private NavigationItem item;
        private List<NavigationItem> children;

        public FavoriteChildItem(NavigationItem item, List<NavigationItem> children) {
            this.item = item;
            this.children = children;
        }

        public NavigationItem getItem() {
            return this.item;
        }

        public List<NavigationItem> getChildren() {
            return this.children;
        }
    }
}

