/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.api;

import de.proveo.client.configuration.api.Configuration;
import de.proveo.client.configuration.api.ConfigurationChangedListener;
import de.proveo.client.configuration.api.ConfigurationProvider;
import de.proveo.client.configuration.impl.FileConfigurationImpl;
import de.proveo.client.configuration.impl.MemoryConfigurationImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class EFMServerData
implements Serializable,
Cloneable {
    private static final Logger log = Logger.getLogger(EFMServerData.class.getName());
    public static final long serialVersionUID = 4L;
    public static final String PROP_CONFIGURATION_PREFIX = "EFMServerData.configuration.";
    public static final String PROP_NAME = "EFMServerData.name";
    public static final String PROP_URL = "EFMServerData.url";
    public static final String PROP_VERSION = "EFMServerData.version";
    public static final String PROP_TUNNEL = "EFMServerData.tunnel";
    public static final String PROP_INFOMAN_TUNNEL = "EFMServerData.tunnel.infoman";
    private transient ConfigurationWatcher configurationSaver = null;
    private transient ConfigurationProvider configurationProvider = null;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Properties extraProperties = new Properties();
    private Collection<String> infomanTunnel = null;
    private Collection<String> tunnel = null;
    private String version = null;
    private String servername;
    private String url;

    public EFMServerData(String name, String url) {
        this.servername = name;
        this.url = url;
        this.updateConfiguration();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayList<String> cloneTunnel;
        EFMServerData clone = new EFMServerData(this.servername, this.url);
        if (this.tunnel != null) {
            cloneTunnel = new ArrayList<String>(this.tunnel);
            clone.setTunnel(cloneTunnel);
        }
        if (this.infomanTunnel != null) {
            cloneTunnel = new ArrayList<String>(this.infomanTunnel);
            clone.setInfomanTunnel(cloneTunnel);
        }
        clone.setVersion(this.version);
        for (String key : this.extraProperties.stringPropertyNames()) {
            clone.setExtraProperty(key, this.getExtraProperty(key));
        }
        return clone;
    }

    private Configuration determineConfigurations() {
        String serverPropSuffix;
        try {
            URL serverURL = new URL(this.url);
            serverPropSuffix = this.servername + "-" + serverURL.getHost() + "." + serverURL.getPort();
        }
        catch (Exception ex) {
            serverPropSuffix = this.servername;
        }
        FileObject serverConfigFilesFolder = FileUtil.getConfigRoot().getFileObject("map/configs/" + serverPropSuffix);
        if (serverConfigFilesFolder == null) {
            try {
                FileObject mapConfigsFolder;
                FileObject mapFolder = FileUtil.getConfigRoot().getFileObject("map");
                if (mapFolder == null) {
                    mapFolder = FileUtil.getConfigRoot().createFolder("map");
                }
                if ((mapConfigsFolder = mapFolder.getFileObject("configs")) == null) {
                    mapConfigsFolder = mapFolder.createFolder("configs");
                }
                if ((serverConfigFilesFolder = mapConfigsFolder.getFileObject(serverPropSuffix)) == null) {
                    serverConfigFilesFolder = mapConfigsFolder.createFolder(serverPropSuffix);
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not create folders for configuration file structure", ex);
            }
        }
        if (serverConfigFilesFolder != null) {
            ArrayList<FileConfigurationImpl> availableConfigurations = new ArrayList<FileConfigurationImpl>();
            Configuration configuration = null;
            FileObject[] configs = serverConfigFilesFolder.getChildren();
            if (configs != null && configs.length > 0) {
                List currentConfigurations;
                Preferences prefs = NbPreferences.forModule(EFMServerData.class);
                String currentPropFileName = prefs.get(PROP_CONFIGURATION_PREFIX + serverPropSuffix, "");
                for (FileObject folder : configs) {
                    FileObject propertyFile = folder.getFileObject("map", "properties");
                    if (propertyFile == null) continue;
                    FileConfigurationImpl config = new FileConfigurationImpl(FileUtil.toFile((FileObject)propertyFile));
                    availableConfigurations.add(config);
                    if (!currentPropFileName.equals(folder.getName())) continue;
                    configuration = config;
                    break;
                }
                if (configuration == null) {
                    configuration = !availableConfigurations.isEmpty() ? (Configuration)availableConfigurations.get(0) : this.getDefaultConfiguration();
                }
                if ((currentConfigurations = this.configurationProvider.getAvailableConfigurations()).size() != availableConfigurations.size()) {
                    this.configurationProvider.setAvailableConfigurations(availableConfigurations);
                } else {
                    for (int i = 0; i < currentConfigurations.size(); ++i) {
                        Configuration currentConfig = (Configuration)currentConfigurations.get(i);
                        Configuration newConfig = (Configuration)availableConfigurations.get(i);
                        if (currentConfig instanceof MemoryConfigurationImpl) continue;
                        if (!availableConfigurations.contains(currentConfig)) {
                            this.configurationProvider.setAvailableConfigurations(availableConfigurations);
                        } else {
                            if (currentConfigurations.contains(newConfig)) continue;
                            this.configurationProvider.setAvailableConfigurations(availableConfigurations);
                        }
                        break;
                    }
                }
            } else {
                configuration = this.getDefaultConfiguration();
            }
            log.log(Level.INFO, "Set configuration file to ''{0}'' for server ''{1}'' ({2})", new Object[]{configuration.getName(), this.servername, this.url});
            return configuration;
        }
        log.log(Level.WARNING, "Could neither find nor create configuration for server {0}, will use in-memory configuration!", this.servername);
        return null;
    }

    private Configuration getDefaultConfiguration() {
        String serverPropSuffix;
        try {
            URL serverURL = new URL(this.url);
            serverPropSuffix = this.servername + "-" + serverURL.getHost() + "." + serverURL.getPort();
        }
        catch (Exception ex) {
            serverPropSuffix = this.servername;
        }
        FileObject serverConfigFilesFolder = FileUtil.getConfigRoot().getFileObject("map/configs/" + serverPropSuffix);
        if (serverConfigFilesFolder == null) {
            try {
                FileObject mapConfigsFolder;
                FileObject mapFolder = FileUtil.getConfigRoot().getFileObject("map");
                if (mapFolder == null) {
                    mapFolder = FileUtil.getConfigRoot().createFolder("map");
                }
                if ((mapConfigsFolder = mapFolder.getFileObject("configs")) == null) {
                    mapConfigsFolder = mapFolder.createFolder("configs");
                }
                if ((serverConfigFilesFolder = mapConfigsFolder.getFileObject(serverPropSuffix)) == null) {
                    serverConfigFilesFolder = mapConfigsFolder.createFolder(serverPropSuffix);
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not create folders for configuration file structure", ex);
            }
        }
        if (serverConfigFilesFolder != null) {
            FileObject propertyFile = null;
            String configFolderName = NbBundle.getMessage(EFMServerData.class, (String)"EFMServerData.defaultConfig.profileName");
            FileObject configFolder = serverConfigFilesFolder.getFileObject(configFolderName);
            if (configFolder == null) {
                try {
                    configFolder = serverConfigFilesFolder.createFolder(configFolderName);
                    propertyFile = configFolder.createData("map", "properties");
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not create configuration folder and file for configuration profile '" + configFolderName + "'", ex);
                }
            } else {
                try {
                    propertyFile = configFolder.getFileObject("map", "properties");
                    if (propertyFile == null) {
                        propertyFile = configFolder.createData("map", "properties");
                    } else {
                        log.log(Level.WARNING, "map.properties already exists for configuration profile ''{0}''", configFolderName);
                    }
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not create configuration file for configuration profile '" + configFolderName + "'", ex);
                }
            }
            if (propertyFile != null) {
                return new FileConfigurationImpl(FileUtil.toFile((FileObject)propertyFile));
            }
        } else {
            log.log(Level.WARNING, "Could neither find nor create configuration folder structure for server {0}, will use in-memory configuration!", this.servername);
        }
        return new MemoryConfigurationImpl();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof EFMServerData) {
            EFMServerData data = (EFMServerData)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)this.servername, (Object)data.servername);
            eb.append((Object)this.url, (Object)data.url);
            eb.append((Object)this.version, (Object)data.version);
            eb.append(this.tunnel, data.tunnel);
            eb.append(this.infomanTunnel, data.infomanTunnel);
            eb.append((Object)this.extraProperties, (Object)data.extraProperties);
            return eb.isEquals();
        }
        return false;
    }

    public ConfigurationProvider getConfigurationProvider() {
        if (this.configurationProvider == null) {
            if (this.configurationSaver == null) {
                this.configurationSaver = new ConfigurationWatcher();
            }
            this.configurationProvider = new ConfigurationProvider();
            this.configurationProvider.addConfigurationChangedListener((ConfigurationChangedListener)this.configurationSaver);
            Configuration configuration = this.determineConfigurations();
            if (configuration != null) {
                this.configurationProvider.setActiveConfiguration(configuration);
            }
        }
        return this.configurationProvider;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public String getExtraProperty(String key) {
        return this.getExtraProperty(key, null);
    }

    public String getExtraProperty(String key, String defaultValue) {
        return this.extraProperties.getProperty(key, defaultValue);
    }

    public Collection<String> getInfomanTunnel() {
        return this.infomanTunnel;
    }

    public String getServername() {
        return this.servername;
    }

    public Collection<String> getTunnel() {
        return this.tunnel;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.servername);
        hcb.append((Object)this.url);
        hcb.append((Object)this.version);
        hcb.append(this.tunnel);
        hcb.append(this.infomanTunnel);
        hcb.append((Object)this.extraProperties);
        return hcb.toHashCode();
    }

    public void removeExtraProperty(String key) {
        this.extraProperties.remove(key);
        this.pcs.firePropertyChange(key, null, this.extraProperties);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setExtraProperty(String key, String value) {
        this.extraProperties.setProperty(key, value);
        this.pcs.firePropertyChange(key, null, this.extraProperties);
    }

    public void setInfomanTunnel(Collection<String> infomanTunnel) {
        this.infomanTunnel = infomanTunnel;
        this.pcs.firePropertyChange(PROP_INFOMAN_TUNNEL, null, this.infomanTunnel);
    }

    public void setServername(String servername) {
        String old = this.servername;
        this.servername = servername;
        this.pcs.firePropertyChange(PROP_NAME, old, this.servername);
        this.updateConfiguration();
    }

    public void setTunnel(Collection<String> tunnel) {
        this.tunnel = tunnel;
        this.pcs.firePropertyChange(PROP_TUNNEL, null, this.tunnel);
    }

    public void setUrl(String url) {
        String old = this.url;
        this.url = url;
        this.pcs.firePropertyChange(PROP_URL, old, this.url);
        this.updateConfiguration();
    }

    public void setVersion(String version) {
        String old = this.version;
        this.version = version;
        this.pcs.firePropertyChange(PROP_VERSION, old, this.version);
    }

    private void updateConfiguration() {
        Configuration configuration;
        Configuration currentConfig = this.getConfigurationProvider().getActiveConfiguration();
        if (ObjectUtils.notEqual((Object)currentConfig, (Object)(configuration = this.determineConfigurations()))) {
            this.getConfigurationProvider().setActiveConfiguration(configuration);
        }
    }

    private class ConfigurationWatcher
    implements ConfigurationChangedListener {
        private ConfigurationWatcher() {
        }

        public void configurationChanged(Configuration oldConfig, Configuration newConfig) {
            String serverPropSuffix;
            try {
                URL serverURL = new URL(EFMServerData.this.url);
                serverPropSuffix = EFMServerData.this.servername + "-" + serverURL.getHost() + "." + serverURL.getPort();
            }
            catch (Exception ex) {
                serverPropSuffix = EFMServerData.this.servername;
            }
            Preferences prefs = NbPreferences.forModule(EFMServerData.class);
            prefs.put(EFMServerData.PROP_CONFIGURATION_PREFIX + serverPropSuffix, newConfig.getName());
            try {
                prefs.flush();
            }
            catch (Exception ex) {
                log.log(Level.INFO, "Could not flush current server configuration property", ex);
            }
        }
    }
}

