/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation.api;

import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationLoadingException;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationNotPresentException;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationSavingException;
import de.proveo.idm.core.gui.navigation.api.exceptions.InvalidDeviceConfigurationException;
import de.proveo.idm.core.gui.navigation.api.exceptions.NotConnectedException;
import de.proveo.idm.core.gui.navigation.api.exceptions.PositionNotPresentException;
import de.proveo.idm.core.gui.navigation.api.exceptions.VersionNotPresentException;
import de.proveo.idm.core.util.Configuration;
import de.proveo.util.geo.GPSPosition;
import java.io.File;

public interface Device {
    public Configuration openConfiguration(SoftwareBundle var1) throws NotConnectedException, ConfigurationLoadingException, ConfigurationNotPresentException, InvalidDeviceConfigurationException;

    public boolean saveConfiguration(File var1) throws NotConnectedException, InvalidDeviceConfigurationException, ConfigurationSavingException;

    public String getName();

    public DeviceType getDeviceType();

    public String getSoftwareVersion() throws NotConnectedException, VersionNotPresentException;

    public GPSPosition getPosition() throws PositionNotPresentException;

    public static enum DeviceType {
        INFOMAN("Infoman"),
        INFOMAN_EFM("InfomanLite"),
        ERCO_GENER("Erco&Gener"),
        TK_CHEL("TK-Chel"),
        TELIC("Telic"),
        GPS_VISION("GPSVision"),
        OMNICOM("Omnicom"),
        NOMO("Non-Motorized"),
        UNKNOWN("Unknown"),
        ANY("any");

        private final String name;

        private DeviceType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static DeviceType nameOf(String name) {
            DeviceType[] types;
            if ("InfomanEFM".equalsIgnoreCase(name)) {
                return INFOMAN_EFM;
            }
            for (DeviceType type : types = DeviceType.values()) {
                if (!type.name.equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

