/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation;

import de.proveo.idm.core.gui.navigation.TopLevelNavigationChildren;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.Server;
import de.proveo.idm.core.gui.navigation.api.ServerNavigationItem;
import de.proveo.idm.core.gui.navigation.filter.TextFilter;
import de.proveo.idm.core.gui.navigation.nodes.NavigationFilterNode;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="NavigationTopComponent", persistenceType=0)
public final class NavigationTopComponent
extends TopComponent
implements ExplorerManager.Provider,
DocumentListener {
    private static final Logger log = Logger.getLogger(NavigationTopComponent.class.getName());
    private static NavigationTopComponent instance;
    protected static final String PREFERRED_ID = "NavigationTopComponent";
    private final List<NavigationItem> expandedNodes = new ArrayList<NavigationItem>();
    private final List<NavigationItem> expandedNodesBeforeFilter = new ArrayList<NavigationItem>();
    private final ExplorerManager em = new ExplorerManager();
    private Lookup lookup;
    private TreeView view;
    private Node[] selectedNodes;
    private JButton clearFilterBtn;
    private JPanel controlPanel;
    private JLabel filterLbl;
    private JToggleButton filterSettingsBtn;
    private JTextField filterTxtFld;
    private JPanel jSearchPanel;
    private JCheckBox matchCaseChkBox;
    private JScrollPane navigationPane;

    public NavigationTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(NavigationTopComponent.class, (String)"CTL_NavigationTopComponent"));
        this.setToolTipText(NbBundle.getMessage(NavigationTopComponent.class, (String)"HINT_NavigationTopComponent"));
        ActionMap aMap = this.getActionMap();
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.em, (ActionMap)aMap);
        this.associateLookup(this.lookup);
        this.em.setRootContext((Node)new NavigationRootNode());
        ((BeanTreeView)this.navigationPane).setRootVisible(false);
        ((BeanTreeView)this.navigationPane).setDragSource(true);
        ((BeanTreeView)this.navigationPane).setDropTarget(true);
        ((BeanTreeView)this.navigationPane).setSelectionMode(1);
        ((BeanTreeView)this.navigationPane).setAllowedDragActions(2);
        ((BeanTreeView)this.navigationPane).setAllowedDropActions(2);
        this.view = (TreeView)this.navigationPane;
        this.matchCaseChkBox.setVisible(false);
        this.view.setQuickSearchAllowed(false);
    }

    public void clearFilter() {
        this.filterTxtFld.setText("");
    }

    private void initComponents() {
        this.navigationPane = new BeanTreeView();
        this.controlPanel = new JPanel();
        this.jSearchPanel = new JPanel();
        this.filterLbl = new JLabel();
        this.filterTxtFld = new JTextField();
        this.clearFilterBtn = new JButton();
        this.filterSettingsBtn = new JToggleButton();
        this.matchCaseChkBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.add(this.navigationPane, "Center");
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 1));
        Mnemonics.setLocalizedText((JLabel)this.filterLbl, (String)NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filterLbl.text"));
        this.filterTxtFld.setText(NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filterTxtFld.text"));
        this.clearFilterBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/delFilter.png")));
        this.clearFilterBtn.setToolTipText(NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filter.clear.tooltip"));
        this.clearFilterBtn.setMaximumSize(new Dimension(20, 20));
        this.clearFilterBtn.setMinimumSize(new Dimension(16, 16));
        this.clearFilterBtn.setPreferredSize(new Dimension(20, 20));
        this.clearFilterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationTopComponent.this.clearFilterBtnActionPerformed(evt);
            }
        });
        this.filterSettingsBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/filter.png")));
        this.filterSettingsBtn.setToolTipText(NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filter.settings.tooltip"));
        this.filterSettingsBtn.setMaximumSize(new Dimension(20, 20));
        this.filterSettingsBtn.setMinimumSize(new Dimension(16, 16));
        this.filterSettingsBtn.setPreferredSize(new Dimension(20, 20));
        this.filterSettingsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationTopComponent.this.filterSettingsBtnActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.matchCaseChkBox, (String)NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.matchCaseChkBox.text"));
        this.matchCaseChkBox.setMargin(new Insets(2, 0, 2, 2));
        this.matchCaseChkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NavigationTopComponent.this.matchCaseChkBoxItemStateChanged(evt);
            }
        });
        GroupLayout jSearchPanelLayout = new GroupLayout(this.jSearchPanel);
        this.jSearchPanel.setLayout(jSearchPanelLayout);
        jSearchPanelLayout.setHorizontalGroup(jSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jSearchPanelLayout.createSequentialGroup().addComponent(this.filterLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterTxtFld, -1, 301, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearFilterBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterSettingsBtn, -2, -1, -2)).addGroup(jSearchPanelLayout.createSequentialGroup().addComponent(this.matchCaseChkBox).addContainerGap()));
        jSearchPanelLayout.setVerticalGroup(jSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jSearchPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.matchCaseChkBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.filterLbl).addComponent(this.filterTxtFld, -2, -1, -2).addComponent(this.clearFilterBtn, -2, -1, -2).addComponent(this.filterSettingsBtn, -2, -1, -2))));
        this.controlPanel.add(this.jSearchPanel);
        this.add(this.controlPanel, "South");
    }

    private void clearFilterBtnActionPerformed(ActionEvent evt) {
        this.clearFilter();
    }

    private void filterSettingsBtnActionPerformed(ActionEvent evt) {
        this.matchCaseChkBox.setVisible(this.filterSettingsBtn.isSelected());
    }

    private void matchCaseChkBoxItemStateChanged(ItemEvent evt) {
        this.handleFilterInput();
    }

    public static synchronized NavigationTopComponent getDefault() {
        if (instance == null) {
            instance = new NavigationTopComponent();
        }
        return instance;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx ret = super.getHelpCtx();
        Node[] nodes = this.em.getSelectedNodes();
        if (nodes.length == 1 && (ret = nodes[0].getHelpCtx()) == null) {
            ret = super.getHelpCtx();
        }
        return ret;
    }

    public static synchronized NavigationTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(NavigationTopComponent.class.getName()).warning("Cannot find NavigationTopComponent component. It will not be located properly in the window system.");
            return NavigationTopComponent.getDefault();
        }
        if (win instanceof NavigationTopComponent) {
            return (NavigationTopComponent)win;
        }
        Logger.getLogger(NavigationTopComponent.class.getName()).warning("There seem to be multiple components with the 'NavigationTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return NavigationTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.filterTxtFld.getDocument().addDocumentListener(this);
    }

    public void componentClosed() {
        this.filterTxtFld.getDocument().removeDocumentListener(this);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleFilterInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleFilterInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleFilterInput();
    }

    private synchronized void handleFilterInput() {
        String pattern = this.filterTxtFld.getText();
        Node root = this.em.getRootContext();
        if (pattern.trim().length() != 0) {
            ((BeanTreeView)this.navigationPane).setRootVisible(true);
            TextFilter filter = new TextFilter(pattern, this.matchCaseChkBox.isSelected());
            if (root instanceof NavigationFilterNode) {
                Node original = ((NavigationFilterNode)root).getOriginal();
                NavigationFilterNode newNode = new NavigationFilterNode(original, filter);
                if (original.isLeaf()) {
                    newNode = new NavigationFilterNode(original);
                }
                this.em.setRootContext((Node)newNode);
            } else {
                this.findExpandedNodes(root, this.expandedNodesBeforeFilter);
                NavigationFilterNode filtered = new NavigationFilterNode(root, filter);
                if (root.isLeaf()) {
                    filtered = new NavigationFilterNode(root);
                }
                this.em.setRootContext((Node)filtered);
            }
            this.view.expandAll();
        } else {
            ((BeanTreeView)this.navigationPane).setRootVisible(false);
            root = this.em.getRootContext();
            if (root instanceof NavigationFilterNode) {
                Node original = ((NavigationFilterNode)root).getOriginal();
                this.em.setRootContext(original);
                this.expandOriginalNodes(original, this.expandedNodesBeforeFilter);
            }
        }
    }

    public void setSelectedNode(Node node) {
        try {
            this.em.setExploredContextAndSelection(node, new Node[]{node});
            Node[] selected = this.em.getSelectedNodes();
            for (int i = 0; !(i >= 10 || selected != null && selected.length == 1 && selected[0].equals((Object)node)); ++i) {
                this.em.setExploredContextAndSelection(node, new Node[]{node});
                selected = this.em.getSelectedNodes();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not select given node", ex);
        }
    }

    public <T extends NavigationItem> Collection<T> findNavigationItemsByType(Class<? extends T> type) {
        return this._findNavigationItemsByType(this.em.getRootContext(), type);
    }

    public ServerNavigationItem findServerNavigationItemByServer(Server server) {
        Collection<ServerNavigationItem> serverItems = this.findNavigationItemsByType(ServerNavigationItem.class);
        if (serverItems != null) {
            for (ServerNavigationItem serverItem : serverItems) {
                if (serverItem == null || !ObjectUtils.equals((Object)server, serverItem.getServerInstance())) continue;
                return serverItem;
            }
        }
        return null;
    }

    public <T extends Node> Collection<T> findNodesOfServerByType(Server server, Class<? extends T> type) {
        Node serverNode;
        ServerNavigationItem serverItem = this.findServerNavigationItemByServer(server);
        if (serverItem != null && (serverNode = this.findNodeByNavigationItem(serverItem)) != null) {
            return this._findNodesByType(serverNode, type);
        }
        return Collections.emptyList();
    }

    public <T extends NavigationItem> Collection<T> findNavigationItemsOfServerByType(Server server, Class<? extends T> type) {
        Node serverNode;
        ServerNavigationItem serverItem = this.findServerNavigationItemByServer(server);
        if (serverItem != null && (serverNode = this.findNodeByNavigationItem(serverItem)) != null) {
            return this._findNavigationItemsByType(serverNode, type);
        }
        return Collections.emptyList();
    }

    private <T extends NavigationItem> Collection<T> _findNavigationItemsByType(Node node, Class<? extends T> type) {
        NavigationItem nodeNavItem;
        ArrayList<NavigationItem> ret = new ArrayList<NavigationItem>();
        Node originalNode = node;
        if (node instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)node).getOriginal();
        }
        if ((nodeNavItem = (NavigationItem)originalNode.getLookup().lookup(NavigationItem.class)) != null && type.isInstance(nodeNavItem)) {
            ret.add(nodeNavItem);
        }
        if (!originalNode.isLeaf()) {
            for (Node child : node.getChildren().getNodes()) {
                Collection<T> itemNodeList = this._findNavigationItemsByType(child, type);
                if (itemNodeList == null || itemNodeList.isEmpty()) continue;
                ret.addAll(itemNodeList);
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        return null;
    }

    public Node findNodeByNavigationItem(NavigationItem item) {
        return this._findNodeByNavigationItem(this.em.getRootContext(), item);
    }

    private Node _findNodeByNavigationItem(Node node, NavigationItem item) {
        NavigationItem nodeNavItem;
        Node originalNode = node;
        if (node instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)node).getOriginal();
        }
        if ((nodeNavItem = (NavigationItem)originalNode.getLookup().lookup(NavigationItem.class)) != null && nodeNavItem.equals(item)) {
            return node;
        }
        if (!node.isLeaf()) {
            for (Node child : node.getChildren().getNodes()) {
                Node itemNode = this._findNodeByNavigationItem(child, item);
                if (itemNode == null) continue;
                return itemNode;
            }
        }
        return null;
    }

    private <T extends Node> Collection<T> _findNodesByType(Node node, Class<? extends T> type) {
        ArrayList<Object> ret = new ArrayList<Object>();
        Node originalNode = node;
        if (node instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)node).getOriginal();
        }
        if (type.isInstance(originalNode)) {
            ret.add(originalNode);
        }
        if (!originalNode.isLeaf()) {
            for (Node child : originalNode.getChildren().getNodes()) {
                Collection<T> childNodes = this._findNodesByType(child, type);
                if (childNodes.isEmpty()) continue;
                ret.addAll(childNodes);
            }
        }
        return ret;
    }

    public void findExpandedNodes(Node root) {
        this.findExpandedNodes(root, this.expandedNodes);
    }

    private void findExpandedNodes(Node root, List<NavigationItem> expandedNodes) {
        this.selectedNodes = this.em.getSelectedNodes();
        expandedNodes.clear();
        this._findExpandedNodes(root, expandedNodes);
    }

    private void _findExpandedNodes(Node node, List<NavigationItem> expandedNodes) {
        Node originalNode = node;
        if (node != null && node instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)node).getOriginal();
        }
        if (node != null && !node.isLeaf()) {
            NavigationItem navItem = (NavigationItem)originalNode.getLookup().lookup(NavigationItem.class);
            if (this.view.isExpanded(node) && navItem != null) {
                expandedNodes.add(navItem);
                for (Node child : node.getChildren().getNodes()) {
                    if (!this.view.isExpanded(child)) continue;
                    this._findExpandedNodes(child, expandedNodes);
                }
            }
        }
    }

    public void expandOriginalNodes(Node root) {
        this.expandOriginalNodes(root, this.expandedNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandOriginalNodes(Node root, List<NavigationItem> expandedNodes) {
        this._expandOriginalNodes(root, expandedNodes);
        expandedNodes.clear();
        if (this.selectedNodes != null && this.selectedNodes.length > 0) {
            try {
                this.em.setSelectedNodes(this.selectedNodes);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.selectedNodes = null;
            }
        }
    }

    private void _expandOriginalNodes(Node root, List<NavigationItem> expandedNodes) {
        Node originalNode = root;
        if (root != null && root instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)root).getOriginal();
        }
        if (root != null && !root.isLeaf()) {
            NavigationItem nodeNavItem = (NavigationItem)originalNode.getLookup().lookup(NavigationItem.class);
            if (expandedNodes.contains(nodeNavItem)) {
                this.view.expandNode(root);
            }
            for (Node child : root.getChildren().getNodes()) {
                this._expandOriginalNodes(child, expandedNodes);
            }
        }
    }

    public boolean isNodeExpanded(Node node) throws Exception {
        return this.view.isExpanded(node);
    }

    public void expandNode(Node node) throws Exception {
        this.view.expandNode(node);
    }

    private class NavigationRootNode
    extends AbstractNode {
        public NavigationRootNode() {
            super((Children)new TopLevelNavigationChildren());
        }

        public String getDisplayName() {
            return NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.rootNode.name");
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"de/proveo/idm/core/filter.png");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }
}

