/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.NavigationItemManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NavigationItemManagerImpl
implements NavigationItemManager {
    private final List<NavigationItem> topLevelNavigationItems = new ArrayList<NavigationItem>();
    private final PropertyChangeSupport porpertyChanceSupport = new PropertyChangeSupport(this);

    @Override
    public List<NavigationItem> getTopLevelNavigationItems() {
        return Collections.unmodifiableList(this.topLevelNavigationItems);
    }

    @Override
    public void addTopLevel(NavigationItem navigationItem) {
        this.topLevelNavigationItems.add(navigationItem);
        this.porpertyChanceSupport.firePropertyChange("navItemAdd", null, navigationItem);
    }

    @Override
    public void remove(NavigationItem navigationItem) {
        this.topLevelNavigationItems.remove(navigationItem);
        this.porpertyChanceSupport.firePropertyChange("navItemRemove", navigationItem.getParent(), navigationItem);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.porpertyChanceSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.porpertyChanceSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void init() {
    }
}

