/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core;

import de.proveo.idm.core.RootFrame;
import de.proveo.idm.core.gui.navigation.api.AppearancePreferencesProvider;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.impl.LocalNavigationManager;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.gui.util.PresentationMode;
import de.proveo.idm.core.util.ApplicationTimer;
import de.proveo.idm.core.util.ThreadPool;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.UIManager;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.core.ProxySettings;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.NetworkSettings;

public class Installer
extends ModuleInstall {
    private static final Logger log = Logger.getLogger(Installer.class.getName());

    public void close() {
        ThreadPool.getInstance().shutdown();
        ApplicationTimer.shutdown();
    }

    public boolean closing() {
        if (PresentationMode.getInstance().isPresentationMode()) {
            PresentationMode.getInstance().setPresentationMode(false);
        }
        return !PresentationMode.getInstance().isPresentationMode();
    }

    private static void disableCertificateValidation() {
        Authenticator.setDefault(new IDMAuthenticator());
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            log.info("Installed the all-trusting trust manager");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not install the all-trusting trust manager!", e);
        }
    }

    public void restored() {
        log.info("Restoring Core module ...");
        Installer.disableCertificateValidation();
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        String langCode = prefs.get("AppearancePreferencesProvider.language", "US-en");
        if (langCode != null && langCode.trim().length() != 0) {
            log.log(Level.INFO, "Default language ({0}) will be switched to: {1}", new Object[]{Locale.getDefault().getDisplayName(), langCode});
            String country = null;
            String language = langCode;
            if (langCode.contains("-")) {
                String[] values = org.apache.commons.lang3.StringUtils.split((String)langCode, (char)'-');
                if (values.length == 2) {
                    country = values[0];
                    language = values[1];
                } else {
                    language = null;
                    log.log(Level.WARNING, "Could not parse given language code: {0}", langCode);
                }
            } else if (langCode.length() != 2) {
                language = null;
                log.log(Level.WARNING, "Could not parse given language code: {0}", langCode);
            }
            if (language != null) {
                Locale locale = country != null ? new Locale(language, country) : new Locale(language);
                Locale.setDefault(locale);
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not set look and feel", ex);
        }
        UIManager.put("NbMainWindow.showCustomBackground", Boolean.TRUE);
        RootFrame.init();
        LocalNavigationManager manager = (LocalNavigationManager)Lookup.getDefault().lookup(LocalNavigationManager.class);
        manager.init();
        this.check();
        log.info("Core module restored.");
    }

    private void check() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (Installer.this.checkVersion()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html>");
                        sb.append(NbBundle.getMessage(Installer.class, (String)"Installer.validate.info1"));
                        sb.append(" ");
                        sb.append("<b>");
                        sb.append(NbBundle.getMessage(Installer.class, (String)"Installer.validate.info2"));
                        sb.append("</b><br>");
                        sb.append(NbBundle.getMessage(Installer.class, (String)"Installer.validate.info3"));
                        sb.append(" <font color=\"red\">");
                        sb.append(System.getProperty("java.runtime.version"));
                        sb.append("</font>");
                        DialogUtil.showInfoDialog(sb.toString(), "Java version");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread thread = new Thread(run);
        thread.start();
    }

    private boolean checkVersion() {
        try {
            String[] parts;
            String check = System.getProperty("java.runtime.version");
            if (check != null && !check.isEmpty() && (parts = check.split("\\.")).length > 1) {
                int versionLevel1 = Integer.parseInt(parts[0]);
                if (versionLevel1 < 1) {
                    return true;
                }
                if (versionLevel1 == 1) {
                    String updateString;
                    int update;
                    String[] buffer;
                    int versionLevel3;
                    int versionLevel2 = Integer.parseInt(parts[1]);
                    if (versionLevel2 < 6) {
                        return true;
                    }
                    if (versionLevel2 == 6 && (versionLevel3 = Integer.parseInt((buffer = parts[2].split("_"))[0])) == 0 && (update = Integer.parseInt(updateString = buffer[1].split("-")[0])) < 14) {
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class IDMAuthenticator
    extends Authenticator {
        private static final Map<URL, Long> lastAutoLoginTimePerURL = new HashMap<URL, Long>();
        private static final long TIMEOUT = 3000L;
        private static long lastTry = 0L;

        private IDMAuthenticator() {
        }

        private PasswordAuthentication getAuthenticationFromURL() {
            String auth;
            URL u = this.getRequestingURL();
            if (u != null && (auth = u.getUserInfo()) != null) {
                int i = auth.indexOf(58);
                String user = i == -1 ? auth : auth.substring(0, i);
                String pwd = i == -1 ? "" : auth.substring(i + 1);
                return new PasswordAuthentication(user, pwd.toCharArray());
            }
            return null;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (Authenticator.RequestorType.PROXY == this.getRequestorType() && ProxySettings.useAuthentication()) {
                Logger.getLogger(IDMAuthenticator.class.getName()).log(Level.FINER, "Username set to {0} while request {1}", new Object[]{ProxySettings.getAuthenticationUsername(), this.getRequestingURL()});
                return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
            }
            if (System.currentTimeMillis() - lastTry > 3000L) {
                String passKey;
                char[] password;
                if (this.getRequestingProtocol().startsWith("SOCKS") && ProxySettings.getAuthenticationUsername().length() > 0) {
                    return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
                }
                if (NetworkSettings.isAuthenticationDialogSuppressed()) {
                    return null;
                }
                PasswordAuthentication auth = this.getAuthenticationFromURL();
                if (auth != null) {
                    return auth;
                }
                Preferences prefs = NbPreferences.forModule(IDMAuthenticator.class);
                String propKey = this.getRequestingProtocol() + ".auth." + this.getRequestingHost() + ":" + this.getRequestingPort();
                String username = prefs.get(propKey + ".username", "");
                String title = NbBundle.getMessage(IDMAuthenticator.class, (String)"Installer.login.title");
                if (Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType())) {
                    title = NbBundle.getMessage(IDMAuthenticator.class, (String)"Installer.login.title.proxy") + " " + StringUtils.lowerCase((String)title);
                }
                if (!(username.trim().length() == 0 || lastAutoLoginTimePerURL.containsKey(this.getRequestingURL()) && System.currentTimeMillis() - lastAutoLoginTimePerURL.get(this.getRequestingURL()) <= 3000L || (password = Keyring.read((String)(passKey = propKey + "." + username))) == null || password.length == 0)) {
                    lastAutoLoginTimePerURL.put(this.getRequestingURL(), System.currentTimeMillis());
                    return new PasswordAuthentication(username, ArrayUtils.clone((char[])password));
                }
                Credentials cred = DialogUtil.showLoginDialog(this.getRequestingPrompt(), title, propKey + ".%s", username, DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT, DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT);
                if (cred != null) {
                    prefs.put(propKey + ".username", cred.getUsername());
                    try {
                        prefs.flush();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(IDMAuthenticator.class.getName()).log(Level.WARNING, "Could not save username for host " + this.getRequestingProtocol() + "://" + this.getRequestingHost() + ":" + this.getRequestingPort(), ex);
                    }
                    lastTry = 0L;
                    return new PasswordAuthentication(cred.getUsername(), ArrayUtils.clone((char[])cred.getPassword()));
                }
                lastTry = System.currentTimeMillis();
            }
            Logger.getLogger(IDMAuthenticator.class.getName()).log(Level.WARNING, "No authentication set while requesting {0}", this.getRequestingURL());
            return null;
        }
    }
}

