/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.summarizedData.dto;

import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.summarizedData.dto.StateDurationsDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StatusDurationsDTOList
extends ReportDTOListBase<StateDurationsDTO> {
    private int[] statusIds;
    private HashMap<Integer, Long> totalDurationMap;
    private HashMap<Integer, Double> totoalStatePercentages = null;
    private Integer stateModelId;

    public StatusDurationsDTOList(ReportSelectionDTO selectionDTO, Integer stateModelId, int[] statusIds) {
        super(selectionDTO);
        this.stateModelId = stateModelId;
        this.statusIds = statusIds;
    }

    public Integer getStateModelId() {
        return this.stateModelId;
    }

    public void setStateModelId(Integer stateModelId) {
        this.stateModelId = stateModelId;
    }

    public Long getTotalDurationForStatus(int stateId) {
        Long totalDuration = 0L;
        for (StateDurationsDTO durationsDTO : this) {
            Long duration = durationsDTO.getDuration(stateId);
            if (duration == null) {
                return null;
            }
            totalDuration = totalDuration + duration;
        }
        return totalDuration;
    }

    public HashMap<Integer, Long> getTotalDurationMap() {
        if (this.totalDurationMap == null) {
            this.totalDurationMap = new HashMap();
            for (int i = 0; i < this.statusIds.length; ++i) {
                Long totalDuration = 0L;
                for (StateDurationsDTO durationsDTO : this) {
                    Long duration = durationsDTO.getDuration(this.statusIds[i]);
                    if (duration == null) {
                        return null;
                    }
                    totalDuration = totalDuration + duration;
                }
                this.totalDurationMap.put(this.statusIds[i], totalDuration);
            }
        }
        return this.totalDurationMap;
    }

    public HashMap<Integer, Double> getTotalStatePercentages() {
        if (this.totoalStatePercentages == null) {
            this.totoalStatePercentages = new HashMap();
            for (Map.Entry<Integer, Long> e : this.getTotalDurationMap().entrySet()) {
                long duration = e.getValue();
                double percentage = (double)duration * 100.0 / (double)this.getTotalDuration();
                this.totoalStatePercentages.put(e.getKey(), percentage);
            }
        }
        return this.totoalStatePercentages;
    }

    public long getTotalDuration() {
        long totalDuration = 0L;
        for (StateDurationsDTO dto : this) {
            totalDuration += dto.getTotalDuration();
        }
        return totalDuration;
    }

    public int[] getStatusIds() {
        return this.statusIds;
    }

    public boolean dataAvailable() {
        boolean chartDataAvailable = false;
        block0: for (StateDurationsDTO dto : this) {
            Set<Integer> set = dto.getStatusIds();
            for (Integer statusId : set) {
                if (this.getTotalDurationForStatus(statusId) == 0L) continue;
                chartDataAvailable = true;
                continue block0;
            }
        }
        return chartDataAvailable;
    }

    public void setStatusIds(int[] statusIds) {
        this.statusIds = statusIds;
    }
}

