/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.historyData.dto;

import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.logic.web.common.dto.StateReportDTO;
import de.proveo.wwt.logic.web.common.dto.interfaces.IDTOAttachable;

public class PositionDTO
extends StateReportDTO
implements IDTOAttachable {
    private boolean trusted;
    private String ggaRec;
    private int latMSEC;
    private int longMSEC;
    private String rmcRec;
    private String reason;
    private String area;
    private String areaDescr;
    private GPSPosition gpsPosition;

    public PositionDTO(long id, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime, long actualBeginTime, long actualEndTime, boolean trusted, String ggaRec, int latMSEC, int longMSEC, String rmcRec, String reason, String area, String areaDescr) {
        super(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime);
        this.trusted = trusted;
        this.ggaRec = ggaRec;
        this.latMSEC = latMSEC;
        this.longMSEC = longMSEC;
        this.rmcRec = rmcRec;
        this.reason = reason;
        this.area = area;
        this.areaDescr = areaDescr;
        this.gpsPosition = ggaRec == null ? new GPSPosition("", "", trusted) : new GPSPosition(rmcRec, ggaRec, trusted);
    }

    public PositionDTO copy() {
        PositionDTO copy = new PositionDTO(this.id, this.beginTime, this.endTime, this.beginReceiveTime, this.endReceiveTime, this.actualBeginTime, this.actualEndTime, this.trusted, this.ggaRec, this.latMSEC, this.longMSEC, this.rmcRec, this.reason, this.area, this.areaDescr);
        copy.attachables = this.attachables;
        return copy;
    }

    @Override
    public long getEndDelay() {
        return super.getEndDelay() < 0L ? 0L : super.getEndDelay();
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getGgaRec() {
        return this.ggaRec;
    }

    public int getLatMSEC() {
        return this.latMSEC;
    }

    public int getLongMSEC() {
        return this.longMSEC;
    }

    public String getRmcRec() {
        return this.rmcRec;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public String getAreaName() {
        return this.area;
    }

    @Override
    public String getAreaDescription() {
        return this.areaDescr;
    }

    public int getSpeedMph() {
        return this.gpsPosition.getSpeedMphIntValue();
    }

    public int getSpeedKmh() {
        return this.gpsPosition.getSpeedKmhIntValue();
    }

    public String getPositionString() {
        return this.gpsPosition.getPositionString();
    }

    public float getAltitude() {
        return this.gpsPosition.getAltitude();
    }

    public String getRmcAndGgaRec() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRmcRec());
        sb.append("\n");
        sb.append(this.getGgaRec());
        return sb.toString();
    }

    public int getCourse() {
        return this.gpsPosition.getCourseIntValue();
    }

    public GPSPosition getGPSPosition() {
        return this.gpsPosition;
    }
}

