/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.historyData.dto;

import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.logic.web.common.dto.EventReportDTO;

public class MeasurementDTO
extends EventReportDTO {
    private Float value;
    private MeasurementDefinition measurementDefinition;
    private MeasurementType measurementType;
    private MeasurementUnit measurementUnit;

    public MeasurementDTO(long id, long createTime, long receiveTime, Float value, MeasurementDefinition measurementDefinition, MeasurementType measurementType, MeasurementUnit measurementUnit) {
        super(id, createTime, receiveTime);
        this.value = value;
        this.measurementDefinition = measurementDefinition;
        this.measurementType = measurementType;
        this.measurementUnit = measurementUnit;
    }

    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public int getMeasurementDefinitionId() {
        return this.measurementDefinition.getId();
    }

    public String getMeasurementUnitName() {
        return this.measurementUnit.getName();
    }

    public Float getMeasurementMinValue() {
        return this.measurementDefinition.getMinValue();
    }

    public Float getMeasurementMaxValue() {
        return this.measurementDefinition.getMaxValue();
    }

    public String getMeasurementValuePattern() {
        if (this.measurementDefinition.getCustomFormatPattern() != null) {
            return this.measurementDefinition.getCustomFormatPattern();
        }
        return this.measurementUnit.getFormatPattern();
    }

    public float getMeasurementRange() {
        return this.getMeasurementMaxValue().floatValue() - this.getMeasurementMinValue().floatValue();
    }

    public MeasurementType getMeasurementType() {
        return this.measurementType;
    }

    public String getMeasurementTypeName() {
        return this.measurementType.getName();
    }

    public MeasurementDefinition getMeasurementDefinition() {
        return this.measurementDefinition;
    }

    public void setMeasurementDefinition(MeasurementDefinition measurementDefinition) {
        this.measurementDefinition = measurementDefinition;
    }

    public void setMeasurementType(MeasurementType measurementType) {
        this.measurementType = measurementType;
    }

    public void setMeasurementUnit(MeasurementUnit measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }
}

