/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.performanceCounter;

import de.proveo.util.database.DatabaseType;
import de.proveo.util.database.DatabaseUtil;
import de.proveo.wwt.logic.ejb.general.tableMappings.readers.PerformanceCounterAnnotationReader;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PerformanceCounterFastLaneBase<E extends Enum<E>>
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(PerformanceCounterFastLaneBase.class);
    public static final String TIMESTAMP_COLUMN = "timestamp";
    protected static final String INCOMPATIBLE_DBMS_MESSAGE = "Performance counter not available for currently used DBMS";
    protected static final long[] VALID_INTERVALS = new long[]{1000L, 5000L, 10000L, 30000L, 60000L, 120000L, 300000L, 600000L, 900000L, 1200000L, 1800000L, 2700000L, 3600000L, 0x6DDD00L, 14400000L, 21600000L, 28800000L, 36000000L, 43200000L, 64800000L, 86400000L};
    protected static final long MIN_VALID_TIMESTAMP = 946681200000L;
    protected final String TABLE_NAME;
    protected static final String CHECK_BASIC_UNIT = "SELECT is_basic FROM unit_model WHERE unit_id = %d";
    protected static final String GET_GROUP_CHILDREN = "SELECT uxu.unit_id FROM unitmodel_x_unitmodel uxu, unit_model um WHERE uxu.group_id = %d AND um.is_basic = 1 AND uxu.unit_id = um.unit_id ORDER BY uxu.unit_id";
    protected Class<E> typeClass;

    protected PerformanceCounterFastLaneBase(Class<E> typeClass) {
        this.typeClass = typeClass;
        this.TABLE_NAME = PerformanceCounterAnnotationReader.getTableName(typeClass);
    }

    protected Enum<E>[] getAllTableMappings() {
        return (Enum[])this.typeClass.getEnumConstants();
    }

    public boolean compatible() {
        return this.databaseType == DatabaseType.MySQL || this.databaseType == DatabaseType.MSSQL || this.databaseType == DatabaseType.Oracle;
    }

    public boolean fullyCompatible() {
        return this.databaseType == DatabaseType.MySQL;
    }

    protected static long intervalMillisFromLoadFactor(long beginTime, long endTime, int loadFactor) {
        long rawInterval = (endTime - beginTime) / (long)loadFactor;
        long minDiff = Long.MAX_VALUE;
        long intervalMillis = 3600000L;
        for (int i = 0; i != VALID_INTERVALS.length; ++i) {
            long currentDiff = Math.abs(rawInterval - VALID_INTERVALS[i]);
            if (currentDiff >= minDiff) continue;
            minDiff = currentDiff;
            intervalMillis = VALID_INTERVALS[i];
        }
        return intervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBasicUnit(long unitId) {
        boolean result = false;
        Connection connection = null;
        try {
            connection = this.getConnection();
            Long isBasic = DatabaseUtil.executeCustomQuery((Connection)connection, (String)String.format(CHECK_BASIC_UNIT, unitId), (Long)-1L);
            if (isBasic != null && isBasic.equals(1L)) {
                result = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error creating SQL connection", (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Long> getGroupChildren(long groupId) {
        ArrayList<Long> units = new ArrayList<Long>();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            String sql = String.format(GET_GROUP_CHILDREN, groupId);
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                units.add(resultSet.getLong(1));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            log.error((Object)"Error creating SQL connection", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        return units;
    }

    protected QueryType queryType(Long unitId) {
        QueryType queryType = unitId == null ? QueryType.AllUnits : (this.isBasicUnit(unitId) ? QueryType.Unit : QueryType.Group);
        return queryType;
    }

    public static enum QueryType {
        AllUnits,
        Unit,
        Group,
        None;

    }
}

