/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.maintenance;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.Subquery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.util.database.DatabaseUtil;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneBase;
import de.proveo.wwt.logic.web.data.query.interfaces.IReportTableDefinitions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HistoryFastLaneDeleter
extends FastLaneBase {
    private static final Log log = LogFactory.getLog(HistoryFastLaneDeleter.class);
    private static final String STOPWATCH_SINGLE_SQL = "Single DELETE statement";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteHistoryData(FastLaneBase.HistoryTable[] historyTables, Long unitId, Long endTimeStamp) {
        log.debug((Object)"FastLaneDeleter deleteDataHistory called");
        Stopwatch stopwatchTotal = new Stopwatch(HistoryFastLaneDeleter.class, "DELETE FROM history tables");
        stopwatchTotal.start("Overall");
        int deletedSum = 0;
        Connection connection = null;
        Statement statement = null;
        try {
            stopwatchTotal.start("Database access");
            connection = this.getConnection();
            statement = this.createStatement(connection);
            Stopwatch stopwatchSql = new Stopwatch(HistoryFastLaneDeleter.class, STOPWATCH_SINGLE_SQL);
            for (int i = 0; i < historyTables.length; ++i) {
                stopwatchSql.start(STOPWATCH_SINGLE_SQL);
                IReportTableDefinitions historyTableDefinitions = (IReportTableDefinitions)tableMap.get((Object)historyTables[i]);
                if (historyTableDefinitions == null) {
                    log.error((Object)("HistoryTableMapping '" + historyTables[i].name() + "' not found. Skipping table."));
                    continue;
                }
                String[] statements = new String[]{HistoryFastLaneDeleter.generateHelperDeletionStatement(historyTables[i], unitId, endTimeStamp), HistoryFastLaneDeleter.generateHistoryStatement(StatementType.DELETE, historyTables[i], unitId, endTimeStamp)};
                for (int j = 0; j != statements.length; ++j) {
                    if (statements[j] == null) continue;
                    log.debug((Object)("Executed SQL: " + statements[j]));
                    int deleted = statement.executeUpdate(statements[j]);
                    log.debug((Object)("Deleted " + String.valueOf(deleted) + " rows"));
                    deletedSum += deleted;
                }
                log.debug((Object)("Deleted " + String.valueOf(deletedSum) + " rows total"));
                stopwatchSql.stop(STOPWATCH_SINGLE_SQL, true);
            }
            stopwatchTotal.stop("Database access", true);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
            deletedSum = 0;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatchTotal.stop("Overall", true);
        return deletedSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<FastLaneBase.HistoryTable, Integer> selectCountHistoryData(FastLaneBase.HistoryTable[] historyTables, Long unitId, Long endTimeStamp) {
        log.debug((Object)"FastLaneDeleter selectCountDataHistory called");
        Stopwatch stopwatch = new Stopwatch(HistoryFastLaneDeleter.class, "select_count_from_table");
        stopwatch.start("Overall");
        HashMap<FastLaneBase.HistoryTable, Integer> result = new HashMap<FastLaneBase.HistoryTable, Integer>();
        Connection connection = null;
        Statement statement = null;
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createStatement(connection);
            log.debug((Object)"Database access fast lane...");
            for (FastLaneBase.HistoryTable historyTable : historyTables) {
                IReportTableDefinitions historyTableDefinitions = (IReportTableDefinitions)tableMap.get((Object)historyTable);
                if (historyTableDefinitions == null) {
                    log.error((Object)("HistoryTableMapping '" + historyTable.name() + "' not found. Skipping table."));
                    continue;
                }
                String sql = HistoryFastLaneDeleter.generateHistoryStatement(StatementType.SELECT_COUNT, historyTable, unitId, endTimeStamp);
                log.debug((Object)("Executed SQL: " + sql));
                Long count = DatabaseUtil.executeCustomQuery((Connection)connection, (String)sql, (Long)-1L);
                if (count == null) continue;
                result.put(historyTable, count.intValue());
            }
            stopwatch.stop("Database access", true);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return result;
    }

    private static String generateHelperDeletionStatement(FastLaneBase.HistoryTable historyTable, Long unitId, Long endTimeStamp) {
        IReportTableDefinitions tables = (IReportTableDefinitions)tableMap.get((Object)historyTable);
        if (tables == null) {
            log.error((Object)("HistoryTableMapping '" + historyTable.name() + "' not found. Skipping table."));
            return null;
        }
        if (tables.getHelperTable() == null || tables.getHelperTable() == tables.getHistoryTable()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE tbl_hlp FROM ");
        sb.append(tables.getHistoryTable().getName());
        sb.append(" tbl, ");
        sb.append(tables.getHelperTable().getName());
        sb.append(" tbl_hlp WHERE tbl.");
        sb.append(tables.getHistoryIdColumn().getName());
        sb.append(" = tbl_hlp.");
        sb.append(tables.getHelperHistoryIdColumn().getName());
        if (unitId != null) {
            sb.append(" AND ");
            sb.append("tbl.");
            sb.append(tables.getHistoryUnitIdColumn().getName());
            sb.append(" = ");
            sb.append(String.valueOf(unitId));
        }
        if (endTimeStamp != null) {
            sb.append(" AND tbl.");
            sb.append(tables.getHistoryDeleteTimeColumn().getName());
            sb.append(" < ");
            sb.append(String.valueOf(endTimeStamp));
        }
        if (tables.getCacheTable() != null) {
            sb.append(" AND tbl.");
            sb.append(tables.getHistoryIdColumn().getName());
            sb.append(" NOT IN (SELECT ");
            sb.append(tables.getCacheHistoryIdColumn().getName());
            sb.append(" FROM ");
            sb.append(tables.getCacheTable().getName());
            sb.append(")");
        }
        return sb.toString().toLowerCase();
    }

    private static String generateHistoryStatement(StatementType statementType, FastLaneBase.HistoryTable historyTable, Long unitId, Long endTimeStamp) {
        DeleteQuery query;
        IReportTableDefinitions tables = (IReportTableDefinitions)tableMap.get((Object)historyTable);
        if (tables == null) {
            log.error((Object)("HistoryTableMapping '" + historyTable.name() + "' not found. Skipping table."));
            return null;
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        switch (statementType) {
            case DELETE: {
                query = new DeleteQuery((Table)tables.getHistoryTable());
                break;
            }
            case SELECT_COUNT: {
                query = new SelectQuery(false).addCustomColumns(new Object[]{FunctionCall.countAll()});
                break;
            }
            default: {
                log.error((Object)"Unknown statement type in generateHistoryStatement()");
                return null;
            }
        }
        if (unitId != null) {
            conditions.add((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)tables.getHistoryUnitIdColumn(), (Object)unitId));
        }
        if (endTimeStamp != null) {
            conditions.add((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)tables.getHistoryDeleteTimeColumn(), (Object)endTimeStamp));
        }
        if (tables.getCacheTable() != null) {
            SelectQuery cachedHistoryQuery = new SelectQuery(true);
            cachedHistoryQuery.addFromTable((Table)tables.getCacheTable());
            cachedHistoryQuery.addColumns(new Column[]{tables.getCacheHistoryIdColumn()});
            InCondition inCondition = new InCondition((Object)tables.getHistoryIdColumn(), new Object[]{new Subquery((Object)cachedHistoryQuery)});
            inCondition.setNegate(true);
            conditions.add((Condition)inCondition);
        }
        if (conditions.size() != 0) {
            if (query instanceof SelectQuery) {
                HistoryFastLaneDeleter.addConditions((SelectQuery)query, conditions);
            } else {
                HistoryFastLaneDeleter.addConditions(query, conditions);
            }
        }
        return query.validate().toString();
    }

    private static void addConditions(DeleteQuery query, List<Condition> conditions) {
        for (Condition condition : conditions) {
            query.addCondition(condition);
        }
    }

    private static void addConditions(SelectQuery query, List<Condition> conditions) {
        for (Condition condition : conditions) {
            query.addCondition(condition);
        }
    }

    private static enum StatementType {
        DELETE,
        SELECT_COUNT;

    }
}

