/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.NumberValueObject;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.UseDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UseFastLaneReader
extends StateReportFastLaneReader<UseDTO, UseDefinitions> {
    public UseFastLaneReader() {
        super(new UseDefinitions());
    }

    public void getHistory(DTOListBase<UseDTO> list, Long unitId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        this.init(list, selectionDTO, FastLaneReaderOrder.ByBeginTime, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getHistory(DTOListBase<UseDTO> list, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(list, selectionDTO, FastLaneReaderOrder.ByBeginTime, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getCache(DTOListBase<UseDTO> list, ReportSelectionDTO selectionDTO, ExtendedDTOData ... extendedData) {
        this.init(list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    public void getCache(DTOListBase<UseDTO> list, Long unitId, boolean useGroupHistory, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, 0L, 0L, useGroupHistory, false);
        this.init(list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getCacheHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getCacheUnitIdColumn().getName());
        int idx_beginTime = resultSet.findColumn("bt");
        int idx_beginReceiveTime = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getCacheBeginReceiveTimeColumn().getName());
        int idx_actualBeginTime = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getCacheBeginTimeColumn().getName());
        UseDefinitions cfr_ignored_0 = (UseDefinitions)this.getDefinitions();
        int idx_beginAreaId = resultSet.findColumn(UseDefinitions.col_Cache_BeginAreaId.getName());
        UseDefinitions cfr_ignored_1 = (UseDefinitions)this.getDefinitions();
        int idx_useUserId = resultSet.findColumn(UseDefinitions.col_Cache_UseUserId.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = 0L;
            long beginTime = resultSet.getLong(idx_beginTime);
            long endTime = 0L;
            long actualBeginTime = resultSet.getLong(idx_actualBeginTime);
            long actualEndTime = 0L;
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            if (unitDTO.isDeleted()) continue;
            Area beginArea = this.getAreaMap().get(resultSet.getInt(idx_beginAreaId));
            Area endArea = null;
            UseUser useUser = this.getUseUserMap().get(resultSet.getLong(idx_useUserId));
            UseDTO dto = DTOFactory.buildUseDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, beginArea, endArea, unitDTO, useUser);
            this.dataList.add(dto);
            this.addExtendedData(true, resultSet, dto, new ExtendedDTOData[0]);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_beginTime = resultSet.findColumn("bt");
        int idx_endTime = resultSet.findColumn("et");
        int idx_beginReceiveTime = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getHistoryBeginReceiveTimeColumn().getName());
        int idx_endReceiveTime = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getHistoryEndReceiveTimeColumn().getName());
        int idx_actualBeginTime = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getHistoryBeginTimeColumn().getName());
        int idx_actualEndTime = resultSet.findColumn(((UseDefinitions)this.getDefinitions()).getHistoryEndTimeColumn().getName());
        UseDefinitions cfr_ignored_0 = (UseDefinitions)this.getDefinitions();
        int idx_beginAreaId = resultSet.findColumn(UseDefinitions.col_History_BeginAreaId.getName());
        UseDefinitions cfr_ignored_1 = (UseDefinitions)this.getDefinitions();
        int idx_endAreaId = resultSet.findColumn(UseDefinitions.col_History_EndAreaId.getName());
        UseDefinitions cfr_ignored_2 = (UseDefinitions)this.getDefinitions();
        int idx_useUserId = resultSet.findColumn(UseDefinitions.col_History_UseUserId.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = resultSet.getLong(idx_endReceiveTime);
            long beginTime = resultSet.getLong(idx_beginTime);
            long endTime = resultSet.getLong(idx_endTime);
            long actualBeginTime = resultSet.getLong(idx_actualBeginTime);
            long actualEndTime = resultSet.getLong(idx_actualEndTime);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            Area beginArea = this.getAreaMap().get(resultSet.getInt(idx_beginAreaId));
            Area endArea = this.getAreaMap().get(resultSet.getInt(idx_endAreaId));
            UseUser useUser = this.getUseUserMap().get(resultSet.getLong(idx_useUserId));
            UseDTO dto = DTOFactory.buildUseDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, beginArea, endArea, unitDTO, useUser);
            this.dataList.add(dto);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        Column[] columnArray = new Column[3];
        UseDefinitions cfr_ignored_0 = (UseDefinitions)this.getDefinitions();
        columnArray[0] = UseDefinitions.col_History_BeginAreaId;
        UseDefinitions cfr_ignored_1 = (UseDefinitions)this.getDefinitions();
        columnArray[1] = UseDefinitions.col_History_EndAreaId;
        UseDefinitions cfr_ignored_2 = (UseDefinitions)this.getDefinitions();
        columnArray[2] = UseDefinitions.col_History_UseUserId;
        this.historyQuery.addColumns(columnArray);
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        Object[] objectArray = new Object[3];
        UseDefinitions cfr_ignored_0 = (UseDefinitions)this.getDefinitions();
        objectArray[0] = UseDefinitions.col_Cache_BeginAreaId;
        objectArray[1] = new NumberValueObject((Number)-1);
        UseDefinitions cfr_ignored_1 = (UseDefinitions)this.getDefinitions();
        objectArray[2] = UseDefinitions.col_Cache_UseUserId;
        this.cacheQuery.addCustomColumns(objectArray);
    }

    @Override
    protected void init(DTOListBase<UseDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order, extendedData);
        this.extendedData.remove((Object)ExtendedDTOData.AREA);
        this.extendedData.remove((Object)ExtendedDTOData.OPERATOR);
    }
}

