/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.EventReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.ScanmanMsgDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.ScanmanMessageDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ScanmanMessageFastLaneReader
extends EventReportFastLaneReader<ScanmanMessageDTO, ScanmanMsgDefinitions> {
    protected Integer messageType;

    public ScanmanMessageFastLaneReader() {
        super(new ScanmanMsgDefinitions());
    }

    public void getHistory(DTOListBase<ScanmanMessageDTO> list, Long unitId, Integer messageId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        this.init(messageId, list, selectionDTO, FastLaneReaderOrder.ByNothing, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getHistory(DTOListBase<ScanmanMessageDTO> list, ReportSelectionDTO selectionDTO, Integer messageId, ExtendedDTOData ... extendedData) {
        this.init(messageId, list, selectionDTO, FastLaneReaderOrder.ByNothing, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        return 0;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((ScanmanMsgDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((ScanmanMsgDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_createTime = resultSet.findColumn(((ScanmanMsgDefinitions)this.getDefinitions()).getHistoryCreateTimeColumn().getName());
        int idx_receiveTime = resultSet.findColumn(((ScanmanMsgDefinitions)this.getDefinitions()).getHistoryReceiveTimeColumn().getName());
        ScanmanMsgDefinitions cfr_ignored_0 = (ScanmanMsgDefinitions)this.getDefinitions();
        int idx_message = resultSet.findColumn(ScanmanMsgDefinitions.col_History_Message.getName());
        ScanmanMsgDefinitions cfr_ignored_1 = (ScanmanMsgDefinitions)this.getDefinitions();
        int idx_type = resultSet.findColumn(ScanmanMsgDefinitions.col_History_Type.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long createTime = resultSet.getLong(idx_createTime);
            long receiveTime = resultSet.getLong(idx_receiveTime);
            String message = resultSet.getString(idx_message);
            int type = resultSet.getInt(idx_type);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            if (this.messageType != null && this.messageType != type) continue;
            ScanmanMessageDTO dto = DTOFactory.buildScanmanMessageDTO(id, createTime, receiveTime, type, message, unitDTO);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        Column[] columnArray = new Column[2];
        ScanmanMsgDefinitions cfr_ignored_0 = (ScanmanMsgDefinitions)this.getDefinitions();
        columnArray[0] = ScanmanMsgDefinitions.col_History_Message;
        ScanmanMsgDefinitions cfr_ignored_1 = (ScanmanMsgDefinitions)this.getDefinitions();
        columnArray[1] = ScanmanMsgDefinitions.col_History_Type;
        this.historyQuery.addColumns(columnArray);
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        Column[] columnArray = new Column[2];
        ScanmanMsgDefinitions cfr_ignored_0 = (ScanmanMsgDefinitions)this.getDefinitions();
        columnArray[0] = ScanmanMsgDefinitions.col_Cache_Message;
        ScanmanMsgDefinitions cfr_ignored_1 = (ScanmanMsgDefinitions)this.getDefinitions();
        columnArray[1] = ScanmanMsgDefinitions.col_Cache_Type;
        this.cacheQuery.addColumns(columnArray);
    }

    protected void init(Integer messageId, DTOListBase<ScanmanMessageDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order, extendedData);
        this.messageType = messageId;
    }
}

